/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.List;
import mpi.eudico.client.annotator.ActiveAnnotationListener;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class CreateDependentAnnotationsCA
extends CommandAction
implements ActiveAnnotationListener {
    private Tier receiver;
    private long beginTime;
    private long endTime;

    public CreateDependentAnnotationsCA(ViewerManager2 viewerManager) {
        super(viewerManager, "Menu.Annotation.CreateDependingAnnotations");
        viewerManager.connectListener(this);
        this.setEnabled(false);
    }

    @Override
    protected void newCommand() {
        this.command = null;
        if (this.checkState() && this.receiver != null) {
            this.command = ELANCommandFactory.createCommand(this.vm.getTranscription(), "Menu.Annotation.CreateDependingAnnotations");
        }
    }

    @Override
    protected Object getReceiver() {
        return this.receiver;
    }

    @Override
    protected Object[] getArguments() {
        Object[] args = new Object[]{new Long(this.beginTime), new Long(this.endTime)};
        return args;
    }

    protected boolean checkState() {
        this.receiver = null;
        this.beginTime = 0L;
        this.endTime = 0L;
        if (this.vm.getActiveAnnotation() != null && this.vm.getActiveAnnotation().getAnnotation() != null) {
            Annotation activeAnn = this.vm.getActiveAnnotation().getAnnotation();
            this.receiver = activeAnn.getTier();
            List<TierImpl> depTiers = ((TierImpl)activeAnn.getTier()).getDependentTiers();
            if (depTiers == null || depTiers.isEmpty()) {
                return false;
            }
            this.beginTime = activeAnn.getBeginTimeBoundary();
            this.endTime = activeAnn.getEndTimeBoundary();
            return true;
        }
        return false;
    }

    @Override
    public void updateActiveAnnotation() {
        if (this.vm.getActiveAnnotation().getAnnotation() == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }
}

