/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CreateDependentAnnotationsCommand
implements UndoableCommand {
    private String commandName;
    private TierImpl tier;
    TranscriptionImpl transcription;
    private long begin;
    private long end;
    List<String> annotationTiers;
    int numberOfannotationsCreated = 0;

    public CreateDependentAnnotationsCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.tier = (TierImpl)receiver;
        this.begin = (Long)arguments[0];
        this.end = (Long)arguments[1];
        this.transcription = this.tier.getTranscription();
        this.annotationTiers = new ArrayList<String>();
        this.createDependingAnnotations();
        if (this.numberOfannotationsCreated > 0 && MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.CREATE_DEPENDING_ANNOTATIONS, this.tier.getName(), this.tier.getAnnotationAtTime(this.begin).getValue(), Long.toString(this.begin), Long.toString(this.end), "number of annotations created : " + this.numberOfannotationsCreated);
        }
    }

    public void createDependingAnnotations() {
        List<TierImpl> dependentTiers;
        this.annotationTiers.clear();
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        if ((dependentTiers = this.tier.getDependentTiers()) != null) {
            int numTiers = dependentTiers.size();
            for (int i = 0; i < numTiers; ++i) {
                TierImpl currentChildTier = dependentTiers.get(i);
                if (currentChildTier.getAnnotationAtTime(this.begin) != null) continue;
                this.annotationTiers.add(currentChildTier.getName());
                if (currentChildTier.isTimeAlignable()) {
                    currentChildTier.createAnnotation(this.begin, this.end);
                } else {
                    long time = (this.begin + this.end) / 2L;
                    currentChildTier.createAnnotation(time, time);
                }
                ++this.numberOfannotationsCreated;
            }
        }
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    @Override
    public void redo() {
        this.createDependingAnnotations();
        if (this.numberOfannotationsCreated > 0 && MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.REDO, MonitoringLogger.CREATE_DEPENDING_ANNOTATIONS);
        }
    }

    @Override
    public void undo() {
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        int numTiers = this.annotationTiers.size();
        for (int i = 0; i < numTiers; ++i) {
            TierImpl currentChildTier = this.transcription.getTierWithId(this.annotationTiers.get(i));
            if (currentChildTier.isTimeAlignable()) {
                Annotation ann = currentChildTier.getAnnotationAtTime(this.begin);
                if (ann == null) continue;
                currentChildTier.removeAnnotation(ann);
                continue;
            }
            long time = (this.begin + this.end) / 2L;
            Annotation ann = currentChildTier.getAnnotationAtTime(time);
            if (ann == null) continue;
            currentChildTier.removeAnnotation(ann);
        }
        this.numberOfannotationsCreated = 0;
        if (MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.UNDO, MonitoringLogger.CREATE_DEPENDING_ANNOTATIONS);
        }
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

