/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.List;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.ControlledVocabulary;

public class DeleteCVCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private ControlledVocabulary controlledVocabulary;
    private List<LinguisticType> affectedTypes;

    public DeleteCVCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.transcription != null && this.controlledVocabulary != null) {
            this.transcription.addControlledVocabulary(this.controlledVocabulary);
            for (LinguisticType type : this.affectedTypes) {
                type.setControlledVocabularyName(this.controlledVocabulary.getName());
            }
        }
    }

    @Override
    public void redo() {
        if (this.transcription != null) {
            this.transcription.removeControlledVocabulary(this.controlledVocabulary);
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.controlledVocabulary = (ControlledVocabulary)arguments[0];
        if (this.transcription != null) {
            this.affectedTypes = this.transcription.getLinguisticTypesWithCV(this.controlledVocabulary.getName());
            this.transcription.removeControlledVocabulary(this.controlledVocabulary);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

