/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.export.ExportFilmStripDialog;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.VideoFrameGrabber;

public class ExportFilmStripDlgCommand
implements Command {
    private String commandName;

    public ExportFilmStripDlgCommand(String commandName) {
        this.commandName = commandName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        long et;
        ViewerManager2 vm = (ViewerManager2)receiver;
        long bt = vm.getSelection().getBeginTime();
        if (bt == (et = vm.getSelection().getEndTime())) {
            JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(vm.getTranscription()), ElanLocale.getString("ExportFilmStrip.Error.NoSelection"), ElanLocale.getString("Message.Warning"), 2);
            return;
        }
        ArrayList<ElanMediaPlayer> visPlayers = new ArrayList<ElanMediaPlayer>(6);
        if (vm.getMasterMediaPlayer() instanceof VideoFrameGrabber) {
            visPlayers.add(vm.getMasterMediaPlayer());
        }
        List<ElanMediaPlayer> slaves = vm.getSlaveMediaPlayers();
        for (int i = 0; i < slaves.size(); ++i) {
            ElanMediaPlayer slPl = slaves.get(i);
            if (!(slPl instanceof VideoFrameGrabber)) continue;
            visPlayers.add(slPl);
        }
        if (visPlayers.size() == 0) {
            JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(vm.getTranscription()), ElanLocale.getString("ExportFilmStrip.Error.NoVideo"), ElanLocale.getString("Message.Warning"), 2);
            return;
        }
        ElanMediaPlayer[] players = visPlayers.toArray(new ElanMediaPlayer[visPlayers.size()]);
        String wavFile = null;
        if (vm.getSignalViewer() != null) {
            wavFile = vm.getSignalViewer().getMediaPath();
        }
        ExportFilmStripDialog dialog = new ExportFilmStripDialog((Frame)ELANCommandFactory.getRootFrame(vm.getTranscription()), players, wavFile, vm.getSelection());
        dialog.setVisible(true);
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

