/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.gui.IndeterminateProgressMonitor;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class FilterTierCommand
implements UndoableCommand,
ClientLogger {
    private String commandName;
    private TranscriptionImpl transcription;
    private TierImpl sourceTier;
    private TierImpl destTier;
    private String[] filters;
    private boolean preserve;
    private boolean createEmpty;
    private List<AnnotationDataRecord> existAnnotations;
    private List<AnnotationDataRecord> newAnnotations;
    private List<AnnotationDataRecord> existChangedAnnotations;

    public FilterTierCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        int i;
        if (this.transcription == null || this.sourceTier == null || this.destTier == null) {
            return;
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        this.transcription.setNotifying(false);
        this.setWaitCursor(true);
        if (this.newAnnotations.size() > 0) {
            for (i = 0; i < this.newAnnotations.size(); ++i) {
                AnnotationDataRecord destRecord = this.newAnnotations.get(i);
                AbstractAnnotation destAnn = (AbstractAnnotation)this.destTier.getAnnotationAtTime(destRecord.getBeginTime());
                if (destAnn != null) {
                    this.destTier.removeAnnotation(destAnn);
                    continue;
                }
                LOG.warning("Undo filter tier: could not remove annotation: " + destRecord.getValue() + " " + destRecord.getBeginTime() + " - " + destRecord.getEndTime());
            }
        }
        if (!this.preserve && this.existAnnotations.size() > 0) {
            for (i = 0; i < this.existAnnotations.size(); ++i) {
                AnnotationDataRecord extRecord = this.existAnnotations.get(i);
                AbstractAnnotation extAnn = (AbstractAnnotation)this.destTier.getAnnotationAtTime(extRecord.getBeginTime());
                if (extAnn != null) {
                    extAnn.setValue(extRecord.getValue());
                    continue;
                }
                LOG.warning("Undo filter tier: could not restore annotation value: " + extRecord.getValue() + " " + extRecord.getBeginTime() + " - " + extRecord.getEndTime());
            }
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    @Override
    public void redo() {
        int i;
        if (this.transcription == null || this.sourceTier == null || this.destTier == null) {
            return;
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        this.transcription.setNotifying(false);
        this.setWaitCursor(true);
        if (this.newAnnotations.size() > 0) {
            for (i = 0; i < this.newAnnotations.size(); ++i) {
                AnnotationDataRecord destRecord = this.newAnnotations.get(i);
                long time = (destRecord.getBeginTime() + destRecord.getEndTime()) / 2L;
                AbstractAnnotation destAnn = (AbstractAnnotation)this.destTier.createAnnotation(time, time);
                if (destAnn != null) {
                    destAnn.setValue(destRecord.getValue());
                    continue;
                }
                LOG.warning("Redo filter tier: could not recreate annotation: " + destRecord.getValue() + " " + destRecord.getBeginTime() + " - " + destRecord.getEndTime());
            }
        }
        if (!this.preserve && this.existChangedAnnotations.size() > 0) {
            for (i = 0; i < this.existChangedAnnotations.size(); ++i) {
                AnnotationDataRecord extRecord = this.existChangedAnnotations.get(i);
                AbstractAnnotation extAnn = (AbstractAnnotation)this.destTier.getAnnotationAtTime(extRecord.getBeginTime());
                if (extAnn != null) {
                    extAnn.setValue(extRecord.getValue());
                    continue;
                }
                LOG.warning("Redo filter tier: could not recreate annotation value: " + extRecord.getValue() + " " + extRecord.getBeginTime() + " - " + extRecord.getEndTime());
            }
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        String sourceName = (String)arguments[0];
        String destName = (String)arguments[1];
        this.filters = (String[])arguments[2];
        this.preserve = (Boolean)arguments[3];
        this.createEmpty = (Boolean)arguments[4];
        this.sourceTier = this.transcription.getTierWithId(sourceName);
        this.destTier = this.transcription.getTierWithId(destName);
        if (this.transcription == null || this.sourceTier == null || this.destTier == null) {
            LOG.severe("Error in retrieving the transcription or one of the tiers.");
            return;
        }
        this.existAnnotations = new ArrayList<AnnotationDataRecord>();
        this.newAnnotations = new ArrayList<AnnotationDataRecord>();
        this.existChangedAnnotations = new ArrayList<AnnotationDataRecord>();
        new FilterThread().start();
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    public String applyFilters(String source, String[] filters) {
        if (filters == null || filters.length == 0 || source == null || source.length() == 0) {
            return source;
        }
        char[] resultchars = source.toCharArray();
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] == null || filters[i].length() == 0 || filters[i].length() > resultchars.length) continue;
            char[] filter = filters[i].toCharArray();
            int from = 0;
            block1: while (from <= resultchars.length - filter.length) {
                while (from <= resultchars.length - filter.length) {
                    if (resultchars[from] == filter[0]) {
                        int count = 1;
                        int start = from + count;
                        int end = from + filter.length - 1;
                        while (start <= end) {
                            if (resultchars[start++] == filter[count++]) continue;
                            ++from;
                            continue block1;
                        }
                        StringBuilder buf = new StringBuilder(resultchars.length);
                        buf.append(resultchars);
                        buf.delete(from, end + 1);
                        char[] ch = new char[buf.length()];
                        buf.getChars(0, buf.length(), ch, 0);
                        resultchars = ch;
                        continue block1;
                    }
                    ++from;
                }
            }
        }
        if (resultchars.length == source.length()) {
            return source;
        }
        return String.valueOf(resultchars);
    }

    private class FilterThread
    extends Thread {
        FilterThread() {
        }

        @Override
        public void run() {
            List<AbstractAnnotation> sourceAnnos;
            final IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor(ELANCommandFactory.getRootFrame(FilterTierCommand.this.transcription), true, ElanLocale.getString("FilterDialog.Message.Filtering"), true, ElanLocale.getString("Button.Cancel"));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    monitor.show();
                }
            }).start();
            int curPropMode = 0;
            curPropMode = FilterTierCommand.this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                FilterTierCommand.this.transcription.setTimeChangePropagationMode(0);
            }
            if ((sourceAnnos = FilterTierCommand.this.sourceTier.getAnnotations()).size() <= 0) {
                monitor.close();
                return;
            }
            FilterTierCommand.this.transcription.setNotifying(false);
            for (AbstractAnnotation srcAnn : sourceAnnos) {
                List<Annotation> childrenOnDest = srcAnn.getChildrenOnTier(FilterTierCommand.this.destTier);
                if (childrenOnDest.size() > 0 && !FilterTierCommand.this.preserve) {
                    AbstractAnnotation childOnDest = (AbstractAnnotation)childrenOnDest.get(0);
                    FilterTierCommand.this.existAnnotations.add(new AnnotationDataRecord(childOnDest));
                    childOnDest.setValue(FilterTierCommand.this.applyFilters(srcAnn.getValue(), FilterTierCommand.this.filters));
                    FilterTierCommand.this.existChangedAnnotations.add(new AnnotationDataRecord(childOnDest));
                }
                if (childrenOnDest.size() == 0) {
                    Annotation ann;
                    long time;
                    String srcValue = srcAnn.getValue();
                    if (srcValue.length() == 0) {
                        if (FilterTierCommand.this.createEmpty) {
                            time = (srcAnn.getBeginTimeBoundary() + srcAnn.getEndTimeBoundary()) / 2L;
                            ann = FilterTierCommand.this.destTier.createAnnotation(time, time);
                            if (ann != null) {
                                FilterTierCommand.this.newAnnotations.add(new AnnotationDataRecord(ann));
                            } else {
                                ClientLogger.LOG.warning("Filter tier: could not create a new annotation for: " + srcValue + " " + srcAnn.getBeginTimeBoundary() + " - " + srcAnn.getEndTimeBoundary());
                            }
                        }
                    } else {
                        time = (srcAnn.getBeginTimeBoundary() + srcAnn.getEndTimeBoundary()) / 2L;
                        ann = FilterTierCommand.this.destTier.createAnnotation(time, time);
                        if (ann != null) {
                            ann.setValue(FilterTierCommand.this.applyFilters(srcAnn.getValue(), FilterTierCommand.this.filters));
                            FilterTierCommand.this.newAnnotations.add(new AnnotationDataRecord(ann));
                        } else {
                            ClientLogger.LOG.warning("Filter tier: could not create a new annotation for: " + srcValue + " " + srcAnn.getBeginTimeBoundary() + " - " + srcAnn.getEndTimeBoundary());
                        }
                    }
                }
                if (!monitor.isCancelled()) continue;
                break;
            }
            FilterTierCommand.this.transcription.setNotifying(true);
            FilterTierCommand.this.transcription.setTimeChangePropagationMode(curPropMode);
            monitor.close();
        }
    }
}

