/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.util.TranscriptionECVLoader;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFSkeletonParser;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;

public class ImportLinguisticTypesCommand
implements UndoableCommand,
ClientLogger {
    private String commandName;
    private TranscriptionImpl transcription;
    private List<LinguisticType> typesAdded = new ArrayList<LinguisticType>();
    private List<ControlledVocabulary> cvsAdded = new ArrayList<ControlledVocabulary>();
    private List<LexiconLink> lexLinksAdded = new ArrayList<LexiconLink>();
    private Map<String, Map<String, Map<String, Object>>> cvPrefsAdded;

    public ImportLinguisticTypesCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.transcription == null) {
            LOG.warning("The transcription is null.");
            return;
        }
        for (LinguisticType lt : this.typesAdded) {
            this.transcription.removeLinguisticType(lt);
        }
        for (ControlledVocabulary cv : this.cvsAdded) {
            this.transcription.removeControlledVocabulary(cv);
        }
        for (LexiconLink ll : this.lexLinksAdded) {
            this.transcription.removeLexiconLink(ll);
        }
        this.removeImportedPreferences();
    }

    @Override
    public void redo() {
        if (this.transcription == null) {
            LOG.warning("The transcription is null.");
            return;
        }
        for (LexiconLink ll : this.lexLinksAdded) {
            this.transcription.addLexiconLink(ll);
        }
        for (ControlledVocabulary cv : this.cvsAdded) {
            this.transcription.addControlledVocabulary(cv);
        }
        for (LinguisticType lt : this.typesAdded) {
            this.transcription.addLinguisticType(lt);
        }
        this.addImportedPreferences();
        Preferences.notifyListeners(this.transcription);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        ArrayList<ControlledVocabulary> impCVs;
        List<LinguisticType> impTypes;
        this.transcription = (TranscriptionImpl)receiver;
        String fileName = (String)arguments[0];
        if (fileName == null) {
            LOG.warning("The filename is null");
            return;
        }
        fileName = FileUtility.pathToURLString(fileName).substring(5);
        try {
            EAFSkeletonParser parser = new EAFSkeletonParser(fileName);
            parser.parse();
            impTypes = parser.getLinguisticTypes();
            List<ControlledVocabulary> cvs = parser.getControlledVocabularies();
            impCVs = new ArrayList<ControlledVocabulary>(cvs.size());
            block2: for (int i = 0; i < impTypes.size(); ++i) {
                LinguisticType lt = impTypes.get(i);
                if (lt.getControlledVocabularyName() == null || lt.getControlledVocabularyName().length() <= 0) continue;
                String string = lt.getControlledVocabularyName();
                for (int j = 0; j < cvs.size(); ++j) {
                    ControlledVocabulary cv = cvs.get(j);
                    if (!cv.getName().equals(string)) continue;
                    impCVs.add(cv);
                    continue block2;
                }
            }
        }
        catch (ParseException pe) {
            LOG.warning(pe.getMessage());
            pe.printStackTrace();
            return;
        }
        ArrayList<LinguisticType> currentTypes = new ArrayList<LinguisticType>(this.transcription.getLinguisticTypes());
        ArrayList<ControlledVocabulary> currentCvs = new ArrayList<ControlledVocabulary>(this.transcription.getControlledVocabularies());
        ArrayList currentLexLinks = new ArrayList(((HashMap)this.transcription.getLexiconLinks()).values());
        this.addCVsAndTypes(impCVs, impTypes);
        for (LinguisticType linguisticType : this.transcription.getLinguisticTypes()) {
            if (currentTypes.contains(linguisticType)) continue;
            this.typesAdded.add(linguisticType);
            if (linguisticType.getLexiconQueryBundle() == null || currentLexLinks.contains(linguisticType.getLexiconQueryBundle().getLink())) continue;
            this.transcription.addLexiconLink(linguisticType.getLexiconQueryBundle().getLink());
            this.lexLinksAdded.add(linguisticType.getLexiconQueryBundle().getLink());
        }
        TranscriptionECVLoader ecvLoader = new TranscriptionECVLoader();
        for (ControlledVocabulary cv : this.transcription.getControlledVocabularies()) {
            if (currentCvs.contains(cv)) continue;
            this.cvsAdded.add(cv);
            if (!(cv instanceof ExternalCV)) continue;
            ecvLoader.loadExternalCVs(this.transcription, null);
        }
        if (!this.cvsAdded.isEmpty()) {
            Map<String, Object> map = Preferences.loadPreferencesForFile(fileName);
            Map importPrefs = null;
            boolean oldPrefs = false;
            if (map != null) {
                Object cvPrefObj = map.get("CV.ML.Prefs");
                if (cvPrefObj instanceof Map) {
                    importPrefs = (Map)cvPrefObj;
                } else {
                    cvPrefObj = map.get("CV.Prefs");
                    if (cvPrefObj instanceof Map) {
                        importPrefs = (Map)cvPrefObj;
                        oldPrefs = true;
                    }
                }
            }
            if (importPrefs != null) {
                for (ControlledVocabulary cv : this.cvsAdded) {
                    this.importPreferencesFor(importPrefs, cv, oldPrefs);
                }
            }
        }
        this.addImportedPreferences();
        Preferences.notifyListeners(this.transcription);
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void addCVsAndTypes(List<ControlledVocabulary> cvs, List<LinguisticType> typesToAdd) {
        int i;
        if (cvs == null) {
            LOG.info("No Controlled Vocabularies to add");
            cvs = new ArrayList<ControlledVocabulary>(0);
        }
        if (typesToAdd == null) {
            LOG.info("No Linguistic Types to add.");
            return;
        }
        HashMap<String, ControlledVocabulary> renamedCVS = new HashMap<String, ControlledVocabulary>(5);
        for (i = 0; i < cvs.size(); ++i) {
            ControlledVocabulary cv = cvs.get(i);
            ControlledVocabulary cv2 = this.transcription.getControlledVocabulary(cv.getName());
            if (cv2 == null) {
                this.transcription.addControlledVocabulary(cv);
                LOG.info("Added Controlled Vocabulary: " + cv.getName());
                continue;
            }
            if (cv.equals(cv2)) continue;
            String newCVName = cv.getName() + "-cp";
            int c = 1;
            while (this.transcription.getControlledVocabulary(newCVName + c) != null) {
                ++c;
            }
            newCVName = newCVName + c;
            LOG.info("Renamed Controlled Vocabulary: " + cv.getName() + " to " + newCVName);
            renamedCVS.put(cv.getName(), cv);
            cv.setName(newCVName);
            this.transcription.addControlledVocabulary(cv);
            LOG.info("Added Controlled Vocabulary: " + cv.getName());
        }
        for (i = 0; i < typesToAdd.size(); ++i) {
            LinguisticType lt = typesToAdd.get(i);
            String typeName = lt.getLinguisticTypeName();
            if (lt.isUsingControlledVocabulary() && renamedCVS.containsKey(lt.getControlledVocabularyName())) {
                ControlledVocabulary cv2 = (ControlledVocabulary)renamedCVS.get(lt.getControlledVocabularyName());
                lt.setControlledVocabularyName(cv2.getName());
            }
            if (this.transcription.getLinguisticTypeByName(typeName) != null) {
                LOG.warning("Transcription already contains a Linguistic Type named: " + typeName);
                continue;
            }
            this.transcription.addLinguisticType(lt);
            LOG.info("Added Linguistic Type: " + typeName);
        }
    }

    private void importPreferencesFor(Map<String, Object> importPrefs, ControlledVocabulary cv, boolean oldStylePrefs) {
        if (importPrefs != null && cv != null) {
            String color = "Color";
            String keyCode = "KeyCode";
            HashMap copyCVPref = new HashMap();
            HashMap copyEntPref = null;
            Map hm = (Map)importPrefs.get(cv.getName());
            if (hm != null) {
                for (CVEntry cve : cv) {
                    Object k;
                    String key = oldStylePrefs ? cve.getValue(0) : cve.getId();
                    Map entMap = (Map)hm.get(key);
                    if (entMap == null) continue;
                    Object c = entMap.get("Color");
                    if (c instanceof Color) {
                        cve.setPrefColor((Color)c);
                        if (copyEntPref == null) {
                            copyEntPref = new HashMap(3);
                        }
                        copyEntPref.put("Color", c);
                    }
                    if ((k = entMap.get("KeyCode")) instanceof Integer) {
                        cve.setShortcutKeyCode((Integer)k);
                        if (copyEntPref == null) {
                            copyEntPref = new HashMap(3);
                        }
                        copyEntPref.put("KeyCode", k);
                    }
                    if (copyEntPref == null) continue;
                    copyCVPref.put(cve.getId(), copyEntPref);
                }
                if (!copyCVPref.isEmpty()) {
                    if (this.cvPrefsAdded == null) {
                        this.cvPrefsAdded = new HashMap<String, Map<String, Map<String, Object>>>();
                    }
                    this.cvPrefsAdded.put(cv.getName(), copyCVPref);
                }
            }
        }
    }

    private void addImportedPreferences() {
        if (this.cvPrefsAdded != null) {
            HashMap<String, Map<String, Map<String, Object>>> cvPrefs = (HashMap<String, Map<String, Map<String, Object>>>)Preferences.getMap("CV.ML.Prefs", this.transcription);
            if (cvPrefs == null) {
                cvPrefs = new HashMap<String, Map<String, Map<String, Object>>>();
                Preferences.set("CV.ML.Prefs", cvPrefs, (Transcription)this.transcription);
            }
            cvPrefs.putAll(this.cvPrefsAdded);
        }
    }

    private void removeImportedPreferences() {
        HashMap cvPrefs;
        if (this.cvPrefsAdded != null && (cvPrefs = (HashMap)Preferences.getMap("CV.ML.Prefs", this.transcription)) != null) {
            Iterator<String> cvPrefIter = this.cvPrefsAdded.keySet().iterator();
            while (cvPrefIter.hasNext()) {
                cvPrefs.remove(cvPrefIter.next());
            }
        }
        Preferences.notifyListeners(this.transcription);
    }
}

