/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.io.CsvTierIO;
import mpi.eudico.client.annotator.recognizer.io.XmlTierIO;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Transcription;

public class ImportRecogTiersCommand
implements Command {
    private String name;
    private Transcription trans;

    public ImportRecogTiersCommand(String name) {
        this.name = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.trans = (Transcription)receiver;
        String filePath = this.promptForTierFile();
        if (filePath == null) {
            return;
        }
        File f = new File(filePath);
        if (f.exists() && f.canRead()) {
            List<Segmentation> segm = null;
            if (filePath.endsWith("csv")) {
                CsvTierIO cio = new CsvTierIO();
                segm = cio.read(f);
            } else {
                XmlTierIO xio = new XmlTierIO(f);
                try {
                    segm = xio.parse();
                }
                catch (Exception exe) {
                    JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.trans), exe.getMessage(), ElanLocale.getString("Message.Error"), 0);
                }
            }
            if (segm != null && segm.size() > 0) {
                Command cc = ELANCommandFactory.createCommand(this.trans, "Seg2TierDlg");
                cc.execute(this.trans, new Object[]{segm});
            } else {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.trans), ElanLocale.getString("Recognizer.RecognizerPanel.Warning.NoTiers"), ElanLocale.getString("Message.Error"), 2);
            }
        } else {
            JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.trans), ElanLocale.getString("Recognizer.RecognizerPanel.Warning.LoadFailed"), ElanLocale.getString("Message.Error"), 2);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private String promptForTierFile() {
        ArrayList<String[]> extensions = new ArrayList<String[]>();
        extensions.add(FileExtension.CSV_EXT);
        FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(this.trans));
        chooser.createAndShowFileDialog(null, 0, extensions, FileExtension.XML_EXT, "Recognizer.Path", null);
        File f = chooser.getSelectedFile();
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }
}

