/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import java.util.ArrayList;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.subtitletext.SubtitleDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.subtitletext.SubtitleFormat;

public class ImportSubtitleTextDlgCommand
implements Command {
    private String commandName;

    public ImportSubtitleTextDlgCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        TranscriptionImpl trans = (TranscriptionImpl)receiver;
        FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(trans));
        ArrayList<String[]> extensions = new ArrayList<String[]>();
        extensions.add(FileExtension.SUBRIP_EXT);
        extensions.add(FileExtension.TEXT_EXT);
        chooser.createAndShowFileAndEncodingDialog(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"), 0, null, extensions, FileExtension.SUBRIP_EXT, false, "LastUsedSubtitlesDir", FileChooser.encodings, "UTF-8", 0, null);
        File subFile = chooser.getSelectedFile();
        String charSet = chooser.getSelectedEncoding();
        if (subFile != null) {
            String fullPath = subFile.getAbsolutePath();
            fullPath = fullPath.replace('\\', '/');
            String lowerPath = fullPath.toLowerCase();
            SubtitleDecoderInfo decoderInfo = new SubtitleDecoderInfo();
            decoderInfo.setSourceFilePath(fullPath);
            if (lowerPath.endsWith("srt")) {
                decoderInfo.setFormat(SubtitleFormat.SUBRIP);
            } else if (lowerPath.endsWith("txt")) {
                decoderInfo.setFormat(SubtitleFormat.AUDACITY_lABELS);
            }
            decoderInfo.setFileEncoding(charSet);
            Command com = ELANCommandFactory.createCommand(trans, "Menu.File.Import.Subtitle");
            com.execute(trans, new Object[]{decoderInfo});
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

