/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.HashMap;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;

public class MergeCVSCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private ControlledVocabulary conVoc;
    private ControlledVocabulary secConVoc;
    private ControlledVocabulary mergedConVoc;
    private ArrayList<CVEntry> copiedEntries;

    public MergeCVSCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        ControlledVocabulary check;
        if (this.conVoc != null && this.copiedEntries != null && this.copiedEntries.size() > 0) {
            for (int i = 0; i < this.copiedEntries.size(); ++i) {
                CVEntry entry = this.copiedEntries.get(i);
                this.conVoc.removeEntry(entry);
            }
        } else if (this.mergedConVoc != null && this.conVoc != null && (check = this.transcription.getControlledVocabulary(this.mergedConVoc.getName())) == this.mergedConVoc) {
            this.transcription.replaceControlledVocabulary(this.conVoc);
        }
    }

    @Override
    public void redo() {
        ControlledVocabulary check;
        if (this.conVoc != null && this.copiedEntries != null && this.copiedEntries.size() > 0) {
            for (int i = 0; i < this.copiedEntries.size(); ++i) {
                CVEntry entry = this.copiedEntries.get(i);
                this.conVoc.addEntry(entry);
            }
        } else if (this.mergedConVoc != null && this.conVoc != null && (check = this.transcription.getControlledVocabulary(this.conVoc.getName())) == this.conVoc) {
            this.transcription.replaceControlledVocabulary(this.mergedConVoc);
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.conVoc = (ControlledVocabulary)arguments[0];
        this.secConVoc = (ControlledVocabulary)arguments[1];
        if (this.transcription.getControlledVocabulary(this.conVoc.getName()) != null && this.secConVoc != null) {
            boolean simple;
            boolean bl = simple = this.conVoc.getNumberOfLanguages() == 1 && this.secConVoc.getNumberOfLanguages() == 1 && this.conVoc.getLongLanguageId(0).equals(this.secConVoc.getLongLanguageId(0));
            if (simple) {
                CVEntry[] first = this.conVoc.getEntriesSortedByAlphabet(0);
                CVEntry[] second = this.secConVoc.getEntriesSortedByAlphabet(0);
                this.copiedEntries = new ArrayList();
                block0: for (int i = 0; i < second.length; ++i) {
                    for (int j = 0; j < first.length && !first[j].getValue(0).equals(second[i].getValue(0)); ++j) {
                        if (j != first.length - 1 && first[j].getValue(0).compareTo(second[i].getValue(0)) <= 0) continue;
                        CVEntry nextEntry = new CVEntry(this.conVoc, second[i]);
                        this.copiedEntries.add(nextEntry);
                        this.conVoc.addEntry(nextEntry);
                        continue block0;
                    }
                }
            } else {
                this.mergedConVoc = this.complicatedMerge(this.conVoc, this.secConVoc);
                this.transcription.replaceControlledVocabulary(this.mergedConVoc);
            }
        }
    }

    private ControlledVocabulary complicatedMerge(ControlledVocabulary one, ControlledVocabulary two) {
        ControlledVocabulary dest = new ControlledVocabulary(one.getName());
        HashMap<String, Integer> langCache = new HashMap<String, Integer>();
        ArrayList<String> overlap = new ArrayList<String>();
        int nLangs1 = one.getNumberOfLanguages();
        for (int i = 0; i < nLangs1; ++i) {
            String id = one.getLanguageId(i);
            String longId = one.getLongLanguageId(i);
            String label = one.getLanguageLabel(i);
            int index = dest.addLanguage(id, longId, label);
            langCache.put(longId, index);
        }
        int nLangs2 = two.getNumberOfLanguages();
        for (int i = 0; i < nLangs2; ++i) {
            Object id = two.getLanguageId(i);
            String longId = two.getLongLanguageId(i);
            String label = two.getLanguageLabel(i);
            if (langCache.containsKey(longId)) {
                overlap.add(longId);
                continue;
            }
            while (one.getIndexOfLanguage((String)id) >= 0) {
                id = (String)id + String.valueOf((int)(Math.random() * 10000.0));
            }
            int index = dest.addLanguage((String)id, longId, label);
            langCache.put(longId, index);
        }
        if (overlap.isEmpty()) {
            this.putIn(dest, one);
            this.putIn(dest, two);
        } else {
            if (overlap.size() != 1) {
                // empty if block
            }
            String overlap1 = (String)overlap.get(0);
            int indexd = dest.getIndexOfLanguage(overlap1);
            int index2 = two.getIndexOfLanguage(overlap1);
            this.putIn(dest, one);
            this.mergeIn(dest, indexd, two, index2);
        }
        return dest;
    }

    private int[] makeIndexMapping(ControlledVocabulary dest, ControlledVocabulary src) {
        int nLanguages = src.getNumberOfLanguages();
        int[] mapping = new int[nLanguages];
        for (int i = 0; i < nLanguages; ++i) {
            int mapped;
            mapping[i] = mapped = dest.getIndexOfLanguage(src.getLongLanguageId(i));
        }
        return mapping;
    }

    private void putIn(ControlledVocabulary dest, ControlledVocabulary src) {
        int nLanguages = src.getNumberOfLanguages();
        int[] mapping = this.makeIndexMapping(dest, src);
        for (CVEntry e : src) {
            CVEntry newEntry = e.cloneExceptValues(dest);
            for (int i = 0; i < nLanguages; ++i) {
                int mapped = mapping[i];
                newEntry.setValue(mapped, e.getValue(i));
                newEntry.setDescription(mapped, e.getDescription(i));
            }
            dest.addEntry(newEntry);
        }
    }

    private void mergeIn(ControlledVocabulary dest, int destIndex, ControlledVocabulary src, int srcIndex) {
        int nLanguages = src.getNumberOfLanguages();
        int[] mapping = this.makeIndexMapping(dest, src);
        for (CVEntry e : src) {
            String overlapValue = e.getValue(srcIndex);
            CVEntry destEntry = null;
            int dontCopyIndex = srcIndex;
            if (!overlapValue.isEmpty()) {
                destEntry = dest.getEntryWithValue(destIndex, overlapValue);
            }
            if (destEntry == null) {
                destEntry = e.cloneExceptValues(dest);
                dest.addEntry(destEntry);
                dontCopyIndex = -1;
            }
            for (int i = 0; i < nLanguages; ++i) {
                String d;
                if (i == dontCopyIndex) continue;
                int mapped = mapping[i];
                String v = e.getValue(i);
                if (!v.isEmpty()) {
                    destEntry.setValue(mapped, v);
                }
                if ((d = e.getDescription(i)) == null || d.isEmpty()) continue;
                destEntry.setDescription(mapped, d);
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

