/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.interlinear.Interlinear;
import mpi.eudico.client.annotator.interlinear.InterlinearPrintable;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class PrintCommand
implements Command {
    public static PrinterJob printJob = PrinterJob.getPrinterJob();
    public static PageFormat pageFormat = printJob.defaultPage();
    private String commandName;

    public PrintCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        Interlinear interlinear;
        Transcription tr = (Transcription)receiver;
        if (arguments == null) {
            interlinear = new Interlinear((TranscriptionImpl)tr);
            interlinear.renderView(new BufferedImage(10, 10, 1));
        } else {
            interlinear = (Interlinear)arguments[0];
        }
        InterlinearPrintable printable = new InterlinearPrintable(interlinear);
        printJob.setPrintable(printable, pageFormat);
        printJob.setPageable(printable);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(tr), ElanLocale.getString("InterlinearizerOptionsDlg.Error.Print") + " \n(" + ex.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    static {
        int orient = pageFormat.getOrientation();
        Double doublePref = Preferences.getDouble("PageFormat.Height", null);
        double h = doublePref != null ? doublePref.doubleValue() : pageFormat.getHeight();
        doublePref = Preferences.getDouble("PageFormat.Width", null);
        double w = doublePref != null ? doublePref.doubleValue() : pageFormat.getWidth();
        doublePref = Preferences.getDouble("PageFormat.ImgX", null);
        double imgX = doublePref != null ? doublePref.doubleValue() : pageFormat.getImageableX();
        doublePref = Preferences.getDouble("PageFormat.ImgY", null);
        double imgY = doublePref != null ? doublePref.doubleValue() : pageFormat.getImageableY();
        doublePref = Preferences.getDouble("PageFormat.ImgHeight", null);
        double imgH = doublePref != null ? doublePref.doubleValue() : pageFormat.getImageableHeight();
        doublePref = Preferences.getDouble("PageFormat.ImgWidth", null);
        double imgW = doublePref != null ? doublePref.doubleValue() : pageFormat.getImageableWidth();
        Integer intPref = Preferences.getInt("PageFormat.Orientation", null);
        if (intPref != null) {
            orient = intPref;
        }
        Paper p = new Paper();
        p.setSize(w, h);
        p.setImageableArea(imgX, imgY, imgW, imgH);
        PageFormat pf = new PageFormat();
        pf.setOrientation(orient);
        pf.setPaper(p);
        pageFormat = pf;
    }
}

