/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ShiftAllAnnotationsCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private long shiftValue = 0L;

    public ShiftAllAnnotationsCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        if (arguments != null && arguments.length >= 1) {
            this.shiftValue = (Long)arguments[0];
        }
        this.shiftAll(this.shiftValue);
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    @Override
    public void undo() {
        this.shiftAll(-this.shiftValue);
    }

    @Override
    public void redo() {
        this.shiftAll(this.shiftValue);
    }

    private void shiftAll(long value) {
        if (this.transcription != null) {
            try {
                this.transcription.shiftAllAnnotations(value);
            }
            catch (IllegalArgumentException iae) {
                ClientLogger.LOG.warning(iae.getMessage());
            }
        }
    }
}

