/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.event.IllegalEditException;

public class ShiftAnnotationsCommand
implements UndoableCommand {
    String commandName;
    TranscriptionImpl transcription;
    private TierImpl tier;
    Long bt;
    Long et;
    Long shiftValue;
    long availBT;
    long availET;

    public ShiftAnnotationsCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void redo() {
        if (this.transcription != null) {
            this.transcription.setNotifying(false);
            int numShifted = this.shift(this.tier, this.shiftValue, this.bt, this.et);
            if (numShifted > 0) {
                this.transcription.handleModification(this.transcription, 14, this.transcription);
            }
            this.transcription.setNotifying(true);
        }
    }

    @Override
    public void undo() {
        if (this.transcription != null) {
            this.transcription.setNotifying(false);
            int numShifted = this.shift(this.tier, -this.shiftValue.longValue(), this.availBT, this.availET);
            if (numShifted > 0) {
                this.transcription.handleModification(this.transcription, 14, this.transcription);
            }
            this.transcription.setNotifying(true);
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        if (arguments != null) {
            this.tier = (TierImpl)arguments[0];
            this.bt = (Long)arguments[1];
            this.et = (Long)arguments[2];
            this.shiftValue = (Long)arguments[3];
            this.availBT = this.getBoundaryBefore(this.tier, this.bt);
            this.availET = this.getBoundaryAfter(this.tier, this.et);
            this.transcription.setNotifying(false);
            int numShifted = this.shift(this.tier, this.shiftValue, this.bt, this.et);
            if (numShifted > 0) {
                this.transcription.handleModification(this.transcription, 14, this.transcription);
            }
            this.transcription.setNotifying(true);
        }
    }

    int shift(TierImpl tier, long shiftValue, long bt, long et) {
        if (tier != null) {
            try {
                return tier.shiftAnnotations(shiftValue, bt, et);
            }
            catch (IllegalArgumentException iae) {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.transcription), ElanLocale.getString("ShiftAllDialog.Warn5") + " " + iae.getMessage(), ElanLocale.getString("Message.Warning"), 2);
                iae.printStackTrace();
            }
            catch (IllegalEditException iee) {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.transcription), ElanLocale.getString("ShiftAllDialog.Warn5") + " " + iee.getMessage(), ElanLocale.getString("Message.Warning"), 2);
                iee.printStackTrace();
            }
        }
        return 0;
    }

    long getBoundaryBefore(TierImpl tier, long bt) {
        if (bt == 0L) {
            return bt;
        }
        Annotation a = tier.getAnnotationBefore(bt);
        if (a != null) {
            return a.getEndTimeBoundary();
        }
        return 0L;
    }

    long getBoundaryAfter(TierImpl tier, long et) {
        if (et == Long.MAX_VALUE) {
            return et;
        }
        Annotation a = tier.getAnnotationAfter(et);
        if (a != null) {
            return a.getBeginTimeBoundary();
        }
        return Long.MAX_VALUE;
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

