/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.List;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ShiftAnnotationsDialog;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class ShiftAnnotationsDlgCommand
implements Command {
    private String commandName;

    public ShiftAnnotationsDlgCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        Transcription transcription = (Transcription)receiver;
        if (arguments != null) {
            TierImpl tier = (TierImpl)arguments[0];
            Long bt = (Long)arguments[1];
            Long et = (Long)arguments[2];
            if (tier.hasParentTier() || !tier.isTimeAlignable()) {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(transcription), ElanLocale.getString("ShiftAllDialog.Warn6"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            List<AbstractAnnotation> annos = tier.getAnnotations();
            AlignableAnnotation beforeAnn = null;
            AlignableAnnotation afterAnn = null;
            AlignableAnnotation firstIn = null;
            AlignableAnnotation lastIn = null;
            for (AlignableAnnotation alignableAnnotation : annos) {
                if (alignableAnnotation.getEnd().getTime() <= bt || alignableAnnotation.getBegin().getTime() < bt && alignableAnnotation.getEnd().getTime() < et) {
                    beforeAnn = alignableAnnotation;
                    continue;
                }
                if (alignableAnnotation.getBegin().getTime() >= et || alignableAnnotation.getBegin().getTime() > bt && alignableAnnotation.getEnd().getTime() > et) {
                    afterAnn = alignableAnnotation;
                    break;
                }
                if (alignableAnnotation.getBegin().getTime() <= bt && alignableAnnotation.getEnd().getTime() > et || alignableAnnotation.getBegin().getTime() < bt && alignableAnnotation.getEnd().getTime() >= et) break;
                if (firstIn == null) {
                    firstIn = alignableAnnotation;
                }
                lastIn = alignableAnnotation;
            }
            if (firstIn == null) {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(transcription), ElanLocale.getString("ShiftAllDialog.Warn3"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            long min = 0L;
            long max = 0L;
            min = beforeAnn != null ? beforeAnn.getEnd().getTime() - firstIn.getBegin().getTime() : -firstIn.getBegin().getTime();
            max = afterAnn != null ? afterAnn.getBegin().getTime() - lastIn.getEnd().getTime() : Integer.MAX_VALUE;
            if (min == 0L && max == 0L) {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(transcription), ElanLocale.getString("ShiftAllDialog.Warn4"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            long shiftValue = 0L;
            ShiftAnnotationsDialog dlg = new ShiftAnnotationsDialog(transcription, min, max);
            dlg.setVisible(true);
            shiftValue = dlg.getValue();
            if (shiftValue != 0L) {
                Command com = ELANCommandFactory.createCommand(transcription, "CommandActions.ShiftAnnotations");
                com.execute(transcription, new Object[]{tier, bt, et, new Long(shiftValue)});
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

