/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.commands.AbstractProgressCommand;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.MergeTranscriptionsByAddingCommand;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.webserviceclient.weblicht.TCFtoTranscription;
import mpi.eudico.webserviceclient.weblicht.TiersToTCF;
import mpi.eudico.webserviceclient.weblicht.WLServiceDescriptor;
import mpi.eudico.webserviceclient.weblicht.WebLichtWsClient;
import org.xml.sax.SAXException;

public class WebLichtTierBasedCommand
extends AbstractProgressCommand
implements UndoableCommand {
    private MergeTranscriptionsByAddingCommand mergeCommand;
    private TranscriptionImpl transcription;
    private WLServiceDescriptor wlDescriptor;
    private TiersToTCF tiersToTCF;
    private String tierName;
    private String contentType;

    public WebLichtTierBasedCommand(String theName) {
        super(theName);
    }

    @Override
    public void undo() {
        if (this.mergeCommand != null) {
            this.mergeCommand.undo();
        }
    }

    @Override
    public void redo() {
        if (this.mergeCommand != null) {
            this.mergeCommand.redo();
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.wlDescriptor = (WLServiceDescriptor)arguments[0];
        this.tierName = (String)arguments[1];
        this.contentType = (String)arguments[2];
        if (this.contentType == null) {
            this.contentType = "sentence";
        }
        if (!this.cancelled) {
            new WLTThread().start();
        } else {
            this.progressInterrupt("The process was cancelled");
        }
    }

    private class WLTThread
    extends Thread {
        private WLTThread() {
        }

        @Override
        public void run() {
            if (WebLichtTierBasedCommand.this.transcription != null) {
                TierImpl tier = WebLichtTierBasedCommand.this.transcription.getTierWithId(WebLichtTierBasedCommand.this.tierName);
                if (tier == null) {
                    WebLichtTierBasedCommand.this.progressInterrupt("A tier of that name has not been found: " + WebLichtTierBasedCommand.this.tierName);
                    return;
                }
                if (WebLichtTierBasedCommand.this.contentType.equals("sentence")) {
                    this.processSentenceLevel(tier);
                } else if (WebLichtTierBasedCommand.this.contentType.equals("token")) {
                    this.processWordLevel(tier);
                } else {
                    ClientLogger.LOG.warning("Unknown content type of the tier, cannot proceed");
                    WebLichtTierBasedCommand.this.progressInterrupt("Unknown content type of the tier, cannot proceed");
                }
            } else {
                ClientLogger.LOG.warning("There is no transcription, cannot do anything");
                WebLichtTierBasedCommand.this.progressInterrupt("There is no transcription, cannot do anything");
            }
        }

        private void processSentenceLevel(TierImpl tier) {
            if (tier == null) {
                ClientLogger.LOG.warning("There is no tier to process.");
                return;
            }
            WebLichtTierBasedCommand.this.tiersToTCF = new TiersToTCF();
            WebLichtWsClient wsClient = new WebLichtWsClient();
            String tcfString = null;
            tcfString = WebLichtTierBasedCommand.this.tiersToTCF.toTCFString(tier, "Sentence");
            if (tcfString != null) {
                WebLichtTierBasedCommand.this.progressUpdate(10, "Created TCF format from input tier");
                String tcfString2 = null;
                try {
                    tcfString2 = wsClient.callWithTCF(((WebLichtTierBasedCommand)WebLichtTierBasedCommand.this).wlDescriptor.fullURL, tcfString);
                    WebLichtTierBasedCommand.this.progressUpdate(50, "Uploaded the input to the service");
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("An error occurred while calling a web service: " + ioe.getMessage());
                    WebLichtTierBasedCommand.this.progressInterrupt("An error occurred while calling a web service: " + ioe.getMessage());
                    return;
                }
                if (tcfString2 != null) {
                    WebLichtTierBasedCommand.this.progressUpdate(52, "Uploaded the input to the service, received output");
                    TCFtoTranscription tctt = new TCFtoTranscription();
                    tctt.setDefaultDuration(1000L);
                    try {
                        TranscriptionImpl nextTrans = tctt.createTranscription(tcfString2);
                        WebLichtTierBasedCommand.this.progressUpdate(60, "Converted returned content to tiers");
                        TierImpl refTier = nextTrans.getTierWithId("sentence");
                        if (refTier == null) {
                            WebLichtTierBasedCommand.this.progressInterrupt("Could not find the Sentence level tier in the output");
                            return;
                        }
                        if (refTier.getAnnotations().size() == 0) {
                            WebLichtTierBasedCommand.this.progressInterrupt("There are no annotations on the Sentence tier");
                            return;
                        }
                        List<AbstractAnnotation> origAnns = tier.getAnnotations();
                        int numOrigAnns = origAnns.size();
                        List<AbstractAnnotation> procAnns = refTier.getAnnotations();
                        int numProcAnns = procAnns.size();
                        long origEndTime = origAnns.get(numOrigAnns - 1).getEndTimeBoundary();
                        nextTrans.shiftAllAnnotations(origEndTime);
                        for (int i = 0; i < numProcAnns; ++i) {
                            if (i >= numOrigAnns) continue;
                            AbstractAnnotation origAnn = origAnns.get(i);
                            AlignableAnnotation procAnn = (AlignableAnnotation)procAnns.get(i);
                            procAnn.updateTimeInterval(origAnn.getBeginTimeBoundary(), origAnn.getEndTimeBoundary());
                        }
                        refTier.setName(tier.getName());
                        WebLichtTierBasedCommand.this.progressUpdate(70, "Realigned the new annotations with the existing annotations, adding new annotations");
                        ArrayList<String> tiersToAdd = new ArrayList<String>();
                        List<TierImpl> depTiers = refTier.getDependentTiers();
                        for (int i = 0; i < depTiers.size(); ++i) {
                            TierImpl depTier = depTiers.get(i);
                            if (depTier.getAnnotations().size() <= 0) continue;
                            tiersToAdd.add(depTier.getName());
                        }
                        if (tiersToAdd.size() == 0) {
                            WebLichtTierBasedCommand.this.progressInterrupt("There were no annotation produced under the sentence level");
                            return;
                        }
                        this.updateTierNames(WebLichtTierBasedCommand.this.transcription, nextTrans, tiersToAdd);
                        MergeTranscriptionsByAddingCommand command = (MergeTranscriptionsByAddingCommand)ELANCommandFactory.createCommand(WebLichtTierBasedCommand.this.transcription, "Menu.Options.WebServices.WebLicht");
                        command.execute(WebLichtTierBasedCommand.this.transcription, new Object[]{nextTrans, tiersToAdd, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE});
                        ClientLogger.LOG.info("Merged in the produced tiers and annotations.");
                        WebLichtTierBasedCommand.this.progressComplete("Merged in the produced tiers and annotations.");
                    }
                    catch (SAXException sax) {
                        ClientLogger.LOG.warning("An error occurred while parsing the returned TCF file: " + sax.getMessage());
                        WebLichtTierBasedCommand.this.progressInterrupt("An error occurred while parsing the returned TCF file: " + sax.getMessage());
                    }
                    catch (IOException ioe) {
                        ClientLogger.LOG.warning("An error occurred while calling a web service: " + ioe.getMessage());
                        WebLichtTierBasedCommand.this.progressInterrupt("An error occurred while calling a web service: " + ioe.getMessage());
                    }
                } else {
                    WebLichtTierBasedCommand.this.progressInterrupt("Calling the web service did not succeed, no content returned.");
                }
            } else {
                WebLichtTierBasedCommand.this.progressInterrupt("Unable to create meaningful input for the web service");
            }
        }

        private void processWordLevel(TierImpl tier) {
            if (tier == null) {
                ClientLogger.LOG.warning("There is no tier to process.");
                return;
            }
            String tcfString = null;
            if (tier.hasParentTier()) {
                TierImpl parentTier = tier.getParentTier();
                if (parentTier.hasParentTier()) {
                    // empty if block
                }
            } else {
                WebLichtTierBasedCommand.this.progressInterrupt("The tier has no parent; token type of input is expected to be on a child tier: " + WebLichtTierBasedCommand.this.tierName);
                return;
            }
            WebLichtTierBasedCommand.this.tiersToTCF = new TiersToTCF();
            tcfString = WebLichtTierBasedCommand.this.tiersToTCF.toTCFString(tier, "Token");
            WebLichtTierBasedCommand.this.progressUpdate(10, "Created TCF format from input tier");
            if (tcfString != null) {
                WebLichtWsClient wsClient = new WebLichtWsClient();
                String tcfString2 = null;
                try {
                    tcfString2 = wsClient.callWithTCF(((WebLichtTierBasedCommand)WebLichtTierBasedCommand.this).wlDescriptor.fullURL, tcfString);
                    WebLichtTierBasedCommand.this.progressUpdate(50, "Uploaded the input to the service");
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("An error occurred while calling a web service: " + ioe.getMessage());
                    WebLichtTierBasedCommand.this.progressInterrupt("An error occurred while calling a web service: " + ioe.getMessage());
                    return;
                }
                if (tcfString2 != null) {
                    WebLichtTierBasedCommand.this.progressUpdate(52, "Uploaded the input to the service, received output");
                    TCFtoTranscription tctt = new TCFtoTranscription();
                    tctt.setDefaultDuration(100L);
                    try {
                        AlignableAnnotation procAnn;
                        AbstractAnnotation origAnn;
                        int i;
                        List<AbstractAnnotation> procAnns;
                        int numProcAnns;
                        TranscriptionImpl nextTrans = tctt.createTranscription(tcfString2);
                        WebLichtTierBasedCommand.this.progressUpdate(60, "Converted returned content to tiers");
                        TierImpl refSentTier = nextTrans.getTierWithId("sentence");
                        if (refSentTier == null) {
                            ClientLogger.LOG.warning("Could not find the Sentence level tier in the output");
                            WebLichtTierBasedCommand.this.progressInterrupt("Could not find the Sentence level tier in the output");
                            return;
                        }
                        if (refSentTier.getAnnotations().size() == 0) {
                            ClientLogger.LOG.warning("There are no annotations on the Sentence tier");
                            WebLichtTierBasedCommand.this.progressInterrupt("There are no annotations on the Sentence tier");
                            return;
                        }
                        TierImpl refTokTier = nextTrans.getTierWithId("token");
                        if (refTokTier == null) {
                            ClientLogger.LOG.warning("Could not find the Token level tier in the output");
                            WebLichtTierBasedCommand.this.progressInterrupt("Could not find the Token level tier in the output");
                            return;
                        }
                        if (refTokTier.getAnnotations().size() == 0) {
                            ClientLogger.LOG.warning("There are no annotations on the Token tier");
                            WebLichtTierBasedCommand.this.progressInterrupt("There are no annotations on the Token tier");
                            return;
                        }
                        ArrayList<AbstractAnnotation> origAnns = new ArrayList<AbstractAnnotation>();
                        for (AbstractAnnotation tokAnn : tier.getAnnotations()) {
                            AbstractAnnotation parAnn = (AbstractAnnotation)tokAnn.getParentAnnotation();
                            if (origAnns.contains(parAnn)) continue;
                            origAnns.add(parAnn);
                        }
                        int numOrigAnns = origAnns.size();
                        if (numOrigAnns == (numProcAnns = (procAnns = refSentTier.getAnnotations()).size())) {
                            for (i = numOrigAnns - 1; i >= 0; --i) {
                                origAnn = (AbstractAnnotation)origAnns.get(i);
                                procAnn = (AlignableAnnotation)procAnns.get(i);
                                if (procAnn.getBeginTimeBoundary() <= origAnn.getBeginTimeBoundary()) {
                                    procAnn.updateTimeInterval(origAnn.getBeginTimeBoundary(), origAnn.getEndTimeBoundary());
                                    continue;
                                }
                                ClientLogger.LOG.warning("A new annotation has been positioned to the right of the original, cannot realign");
                            }
                        } else {
                            for (i = numOrigAnns - 1; i >= 0; --i) {
                                if (i >= numProcAnns) continue;
                                origAnn = (AbstractAnnotation)origAnns.get(i);
                                procAnn = (AlignableAnnotation)procAnns.get(i);
                                if (procAnn.getBeginTimeBoundary() > origAnn.getBeginTimeBoundary() || !procAnn.getValue().equals(origAnn.getValue())) continue;
                                procAnn.updateTimeInterval(origAnn.getBeginTimeBoundary(), origAnn.getEndTimeBoundary());
                            }
                        }
                        refTokTier.setName(tier.getName());
                        ArrayList<String> tiersToAdd = new ArrayList<String>();
                        List<TierImpl> depTiers = refTokTier.getDependentTiers();
                        for (int i2 = 0; i2 < depTiers.size(); ++i2) {
                            TierImpl depTier = depTiers.get(i2);
                            if (depTier.getAnnotations().size() <= 0) continue;
                            tiersToAdd.add(depTier.getName());
                        }
                        if (tiersToAdd.size() == 0) {
                            WebLichtTierBasedCommand.this.progressInterrupt("There were no annotations produced under the sentence level");
                            return;
                        }
                        this.updateTierNames(WebLichtTierBasedCommand.this.transcription, nextTrans, tiersToAdd);
                        WebLichtTierBasedCommand.this.mergeCommand = (MergeTranscriptionsByAddingCommand)ELANCommandFactory.createCommand(WebLichtTierBasedCommand.this.transcription, "Menu.Options.WebServices.WebLicht");
                        WebLichtTierBasedCommand.this.mergeCommand.execute(WebLichtTierBasedCommand.this.transcription, new Object[]{nextTrans, tiersToAdd, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE});
                        ClientLogger.LOG.info("Added the produced tiers and annotations.");
                        WebLichtTierBasedCommand.this.progressComplete("Added in the produced tiers and annotations.");
                    }
                    catch (SAXException sax) {
                        ClientLogger.LOG.warning("An error occurred while parsing the returned TCF file: " + sax.getMessage());
                        WebLichtTierBasedCommand.this.progressInterrupt("An error occurred while parsing the returned TCF file: " + sax.getMessage());
                    }
                    catch (IOException ioe) {
                        ClientLogger.LOG.warning("An error occurred while calling a web service: " + ioe.getMessage());
                        WebLichtTierBasedCommand.this.progressInterrupt("An error occurred while calling a web service: " + ioe.getMessage());
                    }
                }
            }
        }

        private void updateTierNames(Transcription refTrans, Transcription nextTrans, List<String> tiersToAdd) {
            int MAX_COUNT = 50;
            for (Tier tier : nextTrans.getTiers()) {
                String tierName = tier.getName();
                if (!tiersToAdd.contains(tierName) || refTrans.getTierWithId(tierName) == null) continue;
                int count = 1;
                Object newName = tierName;
                while (refTrans.getTierWithId((String)(newName = tierName + "-" + count++)) != null && count < 50) {
                }
                if (count >= 50) continue;
                tier.setName((String)newName);
                tiersToAdd.remove(tierName);
                tiersToAdd.add((String)newName);
            }
        }
    }
}

