/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ClipMediaCommand;
import mpi.eudico.client.annotator.commands.ClipMediaMultiCommand;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.ReportDialog;
import mpi.eudico.client.annotator.util.ClipWithScriptUtil;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextReader;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.SimpleReport;
import mpi.eudico.util.TimeFormatter;

public class ClipMediaMultiMA
extends FrameMenuAction {
    private final String scriptFileName = "clip-media.txt";

    public ClipMediaMultiMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ClipWithScriptUtil scriptUtil = new ClipWithScriptUtil();
        SimpleReport report = new SimpleReport();
        report.append("Starting multiple file clipping...");
        File scriptFile = scriptUtil.getScriptFile("clip-media.txt");
        if (scriptFile == null) {
            this.showWarningMessage("The script file (clip-media.txt) containing the configuration for clipping is not found");
            return;
        }
        report.append("Script file: " + scriptFile.getAbsolutePath());
        String[] scriptLine = scriptUtil.parseScriptLine(scriptFile);
        if (scriptLine == null || scriptLine.length < 2) {
            this.showWarningMessage(ElanLocale.getString("ClipMedia.Error.Message") + " " + ElanLocale.getString("ClipMedia.Error.Message.NoParameters"));
            return;
        }
        String executable = scriptLine[0];
        String paramLine = scriptLine[1];
        report.append("Executable: " + executable);
        report.append("Parameter part: " + paramLine);
        FileChooser chooser = new FileChooser(this.frame);
        chooser.createAndShowFileDialog(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"), 0, FileExtension.CSV_EXT, "LastUsedCSVDir");
        File tabDelFile = chooser.getSelectedFile();
        if (tabDelFile != null) {
            report.append("Input file: " + tabDelFile.getAbsolutePath());
            try {
                DelimitedTextReader reader = new DelimitedTextReader(tabDelFile);
                reader.detectDelimiter();
                int numCol = reader.detectNumColumns();
                if (numCol < 3) {
                    this.showWarningMessage("Too few columns in the tab-delimited text/csv file to perform clipping.");
                    return;
                }
                int[] columns = new int[]{0, 1, numCol - 1};
                List<String[]> rowDataList = reader.getRowDataForColumns(reader.getFirstRowIndex(), columns);
                if (rowDataList == null || rowDataList.size() == 0) {
                    this.showWarningMessage("No row data could be extracted from the file.");
                    return;
                }
                File outputFolder = null;
                FileChooser foldChooser = new FileChooser(this.frame);
                foldChooser.createAndShowFileDialog(ElanLocale.getString("ActivityMonitoringDialog.OpenDialog.Title"), 0, ElanLocale.getString("Button.OK"), null, null, false, "LastUsedExportDir", 1, null);
                outputFolder = foldChooser.getSelectedFile();
                if (outputFolder == null) {
                    this.showWarningMessage("No output folder provided.");
                    return;
                }
                if (!outputFolder.exists()) {
                    this.showWarningMessage("The provided output folder does not exist.");
                    return;
                }
                report.append("Output folder is: " + outputFolder.getAbsolutePath());
                HashMap<String, List<long[]>> groupedSegments = new HashMap<String, List<long[]>>();
                for (int i = 0; i < rowDataList.size(); ++i) {
                    String[] rowData = rowDataList.get(i);
                    if (rowData == null || rowData.length < 3) {
                        report.append("Encountered a line holding no or invalid information for clipping: " + (i + 1));
                        continue;
                    }
                    long bt = this.extractTime(rowData[0]);
                    if (bt < 0L) {
                        report.append("Invalid begin time on line: " + (i + 1));
                        continue;
                    }
                    long et = this.extractTime(rowData[1]);
                    if (et <= bt) {
                        report.append("Invalid end time on line: " + (i + 1));
                        continue;
                    }
                    String filePath = rowData[2].trim();
                    if (filePath.charAt(0) == '\"') {
                        filePath = filePath.substring(1);
                    }
                    if (filePath.charAt(filePath.length() - 1) == '\"') {
                        filePath = filePath.substring(0, filePath.length() - 1);
                    }
                    if (groupedSegments.containsKey(filePath)) {
                        ((List)groupedSegments.get(filePath)).add(new long[]{bt, et});
                        continue;
                    }
                    ArrayList<long[]> segList = new ArrayList<long[]>();
                    groupedSegments.put(filePath, segList);
                    segList.add(new long[]{bt, et});
                    report.append("Encountered file " + filePath + ". Linked media files will be clipped.");
                }
                if (groupedSegments.size() == 0) {
                    this.showWarningMessage("No information for clipping could be extracted from the text file.");
                    return;
                }
                ClippingProgressThread progressMonitor = new ClippingProgressThread(executable, paramLine, outputFolder.getAbsolutePath(), groupedSegments, report);
                progressMonitor.start();
            }
            catch (FileNotFoundException fnfe) {
                this.showWarningMessage("The selected file is not found.");
            }
            catch (IOException ioe) {
                this.showWarningMessage("Error while reading the file.");
            }
        }
    }

    private long extractTime(String time) {
        if (time != null) {
            return TimeFormatter.toMilliSeconds(time);
        }
        return -1L;
    }

    private Transcription loadEafFile(String path) {
        if (path != null) {
            File transFile = new File(path = FileUtility.urlToAbsPath(path));
            if (!transFile.exists()) {
                return null;
            }
            return new TranscriptionImpl(new File(path).getAbsolutePath());
        }
        return null;
    }

    private void showWarningMessage(String message) {
        JOptionPane.showMessageDialog(this.frame, message, ElanLocale.getString("Message.Warning"), 2);
    }

    class ClippingProgressThread
    extends Thread {
        private ProgressMonitor monitor;
        private Map<String, List<long[]>> groupedSegments;
        private ProcessReport report;
        private String executable;
        private String paramLine;
        private String outputPath;
        private final int MULT = 10;

        ClippingProgressThread(String executable, String paramLine, String outputPath, Map<String, List<long[]>> groupedSegments, ProcessReport report) {
            this.executable = executable;
            this.paramLine = paramLine;
            this.outputPath = outputPath;
            this.groupedSegments = groupedSegments;
            this.report = report;
        }

        @Override
        public void run() {
            Iterator<String> groupIter = this.groupedSegments.keySet().iterator();
            int max = this.groupedSegments.size() * 10 + 2;
            int prog = 0;
            int fileCount = 0;
            JLabel message = new JLabel("Clipping progress");
            message.setMinimumSize(new Dimension(400, message.getMinimumSize().height));
            message.setPreferredSize(new Dimension(400, message.getMinimumSize().height));
            this.monitor = new ProgressMonitor(ClipMediaMultiMA.this.frame, message, "Preparing clipping...", 0, max);
            this.monitor.setMillisToDecideToPopup(10);
            this.monitor.setMillisToPopup(50);
            for (int i = 0; i < 2; ++i) {
                prog = i;
                this.monitor.setProgress(i);
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            while (groupIter.hasNext()) {
                if (this.monitor.isCanceled()) {
                    this.report.append("The process has been canceled after: " + fileCount + " transcription files.");
                    this.monitor.close();
                    break;
                }
                String curEafPath = groupIter.next();
                prog += 10;
                this.monitor.setNote("Processing clips based on eaf file: " + FileUtility.fileNameFromPath(curEafPath));
                Transcription trans = ClipMediaMultiMA.this.loadEafFile(curEafPath);
                ++fileCount;
                if (trans == null) {
                    this.report.append("Unable to load the .eaf file: " + curEafPath + ". The linked media files cannot be retrieved and are skipped.");
                    this.monitor.setProgress(prog);
                    continue;
                }
                ClipMediaMultiCommand command = new ClipMediaMultiCommand("ClipMulti");
                List<long[]> curSegs = this.groupedSegments.get(curEafPath);
                ((ClipMediaCommand)command).execute(trans, new Object[]{this.executable, this.paramLine, curSegs, this.outputPath, this.report});
                this.report.append("Processing of " + curEafPath + " done. (But the actual clipping might still continue.)");
                this.monitor.setProgress(prog);
            }
            this.monitor.setProgress(this.monitor.getMaximum());
            ReportDialog repDialog = new ReportDialog((Frame)ClipMediaMultiMA.this.frame, this.report);
            repDialog.setVisible(true);
        }
    }
}

