/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.subtitletext.SubtitleDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.subtitletext.SubtitleFormat;

public class ImportSubtitleTextMA
extends FrameMenuAction {
    public ImportSubtitleTextMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block6: {
            FileChooser chooser = new FileChooser(this.frame);
            ArrayList<String[]> extensions = new ArrayList<String[]>();
            extensions.add(FileExtension.SUBRIP_EXT);
            extensions.add(FileExtension.TEXT_EXT);
            chooser.createAndShowFileAndEncodingDialog(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"), 0, null, extensions, FileExtension.SUBRIP_EXT, false, "LastUsedSubtitlesDir", FileChooser.encodings, "UTF-8", 0, null);
            File subFile = chooser.getSelectedFile();
            String charSet = chooser.getSelectedEncoding();
            if (subFile != null) {
                String fullPath = subFile.getAbsolutePath();
                fullPath = fullPath.replace('\\', '/');
                String lowerPath = fullPath.toLowerCase();
                SubtitleDecoderInfo decoderInfo = new SubtitleDecoderInfo();
                decoderInfo.setSourceFilePath(fullPath);
                if (lowerPath.endsWith("srt")) {
                    decoderInfo.setFormat(SubtitleFormat.SUBRIP);
                } else if (lowerPath.endsWith("txt")) {
                    decoderInfo.setFormat(SubtitleFormat.AUDACITY_lABELS);
                }
                decoderInfo.setFileEncoding(charSet);
                try {
                    TranscriptionImpl trans = new TranscriptionImpl(fullPath, decoderInfo);
                    trans.setChanged();
                    FrameManager.getInstance().createFrame(trans);
                }
                catch (Throwable t) {
                    if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block6;
                    ClientLogger.LOG.warning("An error occurred while importing: " + t.getMessage());
                }
            }
        }
    }
}

