/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.ToolTipManager;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.smfsearch.StructuredMultipleFileSearchFrame;

public class StructuredSearchMultipleMA
extends FrameMenuAction
implements WindowListener {
    private static int numWindows = 0;
    private static JFrame globalSearchFrame = null;

    public StructuredSearchMultipleMA(String name, ElanFrame2 frame) {
        super(name, frame);
        ++numWindows;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (globalSearchFrame != null) {
            if (!globalSearchFrame.isVisible()) {
                globalSearchFrame.setVisible(true);
            }
            globalSearchFrame.toFront();
        } else {
            Dimension size;
            globalSearchFrame = new StructuredMultipleFileSearchFrame(this.frame);
            Point p = Preferences.getPoint("MFSearchFrame.Location", null);
            if (p != null) {
                int MARGIN = 30;
                Rectangle wRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                if (p.x < wRect.x) {
                    p.x = wRect.x;
                } else if (p.x > wRect.width - 30) {
                    p.x = wRect.width - 30;
                }
                if (p.y < wRect.y) {
                    p.y = wRect.y;
                } else if (p.y > wRect.height - 30) {
                    p.y = wRect.height - 30;
                }
                globalSearchFrame.setLocation(p);
            }
            if ((size = Preferences.getDimension("MFSearchFrame.Size", null)) != null) {
                globalSearchFrame.setSize(size);
            }
            globalSearchFrame.addWindowListener(this);
            globalSearchFrame.setVisible(true);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (e.getWindow() != null) {
            Boolean ttPref;
            Preferences.set("MFSearchFrame.Location", e.getWindow().getLocation(), null, false, false);
            Preferences.set("MFSearchFrame.Size", e.getWindow().getSize(), null, false, false);
            e.getWindow().removeWindowListener(this);
            globalSearchFrame = null;
            if (--numWindows == 0 && (ttPref = Preferences.getBool("UI.ToolTips.Enabled", null)) != null && !ttPref.booleanValue() && ToolTipManager.sharedInstance().isEnabled()) {
                ToolTipManager.sharedInstance().setEnabled(false);
            }
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

