/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.comments;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.comments.CommentEnvelope;
import mpi.eudico.client.annotator.comments.Predicate;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class CommentEnvelopesParser {
    private XMLReader reader;
    private List<CommentEnvelope> messages;
    private Predicate<CommentEnvelope> filter;

    public CommentEnvelopesParser() {
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            CommentEnvelopesHandler ceh = new CommentEnvelopesHandler();
            this.reader.setContentHandler(ceh);
            this.reader.setErrorHandler(ceh);
            this.reader.setEntityResolver(ceh);
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    public List<CommentEnvelope> parse(String filename) {
        return this.parse(filename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommentEnvelope> parse(String filename, Predicate<CommentEnvelope> filter) {
        File pf = new File(filename);
        if (pf.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(pf);
                InputSource source = new InputSource(fis);
                source.setSystemId(filename);
                List<CommentEnvelope> list = this.parse(source, filter);
                return list;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        this.messages = new ArrayList<CommentEnvelope>();
        return this.messages;
    }

    public List<CommentEnvelope> parse(InputSource input, Predicate<CommentEnvelope> filter) {
        this.messages = new ArrayList<CommentEnvelope>();
        this.filter = filter;
        try {
            this.reader.parse(input);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXParseException e) {
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return this.messages;
    }

    class CommentEnvelopesHandler
    extends DefaultHandler {
        private CommentEnvelope ctm;
        private String content;

        CommentEnvelopesHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int end) throws SAXException {
            this.content = this.content + new String(ch, start, end);
        }

        @Override
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attrs) throws SAXException {
            this.content = "";
            if (name.equals("ColTime")) {
                String url;
                this.ctm = new CommentEnvelope();
                String id = attrs.getValue("ColTimeMessageID");
                if (id != null) {
                    this.ctm.setMessageID(id);
                }
                if ((url = attrs.getValue("URL")) != null) {
                    this.ctm.setMessageURL(url);
                }
                this.ctm.setRecipient("");
            } else if (name.equals("AnnotationFile")) {
                String type;
                String id = attrs.getValue("URL");
                if (id != null) {
                    this.ctm.setAnnotationFileURL(id);
                }
                if ((type = attrs.getValue("type")) != null) {
                    this.ctm.setAnnotationFileType(type);
                }
            }
        }

        @Override
        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.equals("ColTime")) {
                if (CommentEnvelopesParser.this.filter == null || CommentEnvelopesParser.this.filter.test(this.ctm)) {
                    CommentEnvelopesParser.this.messages.add(this.ctm);
                }
                this.ctm = null;
            } else if (name.equals("Initials")) {
                this.ctm.setInitials(this.content);
            } else if (name.equals("ThreadID")) {
                this.ctm.setThreadID(this.content);
            } else if (name.equals("Sender")) {
                this.ctm.setSender(this.content);
            } else if (name.equals("Recipient")) {
                this.ctm.addRecipient(this.content);
            } else if (name.equals("CreationDate")) {
                this.ctm.setCreationDate(this.content);
            } else if (name.equals("ModificationDate")) {
                this.ctm.setModificationDate(this.content);
            } else if (name.equals("Category")) {
                this.ctm.setCategory(this.content);
            } else if (name.equals("Status")) {
                this.ctm.setStatus(this.content);
            } else if (name.equals("AnnotationFile")) {
                this.ctm.setAnnotationFile(this.content);
            } else if (name.equals("Message")) {
                this.ctm.setMessage(this.content);
            }
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            System.out.println("Error:     " + exception.getMessage());
            System.out.println("System id: " + exception.getSystemId());
            System.out.println("Public id: " + exception.getPublicId());
            System.out.println("Line:      " + exception.getLineNumber());
            System.out.println("Column:    " + exception.getColumnNumber());
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            System.out.println("FatalError: " + exception.getMessage());
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("Warning: " + exception.getMessage());
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            try {
                InputStream stream = this.getClass().getResource("/mpi/eudico/resources/ColTime.xsd").openStream();
                InputStreamReader reader = new InputStreamReader(stream);
                return new InputSource(reader);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

