/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.comments;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.viewer.CommentViewer;

public class CommentsFilterDialog
extends ClosableDialog
implements ActionListener {
    private CommentViewer viewer;
    private JLabel filterLabel;
    private JTextField filterTextField;
    private String filterString;
    private JLabel caseLabel;
    private JCheckBox caseCheckBox;
    private boolean caseSensitive;
    private JButton applyButton;
    private JButton cancelButton;

    public CommentsFilterDialog(CommentViewer commentViewer, String initialFilter, boolean caseSensitive) {
        super((Frame)null, true);
        this.viewer = commentViewer;
        this.filterString = initialFilter;
        this.caseSensitive = caseSensitive;
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        String title = ElanLocale.getString("CommentFilterDialog.Title");
        this.setTitle(title);
        this.setLayout(new GridBagLayout());
        GridBagConstraints maingbc = new GridBagConstraints();
        maingbc.gridx = 0;
        maingbc.weightx = 1.0;
        maingbc.fill = 2;
        maingbc.insets = new Insets(20, 20, 20, 20);
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        settingsPanel.setBorder(BorderFactory.createTitledBorder(title));
        GridBagConstraints settingsgbc = new GridBagConstraints();
        settingsgbc.insets = new Insets(10, 10, 10, 10);
        settingsgbc.fill = 2;
        settingsgbc.weightx = 1.0;
        settingsgbc.gridx = 0;
        settingsgbc.gridy = 0;
        JPanel textfieldsPanel = new JPanel(new GridBagLayout());
        this.filterLabel = new JLabel(ElanLocale.getString("CommentFilterDialog.FilterWithRegex"));
        this.filterTextField = new JTextField(this.filterString, 30);
        this.filterTextField.addActionListener(this);
        this.caseLabel = new JLabel(ElanLocale.getString("CommentFilterDialog.CaseSensitive"));
        this.caseCheckBox = new JCheckBox("", this.caseSensitive);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.gridx = 0;
        gbc.gridy = 0;
        textfieldsPanel.add((Component)this.filterLabel, gbc);
        ++gbc.gridy;
        textfieldsPanel.add((Component)this.caseLabel, gbc);
        ++gbc.gridy;
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        textfieldsPanel.add((Component)this.filterTextField, gbc);
        ++gbc.gridy;
        textfieldsPanel.add((Component)this.caseCheckBox, gbc);
        ++gbc.gridy;
        ++settingsgbc.gridy;
        settingsPanel.add((Component)textfieldsPanel, settingsgbc);
        this.add((Component)settingsPanel, maingbc);
        JPanel okCancelPanel = new JPanel(new GridBagLayout());
        this.applyButton = new JButton(ElanLocale.getString("CommentFilterDialog.Apply"));
        this.applyButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        okCancelPanel.add((Component)this.applyButton, gbc);
        this.cancelButton = new JButton(ElanLocale.getString("CommentFilterDialog.Cancel"));
        this.cancelButton.addActionListener(this);
        okCancelPanel.add((Component)this.cancelButton, gbc);
        this.add((Component)okCancelPanel, maingbc);
    }

    private void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        boolean caseSensitive = this.caseCheckBox.isSelected();
        if (source == this.applyButton || source == this.filterTextField) {
            this.viewer.setRegexFilter(this.filterTextField.getText(), caseSensitive);
            this.dispose();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }
}

