/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.comments;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.comments.CommentEnvelope;
import mpi.eudico.client.annotator.comments.CommentManager;
import mpi.eudico.client.annotator.comments.CommentTableModel;
import mpi.eudico.util.TimeFormatter;

public class DefaultCommentTableModel
extends AbstractTableModel
implements CommentTableModel {
    private List<CommentEnvelope> comments = new ArrayList<CommentEnvelope>(0);
    private CommentManager commentManager = null;
    private static CommentEnvelope noComment = new CommentEnvelope();
    public static final int START_TIME = 0;
    public static final int END_TIME = 1;
    public static final int TIER_NAME = 2;
    public static final int INITIALS = 3;
    public static final int COMMENT = 4;
    public static final int THREAD_ID = 5;
    public static final int SENDER = 6;
    public static final int RECIPIENT = 7;
    public static final int CREATION_DATE = 8;
    public static final int MODIFICATION_DATE = 9;
    private static final String[] columnNames = new String[]{ElanLocale.getString("CommentTable.StartTime"), ElanLocale.getString("CommentTable.EndTime"), ElanLocale.getString("CommentTable.Tier"), ElanLocale.getString("CommentTable.Initials"), ElanLocale.getString("CommentTable.Comment"), ElanLocale.getString("CommentTable.Thread"), ElanLocale.getString("CommentTable.Sender"), ElanLocale.getString("CommentTable.Recipient"), ElanLocale.getString("CommentTable.CreationDate"), ElanLocale.getString("CommentTable.ModificationDate")};

    public DefaultCommentTableModel(CommentManager cm) {
        this.commentManager = cm;
    }

    @Override
    public void setComments(List<CommentEnvelope> comments) {
        this.comments = comments;
        this.fireTableDataChanged();
    }

    @Override
    public CommentEnvelope getComment(int index) {
        if (index >= 0 && index < this.comments.size()) {
            return this.comments.get(index);
        }
        return noComment;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.comments.size();
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int col) {
        CommentEnvelope e = this.comments.get(row);
        return DefaultCommentTableModel.getValueAtColumn(e, col);
    }

    public static String getValueAtColumn(CommentEnvelope e, int col) {
        switch (col) {
            case 0: {
                return TimeFormatter.toString(e.getStartTime());
            }
            case 1: {
                return TimeFormatter.toString(e.getEndTime());
            }
            case 2: {
                return e.getTierName();
            }
            case 3: {
                return e.getInitials();
            }
            case 4: {
                return e.getMessage();
            }
            case 5: {
                return e.getThreadID();
            }
            case 6: {
                return e.getSender();
            }
            case 7: {
                return e.getRecipient();
            }
            case 8: {
                return DefaultCommentTableModel.readableTime(e.getCreationDateString());
            }
            case 9: {
                return DefaultCommentTableModel.readableTime(e.getModificationDateString());
            }
        }
        return "-";
    }

    public static String readableTime(String formal) {
        return formal.replace('T', ' ').replace("Z", " UTC");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.commentManager == null) {
            return false;
        }
        CommentEnvelope e = this.comments.get(row);
        if (e.isReadOnly()) {
            return false;
        }
        switch (col) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int row, int col) {
        if (!(object instanceof String)) {
            return;
        }
        if (this.commentManager == null) {
            return;
        }
        String value = (String)object;
        CommentEnvelope e = this.commentManager.undoableGet(row);
        switch (col) {
            case 3: {
                value = value.trim();
                e.setInitials(value);
                break;
            }
            case 4: {
                e.setMessage(value);
                break;
            }
            case 5: {
                value = value.trim();
                e.setThreadID(value);
                break;
            }
            case 6: {
                value = value.trim();
                e.setSender(value);
                break;
            }
            case 7: {
                value = value.trim();
                e.setRecipient(value);
            }
        }
        e.setModificationDate();
        this.fireTableCellUpdated(row, col);
        this.fireTableCellUpdated(row, 9);
        this.commentManager.undoableRelease(row, e);
    }
}

