/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.comments;

import java.util.Collections;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import mpi.eudico.client.annotator.comments.CommentEnvelope;
import mpi.eudico.client.annotator.comments.CommentTableModel;

public class TableModelExtender<T>
implements TableModel,
CommentTableModel {
    private CommentTableModel delegate;
    private String columnName;
    private Class<T> clazz;
    private List<T> column;
    private int delegateColumns;

    public TableModelExtender(CommentTableModel delegate, String columnName, Class<T> clazz) {
        this.delegate = delegate;
        this.columnName = columnName;
        this.clazz = clazz;
        this.column = Collections.emptyList();
        this.delegateColumns = delegate.getColumnCount();
    }

    @Override
    public void setComments(List<CommentEnvelope> comments) {
        this.delegate.setComments(comments);
    }

    @Override
    public CommentEnvelope getComment(int index) {
        return this.delegate.getComment(index);
    }

    public void setColumn(List<T> column) {
        this.column = column;
    }

    @Override
    public int getRowCount() {
        return this.delegate.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.delegateColumns + 1;
    }

    @Override
    public String getColumnName(int col) {
        if (col < this.delegateColumns) {
            return this.delegate.getColumnName(col);
        }
        return this.columnName;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col < this.delegateColumns) {
            return this.delegate.getColumnClass(col);
        }
        return this.clazz;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex < this.delegateColumns) {
            return this.delegate.getValueAt(rowIndex, columnIndex);
        }
        if (rowIndex < this.column.size()) {
            return this.column.get(rowIndex);
        }
        return "-";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex < this.delegateColumns) {
            return this.delegate.isCellEditable(rowIndex, columnIndex);
        }
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex < this.delegateColumns) {
            this.delegate.setValueAt(aValue, rowIndex, columnIndex);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.delegate.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.delegate.removeTableModelListener(l);
    }
}

