/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.dcr;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import mpi.eudico.client.annotator.util.ClientLogger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ISOCATLanguageCodeMapping {
    private static HashMap<String, String> languageCodes;

    public static String get2LetterLanguageCode(String lang) {
        if (languageCodes == null) {
            ISOCATLanguageCodeMapping.loadLanguageCodesFromCacheFile();
        }
        return languageCodes.get(lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadLanguageCodesFromCacheFile() {
        languageCodes = new HashMap();
        InputStream istr = null;
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            reader.setFeature("http://xml.org/sax/features/namespaces", false);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://apache.org/xml/features/validation/schema", false);
            reader.setFeature("http://apache.org/xml/features/validation/dynamic", false);
            reader.setContentHandler(new LanguageCodeHandler());
            URL url = reader.getClass().getResource("/org/isocat/resources/languages.xml");
            istr = url.openStream();
            InputSource iso = new InputSource(istr);
            reader.parse(iso);
        }
        catch (SAXException se) {
            ClientLogger.LOG.warning("Unable to parse the ISOcat languages cache file" + se.getMessage());
        }
        catch (IOException e) {
            ClientLogger.LOG.warning("Unable to read the ISOcat languages cache file" + e.getMessage());
        }
        finally {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (IOException se) {}
        }
    }

    static class LanguageCodeHandler
    extends DefaultHandler {
        LanguageCodeHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("language")) {
                String[] languages;
                String lang = atts.getValue("tag");
                String langList = atts.getValue("tags");
                for (String language : languages = langList.split(" ")) {
                    languageCodes.put(language, lang);
                }
            }
        }
    }
}

