/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public abstract class AbstractBasicExportDialog
extends ClosableDialog
implements ActionListener,
ClientLogger {
    public static final String LAST_USED_EXPORT_DIR = "LastUsedExportDir";
    protected final Insets insets = new Insets(4, 6, 4, 6);
    protected final JLabel titleLabel = new JLabel();
    protected final JPanel buttonPanel = new JPanel();
    protected final JPanel optionsPanel = new JPanel();
    protected final String defaultEncoding = "UTF-8";
    protected final TranscriptionImpl transcription;
    protected String encoding = "UTF-8";
    private final JButton closeButton = new JButton();
    private final JButton startButton = new JButton();
    private final int minimalHeight = 400;
    private final int minimalWidth = 550;

    public AbstractBasicExportDialog(Frame parent, boolean modal, TranscriptionImpl transcription) {
        super(parent, modal);
        this.transcription = transcription;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.startButton) {
            try {
                boolean success = this.startExport();
                if (success) {
                    this.closeDialog(null);
                }
            }
            catch (Exception ee) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error") + "\n(" + ee.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
                ee.printStackTrace();
            }
        } else if (source == this.closeButton) {
            this.closeDialog(null);
        }
    }

    protected abstract boolean startExport() throws IOException;

    protected void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void setStartButtonEnabled(boolean enabled) {
        this.startButton.setEnabled(enabled);
    }

    protected void makeLayout() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AbstractBasicExportDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        this.startButton.addActionListener(this);
        this.buttonPanel.add(this.startButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
    }

    protected void postInit() {
        this.pack();
        Rectangle pref = Preferences.getRect("AbstractBasicExportDialog.bounds", null);
        Container parent = this.getParent();
        GraphicsConfiguration graphicsConfiguration = parent.getGraphicsConfiguration();
        Rectangle screenBounds = graphicsConfiguration.getBounds();
        Insets ins = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        int maxW = screenBounds.width - ins.left - ins.right;
        int maxH = screenBounds.height - ins.top - ins.bottom;
        if (pref != null && !screenBounds.contains(pref)) {
            pref = null;
        }
        Dimension size = this.getSize();
        int targetW = pref != null ? pref.width : size.width;
        targetW = Math.max(targetW, 550);
        targetW = Math.min(targetW, maxW);
        int targetH = pref != null ? pref.height : size.height;
        targetH = Math.max(targetH, 400);
        targetH = Math.min(targetH, maxH);
        this.setSize(targetW, targetH);
        if (pref != null) {
            this.setLocation(pref.x, pref.y);
        } else {
            this.setLocationRelativeTo(this.getParent());
        }
        this.addComponentListener(new SizeListener());
    }

    protected File promptForFile(String chooserTitle, List<String[]> extensions, String[] mainExt, boolean showEncodingBox, String[] encodings) {
        String selectedFile = null;
        String ext = null;
        if (mainExt != null) {
            ext = mainExt[0];
        } else if (extensions != null) {
            for (int i = 0; i < extensions.size(); ++i) {
                String[] extArray = extensions.get(i);
                if (extArray == null || extArray.length <= 0) continue;
                ext = extArray[0];
                break;
            }
        }
        selectedFile = this.transcription != null ? AbstractBasicExportDialog.getDefaultExportFile(this.transcription.getFullPath(), ext) : AbstractBasicExportDialog.getDefaultExportFile(null, ext);
        FileChooser chooser = new FileChooser(this);
        if (showEncodingBox) {
            chooser.createAndShowFileAndEncodingDialog(chooserTitle, 1, extensions, mainExt, LAST_USED_EXPORT_DIR, encodings, null, selectedFile);
        } else {
            chooser.createAndShowFileDialog(chooserTitle, 1, extensions, mainExt, LAST_USED_EXPORT_DIR, selectedFile);
        }
        if (showEncodingBox) {
            this.encoding = chooser.getSelectedEncoding();
        }
        return chooser.getSelectedFile();
    }

    protected File promptForFile(String chooserTitle, List<String[]> extensions, String[] mainExt, boolean showEncodingBox) {
        return this.promptForFile(chooserTitle, extensions, mainExt, showEncodingBox, null);
    }

    protected void updateLocale() {
        this.startButton.setText(ElanLocale.getString("Button.OK"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
    }

    private static String getDefaultExportFile(String transcriptionPath, String extension) {
        File file = null;
        if (transcriptionPath != null) {
            file = new File(transcriptionPath);
        }
        int index = -1;
        if (file != null) {
            index = file.getName().lastIndexOf(46);
        }
        String exportFileName = index > -1 ? file.getName().substring(0, index) : ElanLocale.getString("Frame.ElanFrame.Untitled");
        return exportFileName + "." + extension;
    }

    class SizeListener
    extends ComponentAdapter {
        SizeListener() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.componentResized(e);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Rectangle bounds = AbstractBasicExportDialog.this.getBounds();
            Preferences.set("AbstractBasicExportDialog.bounds", bounds, null, false, false);
        }
    }
}

