/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.chat.CHATEncoderInfo;

public class CHATExportDlg
extends ClosableDialog
implements ActionListener {
    private final int NUM_OF_COLUMNS = 7;
    private final int NUM_OF_DEP_COLUMNS = 3;
    private final String MAIN_TIER = "Main Tier";
    private final String DEPENDENT_TIER = "Dependent Tier";
    private final String LABEL = "Label";
    private final String FULL_NAME = "Full Name";
    private final String ROLE = "Role";
    private final String ID = "ID";
    private final String LANGUAGE = "Language";
    private TranscriptionImpl transcription;
    private TranscriptionStore acmTranscriptionStore;
    private List<TierImpl> visibleTiers;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JComponent[][] mainTierTable;
    private JComponent[][] dependentTierTable;
    private JPanel mainTiersPanel;
    private JPanel dependentTiersPanel;
    private JPanel optionsPanel;
    private JPanel buttonPanel;
    private JButton exportButton;
    private JButton closeButton;
    private TitledBorder mainTiersBorder;
    private TitledBorder dependentTiersBorder;
    private TitledBorder optionsBorder;
    private JCheckBox correctTimesCB;
    private JCheckBox timesOnSeparateLineCB;
    private JCheckBox includeLanguageLineCB;

    public CHATExportDlg(JFrame frame, boolean modal, Transcription tr, TranscriptionStore acmTranscriptionStore, List<TierImpl> visibleTiers) {
        super((Frame)frame, modal);
        this.transcription = (TranscriptionImpl)tr;
        this.acmTranscriptionStore = acmTranscriptionStore;
        this.visibleTiers = visibleTiers;
        List<TierImpl> topTiers = this.transcription.getTopTiers();
        if (topTiers != null) {
            int numOfTiers = this.transcription.getTiers().size();
            this.mainTierTable = new JComponent[7][topTiers.size() + 1];
            this.dependentTierTable = new JComponent[3][numOfTiers - topTiers.size() + 1];
        }
        this.mainTiersPanel = new JPanel();
        this.dependentTiersPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.exportButton = new JButton();
        this.closeButton = new JButton();
        this.mainTiersBorder = new TitledBorder("Main tiers");
        this.dependentTiersBorder = new TitledBorder("Dependent tiers");
        this.createDialog();
        this.updateForLocale();
        this.setDefaultValues();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void createDialog() {
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(4, 6, 4, 6);
        this.titleLabel = new JLabel();
        this.titlePanel = new JPanel();
        this.titlePanel.setLayout(new BorderLayout(0, 4));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        JPanel titleLabelPanel = new JPanel();
        titleLabelPanel.add(this.titleLabel);
        this.titlePanel.add((Component)titleLabelPanel, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.titlePanel, gridBagConstraints);
        this.mainTiersPanel.setLayout(new GridBagLayout());
        this.dependentTiersPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        GridBagConstraints c = new GridBagConstraints();
        JComponent tableComponent = null;
        JPanel mtPanel = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(mtPanel);
        scrollPane.setBorder(null);
        this.mainTiersPanel.setBorder(this.mainTiersBorder);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = insets;
        mtPanel.add((Component)this.mainTiersPanel, c);
        c = new GridBagConstraints();
        tableComponent = new JLabel("Main Tier");
        this.mainTierTable[1][0] = tableComponent;
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = insets;
        this.mainTiersPanel.add((Component)tableComponent, c);
        tableComponent = new JLabel("Label");
        this.mainTierTable[2][0] = tableComponent;
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = insets;
        this.mainTiersPanel.add((Component)tableComponent, c);
        tableComponent = new JLabel("Full Name");
        this.mainTierTable[3][0] = tableComponent;
        c.gridx = 3;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = insets;
        this.mainTiersPanel.add((Component)tableComponent, c);
        tableComponent = new JLabel("Role");
        this.mainTierTable[4][0] = tableComponent;
        c.gridx = 4;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = insets;
        this.mainTiersPanel.add((Component)tableComponent, c);
        tableComponent = new JLabel("ID");
        this.mainTierTable[5][0] = tableComponent;
        c.gridx = 5;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = insets;
        this.mainTiersPanel.add((Component)tableComponent, c);
        tableComponent = new JLabel("Language");
        this.mainTierTable[5][0] = tableComponent;
        c.gridx = 6;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = insets;
        this.mainTiersPanel.add((Component)tableComponent, c);
        List<TierImpl> topTiers = this.transcription.getTopTiers();
        if (topTiers != null) {
            for (int i = 0; i < topTiers.size(); ++i) {
                Locale defLoc;
                String tName = topTiers.get(i).getName();
                int atInd = tName.indexOf(64);
                tableComponent = new JCheckBox();
                ((JCheckBox)tableComponent).setSelected(atInd != 0);
                this.mainTierTable[0][i + 1] = tableComponent;
                c.gridx = 0;
                c.gridy = i + 1;
                c.anchor = 17;
                c.insets = insets;
                this.mainTiersPanel.add((Component)tableComponent, c);
                tableComponent = new JLabel(tName);
                this.mainTierTable[1][i + 1] = tableComponent;
                c.gridx = 1;
                c.gridy = i + 1;
                c.anchor = 17;
                c.insets = insets;
                this.mainTiersPanel.add((Component)tableComponent, c);
                tableComponent = new JTextField(4);
                String markChar = "*";
                Object defaultName = markChar;
                if (atInd != 0) {
                    if (atInd > 0) {
                        markChar = "%";
                        defaultName = markChar;
                        tName = tName.substring(0, atInd);
                    }
                    defaultName = tName.startsWith(markChar) ? (tName.length() <= 4 ? tName : tName.substring(0, 4)) : (tName.length() <= 3 ? (String)defaultName + tName : (String)defaultName + tName.substring(0, 3));
                    if (((String)defaultName).charAt(0) == '*') {
                        defaultName = ((String)defaultName).toUpperCase();
                    }
                }
                ((JTextField)tableComponent).setText((String)defaultName);
                this.mainTierTable[2][i + 1] = tableComponent;
                c.gridx = 2;
                c.gridy = i + 1;
                c.anchor = 17;
                c.insets = insets;
                this.mainTiersPanel.add((Component)tableComponent, c);
                tableComponent = new JTextField(12);
                ((JTextField)tableComponent).setText(topTiers.get(i).getParticipant());
                this.mainTierTable[3][i + 1] = tableComponent;
                c.gridx = 3;
                c.gridy = i + 1;
                c.anchor = 17;
                c.insets = insets;
                this.mainTiersPanel.add((Component)tableComponent, c);
                tableComponent = new JTextField(12);
                this.mainTierTable[4][i + 1] = tableComponent;
                c.gridx = 4;
                c.gridy = i + 1;
                c.anchor = 17;
                c.insets = insets;
                this.mainTiersPanel.add((Component)tableComponent, c);
                tableComponent = new JTextField(8);
                String idGuess = ((String)defaultName).length() > 1 && ((String)defaultName).charAt(0) == '*' ? ((String)defaultName).substring(1) : topTiers.get(i).getParticipant();
                ((JTextField)tableComponent).setText(idGuess);
                this.mainTierTable[5][i + 1] = tableComponent;
                c.gridx = 5;
                c.gridy = i + 1;
                c.anchor = 17;
                c.insets = insets;
                this.mainTiersPanel.add((Component)tableComponent, c);
                tableComponent = new JTextField(8);
                String language = topTiers.get(i).getLangRef();
                if ((language == null || language.isEmpty()) && (defLoc = topTiers.get(i).getDefaultLocale()) != null) {
                    language = defLoc.getLanguage();
                }
                if (language != null && !language.equals("")) {
                    ((JTextField)tableComponent).setText(language);
                }
                this.mainTierTable[6][i + 1] = tableComponent;
                c.gridx = 6;
                c.gridy = i + 1;
                c.anchor = 17;
                c.insets = insets;
                this.mainTiersPanel.add((Component)tableComponent, c);
            }
        }
        c.gridx = 7;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.mainTiersPanel.add((Component)new JPanel(), c);
        this.dependentTiersPanel.setBorder(this.dependentTiersBorder);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = insets;
        c.weightx = 1.0;
        mtPanel.add((Component)this.dependentTiersPanel, c);
        tableComponent = new JLabel("Dependent Tier");
        this.dependentTierTable[1][0] = tableComponent;
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 17;
        c.insets = insets;
        this.dependentTiersPanel.add((Component)tableComponent, c);
        tableComponent = new JLabel("Label");
        this.dependentTierTable[1][0] = tableComponent;
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = insets;
        this.dependentTiersPanel.add((Component)tableComponent, c);
        List<TierImpl> tiers = null;
        int rowIndex = 1;
        tiers = this.transcription.getTiers();
        if (tiers != null) {
            for (int i = 0; i < tiers.size(); ++i) {
                TierImpl t = tiers.get(i);
                if (!t.hasParentTier()) continue;
                int atInd = t.getName().indexOf(64);
                tableComponent = new JCheckBox();
                ((JCheckBox)tableComponent).setSelected(atInd != 0);
                this.dependentTierTable[0][rowIndex] = tableComponent;
                c.gridx = 0;
                c.gridy = rowIndex;
                c.anchor = 17;
                c.insets = insets;
                this.dependentTiersPanel.add((Component)tableComponent, c);
                tableComponent = new JLabel(t.getName());
                this.dependentTierTable[1][rowIndex] = tableComponent;
                c.gridx = 1;
                c.gridy = rowIndex;
                c.anchor = 17;
                c.insets = insets;
                this.dependentTiersPanel.add((Component)tableComponent, c);
                Object defaultName = "%";
                if (atInd != 0) {
                    String tName = t.getName();
                    if (atInd > 0) {
                        tName = tName.substring(0, atInd);
                    }
                    defaultName = tName.startsWith("%") ? (tName.length() <= 4 ? tName : tName.substring(0, 4)) : (tName.length() <= 3 ? (String)defaultName + tName : (String)defaultName + tName.substring(0, 3));
                }
                tableComponent = new JTextField(7);
                ((JTextField)tableComponent).setText((String)defaultName);
                this.dependentTierTable[2][rowIndex] = tableComponent;
                c.gridx = 2;
                c.gridy = rowIndex++;
                c.anchor = 17;
                c.insets = insets;
                this.dependentTiersPanel.add((Component)tableComponent, c);
            }
        }
        c.gridx = 3;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.dependentTiersPanel.add((Component)new JPanel(), c);
        this.optionsPanel = new JPanel(new GridBagLayout());
        this.optionsBorder = new TitledBorder("");
        this.optionsPanel.setBorder(this.optionsBorder);
        this.correctTimesCB = new JCheckBox();
        this.correctTimesCB.setSelected(true);
        this.timesOnSeparateLineCB = new JCheckBox();
        this.includeLanguageLineCB = new JCheckBox();
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = insets;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        this.optionsPanel.add((Component)this.correctTimesCB, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.insets = insets;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        this.optionsPanel.add((Component)this.timesOnSeparateLineCB, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.insets = insets;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        this.optionsPanel.add((Component)this.includeLanguageLineCB, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.insets = insets;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 100.0;
        this.getContentPane().add((Component)scrollPane, c);
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.anchor = 11;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 12, 2, 12);
        this.getContentPane().add((Component)this.optionsPanel, c);
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 0;
        c.anchor = 15;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, c);
        this.buttonPanel.add(this.exportButton);
        this.buttonPanel.add(this.closeButton);
        this.setPreferredSetting();
    }

    private void setDefaultValues() {
    }

    private void updateForLocale() {
        this.setTitle(ElanLocale.getString("ExportCHATDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportCHATDialog.Title"));
        this.mainTiersBorder.setTitle(ElanLocale.getString("ExportCHATDialog.MainTiers"));
        this.dependentTiersBorder.setTitle(ElanLocale.getString("ExportCHATDialog.DependentTiers"));
        this.optionsBorder.setTitle(ElanLocale.getString("ExportDialog.Label.Options"));
        this.correctTimesCB.setText(ElanLocale.getString("ExportDialog.CorrectTimes"));
        this.timesOnSeparateLineCB.setText(ElanLocale.getString("ExportCHATDialog.SeparateLine"));
        this.includeLanguageLineCB.setText(ElanLocale.getString("ExportCHATDialog.LanguageLine"));
        this.exportButton.setText(ElanLocale.getString("ExportCHATDialog.Export"));
        this.exportButton.addActionListener(this);
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
        this.closeButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.exportButton) {
            if (this.fieldsOK()) {
                this.showDialogAndSave();
            }
        } else if (event.getSource() == this.closeButton) {
            this.closeDialog();
        }
    }

    private boolean fieldsOK() {
        String text;
        int i;
        boolean ok = true;
        this.savePreferences();
        for (i = 1; i < this.mainTierTable[2].length; ++i) {
            if (!((JCheckBox)this.mainTierTable[0][i]).isSelected() || (text = ((JTextField)this.mainTierTable[2][i]).getText()).length() == 4 && (text.startsWith("*") || text.startsWith("%"))) continue;
            ok = false;
            break;
        }
        for (i = 1; i < this.dependentTierTable[2].length; ++i) {
            if (!((JCheckBox)this.dependentTierTable[0][i]).isSelected() || (text = ((JTextField)this.dependentTierTable[2][i]).getText()).length() >= 2 && text.length() <= 8 && text.startsWith("%")) continue;
            ok = false;
            break;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportCHATDlg.Message.WrongLabel"), ElanLocale.getString("Message.Error"), 0);
        }
        return ok;
    }

    private void showDialogAndSave() {
        String saveDir = Preferences.getString("LastUsedCHATDir", null);
        FileChooser chooser = new FileChooser(this);
        if (saveDir == null) {
            File d;
            saveDir = this.transcription.getFullPath();
            if (saveDir.startsWith("file:")) {
                saveDir = saveDir.substring(5);
            }
            if ((saveDir = (d = new File(saveDir)).getParent()) != null) {
                chooser.setCurrentDirectory(saveDir);
            }
        }
        chooser.createAndShowFileDialog(ElanLocale.getString("ExportCHATDialog.Title"), 1, FileExtension.CHAT_EXT, "LastUsedCHATDir");
        File f = chooser.getSelectedFile();
        if (f != null) {
            List<MediaDescriptor> mediaDescriptors;
            String[][] mainTierInfo = new String[this.mainTierTable.length - 1][this.mainTierTable[0].length - 1];
            String[][] dependentTierInfo = new String[this.dependentTierTable.length - 1][this.dependentTierTable[0].length - 1];
            int index = 0;
            for (int i = 1; i < this.mainTierTable[1].length; ++i) {
                if (!((JCheckBox)this.mainTierTable[0][i]).isSelected()) continue;
                mainTierInfo[0][index] = ((JLabel)this.mainTierTable[1][i]).getText();
                mainTierInfo[1][index] = ((JTextField)this.mainTierTable[2][i]).getText();
                mainTierInfo[2][index] = ((JTextField)this.mainTierTable[3][i]).getText();
                mainTierInfo[3][index] = ((JTextField)this.mainTierTable[4][i]).getText();
                mainTierInfo[4][index] = ((JTextField)this.mainTierTable[5][i]).getText();
                mainTierInfo[5][index] = ((JTextField)this.mainTierTable[6][i]).getText();
                ++index;
            }
            index = 0;
            for (int j = 1; j < this.dependentTierTable[1].length; ++j) {
                if (!((JCheckBox)this.dependentTierTable[0][j]).isSelected()) continue;
                dependentTierInfo[0][index] = ((JLabel)this.dependentTierTable[1][j]).getText();
                dependentTierInfo[1][index] = ((JTextField)this.dependentTierTable[2][j]).getText();
                ++index;
            }
            CHATEncoderInfo encoderInfo = new CHATEncoderInfo(mainTierInfo, dependentTierInfo);
            encoderInfo.setCorrectAnnotationTimes(this.correctTimesCB.isSelected());
            encoderInfo.setTimesOnSeparateLine(this.timesOnSeparateLineCB.isSelected());
            encoderInfo.setIncludeLangLine(this.includeLanguageLineCB.isSelected());
            if (this.correctTimesCB.isSelected() && (mediaDescriptors = this.transcription.getMediaDescriptors()).size() > 0) {
                encoderInfo.setMediaOffset(mediaDescriptors.get((int)0).timeOrigin);
            }
            try {
                this.acmTranscriptionStore.storeTranscriptionIn(this.transcription, encoderInfo, this.visibleTiers, f.getAbsolutePath(), 1);
                this.closeDialog();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error") + "\n(" + ioe.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
            }
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.transcription = null;
        this.acmTranscriptionStore = null;
        this.visibleTiers = null;
        this.dispose();
    }

    private void setPreferredSetting() {
        List<TierImpl> topTiers;
        Boolean useTyp = Preferences.getBool("ExportCHATDialog.correctTimesCB", null);
        if (useTyp != null) {
            this.correctTimesCB.setSelected(useTyp);
        }
        if ((useTyp = Preferences.getBool("ExportCHATDialog.timesOnSeparateLineCB", null)) != null) {
            this.timesOnSeparateLineCB.setSelected(useTyp);
        }
        if ((useTyp = Preferences.getBool("ExportCHATDialog.includeLanguageLineCB", null)) != null) {
            this.includeLanguageLineCB.setSelected(useTyp);
        }
        if ((topTiers = this.transcription.getTopTiers()) != null) {
            for (int i = 0; i < topTiers.size(); ++i) {
                String lab;
                String tiername = "ExportCHATDialog.mainTierTable." + topTiers.get(i).getName();
                List<?> list = Preferences.getList(tiername, this.transcription);
                if (list == null || list.size() < 1) continue;
                ((JCheckBox)this.mainTierTable[0][i + 1]).setSelected((Boolean)list.get(0));
                if (list.size() >= 2 && (lab = (String)list.get(1)).length() > 1) {
                    ((JTextField)this.mainTierTable[2][i + 1]).setText(lab);
                }
                if (list.size() >= 3) {
                    ((JTextField)this.mainTierTable[3][i + 1]).setText((String)list.get(2));
                }
                if (list.size() >= 4) {
                    ((JTextField)this.mainTierTable[4][i + 1]).setText((String)list.get(3));
                }
                if (list.size() >= 5) {
                    ((JTextField)this.mainTierTable[5][i + 1]).setText((String)list.get(4));
                }
                if (list.size() < 6) continue;
                ((JTextField)this.mainTierTable[6][i + 1]).setText((String)list.get(5));
            }
        }
        int rowIndex = 1;
        List<TierImpl> tiers = this.transcription.getTiers();
        if (tiers != null) {
            for (int i = 0; i < tiers.size(); ++i) {
                TierImpl t = tiers.get(i);
                if (!t.hasParentTier()) continue;
                String tiername = "ExportCHATDialog.dependentTierTable." + tiers.get(i).getName();
                List<?> list = Preferences.getList(tiername, this.transcription);
                if (list != null && list.size() >= 1) {
                    String lab;
                    ((JCheckBox)this.dependentTierTable[0][rowIndex]).setSelected((Boolean)list.get(0));
                    if (list.size() >= 2 && (lab = (String)list.get(1)).length() > 1) {
                        ((JTextField)this.dependentTierTable[2][rowIndex]).setText(lab);
                    }
                }
                ++rowIndex;
            }
        }
    }

    private void savePreferences() {
        Preferences.set("ExportCHATDialog.correctTimesCB", this.correctTimesCB.isSelected(), null);
        Preferences.set("ExportCHATDialog.timesOnSeparateLineCB", this.timesOnSeparateLineCB.isSelected(), null);
        Preferences.set("ExportCHATDialog.includeLanguageLineCB", this.includeLanguageLineCB.isSelected(), null);
        List<TierImpl> topTiers = this.transcription.getTopTiers();
        if (topTiers != null) {
            for (int i = 0; i < topTiers.size(); ++i) {
                String tiername = "ExportCHATDialog.mainTierTable." + ((JLabel)this.mainTierTable[1][i + 1]).getText();
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(((JCheckBox)this.mainTierTable[0][i + 1]).isSelected());
                list.add(((JTextField)this.mainTierTable[2][i + 1]).getText());
                list.add(((JTextField)this.mainTierTable[3][i + 1]).getText());
                list.add(((JTextField)this.mainTierTable[4][i + 1]).getText());
                list.add(((JTextField)this.mainTierTable[5][i + 1]).getText());
                list.add(((JTextField)this.mainTierTable[6][i + 1]).getText());
                Preferences.set(tiername, list, (Transcription)this.transcription);
            }
        }
        int rowIndex = 1;
        List<TierImpl> tiers = this.transcription.getTiers();
        if (tiers != null) {
            for (int i = 0; i < tiers.size(); ++i) {
                TierImpl t = tiers.get(i);
                if (!t.hasParentTier()) continue;
                String tiername = "ExportCHATDialog.dependentTierTable." + ((JLabel)this.dependentTierTable[1][rowIndex]).getText();
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(((JCheckBox)this.dependentTierTable[0][rowIndex]).isSelected());
                list.add(((JTextField)this.dependentTierTable[2][rowIndex]).getText());
                Preferences.set(tiername, list, (Transcription)this.transcription);
                ++rowIndex;
            }
        }
    }
}

