/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.JFontChooser;
import mpi.eudico.client.util.FavoriteColorPanel;

public class DisplaySettingsPane
extends JDialog
implements ActionListener,
ChangeListener {
    private JPanel backgroundColorPreviewPanel;
    private JButton backgroundColorButton;
    private JButton resetBackgroundColorButton;
    private JLabel backgroundColorLabel;
    private JCheckBox transparentBackgroundCB;
    private JPanel textColorPreviewPanel;
    private JButton textColorButton;
    private JButton resetTextColorButton;
    private JTextField fontTextField;
    private JButton fontButton;
    private JButton resetFontButton;
    private JComboBox fontSizeComboBox;
    private JComboBox textAlignComboBox;
    private JButton applyButton;
    private JButton cancelButton;
    private int fontSize;
    private String fontName;
    private Color backColor;
    private Color textColor;
    private String justify;
    private Map<String, Object> settingHashMap;
    private String parent;

    public DisplaySettingsPane(Dialog owner, String title) {
        this(owner, title, null);
    }

    public DisplaySettingsPane(Dialog owner, String title, String parent) {
        super(owner, title, true);
        this.parent = parent;
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel prefPanel = new JPanel();
        prefPanel.setBorder(new TitledBorder(ElanLocale.getString("DisplaySettingsPane.Label.AdvancedOptions")));
        prefPanel.setLayout(new GridBagLayout());
        this.backgroundColorLabel = new JLabel(ElanLocale.getString("DisplaySettingsPane.Label.BackgroundTextColor"));
        this.backgroundColorPreviewPanel = new JPanel();
        this.backgroundColorPreviewPanel.setBorder(new LineBorder(Color.GRAY, 1));
        this.backgroundColorPreviewPanel.setBackground(Color.BLACK);
        this.backgroundColorButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.backgroundColorButton.addActionListener(this);
        this.resetBackgroundColorButton = new JButton(ElanLocale.getString("Button.Default"));
        this.resetBackgroundColorButton.addActionListener(this);
        this.backgroundColorPreviewPanel.setPreferredSize(new Dimension(this.backgroundColorButton.getPreferredSize().height, this.backgroundColorButton.getPreferredSize().height));
        this.backgroundColorPreviewPanel.setMinimumSize(new Dimension(this.backgroundColorButton.getPreferredSize().height, this.backgroundColorButton.getPreferredSize().height));
        JLabel textColorLabel = new JLabel(ElanLocale.getString("DisplaySettingsPane.Label.TextColor"));
        this.textColorPreviewPanel = new JPanel();
        this.textColorPreviewPanel.setBorder(new LineBorder(Color.GRAY, 1));
        this.textColorPreviewPanel.setBackground(Color.WHITE);
        this.textColorButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.textColorButton.addActionListener(this);
        this.resetTextColorButton = new JButton(ElanLocale.getString("Button.Default"));
        this.resetTextColorButton.addActionListener(this);
        this.textColorPreviewPanel.setPreferredSize(new Dimension(this.textColorButton.getPreferredSize().height, this.textColorButton.getPreferredSize().height));
        this.textColorPreviewPanel.setMinimumSize(new Dimension(this.textColorButton.getPreferredSize().height, this.textColorButton.getPreferredSize().height));
        JLabel fontLabel = new JLabel(ElanLocale.getString("DisplaySettingsPane.Label.Font"));
        this.fontTextField = new JTextField(20);
        this.fontTextField.setEditable(false);
        this.fontTextField.setText("Arial Unicode MS");
        this.fontButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.fontButton.addActionListener(this);
        this.resetFontButton = new JButton(ElanLocale.getString("Button.Default"));
        this.resetFontButton.addActionListener(this);
        this.transparentBackgroundCB = new JCheckBox(ElanLocale.getString("DisplaySettingsPane.Label.TransparentBackground"));
        this.transparentBackgroundCB.addChangeListener(this);
        JLabel fontSizeLabel = new JLabel(ElanLocale.getString("DisplaySettingsPane.Label.FontSize"));
        this.fontSizeComboBox = new JComboBox<Object>(new Object[]{8, 9, 10, 11, 12, 14, 16, 18, 24, 28, 36, 48, 60});
        this.fontSizeComboBox.setEditable(false);
        this.fontSizeComboBox.setSelectedItem(12);
        this.fontSizeComboBox.addActionListener(this);
        JLabel textAlignLabel = new JLabel(ElanLocale.getString("DisplaySettingsPane.Label.TextAlign"));
        this.textAlignComboBox = new JComboBox<Object>(new Object[]{new String("center"), new String("left"), new String("right")});
        this.textAlignComboBox.setEditable(false);
        this.textAlignComboBox.setSelectedItem("left");
        this.textAlignComboBox.addActionListener(this);
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = insets;
        prefPanel.add((Component)this.transparentBackgroundCB, gbc);
        gbc.gridy = 1;
        prefPanel.add((Component)this.backgroundColorLabel, gbc);
        gbc.gridx = 1;
        prefPanel.add((Component)this.backgroundColorPreviewPanel, gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        prefPanel.add((Component)this.backgroundColorButton, gbc);
        gbc.gridx = 4;
        prefPanel.add((Component)this.resetBackgroundColorButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        prefPanel.add((Component)textColorLabel, gbc);
        gbc.gridx = 1;
        prefPanel.add((Component)this.textColorPreviewPanel, gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        prefPanel.add((Component)this.textColorButton, gbc);
        gbc.gridx = 4;
        prefPanel.add((Component)this.resetTextColorButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        prefPanel.add((Component)fontLabel, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        prefPanel.add((Component)this.fontTextField, gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        prefPanel.add((Component)this.fontButton, gbc);
        gbc.gridx = 4;
        prefPanel.add((Component)this.resetFontButton, gbc);
        gbc.gridy = 4;
        gbc.gridx = 0;
        prefPanel.add((Component)fontSizeLabel, gbc);
        gbc.gridx = 1;
        prefPanel.add((Component)this.fontSizeComboBox, gbc);
        gbc.gridy = 5;
        gbc.gridx = 0;
        gbc.fill = 0;
        prefPanel.add((Component)textAlignLabel, gbc);
        gbc.gridx = 1;
        prefPanel.add((Component)this.textAlignComboBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)prefPanel, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.applyButton = new JButton();
        this.applyButton.setText(ElanLocale.getString("Button.Apply"));
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.applyButton);
        buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.anchor = 15;
        gbc.insets = insets;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.fontSizeComboBox.addActionListener(this);
        this.loadPreferences();
        this.initialize();
        if (this.parent != null && this.parent.equalsIgnoreCase("realPlayer")) {
            this.transparentBackgroundCB.setEnabled(false);
            this.transparentBackgroundCB.setSelected(false);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                DisplaySettingsPane.this.doClose();
            }
        });
    }

    private void initialize() {
        this.fontSize = (Integer)this.fontSizeComboBox.getSelectedItem();
        this.fontName = this.fontTextField.getText();
        this.justify = (String)this.textAlignComboBox.getSelectedItem();
        this.backColor = this.backgroundColorPreviewPanel.getBackground();
        this.textColor = this.textColorPreviewPanel.getBackground();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.transparentBackgroundCB) {
            this.backgroundColorButton.setEnabled(!this.transparentBackgroundCB.isSelected());
            this.resetBackgroundColorButton.setEnabled(!this.transparentBackgroundCB.isSelected());
            this.backgroundColorLabel.setEnabled(!this.transparentBackgroundCB.isSelected());
            this.backgroundColorPreviewPanel.setEnabled(!this.transparentBackgroundCB.isSelected());
        }
    }

    private void postInit() {
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
    }

    private Color chooseColor(Color oldColor) {
        Color newColor = null;
        final JColorChooser chooser = new JColorChooser(oldColor);
        AbstractColorChooserPanel[] panels = chooser.getChooserPanels();
        AbstractColorChooserPanel[] panels2 = new AbstractColorChooserPanel[panels.length + 1];
        FavoriteColorPanel fcp = new FavoriteColorPanel();
        panels2[0] = fcp;
        for (int i = 0; i < panels.length; ++i) {
            panels2[i + 1] = panels[i];
        }
        chooser.setChooserPanels(panels2);
        Map<String, Color> oldColors = Preferences.getMapOfColor("FavoriteColors", null);
        if (oldColors != null) {
            Color[] favColors = fcp.getColors();
            for (Map.Entry<String, Color> e : oldColors.entrySet()) {
                String key = e.getKey();
                Color val = e.getValue();
                try {
                    int index = Integer.valueOf(key);
                    if (index >= favColors.length) continue;
                    favColors[index] = val;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        AbstractAction aa = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.putValue("Default", chooser.getColor());
            }
        };
        JDialog cd = JColorChooser.createDialog(this, ElanLocale.getString("ColorChooser.Title"), true, chooser, aa, null);
        cd.setVisible(true);
        HashMap<String, Color> colMap = new HashMap<String, Color>();
        Color[] colors = fcp.getColors();
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i] == null) continue;
            colMap.put(String.valueOf(i), colors[i]);
        }
        if (colMap.size() > 0 || oldColors != null) {
            Preferences.set("FavoriteColors", colMap, null);
        }
        newColor = (Color)aa.getValue("Default");
        return newColor;
    }

    private void selectBackgroundColor() {
        Color newColor = this.chooseColor(this.backgroundColorPreviewPanel.getBackground());
        if (newColor != null) {
            this.backgroundColorPreviewPanel.setBackground(newColor);
            this.backColor = newColor;
        }
    }

    private void selectTextColor() {
        Color newColor = this.chooseColor(this.textColorPreviewPanel.getBackground());
        if (newColor != null) {
            this.textColorPreviewPanel.setBackground(newColor);
            this.textColor = newColor;
        }
    }

    private void updateFontSize() {
        this.fontSize = (Integer)this.fontSizeComboBox.getSelectedItem();
    }

    private void updateTextAlignment() {
        this.justify = (String)this.textAlignComboBox.getSelectedItem();
    }

    private void selectFont() {
        JFontChooser jfc = new JFontChooser();
        Font curFont = new Font(this.fontTextField.getText(), 0, 12);
        Font f = jfc.showDialog(this, true, curFont);
        if (f != null) {
            this.fontTextField.setText(f.getName());
            this.fontName = f.getName();
        }
    }

    private void applyNewSetting() {
        this.settingHashMap = new HashMap<String, Object>();
        this.settingHashMap.put("size", this.fontSize);
        this.settingHashMap.put("font", this.fontName);
        this.settingHashMap.put("backColor", this.backColor);
        this.settingHashMap.put("textColor", this.textColor);
        this.settingHashMap.put("justify", this.justify);
        this.settingHashMap.put("transparent", this.transparentBackgroundCB.isSelected());
    }

    private void doClose() {
        this.savePreferences();
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.applyButton) {
            this.applyNewSetting();
            this.doClose();
        } else if (e.getSource() == this.cancelButton) {
            this.doClose();
        } else if (e.getSource() == this.backgroundColorButton) {
            this.selectBackgroundColor();
        } else if (e.getSource() == this.resetBackgroundColorButton) {
            this.backgroundColorPreviewPanel.setBackground(Color.BLACK);
        } else if (e.getSource() == this.textColorButton) {
            this.selectTextColor();
        } else if (e.getSource() == this.resetTextColorButton) {
            this.textColorPreviewPanel.setBackground(Color.WHITE);
        } else if (e.getSource() == this.fontButton) {
            this.selectFont();
        } else if (e.getSource() == this.resetFontButton) {
            this.fontTextField.setText("Arial Unicode MS");
        } else if (e.getSource() == this.fontSizeComboBox) {
            this.updateFontSize();
        } else if (e.getSource() == this.textAlignComboBox) {
            this.updateTextAlignment();
        }
    }

    public static Map<String, Object> getNewFontSetting(JDialog parent, String title) {
        DisplaySettingsPane pane = new DisplaySettingsPane((Dialog)parent, title, parent.getName());
        pane.setVisible(true);
        return pane.settingHashMap;
    }

    public static Map<String, Object> getLastUsedSetting() {
        Boolean boolPref;
        Integer intPref;
        String stringPref;
        HashMap<String, Object> storedMap = new HashMap<String, Object>();
        Color colorPref = Preferences.getColor("DisplaySettingsPane.backColor", null);
        if (colorPref != null) {
            storedMap.put("backColor", colorPref);
        }
        if ((colorPref = Preferences.getColor("DisplaySettingsPane.textColor", null)) != null) {
            storedMap.put("textColor", colorPref);
        }
        if ((stringPref = Preferences.getString("DisplaySettingsPane.fontName", null)) != null) {
            storedMap.put("font", stringPref);
        }
        if ((intPref = Preferences.getInt("DisplaySettingsPane.fontSize", null)) != null) {
            storedMap.put("size", intPref);
        }
        if ((stringPref = Preferences.getString("DisplaySettingsPane.justify", null)) != null) {
            storedMap.put("justify", stringPref);
        }
        if ((boolPref = Preferences.getBool("DisplaySettingsPane.transparentBackground", null)) != null) {
            storedMap.put("transparent", boolPref);
        }
        if (storedMap.isEmpty()) {
            return null;
        }
        return storedMap;
    }

    private void savePreferences() {
        Preferences.set("DisplaySettingsPane.backColor", this.backColor, null);
        Preferences.set("DisplaySettingsPane.textColor", this.textColor, null);
        Preferences.set("DisplaySettingsPane.fontSize", this.fontSize, null);
        Preferences.set("DisplaySettingsPane.fontName", this.fontName, null);
        Preferences.set("DisplaySettingsPane.justify", this.justify, null);
        Preferences.set("DisplaySettingsPane.transparentBackground", this.transparentBackgroundCB.isSelected(), null);
    }

    private void loadPreferences() {
        Boolean boolPref;
        Integer intPref;
        String stringPref;
        Color colorPref = Preferences.getColor("DisplaySettingsPane.backColor", null);
        if (colorPref != null) {
            this.backgroundColorPreviewPanel.setBackground(colorPref);
        }
        if ((colorPref = Preferences.getColor("DisplaySettingsPane.textColor", null)) != null) {
            this.textColorPreviewPanel.setBackground(colorPref);
        }
        if ((stringPref = Preferences.getString("DisplaySettingsPane.fontName", null)) != null) {
            this.fontTextField.setText(stringPref);
        }
        if ((stringPref = Preferences.getString("DisplaySettingsPane.justify", null)) != null) {
            this.textAlignComboBox.setSelectedItem(stringPref);
        }
        if ((intPref = Preferences.getInt("DisplaySettingsPane.fontSize", null)) != null) {
            this.fontSizeComboBox.setSelectedItem(intPref);
        }
        if ((boolPref = Preferences.getBool("DisplaySettingsPane.transparentBackground", null)) != null) {
            this.transparentBackgroundCB.setSelected(boolPref);
        }
    }
}

