/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.client.util.SelectEnableObject;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.flex.FlexEncoderInfo;

public class ExportFlexStep1
extends StepPane {
    private TranscriptionImpl transcription;
    private final String ELEMENT_NAME = ElanLocale.getString("ExportFlexStep1.Table.ElementName");
    private final String ELEMENT_TYPE = ElanLocale.getString("ExportFlexStep1.Table.Type");
    private final String SELECT_TYPE = ElanLocale.getString("TranscriptionManager.ComboBoxDefaultString");
    private final String SELECT_TIER = "<" + ElanLocale.getString("TranscriptionManager.SelectTierDlg.DefaultValue") + ">";
    private final String DEFAULT_VALUE = ElanLocale.getString("ExportFlexDialog.DefaultValue");
    private JTable typeTable;
    private DefaultTableModel typeModel;
    private JTable tierTable;
    private DefaultTableModel tierModel;
    private JComboBox textCombo;
    private JCheckBox textCB;
    private JCheckBox paraCB;
    private HashMap<String, List<String>> elementTypeMap;
    private HashMap<String, List<TierImpl>> elementTiersMap;
    private String interLinearTextTierName;
    protected Insets globalInset = new Insets(2, 4, 2, 4);
    public static final String INTERLINEAR_TEXT = "ExportFLExDialog.IncludeInterlinearText";
    public static final String PARAGRAPH = "ExportFLExDialog.IncludeParagraph";

    public ExportFlexStep1(MultiStepPane mp, TranscriptionImpl transcription) {
        super(mp);
        this.transcription = transcription;
        this.elementTypeMap = new HashMap();
        this.elementTypeMap.put("paragraph", new ArrayList());
        this.elementTypeMap.put("phrase", new ArrayList());
        this.elementTypeMap.put("word", new ArrayList());
        this.elementTypeMap.put("morph", new ArrayList());
        this.elementTiersMap = new HashMap();
        this.elementTiersMap.put("paragraph", new ArrayList());
        this.elementTiersMap.put("phrase", new ArrayList());
        this.elementTiersMap.put("word", new ArrayList());
        this.elementTiersMap.put("morph", new ArrayList());
        this.initComponents();
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("ExportFlexStep1.Title");
    }

    @Override
    public void enterStepForward() {
        this.updateButtonStates();
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    public boolean leaveStepForward() {
        String tierName;
        TierImpl itTier;
        this.storePreferences();
        FlexEncoderInfo encoderInfo = new FlexEncoderInfo();
        ArrayList<TierImpl> itTiers = new ArrayList<TierImpl>();
        if (this.textCB.isSelected() && (itTier = this.transcription.getTierWithId(tierName = (String)this.textCombo.getSelectedItem())) != null) {
            itTiers.add(itTier);
        }
        ArrayList<TierImpl> paraList = new ArrayList<TierImpl>();
        ArrayList<TierImpl> phraseList = new ArrayList<TierImpl>();
        ArrayList<TierImpl> wordList = new ArrayList<TierImpl>();
        ArrayList<TierImpl> morphList = new ArrayList<TierImpl>();
        for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
            Object obj = this.tierTable.getValueAt(i, 0);
            if (obj != null && ((SelectEnableObject)obj).isEnabled() && ((SelectEnableObject)obj).isSelected()) {
                paraList.add(this.transcription.getTierWithId(((SelectEnableObject)obj).toString()));
            }
            if ((obj = this.tierTable.getValueAt(i, 1)) != null && ((SelectEnableObject)obj).isEnabled() && ((SelectEnableObject)obj).isSelected()) {
                phraseList.add(this.transcription.getTierWithId(((SelectEnableObject)obj).toString()));
            }
            if ((obj = this.tierTable.getValueAt(i, 2)) != null && ((SelectEnableObject)obj).isEnabled() && ((SelectEnableObject)obj).isSelected()) {
                wordList.add(this.transcription.getTierWithId(((SelectEnableObject)obj).toString()));
            }
            if ((obj = this.tierTable.getValueAt(i, 3)) == null || !((SelectEnableObject)obj).isEnabled() || !((SelectEnableObject)obj).isSelected()) continue;
            morphList.add(this.transcription.getTierWithId(((SelectEnableObject)obj).toString()));
        }
        encoderInfo.setMappingForElement("interlinear-text", itTiers);
        encoderInfo.setMappingForElement("paragraph", paraList);
        encoderInfo.setMappingForElement("phrase", phraseList);
        encoderInfo.setMappingForElement("word", wordList);
        encoderInfo.setMappingForElement("morph", morphList);
        this.multiPane.putStepProperty("EncoderInfo", encoderInfo);
        return true;
    }

    public void updateButtonStates() {
        boolean phraseTier = false;
        for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
            SelectEnableObject obj = (SelectEnableObject)this.tierTable.getValueAt(i, 1);
            if (obj == null || !obj.isEnabled() || !obj.isSelected()) continue;
            phraseTier = true;
        }
        this.multiPane.setButtonEnabled(1, phraseTier);
        this.multiPane.setButtonEnabled(2, false);
    }

    @Override
    protected void initComponents() {
        this.textCombo = new JComboBox();
        this.textCombo.addItem(this.SELECT_TIER);
        List<TierImpl> tiers = this.transcription.getTiers();
        String selectTextTier = null;
        for (int i = 0; i < tiers.size(); ++i) {
            TierImpl t = tiers.get(i);
            if (t.getLinguisticType().getConstraints() != null) continue;
            this.textCombo.addItem(t.getName());
            if (selectTextTier != null || !t.getName().contains("interlinear-text")) continue;
            selectTextTier = t.getName();
        }
        this.textCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String item;
                if (e.getStateChange() == 1 && (item = (String)e.getItem()) != null) {
                    ExportFlexStep1.this.updateTable();
                }
            }
        });
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExportFlexStep1.this.textCombo.setEnabled(ExportFlexStep1.this.textCB.isSelected());
                ExportFlexStep1.this.updateTable();
            }
        };
        this.textCB = new JCheckBox(ElanLocale.getString("ExportFlexStep1.InterLinearText"));
        this.textCB.setSelected(true);
        this.textCB.addChangeListener(listener);
        this.paraCB = new JCheckBox(ElanLocale.getString("ExportFlexStep1.Paragraph"));
        this.paraCB.setSelected(true);
        this.paraCB.addChangeListener(listener);
        this.typeModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (this.getColumnName(column).equals(ExportFlexStep1.this.ELEMENT_NAME)) {
                    return false;
                }
                if (ExportFlexStep1.this.typeTable.getValueAt(row, column) == null) {
                    return false;
                }
                if (ExportFlexStep1.this.typeTable.getValueAt(row, column).toString().equals(ExportFlexStep1.this.DEFAULT_VALUE)) {
                    return false;
                }
                if (ExportFlexStep1.this.typeTable.isEditing()) {
                    ExportFlexStep1.this.typeTable.editingCanceled(null);
                }
                return true;
            }
        };
        this.typeModel.setColumnIdentifiers(new String[]{this.ELEMENT_NAME, this.ELEMENT_TYPE});
        this.typeModel.addRow(new Object[]{"paragraph", null});
        this.typeModel.addRow(new Object[]{"phrase", null});
        this.typeModel.addRow(new Object[]{"word", null});
        this.typeModel.addRow(new Object[]{"morph", null});
        DefaultTableCellRenderer typeTableRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    return cell;
                }
                if (!table.isEnabled()) {
                    table.setGridColor(Color.GRAY);
                    cell.setForeground(Color.GRAY);
                    return cell;
                }
                table.setGridColor(Color.BLACK);
                if (row == 0) {
                    if (ExportFlexStep1.this.paraCB.isSelected()) {
                        cell.setForeground(Color.BLACK);
                    } else {
                        cell.setForeground(Color.GRAY);
                        return cell;
                    }
                }
                if (value.equals(ExportFlexStep1.this.SELECT_TYPE)) {
                    cell.setForeground(Color.GRAY);
                } else {
                    cell.setForeground(Color.BLACK);
                }
                return cell;
            }
        };
        this.typeTable = new JTable(this.typeModel);
        this.typeTable.setCellSelectionEnabled(true);
        this.typeTable.setDefaultEditor(Object.class, new TypeTableCellEditor());
        this.typeTable.setDefaultRenderer(Object.class, typeTableRenderer);
        this.typeTable.setShowGrid(true);
        this.typeTable.setGridColor(Color.BLACK);
        this.typeTable.setSelectionBackground(Color.WHITE);
        this.typeTable.setRowHeight(this.typeTable.getRowHeight() + 5);
        JPanel mappingPanel = new JPanel();
        mappingPanel.setLayout(new GridBagLayout());
        mappingPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportFlexStep1.ElementMapping")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInset;
        gbc.fill = 0;
        gbc.anchor = 18;
        mappingPanel.add((Component)this.textCB, gbc);
        gbc.gridx = 1;
        mappingPanel.add((Component)this.textCombo, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        mappingPanel.add((Component)this.paraCB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        mappingPanel.add((Component)new JScrollPane(this.typeTable), gbc);
        this.tierModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                Object value = this.getValueAt(row, column);
                if (value instanceof SelectEnableObject) {
                    return ((SelectEnableObject)value).isEnabled();
                }
                return false;
            }
        };
        this.tierModel.setColumnIdentifiers(new String[]{"paragraph", "phrase", "word", "morph"});
        this.tierModel.addRow(new Object[]{null, null, null, null});
        this.tierTable = new JTable(this.tierModel);
        this.tierTable.setDefaultRenderer(Object.class, new CheckBoxTableCellRenderer());
        this.tierTable.setDefaultEditor(Object.class, new TierTableCellEditor());
        this.tierTable.setShowGrid(true);
        this.tierTable.setGridColor(Color.BLACK);
        this.tierTable.setSelectionBackground(Color.WHITE);
        this.tierTable.setRowHeight(this.typeTable.getRowHeight() + 5);
        JPanel itemPanel = new JPanel();
        itemPanel.setLayout(new GridBagLayout());
        itemPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportFlexStep1.TierMapping")));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        itemPanel.add((Component)new JScrollPane(this.tierTable), gbc);
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)mappingPanel, gbc);
        gbc.gridy = 1;
        this.add((Component)itemPanel, gbc);
        this.loadPreferences();
    }

    private void intializeElementTypeColum() {
        this.typeTable.setEnabled(false);
        for (int i = 0; i < this.typeModel.getRowCount(); ++i) {
            this.typeModel.setValueAt(null, i, 1);
        }
    }

    private void updateTable() {
        if (this.typeTable.isEditing()) {
            this.typeTable.editingCanceled(null);
        }
        this.interLinearTextTierName = null;
        String textTier = (String)this.textCombo.getSelectedItem();
        if (this.textCB.isSelected()) {
            if (textTier == null || textTier.equals(this.SELECT_TIER)) {
                this.intializeElementTypeColum();
            } else {
                this.interLinearTextTierName = textTier;
                this.typeTable.setEnabled(true);
                if (this.paraCB.isSelected()) {
                    this.updateTypesForParagraph();
                } else {
                    this.typeModel.setValueAt(null, 0, 1);
                    this.updateTypesForPhrase();
                }
            }
        } else {
            this.typeTable.setEnabled(true);
            if (this.paraCB.isSelected()) {
                this.updateTypesForParagraph();
            } else {
                this.typeModel.setValueAt(null, 0, 1);
                this.updateTypesForPhrase();
            }
        }
    }

    private void updateTypesForParagraph() {
        int i;
        TierImpl t;
        List<String> typeList = this.elementTypeMap.get("paragraph");
        typeList.clear();
        String itType = null;
        if (this.textCB.isSelected()) {
            t = this.transcription.getTierWithId(this.interLinearTextTierName);
            itType = t.getLinguisticType().getLinguisticTypeName();
        }
        List<TierImpl> tiers = this.transcription.getTiers();
        for (i = 0; i < tiers.size(); ++i) {
            t = tiers.get(i);
            if (itType != null && t.getLinguisticType().getLinguisticTypeName().equals(itType)) continue;
            if (t.getLinguisticType().getConstraints() != null) {
                int stereotype = t.getLinguisticType().getConstraints().getStereoType();
                if (stereotype != 0 && stereotype != 3 && stereotype != 1 || typeList.contains(t.getLinguisticType().getLinguisticTypeName())) continue;
                typeList.add(t.getLinguisticType().getLinguisticTypeName());
                continue;
            }
            if (typeList.contains(t.getLinguisticType().getLinguisticTypeName())) continue;
            typeList.add(t.getLinguisticType().getLinguisticTypeName());
        }
        if (typeList.size() == 0) {
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 0, 1);
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 1, 1);
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 2, 1);
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 3, 1);
            this.updateTiersForParagraph();
        } else {
            this.typeModel.setValueAt(typeList.get(0), 0, 1);
            for (i = 0; i < typeList.size(); ++i) {
                if (!typeList.get(i).startsWith("paragraph")) continue;
                this.typeModel.setValueAt(typeList.get(i), 0, 1);
                break;
            }
            this.updateTiersForParagraph();
            this.updateTypesForPhrase();
        }
    }

    private boolean hasPhraseTier(TierImpl tier) {
        if (tier != null) {
            List<TierImpl> childTiers = tier.getChildTiers();
            for (int i = 0; i < childTiers.size(); ++i) {
                tier = childTiers.get(i);
                int sterotype = tier.getLinguisticType().getConstraints().getStereoType();
                if (sterotype != 0 && sterotype != 3 && sterotype != 1) continue;
                return true;
            }
        }
        return false;
    }

    private void updateTiersForParagraph() {
        List<TierImpl> tierList = this.elementTiersMap.get("paragraph");
        tierList.clear();
        String paraType = (String)this.typeTable.getValueAt(0, 1);
        if (!paraType.equals(this.DEFAULT_VALUE) && !paraType.equals(this.SELECT_TYPE)) {
            List<TierImpl> tiers = this.transcription.getTiersWithLinguisticType(paraType);
            if (tiers.get(0).getLinguisticType().getConstraints() == null) {
                tierList.addAll(tiers);
            } else {
                for (int i = 0; i < tiers.size(); ++i) {
                    TierImpl tier = tiers.get(i);
                    if (this.interLinearTextTierName != null && (!tier.hasParentTier() || !tier.getParentTier().getName().equals(this.interLinearTextTierName)) || !this.hasPhraseTier(tier)) continue;
                    tierList.add(tier);
                }
            }
        }
        this.updateTierTableForElement("paragraph");
    }

    private void updateTypesForPhrase() {
        TierImpl tier;
        List<TierImpl> tiers;
        List<String> typeList = this.elementTypeMap.get("phrase");
        typeList.clear();
        if (this.paraCB.isSelected()) {
            String type = (String)this.typeTable.getValueAt(0, 1);
            tiers = this.transcription.getTiersWithLinguisticType(type);
            for (int t = 0; t < tiers.size(); ++t) {
                tier = tiers.get(t);
                List<TierImpl> childTiers = tier.getChildTiers();
                for (int i = 0; i < childTiers.size(); ++i) {
                    tier = childTiers.get(i);
                    int sterotype = tier.getLinguisticType().getConstraints().getStereoType();
                    if (sterotype != 1 && sterotype != 0 && sterotype != 3 || typeList.contains(tier.getLinguisticType().getLinguisticTypeName())) continue;
                    typeList.add(tier.getLinguisticType().getLinguisticTypeName());
                }
            }
        } else {
            String itType = null;
            if (this.textCB.isSelected()) {
                tier = this.transcription.getTierWithId((String)this.textCombo.getSelectedItem());
                itType = tier.getLinguisticType().getLinguisticTypeName();
            }
            tiers = this.transcription.getTiers();
            for (int i = 0; i < tiers.size(); ++i) {
                tier = tiers.get(i);
                if (itType != null && tier.getLinguisticType().getLinguisticTypeName().equals(itType)) continue;
                if (tier.getLinguisticType().getConstraints() != null) {
                    int stereotype = tier.getLinguisticType().getConstraints().getStereoType();
                    if (stereotype != 0 && stereotype != 3 && stereotype != 1 || typeList.contains(tier.getLinguisticType().getLinguisticTypeName())) continue;
                    typeList.add(tier.getLinguisticType().getLinguisticTypeName());
                    continue;
                }
                if (typeList.contains(tier.getLinguisticType().getLinguisticTypeName())) continue;
                typeList.add(tier.getLinguisticType().getLinguisticTypeName());
            }
        }
        if (typeList.size() == 0) {
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 1, 1);
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 2, 1);
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 3, 1);
            this.updateTiersForPhrase();
        } else {
            this.typeModel.setValueAt(typeList.get(0), 1, 1);
            for (int i = 0; i < typeList.size(); ++i) {
                if (!typeList.get(i).startsWith("phrase")) continue;
                this.typeModel.setValueAt(typeList.get(i), 1, 1);
                break;
            }
            this.updateTiersForPhrase();
            this.updateTypesForWord();
        }
    }

    private void updateTiersForPhrase() {
        List<TierImpl> paraGrapghTierList = this.elementTiersMap.get("paragraph");
        List<TierImpl> tierList = this.elementTiersMap.get("phrase");
        tierList.clear();
        String phraseType = (String)this.typeTable.getValueAt(1, 1);
        if (!phraseType.equals(this.DEFAULT_VALUE) && !phraseType.equals(this.SELECT_TYPE)) {
            if (this.paraCB.isSelected()) {
                for (int x = 0; x < paraGrapghTierList.size(); ++x) {
                    List<TierImpl> tiers = paraGrapghTierList.get(x).getChildTiers();
                    boolean phraseTierFound = false;
                    for (int i = 0; i < tiers.size(); ++i) {
                        TierImpl tier = tiers.get(i);
                        if (!tier.getLinguisticType().getLinguisticTypeName().equals(phraseType)) continue;
                        tierList.add(tier);
                        phraseTierFound = true;
                    }
                    if (phraseTierFound) continue;
                    tierList.add(null);
                }
            } else {
                paraGrapghTierList.clear();
                tierList.addAll(this.transcription.getTiersWithLinguisticType(phraseType));
            }
        }
        this.updateTierTableForElement("phrase");
    }

    private void updateTypesForWord() {
        List<String> typeList = this.elementTypeMap.get("word");
        typeList.clear();
        String type = (String)this.typeTable.getValueAt(1, 1);
        List<TierImpl> tiers = this.transcription.getTiersWithLinguisticType(type);
        for (int t = 0; t < tiers.size(); ++t) {
            TierImpl tier = tiers.get(t);
            List<TierImpl> childTiers = tier.getChildTiers();
            for (int i = 0; i < childTiers.size(); ++i) {
                tier = childTiers.get(i);
                int stereotype = tier.getLinguisticType().getConstraints().getStereoType();
                if (stereotype != 0 && stereotype != 3 && stereotype != 1 || typeList.contains(tier.getLinguisticType().getLinguisticTypeName())) continue;
                typeList.add(tier.getLinguisticType().getLinguisticTypeName());
            }
        }
        if (typeList.size() == 0) {
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 2, 1);
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 3, 1);
        } else {
            this.typeModel.setValueAt(typeList.get(0), 2, 1);
            for (int i = 0; i < typeList.size(); ++i) {
                if (!typeList.get(i).startsWith("word")) continue;
                this.typeModel.setValueAt(typeList.get(i), 2, 1);
                break;
            }
        }
        this.updateTiersForWord();
        this.updateTypesForMorph();
    }

    private void updateTiersForWord() {
        List<TierImpl> phraseTierList = this.elementTiersMap.get("phrase");
        List<TierImpl> tierList = this.elementTiersMap.get("word");
        tierList.clear();
        String wordType = (String)this.typeTable.getValueAt(2, 1);
        if (!wordType.equals(this.DEFAULT_VALUE) && !wordType.equals(this.SELECT_TYPE)) {
            for (int x = 0; x < phraseTierList.size(); ++x) {
                boolean tierFound = false;
                List<TierImpl> tiers = phraseTierList.get(x).getChildTiers();
                for (int i = 0; i < tiers.size(); ++i) {
                    TierImpl tier = tiers.get(i);
                    if (!tier.getLinguisticType().getLinguisticTypeName().equals(wordType)) continue;
                    tierList.add(tier);
                    tierFound = true;
                }
                if (tierFound) continue;
                tierList.add(null);
            }
        }
        this.updateTierTableForElement("word");
    }

    private void updateTypesForMorph() {
        List<String> typeList = this.elementTypeMap.get("morph");
        typeList.clear();
        String type = (String)this.typeTable.getValueAt(2, 1);
        List<TierImpl> tiers = this.transcription.getTiersWithLinguisticType(type);
        for (int t = 0; t < tiers.size(); ++t) {
            TierImpl tier = tiers.get(t);
            List<TierImpl> childTiers = tier.getChildTiers();
            for (int i = 0; i < childTiers.size(); ++i) {
                tier = childTiers.get(i);
                int stereotype = tier.getLinguisticType().getConstraints().getStereoType();
                if (stereotype != 3 && stereotype != 0 && stereotype != 1 || typeList.contains(tier.getLinguisticType().getLinguisticTypeName())) continue;
                typeList.add(tier.getLinguisticType().getLinguisticTypeName());
            }
        }
        if (typeList.size() == 0) {
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 3, 1);
        } else {
            this.typeModel.setValueAt(typeList.get(0), 3, 1);
            for (int i = 0; i < typeList.size(); ++i) {
                if (!typeList.get(i).startsWith("morph")) continue;
                this.typeModel.setValueAt(typeList.get(i), 3, 1);
                break;
            }
        }
        this.updateTiersForMorph();
    }

    private void updateTiersForMorph() {
        List<TierImpl> wordTierList = this.elementTiersMap.get("word");
        List<TierImpl> tierList = this.elementTiersMap.get("morph");
        tierList.clear();
        String morphType = (String)this.typeTable.getValueAt(3, 1);
        if (!morphType.equals(this.DEFAULT_VALUE) && !morphType.equals(this.SELECT_TYPE)) {
            for (TierImpl tier : wordTierList) {
                boolean tierFound = false;
                if (tier != null) {
                    for (TierImpl ctier : tier.getChildTiers()) {
                        if (!ctier.getLinguisticType().getLinguisticTypeName().equals(morphType)) continue;
                        tierList.add(ctier);
                        tierFound = true;
                    }
                }
                if (tierFound) continue;
                tierList.add(null);
            }
        }
        this.updateTierTableForElement("morph");
    }

    private void updateTierTableForElement(String itemType) {
        List<TierImpl> tierList = this.elementTiersMap.get(itemType);
        int column = 0;
        if (itemType.equals("paragraph")) {
            column = 0;
            this.clearTierTable();
        } else if (itemType.equals("phrase")) {
            column = 1;
            if (!this.paraCB.isSelected()) {
                this.clearTierTable();
            }
        } else if (itemType.equals("word")) {
            column = 2;
        } else if (itemType.equals("morph")) {
            column = 3;
        }
        if (tierList.size() > 0) {
            int row = tierList.size();
            for (int i = this.tierTable.getRowCount(); i < row; ++i) {
                this.tierModel.addRow(new Object[]{null, null, null, null});
            }
            for (int i = 0; i < tierList.size(); ++i) {
                Tier t = tierList.get(i);
                if (t != null) {
                    this.tierModel.setValueAt(new SelectEnableObject<String>(tierList.get(i).getName(), true), i, column);
                    continue;
                }
                this.tierModel.setValueAt(null, i, column);
            }
        } else {
            for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
                for (int c = column; c <= 3; ++c) {
                    this.tierModel.setValueAt(null, i, c);
                }
            }
        }
        this.updateButtonStates();
    }

    private void clearTierTable() {
        while (this.tierTable.getRowCount() > 0) {
            this.tierModel.removeRow(this.tierTable.getRowCount() - 1);
        }
    }

    private void deleteRowValuesAfter(int row) {
        for (int i = row + 1; i < this.typeTable.getRowCount(); ++i) {
            this.typeTable.setValueAt(null, i, 1);
        }
    }

    private void updateTypesForRow(int row) {
        switch (row) {
            case 0: {
                this.updateTypesForParagraph();
                break;
            }
            case 1: {
                this.updateTypesForPhrase();
                break;
            }
            case 2: {
                this.updateTypesForWord();
                break;
            }
            case 3: {
                this.updateTypesForMorph();
            }
        }
    }

    private void updateTiersForRow(int row) {
        switch (row) {
            case 0: {
                this.updateTiersForParagraph();
                break;
            }
            case 1: {
                this.updateTiersForPhrase();
                break;
            }
            case 2: {
                this.updateTiersForWord();
                break;
            }
            case 3: {
                this.updateTiersForMorph();
            }
        }
    }

    private void loadPreferences() {
        Boolean val = Preferences.getBool(INTERLINEAR_TEXT, null);
        if (val != null) {
            this.textCB.setSelected(val);
        }
        if ((val = Preferences.getBool(PARAGRAPH, null)) != null) {
            this.paraCB.setSelected(val);
        }
    }

    private void storePreferences() {
        Preferences.set(INTERLINEAR_TEXT, this.textCB.isSelected(), null);
        Preferences.set(PARAGRAPH, this.paraCB.isSelected(), null);
    }

    private class TypeTableCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        private int startEditInOneClick;
        private JComboBox comboBox;
        private int row;
        private String value;

        public TypeTableCellEditor() {
            super(new JComboBox());
            this.startEditInOneClick = 1;
            this.setClickCountToStart(this.startEditInOneClick);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            this.value = value.toString();
            List types = (List)ExportFlexStep1.this.elementTypeMap.get(table.getValueAt(row, 0));
            this.comboBox = new JComboBox();
            this.comboBox.addItem(ExportFlexStep1.this.SELECT_TYPE);
            for (int i = 0; i < types.size(); ++i) {
                this.comboBox.addItem(types.get(i));
            }
            this.comboBox.addActionListener(this);
            return this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportFlexStep1.this.typeTable.editingStopped(new ChangeEvent(this));
            if (this.value.equals(this.comboBox.getSelectedItem())) {
                return;
            }
            Object val = this.comboBox.getSelectedItem();
            if (!val.equals(ExportFlexStep1.this.DEFAULT_VALUE) && !val.equals(ExportFlexStep1.this.SELECT_TYPE)) {
                ExportFlexStep1.this.updateTiersForRow(this.row);
                ExportFlexStep1.this.deleteRowValuesAfter(this.row);
                if (ExportFlexStep1.this.typeTable.getRowCount() - 1 > this.row) {
                    ExportFlexStep1.this.updateTypesForRow(this.row + 1);
                }
            } else {
                if (val.equals(ExportFlexStep1.this.SELECT_TYPE)) {
                    ExportFlexStep1.this.deleteRowValuesAfter(this.row);
                }
                ExportFlexStep1.this.updateTiersForRow(this.row);
            }
        }
    }

    private class TierTableCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        private int startEditInOneClick;
        private JCheckBox checkBox;
        private SelectEnableObject selObject;
        private int column;
        private int row;

        public TierTableCellEditor() {
            super(new JCheckBox());
            this.startEditInOneClick = 1;
            this.setClickCountToStart(this.startEditInOneClick);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            this.column = column;
            if (value instanceof SelectEnableObject) {
                this.selObject = (SelectEnableObject)value;
                this.checkBox = new JCheckBox();
                this.checkBox.setSelected(this.selObject.isSelected());
                this.checkBox.setText(this.selObject.getValue().toString());
                this.checkBox.addActionListener(this);
                return this.checkBox;
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return this.selObject;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.selObject.setSelected(this.checkBox.isSelected());
            this.validateOtherTiers();
            ExportFlexStep1.this.updateButtonStates();
        }

        private void validateOtherTiers() {
            if (this.column < 3) {
                for (int i = this.column + 1; i <= 3; ++i) {
                    SelectEnableObject obj = (SelectEnableObject)ExportFlexStep1.this.tierModel.getValueAt(this.row, i);
                    if (obj == null) continue;
                    obj.setEnabled(this.selObject.isSelected());
                }
                ExportFlexStep1.this.tierTable.repaint();
            }
        }
    }
}

