/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.client.util.SelectEnableObject;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.flex.FlexEncoderInfo;

public class ExportFlexStep2
extends StepPane {
    private TranscriptionImpl transcription;
    private final String SELECT_TYPE = ElanLocale.getString("TranscriptionManager.ComboBoxDefaultString");
    private final String DEFAULT_VALUE = ElanLocale.getString("ExportFlexDialog.DefaultValue");
    private final String MORPH_TYPE = "morph-type";
    private FlexEncoderInfo encoderInfo;
    private JCheckBox morphTypeCB;
    private JComboBox morphTypeCombo;
    private JTable itemTable;
    private DefaultTableModel itemModel;
    private JTable tierTable;
    private DefaultTableModel tierModel;
    private HashMap<String, List<String>> itemTypeMap;
    private HashMap<String, List<TierImpl>> itemTiersMap;
    private List<TierImpl> morphTypeTiersList;
    private String morphTypeSelected;
    protected Insets globalInset = new Insets(2, 4, 2, 4);
    private String DEL = "_";
    private ActionHandler actionHandler;
    public static final String MORPHTYPE = "ExportFlex.MorphTypeSelected";

    public ExportFlexStep2(MultiStepPane mp, TranscriptionImpl transcription) {
        super(mp);
        this.transcription = transcription;
        this.itemTypeMap = new HashMap();
        this.itemTypeMap.put("interlinear-text", new ArrayList());
        this.itemTypeMap.put("phrase", new ArrayList());
        this.itemTypeMap.put("word", new ArrayList());
        this.itemTypeMap.put("morph", new ArrayList());
        this.itemTiersMap = new HashMap();
        this.itemTiersMap.put("interlinear-text", new ArrayList());
        this.itemTiersMap.put("phrase", new ArrayList());
        this.itemTiersMap.put("word", new ArrayList());
        this.itemTiersMap.put("morph", new ArrayList());
        this.morphTypeTiersList = new ArrayList<TierImpl>();
        this.actionHandler = new ActionHandler();
        this.initComponents();
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("ExportFlexStep2.Title");
    }

    @Override
    public void enterStepForward() {
        this.encoderInfo = (FlexEncoderInfo)this.multiPane.getStepProperty("EncoderInfo");
        this.updateItemTypesFor("interlinear-text");
        this.updateItemTypesFor("phrase");
        this.updateItemTypesFor("word");
        this.updateItemTypesFor("morph");
        this.updateTypesForMorphType();
        this.updateButtonStates();
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    public boolean leaveStepForward() {
        this.storePreferences();
        ArrayList<TierImpl> itTiers = new ArrayList<TierImpl>();
        ArrayList<TierImpl> phraseList = new ArrayList<TierImpl>();
        ArrayList<TierImpl> wordList = new ArrayList<TierImpl>();
        ArrayList<TierImpl> morphList = new ArrayList<TierImpl>();
        this.morphTypeTiersList.clear();
        for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
            Object obj = this.tierTable.getValueAt(i, 0);
            if (obj != null && ((SelectEnableObject)obj).isEnabled() && ((SelectEnableObject)obj).isSelected()) {
                itTiers.add(this.transcription.getTierWithId(((SelectEnableObject)obj).toString()));
            }
            if ((obj = this.tierTable.getValueAt(i, 1)) != null && ((SelectEnableObject)obj).isEnabled() && ((SelectEnableObject)obj).isSelected()) {
                phraseList.add(this.transcription.getTierWithId(((SelectEnableObject)obj).toString()));
            }
            if ((obj = this.tierTable.getValueAt(i, 2)) != null && ((SelectEnableObject)obj).isEnabled() && ((SelectEnableObject)obj).isSelected()) {
                wordList.add(this.transcription.getTierWithId(((SelectEnableObject)obj).toString()));
            }
            if ((obj = this.tierTable.getValueAt(i, 3)) != null && ((SelectEnableObject)obj).isEnabled() && ((SelectEnableObject)obj).isSelected()) {
                morphList.add(this.transcription.getTierWithId(((SelectEnableObject)obj).toString()));
            }
            if ((obj = this.tierTable.getValueAt(i, 4)) == null || !((SelectEnableObject)obj).isEnabled() || !((SelectEnableObject)obj).isSelected()) continue;
            this.morphTypeTiersList.add(this.transcription.getTierWithId(((SelectEnableObject)obj).toString()));
        }
        this.encoderInfo.setMappingForItem("interlinear-text", itTiers);
        this.encoderInfo.setMappingForItem("phrase", phraseList);
        this.encoderInfo.setMappingForItem("word", wordList);
        this.encoderInfo.setMappingForItem("morph", morphList);
        this.encoderInfo.setMorphTypeTiers(this.morphTypeTiersList);
        this.multiPane.putStepProperty("EncoderInfo", this.encoderInfo);
        return true;
    }

    public void updateButtonStates() {
        this.multiPane.setButtonEnabled(1, true);
        this.multiPane.setButtonEnabled(2, true);
    }

    private void loadPreferences() {
        Boolean val = Preferences.getBool(MORPHTYPE, null);
        if (val != null) {
            this.morphTypeCB.setSelected(val);
        }
    }

    private void storePreferences() {
        Preferences.set(MORPHTYPE, this.morphTypeCB.isSelected(), null);
    }

    @Override
    protected void initComponents() {
        this.morphTypeCB = new JCheckBox(ElanLocale.getString("ExportFlexStep2.SelectMorphType"));
        this.morphTypeCB.setSelected(true);
        this.morphTypeCB.addActionListener(this.actionHandler);
        this.morphTypeCombo = new JComboBox();
        this.morphTypeCombo.addActionListener(this.actionHandler);
        this.itemModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (ExportFlexStep2.this.itemModel.getValueAt(row, column) == null) {
                    return false;
                }
                return !ExportFlexStep2.this.itemModel.getValueAt(row, column).toString().equals(ExportFlexStep2.this.DEFAULT_VALUE);
            }
        };
        this.itemModel.setColumnIdentifiers(new String[]{"interlinear-text" + this.DEL + "item", "phrase" + this.DEL + "item", "word" + this.DEL + "item", "morph" + this.DEL + "item"});
        this.itemModel.addRow(new Object[]{null, null, null, null});
        DefaultTableCellRenderer itemTableRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    return cell;
                }
                if (value.equals(ExportFlexStep2.this.SELECT_TYPE)) {
                    cell.setForeground(Color.GRAY);
                } else {
                    cell.setForeground(Color.BLACK);
                }
                return cell;
            }
        };
        this.itemTable = new JTable(this.itemModel);
        this.itemTable.setCellSelectionEnabled(true);
        this.itemTable.setDefaultEditor(Object.class, new ItemTableCellEditor());
        this.itemTable.setDefaultRenderer(Object.class, itemTableRenderer);
        this.itemTable.setShowGrid(true);
        this.itemTable.setGridColor(Color.BLACK);
        this.itemTable.setSelectionBackground(Color.WHITE);
        this.itemTable.setRowHeight(this.itemTable.getRowHeight() + 5);
        JPanel mappingPanel = new JPanel();
        mappingPanel.setLayout(new GridBagLayout());
        mappingPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportFlexStep2.ItemMapping")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInset;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        mappingPanel.add((Component)new JScrollPane(this.itemTable), gbc);
        this.tierModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (column == 4 && !ExportFlexStep2.this.morphTypeCB.isSelected()) {
                    return false;
                }
                Object value = this.getValueAt(row, column);
                if (value instanceof SelectEnableObject) {
                    return ((SelectEnableObject)value).isEnabled();
                }
                return false;
            }
        };
        this.tierModel.setColumnIdentifiers(new String[]{"interlinear-text" + this.DEL + "item", "phrase" + this.DEL + "item", "word" + this.DEL + "item", "morph" + this.DEL + "item", "morph-type"});
        this.tierModel.addRow(new Object[]{null, null, null, null, null});
        this.tierTable = new JTable(this.tierModel);
        this.tierTable.setDefaultRenderer(Object.class, new CheckBoxTableCellRenderer());
        this.tierTable.setDefaultEditor(Object.class, new TierTableCellEditor());
        this.tierTable.setShowGrid(true);
        this.tierTable.setGridColor(Color.BLACK);
        this.tierTable.setSelectionBackground(Color.WHITE);
        JPanel itemPanel = new JPanel();
        itemPanel.setLayout(new GridBagLayout());
        itemPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportFlexStep1.TierMapping")));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        itemPanel.add((Component)new JScrollPane(this.tierTable), gbc);
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInset;
        gbc.fill = 0;
        gbc.anchor = 18;
        this.add((Component)this.morphTypeCB, gbc);
        gbc.gridx = 1;
        this.add((Component)this.morphTypeCombo, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)mappingPanel, gbc);
        gbc.gridy = 2;
        this.add((Component)itemPanel, gbc);
        this.loadPreferences();
    }

    private void updateTypesForMorphType() {
        int i;
        List<String> typeList = this.itemTypeMap.get("morph");
        this.morphTypeCombo.removeActionListener(this.actionHandler);
        this.morphTypeCombo.removeAllItems();
        if (typeList.size() <= 0) {
            this.morphTypeCombo.setEnabled(false);
            this.morphTypeCB.setEnabled(false);
            this.morphTypeCombo.addItem(this.DEFAULT_VALUE);
            this.updateTiersForMorphType();
        } else {
            this.morphTypeCombo.setEnabled(true);
            this.morphTypeCB.setEnabled(true);
            this.morphTypeCombo.addItem(this.SELECT_TYPE);
            for (i = 0; i < typeList.size(); ++i) {
                this.morphTypeCombo.addItem(typeList.get(i));
            }
        }
        this.morphTypeCombo.addActionListener(this.actionHandler);
        if (this.morphTypeSelected != null) {
            if (typeList.contains(this.morphTypeSelected)) {
                this.morphTypeCombo.setSelectedItem(this.morphTypeSelected);
            }
        } else {
            for (i = 0; i < typeList.size(); ++i) {
                if (!typeList.get(i).contains("morph-type")) continue;
                this.morphTypeCombo.setSelectedIndex(i + 1);
            }
        }
    }

    private void updateTiersForMorphType() {
        int column = 4;
        for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
            this.tierModel.setValueAt(null, i, column);
        }
        this.morphTypeSelected = this.morphTypeCB.isSelected() ? this.morphTypeCombo.getSelectedItem().toString() : null;
        if (this.morphTypeSelected == null || this.morphTypeSelected.equals(this.DEFAULT_VALUE) || this.morphTypeSelected.equals(this.SELECT_TYPE)) {
            return;
        }
        List<TierImpl> tierList = this.encoderInfo.getMappingForElement("morph");
        ArrayList<String> itemTierList = new ArrayList<String>();
        for (TierImpl t : tierList) {
            for (TierImpl t2 : t.getChildTiers()) {
                if (!this.morphTypeSelected.equals(t2.getLinguisticType().getLinguisticTypeName())) continue;
                itemTierList.add(t.getName());
            }
        }
        if (itemTierList.size() > 0) {
            int i;
            int row = itemTierList.size();
            for (i = this.tierTable.getRowCount(); i < row; ++i) {
                this.tierModel.addRow(new Object[]{null, null, null, null, null});
            }
            for (i = 0; i < itemTierList.size(); ++i) {
                this.tierModel.setValueAt(new SelectEnableObject<String>((String)itemTierList.get(i), ((String)itemTierList.get(i)).contains("morph-type")), i, column);
            }
        } else {
            for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
                this.tierModel.setValueAt(null, i, column);
            }
        }
        this.checkAndRemoveEmptyRows(this.tierModel);
    }

    private void updateItemTypesFor(String itemType) {
        List<String> typeList = this.itemTypeMap.get(itemType);
        typeList.clear();
        List<TierImpl> tiers = null;
        int column = 0;
        if (itemType.equals("interlinear-text")) {
            tiers = this.encoderInfo.getMappingForElement("interlinear-text");
            column = 0;
        } else if (itemType.equals("phrase")) {
            tiers = this.encoderInfo.getMappingForElement("phrase");
            column = 1;
        } else if (itemType.equals("word")) {
            tiers = this.encoderInfo.getMappingForElement("word");
            column = 2;
        } else if (itemType.equals("morph")) {
            tiers = this.encoderInfo.getMappingForElement("morph");
            column = 3;
        }
        if (tiers != null) {
            for (TierImpl tier : tiers) {
                for (TierImpl tier2 : tier.getChildTiers()) {
                    int sterotype = tier2.getLinguisticType().getConstraints().getStereoType();
                    if (sterotype != 4 || typeList.contains(tier2.getLinguisticType().getLinguisticTypeName())) continue;
                    typeList.add(tier2.getLinguisticType().getLinguisticTypeName());
                }
            }
        }
        if (typeList.size() > 0) {
            int row = typeList.size();
            for (int i = this.itemTable.getRowCount(); i <= row; ++i) {
                this.itemModel.addRow(new Object[]{null, null, null, null});
            }
            boolean addDefaultValue = true;
            for (int i = 0; i < typeList.size(); ++i) {
                if (column == 3 && typeList.get(i).contains("morph-type")) {
                    addDefaultValue = false;
                    continue;
                }
                this.itemModel.setValueAt(typeList.get(i), i, column);
            }
            if (addDefaultValue) {
                this.itemModel.setValueAt(this.DEFAULT_VALUE, row, column);
            } else {
                this.itemModel.setValueAt(this.SELECT_TYPE, row - 1, column);
            }
            this.deleteColumnValuesAfter(row, column);
        } else {
            if (this.itemTable.getRowCount() <= 0) {
                this.itemModel.addRow(new Object[]{null, null, null, null});
            }
            this.itemModel.setValueAt(this.DEFAULT_VALUE, 0, column);
            this.deleteColumnValuesAfter(1, column);
        }
        this.checkAndRemoveEmptyRows(this.itemModel);
        this.updateTierTableForItem(itemType);
    }

    private void updateTierTableForItem(String itemType) {
        int i;
        List<TierImpl> tierList = this.encoderInfo.getMappingForElement(itemType);
        ArrayList<Object> typeList = new ArrayList<Object>();
        int column = 0;
        if (itemType.equals("interlinear-text")) {
            column = 0;
        } else if (itemType.equals("phrase")) {
            column = 1;
        } else if (itemType.equals("word")) {
            column = 2;
        } else if (itemType.equals("morph")) {
            column = 3;
        }
        for (int i2 = 0; i2 < this.itemTable.getRowCount(); ++i2) {
            String type = (String)this.itemTable.getValueAt(i2, column);
            if (type == null || type.equals(this.SELECT_TYPE) || type.equals(this.DEFAULT_VALUE) || typeList.contains(type)) continue;
            typeList.add(type);
        }
        ArrayList<String> itemTierList = new ArrayList<String>();
        for (TierImpl t : tierList) {
            for (TierImpl t2 : t.getChildTiers()) {
                if (!typeList.contains(t2.getLinguisticType().getLinguisticTypeName())) continue;
                itemTierList.add(t2.getName());
            }
        }
        for (i = 0; i < this.tierTable.getRowCount(); ++i) {
            this.tierModel.setValueAt(null, i, column);
        }
        if (itemTierList.size() > 0) {
            int i3;
            int row = itemTierList.size();
            for (i3 = this.tierTable.getRowCount(); i3 < row; ++i3) {
                this.tierModel.addRow(new Object[]{null, null, null, null, null});
            }
            for (i3 = 0; i3 < itemTierList.size(); ++i3) {
                if (column == 3 && ((String)itemTierList.get(i3)).contains("morph-type")) {
                    this.tierModel.setValueAt(new SelectEnableObject<String>((String)itemTierList.get(i3), false), i3, column);
                    continue;
                }
                this.tierModel.setValueAt(new SelectEnableObject<String>((String)itemTierList.get(i3), true), i3, column);
            }
        } else {
            for (i = 0; i < this.tierTable.getRowCount(); ++i) {
                this.tierModel.setValueAt(null, i, column);
            }
        }
        this.checkAndRemoveEmptyRows(this.tierModel);
    }

    private void checkAndRemoveEmptyRows(DefaultTableModel model) {
        int rowIndex = 0;
        int n = model.getColumnCount();
        while (rowIndex < model.getRowCount()) {
            if (n == 4) {
                if (model.getValueAt(rowIndex, 0) == null && model.getValueAt(rowIndex, 1) == null && model.getValueAt(rowIndex, 2) == null && model.getValueAt(rowIndex, 3) == null) {
                    model.removeRow(rowIndex);
                    continue;
                }
                ++rowIndex;
                continue;
            }
            if (n != 5) continue;
            if (model.getValueAt(rowIndex, 0) == null && model.getValueAt(rowIndex, 1) == null && model.getValueAt(rowIndex, 2) == null && model.getValueAt(rowIndex, 3) == null && model.getValueAt(rowIndex, 4) == null) {
                model.removeRow(rowIndex);
                continue;
            }
            ++rowIndex;
        }
    }

    private void updateTiersForColumn(int column) {
        switch (column) {
            case 0: {
                this.updateTierTableForItem("interlinear-text");
                break;
            }
            case 1: {
                this.updateTierTableForItem("phrase");
                break;
            }
            case 2: {
                this.updateTierTableForItem("word");
                break;
            }
            case 3: {
                this.updateTierTableForItem("morph");
            }
        }
    }

    private void deleteColumnValuesAfter(int row, int column) {
        for (int i = row + 1; i < this.itemTable.getRowCount(); ++i) {
            this.itemTable.setValueAt(null, i, column);
        }
    }

    private class ItemTableCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        private int startEditInOneClick;
        private JComboBox comboBox;
        private int row;
        private int column;
        private String value;
        private String type;

        public ItemTableCellEditor() {
            super(new JComboBox());
            this.startEditInOneClick = 1;
            this.setClickCountToStart(this.startEditInOneClick);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            int i;
            this.row = row;
            this.column = column;
            this.value = value.toString();
            switch (column) {
                case 0: {
                    this.type = "interlinear-text";
                    break;
                }
                case 1: {
                    this.type = "phrase";
                    break;
                }
                case 2: {
                    this.type = "word";
                    break;
                }
                case 3: {
                    this.type = "morph";
                }
            }
            List types = (List)ExportFlexStep2.this.itemTypeMap.get(this.type);
            this.comboBox = new JComboBox();
            ArrayList<String> usedTypes = new ArrayList<String>();
            for (i = 0; i < row; ++i) {
                usedTypes.add((String)table.getValueAt(i, column));
            }
            this.comboBox.addItem(ExportFlexStep2.this.SELECT_TYPE);
            for (i = 0; i < types.size(); ++i) {
                if (usedTypes.contains(types.get(i))) continue;
                this.comboBox.addItem(types.get(i));
            }
            this.comboBox.addActionListener(this);
            return this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportFlexStep2.this.itemTable.editingStopped(new ChangeEvent(this));
            if (this.value.equals(this.comboBox.getSelectedItem())) {
                return;
            }
            Object val = this.comboBox.getSelectedItem();
            if (!val.equals(ExportFlexStep2.this.DEFAULT_VALUE) && !val.equals(ExportFlexStep2.this.SELECT_TYPE)) {
                ExportFlexStep2.this.deleteColumnValuesAfter(this.row, this.column);
                if (this.row < ((List)ExportFlexStep2.this.itemTypeMap.get(this.type)).size() - 1) {
                    if (ExportFlexStep2.this.itemTable.getRowCount() - 1 == this.row) {
                        ExportFlexStep2.this.itemModel.addRow(new Object[]{null, null, null, null, null});
                    }
                    ExportFlexStep2.this.itemTable.setValueAt(ExportFlexStep2.this.SELECT_TYPE, this.row + 1, this.column);
                } else {
                    if (ExportFlexStep2.this.itemTable.getRowCount() - 1 == this.row) {
                        ExportFlexStep2.this.itemModel.addRow(new Object[]{null, null, null, null, null});
                    }
                    ExportFlexStep2.this.itemTable.setValueAt(ExportFlexStep2.this.DEFAULT_VALUE, this.row + 1, this.column);
                }
            } else if (val.equals(ExportFlexStep2.this.SELECT_TYPE)) {
                ExportFlexStep2.this.deleteColumnValuesAfter(this.row, this.column);
            }
            ExportFlexStep2.this.checkAndRemoveEmptyRows(ExportFlexStep2.this.itemModel);
            ExportFlexStep2.this.updateTiersForColumn(this.column);
        }
    }

    private class TierTableCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        private int startEditInOneClick;
        private JCheckBox checkBox;
        private SelectEnableObject<String> selObject;
        private int column;
        private int row;

        public TierTableCellEditor() {
            super(new JCheckBox());
            this.startEditInOneClick = 1;
            this.setClickCountToStart(this.startEditInOneClick);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            this.column = column;
            if (value instanceof SelectEnableObject) {
                this.selObject = (SelectEnableObject)value;
                this.checkBox = new JCheckBox();
                this.checkBox.setSelected(this.selObject.isSelected());
                this.checkBox.setText(((String)this.selObject.getValue()).toString());
                this.checkBox.addActionListener(this);
                return this.checkBox;
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return this.selObject;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.selObject.setSelected(this.checkBox.isSelected());
            if (this.column == 3 || this.column == 4) {
                // empty if block
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            ExportFlexStep2.this.updateTiersForMorphType();
        }
    }
}

