/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.praat.PraatTGEncoderInfo;
import mpi.eudico.server.corpora.clomimpl.praat.PraatTextGridEncoder;

public class ExportPraatDialog
extends AbstractExtTierExportDialog
implements ItemListener {
    private JCheckBox selectionCB;
    private JCheckBox correctTimesCB;
    final String prefSelectedTiers = "ExportPraatDialog.selectedTiers";
    final String prefTierOrder = "ExportPraatDialog.TierOrder";
    final String prefParentTierOrder = "ExportPraatDialog.ParentTierOrder";
    final String prefSelectTiersMode = "ExportPraatDialog.SelectTiersMode";
    final String prefLastSelectedItems = "ExportPraatDialog.LastSelectedItems";
    final String prefHiddenTiers = "ExportPraatDialog.HiddenTiers";
    final String prefRootTiersOnly = "ExportPraatDialog.ShowOnlyRootTiers";
    final String prefSelectionOnly = "ExportPraatDialog.SelectionOnly";
    final String prefAddOffsetTime = "ExportPraatDialog.AddOffsetTime";

    public ExportPraatDialog(Frame parent, boolean modal, TranscriptionImpl transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.makeLayout();
        this.postInit();
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        this.extractTiers();
    }

    protected void extractTiers() {
        String stringPref;
        List<String> tierList = Preferences.getListOfString("ExportPraatDialog.TierOrder", this.transcription);
        if (tierList != null) {
            this.setTierOrder(tierList);
        } else {
            super.extractTiers(false);
        }
        tierList = Preferences.getListOfString("ExportPraatDialog.selectedTiers", this.transcription);
        if (tierList != null) {
            this.setSelectedTiers(tierList);
        }
        if ((stringPref = Preferences.getString("ExportPraatDialog.SelectTiersMode", this.transcription)) != null) {
            List<String> selItems;
            this.setSelectionMode(stringPref);
            if (!"Tier".equals(stringPref) && (selItems = Preferences.getListOfString("ExportPraatDialog.LastSelectedItems", this.transcription)) instanceof List) {
                this.setSelectedItems(selItems);
            }
        }
        this.setPreferredSetting();
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        this.selectionCB = new JCheckBox();
        this.correctTimesCB = new JCheckBox();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.selectionCB, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.optionsPanel.add((Component)this.correctTimesCB, gridBagConstraints);
        this.updateLocale();
    }

    @Override
    protected boolean startExport() throws IOException {
        List<MediaDescriptor> mds;
        List<String> selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        String[] encodings = new String[]{"UTF-8", "UTF-16"};
        File exportFile = this.promptForFile(ElanLocale.getString("ExportPraatDialog.Title"), null, FileExtension.PRAAT_TEXTGRID_EXT, true, encodings);
        if (exportFile == null) {
            return false;
        }
        long begin = 0L;
        long end = ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer().getMediaDuration();
        boolean exportSelection = false;
        if (this.selectionCB.isSelected() && this.selection != null && this.selection.getBeginTime() < this.selection.getEndTime()) {
            begin = this.selection.getBeginTime();
            end = this.selection.getEndTime();
            exportSelection = true;
        }
        long mediaOffset = 0L;
        if (this.correctTimesCB.isSelected() && (mds = this.transcription.getMediaDescriptors()) != null && mds.size() > 0) {
            mediaOffset = mds.get((int)0).timeOrigin;
        }
        PraatTGEncoderInfo encInfo = new PraatTGEncoderInfo(begin, end);
        encInfo.setEncoding(this.encoding);
        encInfo.setOffset(mediaOffset);
        encInfo.setExportSelection(exportSelection);
        List<TierImpl> tiers = this.transcription.getTiersWithIds(selectedTiers);
        PraatTextGridEncoder encoder = new PraatTextGridEncoder();
        encoder.encodeAndSave(this.transcription, encInfo, tiers, exportFile.getAbsolutePath());
        return true;
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportPraatDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportPraatDialog.Title"));
        this.selectionCB.setText(ElanLocale.getString("ExportDialog.Restrict"));
        this.correctTimesCB.setText(ElanLocale.getString("ExportDialog.CorrectTimes"));
    }

    private void setPreferredSetting() {
        this.extractTiers();
        Boolean boolPref = Preferences.getBool("ExportPraatDialog.ShowOnlyRootTiers", null);
        if (boolPref == null) {
            boolPref = Preferences.getBool("ExportPraatDialog.rootTiersCB", null);
            Preferences.set("ExportPraatDialog.rootTiersCB", null, null);
        }
        if (boolPref != null) {
            this.setRootTiersOnly(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportPraatDialog.SelectionOnly", null)) == null) {
            boolPref = Preferences.getBool("ExportPraatDialog.selectionCB", null);
            Preferences.set("ExportPraatDialog.selectionCB", null, null);
        }
        if (boolPref != null) {
            this.selectionCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportPraatDialog.AddOffsetTime", null)) == null) {
            boolPref = Preferences.getBool("ExportPraatDialog.correctTimesCB", null);
            Preferences.set("ExportPraatDialog.correctTimesCB", null, null);
        }
        if (boolPref != null) {
            this.correctTimesCB.setSelected(boolPref);
        }
    }

    private void savePreferences() {
        boolean rootsOnly = this.tierSelectPanel.isRootTiersOnly();
        Preferences.set("ExportPraatDialog.ShowOnlyRootTiers", rootsOnly, null);
        Preferences.set("ExportPraatDialog.SelectionOnly", this.selectionCB.isSelected(), null);
        Preferences.set("ExportPraatDialog.AddOffsetTime", this.correctTimesCB.isSelected(), null);
        Preferences.set("ExportPraatDialog.selectedTiers", this.getSelectedTiers(), (Transcription)this.transcription);
        Preferences.set("ExportPraatDialog.SelectTiersMode", this.getSelectionMode(), (Transcription)this.transcription);
        if (this.getSelectionMode() != "Tier") {
            Preferences.set("ExportPraatDialog.LastSelectedItems", this.getSelectedItems(), (Transcription)this.transcription);
        }
        Preferences.set("ExportPraatDialog.HiddenTiers", this.getHiddenTiers(), (Transcription)this.transcription);
        List<String> tierOrder = this.getTierOrder();
        Preferences.set("ExportPraatDialog.TierOrder", tierOrder, (Transcription)this.transcription);
    }
}

