/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Color;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.ExportQtSubtitleDialog;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.TimeFormatter;

public class ExportQtSmilDialog
extends ExportQtSubtitleDialog {
    private static Transformer transformer2smilQt;

    public ExportQtSmilDialog(Frame parent, boolean modal, TranscriptionImpl transcription, Selection selection) {
        super(parent, modal, transcription, selection, true);
    }

    public static void export2SMILQt(URL eafURL, File smilFile, String[] tierNames, String mediaFileName, Map<String, Object> fontSettingMap) throws IOException, TransformerException {
        ExportQtSmilDialog.createTransformer();
        String fileName = new File(eafURL.getFile()).getName();
        int index = fileName.lastIndexOf(46);
        String title = index > 0 ? (fileName = fileName.substring(0, index)) : fileName;
        String comment = "Generated from " + fileName + " on " + new Date(System.currentTimeMillis());
        String txtFileName = smilFile.getName();
        index = txtFileName.lastIndexOf(46);
        if (index > 0) {
            txtFileName = txtFileName.substring(0, index);
        }
        transformer2smilQt.setParameter("comment", comment);
        transformer2smilQt.setParameter("title", title);
        if (fontSettingMap != null) {
            if (fontSettingMap.get("backColor") != null) {
                String rgb = Integer.toHexString(((Color)fontSettingMap.get("backColor")).getRGB());
                rgb = rgb.substring(2, rgb.length());
                transformer2smilQt.setParameter("background_color", "#" + rgb);
            }
            if (fontSettingMap.get("size") != null) {
                transformer2smilQt.setParameter("font_size", fontSettingMap.get("size"));
            }
            if (fontSettingMap.get("transparent") != null) {
                if (((Boolean)fontSettingMap.get("transparent")).booleanValue()) {
                    transformer2smilQt.setParameter("transparent_background", "true");
                } else {
                    transformer2smilQt.setParameter("transparent_background", "false");
                }
            }
        }
        if (mediaFileName != null) {
            transformer2smilQt.setParameter("media_url", mediaFileName);
        }
        if (tierNames != null) {
            Object tierString = tierNames[0];
            for (int i = 1; i < tierNames.length; ++i) {
                tierString = (String)tierString + "," + tierNames[i];
            }
            transformer2smilQt.setParameter("tier", tierString);
        }
        transformer2smilQt.setParameter("txtFileName", txtFileName + ".txt");
        FileOutputStream stream = new FileOutputStream(smilFile);
        transformer2smilQt.transform(new StreamSource(eafURL.openStream()), new StreamResult(stream));
        stream.close();
        transformer2smilQt.clearParameters();
    }

    public static void export2SMILQt(File eafFile, File smilFile, String[] tierNames, String mediaFileName, long beginTime, long endTime, boolean recalculateTimeInterval, boolean merged, Map<String, Object> fontSettingHashMap) throws IOException, TransformerException {
        try {
            URL eafURL = new URL("file:///" + eafFile.getAbsolutePath());
            ExportQtSmilDialog.export2SMILQt(eafURL, smilFile, tierNames, mediaFileName, beginTime, endTime, recalculateTimeInterval, merged, fontSettingHashMap);
        }
        catch (MalformedURLException e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public static void export2SMILQt(URL eafURL, File smilFile, String[] tierNames, String mediaFileName, long beginTime, long endTime, boolean recalculateTimeInterval, boolean merged, Map<String, Object> fontSettingHashMap) throws IOException, TransformerException {
        ExportQtSmilDialog.createTransformer();
        String begin_time = TimeFormatter.toString(beginTime);
        int index = begin_time.indexOf(58);
        begin_time = begin_time.substring(index + 1, begin_time.indexOf(46));
        String end_time = TimeFormatter.toString(endTime + 1000L);
        index = end_time.indexOf(58);
        end_time = end_time.substring(index + 1, end_time.indexOf(46));
        transformer2smilQt.setParameter("selected_time_interval", "true");
        if (recalculateTimeInterval) {
            transformer2smilQt.setParameter("recalculate_time_interval", "true");
        }
        if (merged) {
            transformer2smilQt.setParameter("merge", "true");
        }
        transformer2smilQt.setParameter("media_start_time", begin_time);
        transformer2smilQt.setParameter("media_stop_time", end_time);
        transformer2smilQt.setParameter("media_dur", TimeFormatter.toString(endTime - beginTime));
        ExportQtSmilDialog.export2SMILQt(eafURL, smilFile, tierNames, mediaFileName, fontSettingHashMap);
    }

    public static void export2SMILQt(URL eafURL, File smilFile, String[] tierNames, String mediaURL, long mediaDur, boolean merged, Map<String, Object> fontSettingHashMap) throws IOException, TransformerException {
        ExportQtSmilDialog.createTransformer();
        if (merged) {
            transformer2smilQt.setParameter("merge", "true");
        }
        transformer2smilQt.setParameter("media_dur", TimeFormatter.toString(mediaDur));
        ExportQtSmilDialog.export2SMILQt(eafURL, smilFile, tierNames, mediaURL, fontSettingHashMap);
    }

    public static void export2SMILQt(File eafFile, File smilFile, String[] tierNames, String mediaURL, long mediaDur, boolean merged, Map<String, Object> fontSettingHashMap) throws IOException, TransformerException {
        try {
            URL eafURL = new URL("file:///" + eafFile.getAbsolutePath());
            ExportQtSmilDialog.export2SMILQt(eafURL, smilFile, tierNames, mediaURL, mediaDur, merged, fontSettingHashMap);
        }
        catch (MalformedURLException e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    private static void createTransformer() throws TransformerException, IOException {
        if (transformer2smilQt == null) {
            String file = "/mpi/eudico/resources/eaf2smilQt.xsl";
            URL eaf2smilQt = ExportQtSmilDialog.class.getResource(file);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            transformer2smilQt = tFactory.newTransformer(new StreamSource(eaf2smilQt.openStream()));
        }
    }
}

