/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.ShoeboxMarkerDialog;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.shoebox.MarkerRecord;
import mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxTypFile;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxEncoderInfo;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;

public class ExportShoebox
extends AbstractExtTierExportDialog
implements ItemListener {
    private JButton fieldSpecButton;
    private JButton typButton;
    private JCheckBox allUnicodeCB;
    private JCheckBox correctTimesCB;
    private JCheckBox generateMarkersCB;
    private JCheckBox wrapLinesCB;
    private JLabel charPerLineLabel;
    private JLabel dbTypeLabel;
    private JLabel tierNamesLabel;
    private JLabel timeFormatLabel;
    private JLabel typeLabel;
    private JPanel markerPanel;
    private JRadioButton hhMMSSMSFormatRB;
    private JRadioButton specRB;
    private JRadioButton ssMSFormatRB;
    private JRadioButton tierNamesRB;
    private JRadioButton typeRB;
    private JTextField dbTypField;
    private JTextField numCharTF;
    private JTextField typField;
    private final int NUM_CHARS = 80;
    private List<MarkerRecord> markers;
    private String databaseType;
    private String exportFileName;

    public ExportShoebox(Frame parent, boolean modal, TranscriptionImpl transcription) {
        super(parent, modal, transcription, null);
        this.makeLayout();
        this.extractTiers();
        this.postInit();
        this.typField.requestFocus();
    }

    public List<TierImpl> getTierTree(TierImpl tier) {
        int j;
        ArrayList<TierImpl> tierTree = new ArrayList<TierImpl>();
        ArrayList<List<TierImpl>> tierTrees = new ArrayList<List<TierImpl>>();
        List<TierImpl> children = tier.getChildTiers();
        tierTree.add(tier);
        for (j = 0; j < children.size(); ++j) {
            TierImpl child = children.get(j);
            tierTrees.add(this.getTierTree(child));
        }
        Collections.sort(tierTrees, new ListComparator());
        for (j = 0; j < tierTrees.size(); ++j) {
            tierTree.addAll((Collection)tierTrees.get(j));
        }
        return tierTree;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.typButton) {
            this.chooseTyp();
            this.typeRB.setSelected(true);
        } else if (source == this.fieldSpecButton) {
            this.specifyFieldSpecs();
            this.specRB.setSelected(true);
        } else {
            super.actionPerformed(ae);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.wrapLinesCB) {
            if (this.wrapLinesCB.isSelected()) {
                this.setDefaultNumOfChars();
                this.numCharTF.requestFocus();
            } else {
                this.numCharTF.setEnabled(false);
                this.numCharTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            }
        } else if (ie.getSource() == this.typeRB) {
            this.setEnabledAutoGenerate(false);
            this.setEnabledAllUnicode(true);
        } else if (ie.getSource() == this.specRB) {
            this.setEnabledAutoGenerate(false);
            this.setEnabledAllUnicode(false);
        } else if (ie.getSource() == this.tierNamesRB) {
            this.setEnabledAutoGenerate(true);
            this.setEnabledAllUnicode(false);
        }
    }

    protected void extractTiers() {
        String stringPref;
        List<String> listPref = Preferences.getListOfString("ExportShoebox.TierOrder", this.transcription);
        if (listPref != null) {
            this.setTierOrder(listPref);
        } else {
            super.extractTiers(false);
        }
        listPref = Preferences.getListOfString("ExportShoebox.selectedTiers", this.transcription);
        if (listPref != null) {
            this.setSelectedTiers(listPref);
        }
        if ((stringPref = Preferences.getString("ExportShoebox.SelectTiersMode", this.transcription)) != null) {
            List<String> selItems;
            this.setSelectionMode(stringPref);
            if (!"Tier".equals(stringPref) && (selItems = Preferences.getListOfString("ExportShoebox.LastSelectedItems", this.transcription)) != null) {
                this.setSelectedItems(selItems);
            }
        }
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        this.charPerLineLabel = new JLabel();
        this.wrapLinesCB = new JCheckBox();
        this.wrapLinesCB.setSelected(true);
        this.numCharTF = new JTextField(4);
        this.timeFormatLabel = new JLabel();
        this.ssMSFormatRB = new JRadioButton();
        this.hhMMSSMSFormatRB = new JRadioButton();
        this.correctTimesCB = new JCheckBox();
        this.typField = new JTextField("", 23);
        this.typButton = new JButton("...");
        this.typeLabel = new JLabel();
        this.allUnicodeCB = new JCheckBox();
        this.fieldSpecButton = new JButton();
        this.dbTypeLabel = new JLabel();
        this.dbTypField = new JTextField("", 14);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.typeRB = new JRadioButton();
        this.typeRB.setSelected(true);
        this.typeRB.addItemListener(this);
        this.specRB = new JRadioButton();
        this.specRB.addItemListener(this);
        this.tierNamesRB = new JRadioButton();
        this.tierNamesRB.addItemListener(this);
        buttonGroup.add(this.typeRB);
        buttonGroup.add(this.specRB);
        buttonGroup.add(this.tierNamesRB);
        this.tierNamesLabel = new JLabel();
        this.generateMarkersCB = new JCheckBox();
        this.optionsPanel.setLayout(new GridBagLayout());
        this.wrapLinesCB.addItemListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.wrapLinesCB, gridBagConstraints);
        JPanel fill = new JPanel();
        Dimension fillDim = new Dimension(30, 10);
        fill.setPreferredSize(fillDim);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)fill, gridBagConstraints);
        this.numCharTF.setEnabled(false);
        this.numCharTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.numCharTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.charPerLineLabel, gridBagConstraints);
        ButtonGroup group = new ButtonGroup();
        group.add(this.ssMSFormatRB);
        this.ssMSFormatRB.setSelected(true);
        group.add(this.hhMMSSMSFormatRB);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.timeFormatLabel, gridBagConstraints);
        fill = new JPanel();
        fillDim = new Dimension(30, 10);
        fill.setPreferredSize(fillDim);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)fill, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.hhMMSSMSFormatRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.ssMSFormatRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.correctTimesCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.getContentPane().add((Component)this.optionsPanel, gridBagConstraints);
        this.markerPanel = new JPanel();
        this.markerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.markerPanel.add((Component)this.typeRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.markerPanel.add((Component)this.typeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.markerPanel.add((Component)this.typField, gridBagConstraints);
        this.typButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.markerPanel.add((Component)this.typButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.markerPanel.add((Component)this.allUnicodeCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.markerPanel.add((Component)this.specRB, gridBagConstraints);
        this.fieldSpecButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.markerPanel.add((Component)this.fieldSpecButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.markerPanel.add((Component)this.dbTypeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.markerPanel.add((Component)this.dbTypField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.markerPanel.add((Component)this.tierNamesRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.markerPanel.add((Component)this.tierNamesLabel, gridBagConstraints);
        this.generateMarkersCB.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.markerPanel.add((Component)this.generateMarkersCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.getContentPane().add((Component)this.markerPanel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this.buttonPanel, gridBagConstraints);
        this.setDefaultNumOfChars();
        this.setEnabledAutoGenerate(false);
        this.setShoeboxMarkerRB();
        this.loadPreferences();
        this.updateLocale();
    }

    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    @Override
    protected boolean startExport() {
        File exportFile;
        this.savePreferences();
        if (!this.checkMarkerFields()) {
            return false;
        }
        List<String> selectedTiers = this.getSelectedTiers();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        int charsPerLine = Integer.MAX_VALUE;
        if (this.wrapLinesCB.isSelected()) {
            String textValue = this.numCharTF.getText().trim();
            try {
                charsPerLine = Integer.parseInt(textValue);
            }
            catch (NumberFormatException nfe) {
                this.showWarningDialog(ElanLocale.getString("ExportShoebox.Message.InvalidNumber"));
                this.numCharTF.selectAll();
                this.numCharTF.requestFocus();
                return false;
            }
        }
        int timeFormat = 1;
        if (this.hhMMSSMSFormatRB.isSelected()) {
            timeFormat = 0;
        }
        if ((exportFile = this.promptForFile(ElanLocale.getString("ExportShoeboxDialog.Title"), null, FileExtension.SHOEBOX_TEXT_EXT, false)) == null) {
            return false;
        }
        this.exportFileName = exportFile.getPath();
        boolean success = this.doExport(this.exportFileName, selectedTiers, charsPerLine, timeFormat, this.correctTimesCB.isSelected());
        if (success && this.generateMarkersCB.isSelected()) {
            this.autoGenerateMarkerFile();
        }
        return success;
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportShoebox.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportShoebox.Title"));
        this.markerPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportShoebox.Label.Markers")));
        this.wrapLinesCB.setText(ElanLocale.getString("ExportShoebox.Label.WrapBlocks"));
        this.charPerLineLabel.setText(ElanLocale.getString("ExportShoebox.Label.NumberChars"));
        this.timeFormatLabel.setText(ElanLocale.getString("ExportShoebox.Label.Format"));
        this.hhMMSSMSFormatRB.setText(ElanLocale.getString("InterlinearizerOptionsDlg.TimeCodeFormat.TimeCode"));
        this.ssMSFormatRB.setText(ElanLocale.getString("InterlinearizerOptionsDlg.TimeCodeFormat.Seconds"));
        this.correctTimesCB.setText(ElanLocale.getString("ExportDialog.CorrectTimes"));
        this.typeLabel.setText(ElanLocale.getString("ExportShoebox.Label.Type"));
        this.allUnicodeCB.setText(ElanLocale.getString("ExportShoebox.CheckBox.AllUnicode"));
        this.fieldSpecButton.setText(ElanLocale.getString("ExportShoebox.Button.FieldSpec"));
        this.dbTypeLabel.setText(ElanLocale.getString("ExportShoebox.Label.SpecifyType"));
        this.tierNamesLabel.setText(ElanLocale.getString("ExportShoebox.Label.UseTierNames"));
        this.generateMarkersCB.setText(ElanLocale.getString("ExportShoebox.CheckBox.AutoGenerateMarkers"));
    }

    private void loadPreferences() {
        String stringPref;
        Boolean boolPref = Preferences.getBool("ExportShoebox.wrapLinesCB", null);
        if (boolPref != null) {
            this.wrapLinesCB.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString("ExportShoebox.numCharTF", null)) != null) {
            this.numCharTF.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool("ExportShoebox.hhMMSSMSFormatRB", null)) != null) {
            this.hhMMSSMSFormatRB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportShoebox.ssMSFormatRB", null)) != null) {
            this.ssMSFormatRB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportShoebox.allUnicodeCB", null)) != null) {
            this.allUnicodeCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportShoebox.generateMarkersCB", null)) != null) {
            this.generateMarkersCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportShoebox.correctTimesCB", null)) != null) {
            this.correctTimesCB.setSelected(boolPref);
        }
    }

    private void savePreferences() {
        Preferences.set("ExportShoebox.selectedTiers", this.getSelectedTiers(), (Transcription)this.transcription);
        Preferences.set("ExportShoebox.wrapLinesCB", this.wrapLinesCB.isSelected(), null);
        Preferences.set("ExportShoebox.numCharTF", this.numCharTF.getText(), null);
        Preferences.set("ExportShoebox.hhMMSSMSFormatRB", this.hhMMSSMSFormatRB.isSelected(), null);
        Preferences.set("ExportShoebox.ssMSFormatRB", this.ssMSFormatRB.isSelected(), null);
        Preferences.set("ExportShoebox.allUnicodeCB", this.allUnicodeCB.isSelected(), null);
        Preferences.set("ExportShoebox.generateMarkersCB", this.generateMarkersCB.isSelected(), null);
        Preferences.set("ExportShoebox.correctTimesCB", this.correctTimesCB.isSelected(), null);
        Preferences.set("ExportShoebox.SelectTiersMode", this.getSelectionMode(), (Transcription)this.transcription);
        if (this.getSelectionMode() != "Tier") {
            Preferences.set("ExportShoebox.LastSelectedItems", this.getSelectedItems(), (Transcription)this.transcription);
        }
        Preferences.set("ExportShoebox.HiddenTiers", this.getHiddenTiers(), (Transcription)this.transcription);
        List<String> tierOrder = this.getTierOrder();
        Preferences.set("ExportShoebox.TierOrder", tierOrder, (Transcription)this.transcription);
    }

    private void setDefaultNumOfChars() {
        this.numCharTF.setEnabled(true);
        this.numCharTF.setBackground(Constants.SHAREDCOLOR4);
        if (this.numCharTF.getText() != null || this.numCharTF.getText().length() == 0) {
            this.numCharTF.setText("80");
        }
    }

    private void setEnabledAllUnicode(boolean enable) {
        this.allUnicodeCB.setSelected(false);
        this.allUnicodeCB.setEnabled(enable);
    }

    private void setEnabledAutoGenerate(boolean enable) {
        this.generateMarkersCB.setSelected(false);
        this.generateMarkersCB.setEnabled(enable);
    }

    private List<TierImpl> getHierarchicallySortedTiers(TranscriptionImpl transcription) {
        ArrayList<List<TierImpl>> tierTrees = new ArrayList<List<TierImpl>>();
        ArrayList<TierImpl> sortedTiers = new ArrayList<TierImpl>();
        List<TierImpl> topTiers = transcription.getTopTiers();
        for (int i = 0; i < topTiers.size(); ++i) {
            TierImpl topTier = topTiers.get(i);
            tierTrees.add(this.getTierTree(topTier));
        }
        Collections.sort(tierTrees, new ListComparator());
        for (int j = 0; j < tierTrees.size(); ++j) {
            sortedTiers.addAll((Collection)tierTrees.get(j));
        }
        return sortedTiers;
    }

    private void setShoeboxMarkerRB() {
        String stringPref = Preferences.getString("LastUsedShoeboxExport", null);
        if (stringPref == null) {
            this.tierNamesRB.setSelected(true);
        } else if (stringPref.equalsIgnoreCase("markers")) {
            this.specRB.setSelected(true);
            this.fieldSpecButton.setEnabled(true);
            List<?> mo = Preferences.getList("LastUsedShoeboxMarkers", null);
            if (mo != null) {
                this.markers = mo;
            }
        } else if (stringPref.equalsIgnoreCase("typ")) {
            this.typeRB.setSelected(true);
            String luTypFile = Preferences.getString("LastUsedShoeboxTypFile", null);
            if (luTypFile != null) {
                this.typField.setText(luTypFile);
            }
        } else {
            this.tierNamesRB.setSelected(true);
        }
    }

    private void autoGenerateMarkerFile() {
        ArrayList<MarkerRecord> markerRecords = new ArrayList<MarkerRecord>();
        try {
            List<TierImpl> tiers = this.transcription.getTiers();
            for (int i = 0; i < tiers.size(); ++i) {
                TierImpl t = tiers.get(i);
                MarkerRecord mkrRecord = new MarkerRecord();
                mkrRecord.setMarker(t.getName());
                if (t.hasParentTier()) {
                    mkrRecord.setParentMarker(t.getParentTier().getName());
                    if (t.getLinguisticType() != null) {
                        int stereotype = t.getLinguisticType().getConstraints().getStereoType();
                        if (stereotype == 3 || stereotype == 0 || stereotype == 1) {
                            mkrRecord.setStereoType(Constraint.stereoTypes[3]);
                        } else if (stereotype == 4) {
                            mkrRecord.setStereoType(Constraint.stereoTypes[4]);
                        }
                    }
                }
                mkrRecord.setCharset("Unicode (UTF-8)");
                mkrRecord.setParticipantMarker(false);
                mkrRecord.setExcluded(false);
                markerRecords.add(mkrRecord);
            }
            Object fileName = this.transcription.getPathName();
            if (this.exportFileName != null) {
                fileName = this.exportFileName.substring(0, this.exportFileName.lastIndexOf("."));
            } else if (((String)fileName).toLowerCase().endsWith(".eaf")) {
                fileName = ((String)fileName).substring(0, ((String)fileName).lastIndexOf("."));
            }
            fileName = (String)fileName + ".mkr";
            File newSaveFile = new File((String)fileName);
            if (newSaveFile != null) {
                int answer;
                if (newSaveFile.exists() && (answer = JOptionPane.showConfirmDialog(null, ElanLocale.getString("Message.Overwrite") + "\n" + (String)fileName, ElanLocale.getString("SaveDialog.Message.Title"), 0)) == 1) {
                    return;
                }
                FileOutputStream out = new FileOutputStream(newSaveFile);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
                Iterator markerIter = markerRecords.iterator();
                while (markerIter.hasNext()) {
                    writer.write(((MarkerRecord)markerIter.next()).toString());
                }
                writer.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean checkMarkerFields() {
        if (this.typeRB.isSelected() && (this.typField.getText() == null || this.typField.getText().length() == 0)) {
            this.showError(ElanLocale.getString("ImportDialog.Message.SpecifyType"));
            return false;
        }
        if (this.typeRB.isSelected()) {
            File tf = new File(this.typField.getText());
            if (!tf.exists()) {
                this.showError(ElanLocale.getString("ImportDialog.Message.NoType"));
                return false;
            }
            try {
                ShoeboxTypFile typFile = new ShoeboxTypFile(tf);
                this.databaseType = typFile.getDatabaseType();
            }
            catch (Exception exception) {}
        } else {
            this.databaseType = this.dbTypField.getText();
        }
        return true;
    }

    private void chooseTyp() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("ImportDialog.Title.Select"), 0, ElanLocale.getString("ImportDialog.Approve"), null, FileExtension.SHOEBOX_TYP_EXT, false, "LastUsedShoeboxTypDir", 0, null);
        File f = chooser.getSelectedFile();
        if (f != null) {
            this.typField.setText(f.getAbsolutePath());
        }
    }

    private boolean doExport(String fileName, List<String> orderedTiers, int charsPerLine, int timeFormat, boolean correctTimes) {
        int markerSource = 2;
        if (this.typeRB.isSelected()) {
            markerSource = 0;
            Preferences.set("LastUsedShoeboxExport", "typ", null);
            Preferences.set("LastUsedShoeboxTypFile", this.typField.getText(), null);
        } else if (this.specRB.isSelected()) {
            markerSource = 1;
            Preferences.set("LastUsedShoeboxExport", "markers", null);
            if (this.markers != null) {
                Preferences.set("LastUsedShoeboxMarkers", this.markers, null);
            }
        } else {
            Preferences.set("LastUsedShoeboxExport", "", null);
        }
        ToolboxEncoderInfo tbEncoderInfo = new ToolboxEncoderInfo(charsPerLine, markerSource, timeFormat);
        tbEncoderInfo.setCorrectAnnotationTimes(correctTimes);
        if (this.databaseType != null) {
            tbEncoderInfo.setDatabaseType(this.databaseType);
        }
        if (this.typeRB.isSelected()) {
            if (this.allUnicodeCB.isSelected()) {
                tbEncoderInfo.setAllUnicode(true);
            }
        } else if (this.specRB.isSelected()) {
            tbEncoderInfo.setMarkers(this.markers);
        }
        if (fileName != null) {
            List<TierImpl> tiers = this.transcription.getTiersWithIds(orderedTiers);
            try {
                ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscriptionIn(this.transcription, tbEncoderInfo, tiers, fileName, 2);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error") + "\n(" + ioe.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
            }
        }
        return true;
    }

    private void showError(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Error"), 0);
    }

    private void specifyFieldSpecs() {
        ShoeboxMarkerDialog smd = new ShoeboxMarkerDialog(null, true);
        smd.setVisible(true);
        this.markers = smd.getMarkers();
    }

    class ListComparator
    implements Comparator<List<?>> {
        ListComparator() {
        }

        @Override
        public int compare(List<?> l0, List<?> l1) {
            if (l0.size() < l1.size()) {
                return 1;
            }
            if (l0.size() > l1.size()) {
                return -1;
            }
            return 0;
        }
    }
}

