/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.transform.TransformerException;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.export.DisplaySettingsPane;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.EAF2SMIL;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ExportSmilDialog
extends AbstractExtTierExportDialog
implements ChangeListener {
    private JCheckBox minimalDurCB;
    private JTextField minimalDurTF;
    private JCheckBox correctTimesCB;
    private JCheckBox recalculateTimesCB;
    private JButton fontSettingsButton;
    private Map<String, Object> fontSettingHashMap;

    public ExportSmilDialog(Frame parent, boolean modal, TranscriptionImpl transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.makeLayout();
        this.extractTiers();
        this.postInit();
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.restrictCheckBox, gridBagConstraints);
        this.recalculateTimesCB = new JCheckBox();
        this.recalculateTimesCB.setEnabled(false);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)this.recalculateTimesCB, gridBagConstraints);
        this.correctTimesCB = new JCheckBox();
        this.correctTimesCB.setSelected(true);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.correctTimesCB, gridBagConstraints);
        this.minimalDurCB = new JCheckBox();
        this.minimalDurCB.setSelected(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.minimalDurCB, gridBagConstraints);
        this.minimalDurTF = new JTextField(6);
        this.minimalDurTF.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.minimalDurTF, gridBagConstraints);
        this.fontSettingsButton = new JButton();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.fontSettingsButton, gridBagConstraints);
        this.fontSettingsButton.addActionListener(this);
        this.restrictCheckBox.addChangeListener(this);
        this.minimalDurCB.addChangeListener(this);
        this.setPreferredSetting();
        this.updateLocale();
    }

    protected void extractTiers() {
        String stringPref;
        List<String> stringsPref = Preferences.getListOfString("ExportSmilDialog.TierOrder", this.transcription);
        if (stringsPref != null) {
            this.setTierOrder(stringsPref);
        } else {
            super.extractTiers(false);
        }
        stringsPref = Preferences.getListOfString("ExportSmilDialog.selectedTiers", this.transcription);
        if (stringsPref != null) {
            this.setSelectedTiers(stringsPref);
        }
        if ((stringPref = Preferences.getString("ExportSmilDialog.SelectTiersMode", this.transcription)) != null) {
            List<String> selItems;
            this.setSelectionMode(stringPref);
            if (!"Tier".equals(stringPref) && (selItems = Preferences.getListOfString("ExportSmilDialog.LastSelectedItems", this.transcription)) instanceof List) {
                this.setSelectedItems(selItems);
            }
        }
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportSmilDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportSmilDialog.TitleLabel"));
        this.fontSettingsButton.setText(ElanLocale.getString("ExportQtSubtitleDialog.Button.FontSetting"));
        this.correctTimesCB.setText(ElanLocale.getString("ExportDialog.CorrectTimes"));
        this.minimalDurCB.setText(ElanLocale.getString("ExportDialog.Label.MinimalDur"));
        this.recalculateTimesCB.setText(ElanLocale.getString("ExportDialog.RecalculateTimes"));
    }

    @Override
    protected boolean startExport() throws IOException {
        List<MediaDescriptor> mediaDescriptors;
        File exportFile;
        List<String> selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        int minimalDur = 0;
        if (this.minimalDurCB.isSelected()) {
            String dur = this.minimalDurTF.getText();
            if (dur == null || dur.length() == 0) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
                this.minimalDurTF.requestFocus();
                return false;
            }
            try {
                minimalDur = Integer.parseInt(dur);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
                this.minimalDurTF.requestFocus();
                return false;
            }
        }
        if ((exportFile = this.promptForFile(ElanLocale.getString("Export.TigerDialog.title"), null, FileExtension.SMIL_EXT, false)) == null) {
            return false;
        }
        long offset = 0L;
        if (this.correctTimesCB.isSelected() && (mediaDescriptors = this.transcription.getMediaDescriptors()).size() > 0) {
            offset = mediaDescriptors.get((int)0).timeOrigin;
        }
        String[] tierNames = selectedTiers.toArray(new String[0]);
        String mediaURL = "";
        if (this.transcription.getMediaDescriptors().size() > 0) {
            mediaURL = this.transcription.getMediaDescriptors().get((int)0).mediaURL;
        }
        try {
            if (this.selection != null && this.restrictCheckBox.isSelected()) {
                EAF2SMIL.export2SMIL(this.transcription, exportFile, tierNames, mediaURL, this.selection.getBeginTime(), this.selection.getEndTime(), offset, minimalDur, this.recalculateTimesCB.isSelected(), this.fontSettingHashMap);
            } else {
                EAF2SMIL.export2SMIL(new File(this.transcription.getPathName()), exportFile, tierNames, mediaURL, offset, minimalDur, this.fontSettingHashMap);
            }
        }
        catch (TransformerException te) {
            throw new IOException("TransformerException: " + te.getMessage());
        }
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.minimalDurCB) {
            this.minimalDurTF.setEnabled(this.minimalDurCB.isSelected());
        } else if (e.getSource() == this.restrictCheckBox) {
            this.recalculateTimesCB.setEnabled(this.restrictCheckBox.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
        if (ae.getSource() == this.fontSettingsButton) {
            this.setName("realPlayer");
            this.setNewFontSetting(DisplaySettingsPane.getNewFontSetting(this, ElanLocale.getString("DisplaySettingsPane.Title")));
        }
    }

    private void setNewFontSetting(Map<String, Object> newSetting) {
        if (newSetting != null) {
            this.fontSettingHashMap = new HashMap<String, Object>();
            this.fontSettingHashMap = newSetting;
        }
    }

    private void setPreferredSetting() {
        String stringPref;
        Boolean boolPref = Preferences.getBool("ExportSmilDialog.restrictCheckBox", null);
        if (boolPref != null) {
            this.restrictCheckBox.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportSmilDialog.minimalDurCB", null)) != null) {
            this.minimalDurCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportSmilDialog.correctTimesCB", null)) != null) {
            this.correctTimesCB.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString("ExportSmilDialog.minimalDurTF", null)) != null) {
            this.minimalDurTF.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool("ExportSmilDialog.recalculateTimesCB", null)) != null) {
            this.recalculateTimesCB.setSelected(boolPref);
        }
    }

    private void savePreferences() {
        Preferences.set("ExportSmilDialog.restrictCheckBox", this.restrictCheckBox.isSelected(), null);
        Preferences.set("ExportSmilDialog.selectedTiers", this.getSelectedTiers(), (Transcription)this.transcription);
        Preferences.set("ExportSmilDialog.minimalDurCB", this.minimalDurCB.isSelected(), null);
        Preferences.set("ExportSmilDialog.correctTimesCB", this.correctTimesCB.isSelected(), null);
        Preferences.set("ExportSmilDialog.recalculateTimesCB", this.recalculateTimesCB.isSelected(), null);
        if (this.minimalDurTF.getText() != null) {
            Preferences.set("ExportSmilDialog.minimalDurTF", this.minimalDurTF.getText(), null);
        }
        Preferences.set("ExportSmilDialog.SelectTiersMode", this.getSelectionMode(), (Transcription)this.transcription);
        if (this.getSelectionMode() != "Tier") {
            Preferences.set("ExportSmilDialog.LastSelectedItems", this.getSelectedItems(), (Transcription)this.transcription);
        }
        Preferences.set("ExportSmilDialog.HiddenTiers", this.getHiddenTiers(), (Transcription)this.transcription);
        List<String> tierOrder = this.getTierOrder();
        Preferences.set("ExportSmilDialog.TierOrder", tierOrder, (Transcription)this.transcription);
    }
}

