/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.logging.Level;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.export.MinimalTabExportTableModel;
import mpi.eudico.client.annotator.util.AnnotationSlicer;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextEncoderInfo;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextEncoderInfoFiles;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextEncoderInfoTrans;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.TimeFormatter;
import mpi.eudico.util.TimeInterval;
import mpi.eudico.util.TimeRelation;

public class ExportTabdelimited {
    private String TAB = "\t";
    private final String NEWLINE = "\n";
    private String COMMA = ",";
    private final String SQ = "\"";
    private final String DQ = "\"\"";
    private boolean csvEncodeText = false;

    public void setDelimiter(String delimiter) {
        if (delimiter != null) {
            this.TAB = delimiter;
        }
    }

    public String getDelimiter() {
        return this.TAB;
    }

    public void exportTiersColumnPerTier(DelimitedTextEncoderInfoTrans encoderInfo) throws IOException {
        if (encoderInfo.getExportFile() == null) {
            throw new IOException("Encoder: no destination file specified for export");
        }
        if (encoderInfo.isExportCSVFormat()) {
            this.TAB = this.COMMA;
            this.csvEncodeText = true;
        }
        BufferedWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(encoderInfo.getExportFile());
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, encoderInfo.getCharEncoding());
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
            if (encoderInfo.getTierNames() == null) {
                ArrayList<String> includedTiers = new ArrayList<String>();
                List<TierImpl> tiers = encoderInfo.getTranscription().getTiers();
                for (Tier tier : tiers) {
                    includedTiers.add(tier.getName());
                }
                encoderInfo.setTierNames(includedTiers);
            }
            if (encoderInfo.getMediaHeaderLines() != null) {
                for (String line : encoderInfo.getMediaHeaderLines()) {
                    writer.write(line + "\n");
                }
            }
            this.writeHeaders(writer, encoderInfo);
            this.writeTiersColumnPerTier(writer, encoderInfo.getTranscription(), encoderInfo);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("Cannot write to file: " + ex.getMessage());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void exportTiersColumnPerTierForFiles(DelimitedTextEncoderInfoFiles encoderInfo) throws IOException {
        if (encoderInfo.getExportFile() == null) {
            throw new IOException("No destination file specified for export");
        }
        if (encoderInfo.getFiles() == null || encoderInfo.getFiles().isEmpty()) {
            throw new IOException("No files specified for export");
        }
        if (encoderInfo.getTierNames() == null || encoderInfo.getTierNames().isEmpty()) {
            throw new IOException("No tiers specified for export");
        }
        if (encoderInfo.isExportCSVFormat()) {
            this.TAB = this.COMMA;
            this.csvEncodeText = true;
        }
        BufferedWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(encoderInfo.getExportFile());
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, encoderInfo.getCharEncoding());
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
            this.writeHeaders(writer, encoderInfo);
            for (File file : encoderInfo.getFiles()) {
                if (file == null) continue;
                try {
                    TranscriptionImpl trans = new TranscriptionImpl(file.getAbsolutePath());
                    this.writeTiersColumnPerTier(writer, trans, encoderInfo);
                }
                catch (Exception ex) {
                    ClientLogger.LOG.warning("Could not handle file: " + file.getAbsolutePath());
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("Cannot write to file: " + ex.getMessage());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void writeTiersColumnPerTier(BufferedWriter writer, TranscriptionImpl transcription, DelimitedTextEncoderInfo encoderInfo) throws IOException {
        int j;
        if (transcription == null) {
            throw new NullPointerException("The transcription is null");
        }
        if (writer == null) {
            throw new IOException("No writer supplied to write to");
        }
        if (encoderInfo.isExportCSVFormat()) {
            this.TAB = this.COMMA;
            this.csvEncodeText = true;
        }
        long mediaOffset = 0L;
        if (encoderInfo.isAddMasterMediaOffset() && transcription.getMediaDescriptors() != null && !transcription.getMediaDescriptors().isEmpty()) {
            mediaOffset = transcription.getMediaDescriptors().get((int)0).timeOrigin;
        }
        if (encoderInfo instanceof DelimitedTextEncoderInfoFiles) {
            List<String> medHeaders;
            DelimitedTextEncoderInfoFiles ecoderInfoFiles = (DelimitedTextEncoderInfoFiles)encoderInfo;
            if (ecoderInfoFiles.isFileNameInRow()) {
                writer.write("\n");
                if (ecoderInfoFiles.isIncludeFileName()) {
                    writer.write("\"#" + transcription.getName() + "\"\n");
                }
                if (ecoderInfoFiles.isIncludeFilePath() || !ecoderInfoFiles.isIncludeFileName() && !ecoderInfoFiles.isIncludeFilePath()) {
                    writer.write("\"#" + transcription.getPathName() + "\"\n");
                }
            }
            if (ecoderInfoFiles.isIncludeMediaHeaders() && (medHeaders = this.getMediaHeaders(transcription)) != null) {
                if (!ecoderInfoFiles.isFileNameInRow()) {
                    writer.write("\n");
                }
                for (String s : medHeaders) {
                    writer.write(s);
                    writer.write("\n");
                }
            }
        }
        DefaultMutableTreeNode rootNode = this.createTree(encoderInfo.getTierNames(), transcription);
        ArrayList<MinimalTabExportTableModel> allBlocks = new ArrayList<MinimalTabExportTableModel>();
        ArrayList<Annotation> allAnnotations = new ArrayList<Annotation>(100);
        block1: for (int i = 0; i < rootNode.getChildCount(); ++i) {
            HashMap<String, String> cvEntryMap = null;
            String cvName = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            String tierName = (String)node.getUserObject();
            TierImpl tier = transcription.getTierWithId(tierName);
            if (tier == null) continue;
            if (encoderInfo.isIncludeCVDescription()) {
                cvEntryMap = new HashMap<String, String>();
                cvName = tier.getLinguisticType().getControlledVocabularyName();
                if (cvName != null) {
                    ControlledVocabulary cv = transcription.getControlledVocabulary(cvName);
                    int defLang = cv.getDefaultLanguageIndex();
                    for (CVEntry cve : cv) {
                        cvEntryMap.put(cve.getValue(defLang), cve.getDescription(defLang));
                    }
                }
            }
            List<AbstractAnnotation> annos = tier.getAnnotations();
            for (j = 0; j < annos.size(); ++j) {
                allAnnotations.clear();
                Annotation ann = annos.get(j);
                if (ann == null) continue;
                if (TimeRelation.overlaps(ann, encoderInfo.getBeginTime(), encoderInfo.getEndTime())) {
                    allAnnotations.add(ann);
                    long b = ann.getBeginTimeBoundary();
                    long e = ann.getEndTimeBoundary();
                    Enumeration<TreeNode> nodeEn = node.depthFirstEnumeration();
                    block4: while (nodeEn.hasMoreElements()) {
                        DefaultMutableTreeNode chNode = (DefaultMutableTreeNode)nodeEn.nextElement();
                        if (chNode == node || (tier = transcription.getTierWithId(tierName = (String)chNode.getUserObject())) == null) continue;
                        List<AbstractAnnotation> annos2 = tier.getAnnotations();
                        for (int k = 0; k < annos2.size(); ++k) {
                            Annotation ann2 = annos2.get(k);
                            if (ann2 == null) continue;
                            if (TimeRelation.overlaps(ann2, b, e)) {
                                allAnnotations.add(ann2);
                            }
                            if (ann2.getBeginTimeBoundary() > e) continue block4;
                        }
                    }
                    MinimalTabExportTableModel tm = null;
                    tm = encoderInfo.isRepeatValues() && encoderInfo.isCombineBlocks() ? new MinimalTabExportTableModel(encoderInfo.getTierNames(), allAnnotations, cvEntryMap, true, true, encoderInfo.isIncludeAnnotationId()) : new MinimalTabExportTableModel(encoderInfo.getTierNames(), allAnnotations, cvEntryMap, true, false, encoderInfo.isIncludeAnnotationId());
                    if (encoderInfo instanceof DelimitedTextEncoderInfoFiles && !((DelimitedTextEncoderInfoFiles)encoderInfo).isFileNameInRow()) {
                        if (((DelimitedTextEncoderInfoFiles)encoderInfo).isIncludeFileName()) {
                            tm.setFileName(transcription.getName());
                        }
                        if (((DelimitedTextEncoderInfoFiles)encoderInfo).isIncludeFilePath()) {
                            tm.setFilePath(transcription.getFullPath());
                        }
                    }
                    if (encoderInfo.isCombineBlocks()) {
                        tm.setSpan(new long[]{b, e});
                        allBlocks.add(tm);
                    } else {
                        this.writeBlock(writer, tm, encoderInfo, mediaOffset);
                    }
                }
                if (ann.getBeginTimeBoundary() > encoderInfo.getEndTime()) continue block1;
            }
        }
        if (encoderInfo.isCombineBlocks()) {
            int i;
            ArrayList<MinimalTabExportTableModel> removableBlocks = new ArrayList<MinimalTabExportTableModel>();
            for (i = allBlocks.size() - 1; i >= 0; --i) {
                MinimalTabExportTableModel mtm2 = (MinimalTabExportTableModel)allBlocks.get(i);
                long[] span2 = mtm2.getSpan();
                for (j = 0; j < allBlocks.size(); ++j) {
                    boolean empty;
                    MinimalTabExportTableModel mtm1;
                    long[] span1;
                    if (j == i || (span1 = (mtm1 = (MinimalTabExportTableModel)allBlocks.get(j)).getSpan())[0] > span2[0] || span1[1] < span2[1] || !(empty = this.mergeTables(mtm1, mtm2))) continue;
                    removableBlocks.add(mtm2);
                }
            }
            if (removableBlocks.size() > 0) {
                for (i = allBlocks.size() - 1; i >= 0; --i) {
                    if (!removableBlocks.contains(allBlocks.get(i))) continue;
                    allBlocks.remove(i);
                }
            }
            for (i = 0; i < allBlocks.size(); ++i) {
                this.writeBlock(writer, (MinimalTabExportTableModel)allBlocks.get(i), encoderInfo, mediaOffset);
            }
        }
    }

    private boolean mergeTables(MinimalTabExportTableModel mtm1, MinimalTabExportTableModel mtm2) {
        int i;
        ArrayList<Integer> removals = new ArrayList<Integer>();
        block0: for (i = 0; i < mtm2.getRows().size(); ++i) {
            List<Object> curRow = mtm2.getRows().get(i);
            long l1 = (Long)curRow.get(1);
            long l2 = (Long)curRow.get(2);
            for (int j = 0; j < mtm1.getRows().size(); ++j) {
                Object val;
                int k;
                List<Object> otherRow = mtm1.getRows().get(j);
                long l3 = (Long)otherRow.get(1);
                long l4 = (Long)otherRow.get(2);
                if (l1 == l3 && l2 == l4) {
                    removals.add(i);
                    for (k = 3; k < curRow.size(); ++k) {
                        val = curRow.get(k);
                        if (val == null) continue;
                        otherRow.set(k, val);
                    }
                    continue block0;
                }
                if (l3 > l1 || l4 < l2) continue;
                for (k = 3; k < otherRow.size(); ++k) {
                    val = otherRow.get(k);
                    if (val == null) continue;
                    curRow.set(k, val);
                }
            }
        }
        for (i = removals.size() - 1; i >= 0; --i) {
            mtm2.getRows().remove((Integer)removals.get(i));
        }
        return mtm2.getRows().size() == 0;
    }

    private void writeHeaders(BufferedWriter writer, DelimitedTextEncoderInfo encoderInfo) throws IOException {
        if (encoderInfo.isIncludeBeginTime()) {
            if (encoderInfo.isIncludeHHMM()) {
                writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode")) + this.TAB);
            }
            if (encoderInfo.isIncludeSSMS()) {
                writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.Seconds")) + this.TAB);
            }
            if (encoderInfo.isIncludeMS()) {
                writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.MilliSec")) + this.TAB);
            }
            if (encoderInfo.isIncludeSMPTE()) {
                if (encoderInfo.isPalFormat()) {
                    writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL")) + this.TAB);
                } else if (encoderInfo.isPal50Format()) {
                    writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL50")) + this.TAB);
                } else {
                    writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC")) + this.TAB);
                }
            }
        }
        if (encoderInfo.isIncludeEndTime()) {
            if (encoderInfo.isIncludeHHMM()) {
                writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode")) + this.TAB);
            }
            if (encoderInfo.isIncludeSSMS()) {
                writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.Seconds")) + this.TAB);
            }
            if (encoderInfo.isIncludeMS()) {
                writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.MilliSec")) + this.TAB);
            }
            if (encoderInfo.isIncludeSMPTE()) {
                if (encoderInfo.isPalFormat()) {
                    writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL")) + this.TAB);
                } else if (encoderInfo.isPal50Format()) {
                    writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL50")) + this.TAB);
                } else {
                    writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC")) + this.TAB);
                }
            }
        }
        if (encoderInfo.isIncludeDuration()) {
            if (encoderInfo.isIncludeHHMM()) {
                writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode")) + this.TAB);
            }
            if (encoderInfo.isIncludeSSMS()) {
                writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.Seconds")) + this.TAB);
            }
            if (encoderInfo.isIncludeMS()) {
                writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.MilliSec")) + this.TAB);
            }
            if (encoderInfo.isIncludeSMPTE()) {
                if (encoderInfo.isPalFormat()) {
                    writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL")) + this.TAB);
                } else if (encoderInfo.isPal50Format()) {
                    writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL50")) + this.TAB);
                } else {
                    writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC")) + this.TAB);
                }
            }
        }
        for (String name : encoderInfo.getTierNames()) {
            writer.write(this.csvEncodeCond1(name));
            writer.write(this.TAB);
        }
        if (encoderInfo.isIncludeCVDescription()) {
            writer.write(this.csvEncodeCond1(ElanLocale.getString("EditCVDialog.Label.CVDescription")));
            writer.write(this.TAB);
        }
        if (encoderInfo instanceof DelimitedTextEncoderInfoFiles && !((DelimitedTextEncoderInfoFiles)encoderInfo).isFileNameInRow()) {
            if (((DelimitedTextEncoderInfoFiles)encoderInfo).isIncludeFileName()) {
                writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnFileName")) + this.TAB);
            }
            if (((DelimitedTextEncoderInfoFiles)encoderInfo).isIncludeFilePath()) {
                writer.write(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnFilePath")));
            }
        }
        writer.write("\n");
    }

    private void writeBlock(BufferedWriter writer, MinimalTabExportTableModel tm, DelimitedTextEncoderInfo encoderInfo, long mediaOffset) throws IOException {
        if (tm == null) {
            ClientLogger.LOG.warning("No table model provided");
            return;
        }
        List<List<Object>> rows = tm.getRows();
        List<Object> row = null;
        for (int i = 0; i < rows.size(); ++i) {
            row = rows.get(i);
            if (row.get(0) == tm.HIDDEN) continue;
            long bt = (Long)row.get(1) + mediaOffset;
            long et = (Long)row.get(2) + mediaOffset;
            this.writeTimes(writer, encoderInfo, bt, et);
            for (int j = 3; j < row.size(); ++j) {
                Object value = row.get(j);
                if (value != null) {
                    if (value instanceof String) {
                        writer.write(this.csvEncodeCond2((String)value));
                    } else {
                        writer.write(this.csvEncodeCond2(value.toString()));
                    }
                }
                if (j == row.size() - 1) continue;
                writer.write(this.TAB);
            }
            if (tm.getFileName() != null) {
                writer.write(this.TAB + this.csvEncodeCond1(tm.getFileName()));
            }
            if (tm.getFilePath() != null) {
                writer.write(this.TAB + this.csvEncodeCond1(tm.getFilePath()));
            }
            writer.write("\n");
        }
    }

    private DefaultMutableTreeNode createTree(List<String> includedTiers, Transcription transcription) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("root");
        ArrayList<DefaultMutableTreeNode> nodeList = new ArrayList<DefaultMutableTreeNode>(includedTiers.size());
        for (String name : includedTiers) {
            nodeList.add(new DefaultMutableTreeNode(name));
        }
        for (DefaultMutableTreeNode node : nodeList) {
            String tierName = (String)node.getUserObject();
            TierImpl tier = (TierImpl)transcription.getTierWithId(tierName);
            if (tier == null) continue;
            TierImpl parentTier = tier.getParentTier();
            if (parentTier == null) {
                rootNode.add(node);
            } else {
                String parentName = parentTier.getName();
                if (!includedTiers.contains(parentName)) {
                    do {
                        if ((parentTier = parentTier.getParentTier()) != null) continue;
                        parentName = null;
                        break;
                    } while (!includedTiers.contains(parentName = parentTier.getName()));
                }
                if (parentName == null) {
                    rootNode.add(node);
                } else {
                    for (DefaultMutableTreeNode node2 : nodeList) {
                        if (!parentName.equals(node2.getUserObject())) continue;
                        node2.add(node);
                        break;
                    }
                }
            }
            if (node.getParent() != null) continue;
            ClientLogger.LOG.warning("Tier " + tierName + " could not be added to a parent");
            rootNode.add(node);
        }
        return rootNode;
    }

    private List<String> getMediaHeaders(Transcription transcription) {
        if (transcription != null && transcription.getMediaDescriptors() != null && !transcription.getMediaDescriptors().isEmpty()) {
            ArrayList<String> lines = new ArrayList<String>(transcription.getMediaDescriptors().size());
            for (MediaDescriptor md : transcription.getMediaDescriptors()) {
                lines.add("\"#" + md.mediaURL + " -- offset: " + md.timeOrigin + "\"");
            }
            return lines;
        }
        return null;
    }

    public void exportTiersSliced(DelimitedTextEncoderInfoTrans encoderInfo) throws IOException {
        if (encoderInfo.getExportFile() == null) {
            throw new IOException("Encoder: no destination file specified for export");
        }
        if (encoderInfo.isExportCSVFormat()) {
            this.TAB = this.COMMA;
            this.csvEncodeText = true;
        }
        BufferedWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(encoderInfo.getExportFile());
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, encoderInfo.getCharEncoding());
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
            if (encoderInfo.getTierNames() == null) {
                ArrayList<String> includedTiers = new ArrayList<String>();
                List<TierImpl> tiers = encoderInfo.getTranscription().getTiers();
                for (Tier tier : tiers) {
                    includedTiers.add(tier.getName());
                }
                encoderInfo.setTierNames(includedTiers);
            }
            if (encoderInfo.getMediaHeaderLines() != null) {
                for (String line : encoderInfo.getMediaHeaderLines()) {
                    writer.write(line + "\n");
                }
            }
            this.writeHeaders(writer, encoderInfo);
            this.writeSlices(writer, encoderInfo.getTranscription(), encoderInfo);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("Cannot write to file: " + ex.getMessage());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void exportTiersSlicedForFiles(DelimitedTextEncoderInfoFiles encoderInfo) throws IOException {
        if (encoderInfo.getExportFile() == null) {
            throw new IOException("No destination file specified for export");
        }
        if (encoderInfo.getFiles() == null || encoderInfo.getFiles().isEmpty()) {
            throw new IOException("No files specified for export");
        }
        if (encoderInfo.getTierNames() == null || encoderInfo.getTierNames().isEmpty()) {
            throw new IOException("No tiers specified for export");
        }
        if (encoderInfo.isExportCSVFormat()) {
            this.TAB = this.COMMA;
            this.csvEncodeText = true;
        }
        BufferedWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(encoderInfo.getExportFile());
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, encoderInfo.getCharEncoding());
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
            this.writeHeaders(writer, encoderInfo);
            for (File file : encoderInfo.getFiles()) {
                if (file == null) {
                    if (!ClientLogger.LOG.isLoggable(Level.INFO)) continue;
                    ClientLogger.LOG.info("A tier in the list is null");
                    continue;
                }
                try {
                    TranscriptionImpl trans = new TranscriptionImpl(file.getAbsolutePath());
                    this.writeSlices(writer, trans, encoderInfo);
                }
                catch (Exception ex) {
                    ClientLogger.LOG.warning("Could not handle file: " + file.getAbsolutePath());
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("Cannot write to file: " + ex.getMessage());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void writeSlices(BufferedWriter writer, TranscriptionImpl transcription, DelimitedTextEncoderInfo encoderInfo) throws IOException {
        if (transcription == null) {
            throw new NullPointerException("The transcription is null");
        }
        if (writer == null) {
            throw new IOException("No writer supplied to write to");
        }
        long mediaOffset = 0L;
        if (encoderInfo.isAddMasterMediaOffset() && transcription.getMediaDescriptors() != null && !transcription.getMediaDescriptors().isEmpty()) {
            mediaOffset = transcription.getMediaDescriptors().get((int)0).timeOrigin;
        }
        if (encoderInfo instanceof DelimitedTextEncoderInfoFiles) {
            List<String> medHeaders;
            DelimitedTextEncoderInfoFiles ecoderInfoFiles = (DelimitedTextEncoderInfoFiles)encoderInfo;
            if (ecoderInfoFiles.isFileNameInRow()) {
                writer.write("\n");
                if (ecoderInfoFiles.isIncludeFileName()) {
                    writer.write("\"#" + transcription.getName() + "\"\n");
                }
                if (ecoderInfoFiles.isIncludeFilePath() || !ecoderInfoFiles.isIncludeFileName() && !ecoderInfoFiles.isIncludeFilePath()) {
                    writer.write("\"#" + transcription.getPathName() + "\"\n");
                }
            }
            if (ecoderInfoFiles.isIncludeMediaHeaders() && (medHeaders = this.getMediaHeaders(transcription)) != null) {
                if (!ecoderInfoFiles.isFileNameInRow()) {
                    writer.write("\n");
                }
                for (String s : medHeaders) {
                    writer.write(s);
                    writer.write("\n");
                }
            }
        }
        ArrayList<TierImpl> tierList = new ArrayList<TierImpl>(encoderInfo.getTierNames().size());
        ArrayList<Integer> tierIndexList = new ArrayList<Integer>(tierList.size());
        for (int i = 0; i < encoderInfo.getTierNames().size(); ++i) {
            String name = encoderInfo.getTierNames().get(i);
            TierImpl t = transcription.getTierWithId(name);
            if (t != null) {
                tierList.add(t);
                tierIndexList.add(tierList.indexOf(t));
                continue;
            }
            tierIndexList.add(-1);
        }
        List<Long> timeValues = AnnotationSlicer.getTimeValues(tierList);
        if (timeValues == null || timeValues.isEmpty()) {
            writer.write("\n");
            return;
        }
        SortedMap<TimeInterval, List<Annotation>> sliceMap = AnnotationSlicer.getIntervalAnnotationMap(timeValues, tierList);
        if (sliceMap == null || sliceMap.isEmpty()) {
            writer.write("\n");
            return;
        }
        for (TimeInterval nextKey : sliceMap.keySet()) {
            List annList = (List)sliceMap.get(nextKey);
            long bt = nextKey.getBeginTime() + mediaOffset;
            long et = nextKey.getEndTime() + mediaOffset;
            this.writeTimes(writer, encoderInfo, bt, et);
            for (Integer i : tierIndexList) {
                if (i == -1) {
                    writer.write(this.TAB);
                    continue;
                }
                Annotation a = (Annotation)annList.get(i);
                if (a != null) {
                    if (!encoderInfo.isIncludeAnnotationId()) {
                        writer.write(this.csvEncodeCond2(a.getValue()));
                    } else {
                        writer.write(this.csvEncodeCond2(a.getValue() + " [" + a.getId() + "]"));
                    }
                }
                writer.write(this.TAB);
            }
            if (encoderInfo instanceof DelimitedTextEncoderInfoFiles) {
                DelimitedTextEncoderInfoFiles ecoderInfoFiles = (DelimitedTextEncoderInfoFiles)encoderInfo;
                if (ecoderInfoFiles.isIncludeFileName()) {
                    writer.write(this.TAB + this.csvEncodeCond1(transcription.getName()));
                }
                if (ecoderInfoFiles.isIncludeFilePath()) {
                    writer.write(this.TAB + this.csvEncodeCond1(transcription.getPathName()));
                }
            }
            writer.write("\n");
        }
    }

    private void writeTimes(BufferedWriter writer, DelimitedTextEncoderInfo encoderInfo, long bt, long et) throws IOException {
        if (encoderInfo.isIncludeBeginTime()) {
            if (encoderInfo.isIncludeHHMM()) {
                writer.write(TimeFormatter.toString(bt) + this.TAB);
            }
            if (encoderInfo.isIncludeSSMS()) {
                writer.write(Double.toString((double)bt / 1000.0) + this.TAB);
            }
            if (encoderInfo.isIncludeMS()) {
                writer.write(bt + this.TAB);
            }
            if (encoderInfo.isIncludeSMPTE()) {
                if (encoderInfo.isPalFormat()) {
                    writer.write(TimeFormatter.toTimecodePAL(bt) + this.TAB);
                } else if (encoderInfo.isPal50Format()) {
                    writer.write(TimeFormatter.toTimecodePAL50(bt) + this.TAB);
                } else {
                    writer.write(TimeFormatter.toTimecodeNTSC(bt) + this.TAB);
                }
            }
        }
        if (encoderInfo.isIncludeEndTime()) {
            if (encoderInfo.isIncludeHHMM()) {
                writer.write(TimeFormatter.toString(et) + this.TAB);
            }
            if (encoderInfo.isIncludeSSMS()) {
                writer.write(Double.toString((double)et / 1000.0) + this.TAB);
            }
            if (encoderInfo.isIncludeMS()) {
                writer.write(et + this.TAB);
            }
            if (encoderInfo.isIncludeSMPTE()) {
                if (encoderInfo.isPalFormat()) {
                    writer.write(TimeFormatter.toTimecodePAL(et) + this.TAB);
                } else if (encoderInfo.isPal50Format()) {
                    writer.write(TimeFormatter.toTimecodePAL50(et) + this.TAB);
                } else {
                    writer.write(TimeFormatter.toTimecodeNTSC(et) + this.TAB);
                }
            }
        }
        if (encoderInfo.isIncludeDuration()) {
            long d = et - bt;
            if (encoderInfo.isIncludeHHMM()) {
                writer.write(TimeFormatter.toString(d) + this.TAB);
            }
            if (encoderInfo.isIncludeSSMS()) {
                writer.write(Double.toString((double)d / 1000.0) + this.TAB);
            }
            if (encoderInfo.isIncludeMS()) {
                writer.write(d + this.TAB);
            }
            if (encoderInfo.isIncludeSMPTE()) {
                if (encoderInfo.isPalFormat()) {
                    writer.write(TimeFormatter.toTimecodePAL(d) + this.TAB);
                } else if (encoderInfo.isPal50Format()) {
                    writer.write(TimeFormatter.toTimecodePAL50(d) + this.TAB);
                } else {
                    writer.write(TimeFormatter.toTimecodeNTSC(d) + this.TAB);
                }
            }
        }
    }

    private String csvEncodeCond1(String inputText) {
        if (this.csvEncodeText) {
            return "\"" + inputText.replace('\n', ' ').replaceAll("\"", "\"\"") + "\"";
        }
        return inputText;
    }

    private String csvEncodeCond2(String inputText) {
        if (this.csvEncodeText) {
            return "\"" + inputText.replace('\n', ' ').replaceAll("\"", "\"\"") + "\"";
        }
        return inputText.replace('\n', ' ');
    }
}

