/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.SaveAs27Preferences;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;

public class ExportTiersDialog
extends AbstractExtTierExportDialog {
    private int progressValue;
    private boolean filesOpened = false;
    private boolean exportingStarted = false;
    private ButtonGroup dependentTiersBtnGroup;
    private ButtonGroup saveTierBtnGroup;
    private ButtonGroup fileNameBtnGroup;
    private ButtonGroup suffixBtnGroup;
    private JButton browseBtn;
    private JCheckBox dontExportFilesWithoutTiersCB;
    private JLabel dependentTiersLabel;
    private JLabel directoryOptionsLabel;
    private JLabel resultingFilenameLabel;
    private JLabel otherOptionLabel;
    private JRadioButton includeParentTiersRB;
    private JRadioButton neglectDependentTiersRB;
    private JRadioButton originalDirRB;
    private JRadioButton togetherInSameDirRB;
    private JRadioButton newDirectoryRB;
    private JRadioButton originalFileNameRB;
    private JRadioButton addSuffixRB;
    private JRadioButton originalFileNameWithSuffixRB;
    private JRadioButton useBaseNameWithSuffixRB;
    private JTextField sameDirectoryTextField;
    private JTextField localDirectoryTextField;
    private JTextField suffixNameTextField;
    private JTextField baseNameTextField;
    private JProgressBar progressBar;
    private JPanel dependentTiersOptionPanel;
    private JPanel fileNameOptionsPanel;
    private JPanel directoryOptionsPanel;
    private JPanel otherOptionsPanel;
    private String browseDirText;

    public ExportTiersDialog(Frame parent, boolean modal, List<File> files) {
        super(parent, modal, files);
        this.files = files;
        this.initializeComponents();
        this.makeLayout();
        this.loadPreferences();
        this.extractTiersFromFiles();
        this.postInit();
    }

    @Override
    protected void extractTiersFromFiles() {
        super.extractTiersFromFiles();
        this.filesOpened = true;
        this.updateExportButtonEnabled();
    }

    private void initializeComponents() {
        this.dependentTiersOptionPanel = new JPanel();
        this.dependentTiersLabel = new JLabel();
        this.includeParentTiersRB = new JRadioButton("", true);
        this.neglectDependentTiersRB = new JRadioButton();
        this.dependentTiersBtnGroup = new ButtonGroup();
        this.dependentTiersBtnGroup.add(this.includeParentTiersRB);
        this.dependentTiersBtnGroup.add(this.neglectDependentTiersRB);
        this.fileNameOptionsPanel = new JPanel();
        this.resultingFilenameLabel = new JLabel();
        this.originalFileNameRB = new JRadioButton("", true);
        this.addSuffixRB = new JRadioButton();
        this.fileNameBtnGroup = new ButtonGroup();
        this.fileNameBtnGroup.add(this.originalFileNameRB);
        this.fileNameBtnGroup.add(this.addSuffixRB);
        this.suffixBtnGroup = new ButtonGroup();
        this.originalFileNameWithSuffixRB = new JRadioButton("", true);
        this.originalFileNameWithSuffixRB.setEnabled(false);
        this.suffixNameTextField = new JTextField();
        this.suffixNameTextField.setEnabled(false);
        this.useBaseNameWithSuffixRB = new JRadioButton();
        this.useBaseNameWithSuffixRB.setEnabled(false);
        this.baseNameTextField = new JTextField();
        this.baseNameTextField.setEnabled(false);
        this.suffixBtnGroup.add(this.originalFileNameWithSuffixRB);
        this.suffixBtnGroup.add(this.useBaseNameWithSuffixRB);
        this.directoryOptionsPanel = new JPanel();
        this.directoryOptionsLabel = new JLabel();
        this.originalDirRB = new JRadioButton("", true);
        this.newDirectoryRB = new JRadioButton();
        this.togetherInSameDirRB = new JRadioButton();
        this.saveTierBtnGroup = new ButtonGroup();
        this.saveTierBtnGroup.add(this.originalDirRB);
        this.saveTierBtnGroup.add(this.togetherInSameDirRB);
        this.saveTierBtnGroup.add(this.newDirectoryRB);
        this.localDirectoryTextField = new JTextField();
        this.localDirectoryTextField.setEnabled(false);
        this.sameDirectoryTextField = new JTextField();
        this.sameDirectoryTextField.setEnabled(false);
        this.sameDirectoryTextField.setEditable(false);
        this.browseBtn = new JButton();
        this.browseBtn.setEnabled(false);
        this.otherOptionsPanel = new JPanel();
        this.otherOptionLabel = new JLabel();
        this.dontExportFilesWithoutTiersCB = new JCheckBox();
        this.progressBar = new JProgressBar(0, this.files.size());
        this.progressBar.setValue(this.progressValue);
        this.progressBar.setStringPainted(true);
        this.progressValue = 0;
        RadioButtonHandler radioBtnListener = new RadioButtonHandler();
        TextFieldHandler keyListener = new TextFieldHandler();
        this.originalDirRB.addActionListener(radioBtnListener);
        this.newDirectoryRB.addActionListener(radioBtnListener);
        this.togetherInSameDirRB.addActionListener(radioBtnListener);
        this.originalFileNameRB.addActionListener(radioBtnListener);
        this.addSuffixRB.addActionListener(radioBtnListener);
        this.originalFileNameWithSuffixRB.addActionListener(radioBtnListener);
        this.useBaseNameWithSuffixRB.addActionListener(radioBtnListener);
        this.browseBtn.addActionListener(this);
        this.suffixNameTextField.addKeyListener(keyListener);
        this.baseNameTextField.addKeyListener(keyListener);
        this.localDirectoryTextField.addKeyListener(keyListener);
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        Insets singleTabInset = new Insets(4, 15, 4, 6);
        this.dependentTiersOptionPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        this.dependentTiersOptionPanel.add((Component)this.dependentTiersLabel, gbc);
        gbc.gridy = 1;
        gbc.insets = this.insets;
        this.dependentTiersOptionPanel.add((Component)this.includeParentTiersRB, gbc);
        gbc.gridy = 2;
        this.dependentTiersOptionPanel.add((Component)this.neglectDependentTiersRB, gbc);
        this.fileNameOptionsPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        this.fileNameOptionsPanel.add((Component)this.resultingFilenameLabel, gbc);
        gbc.gridy = 1;
        gbc.insets = this.insets;
        this.fileNameOptionsPanel.add((Component)this.originalFileNameRB, gbc);
        gbc.gridy = 2;
        this.fileNameOptionsPanel.add((Component)this.addSuffixRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.insets = singleTabInset;
        this.fileNameOptionsPanel.add((Component)this.originalFileNameWithSuffixRB, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = this.insets;
        gbc.fill = 2;
        this.fileNameOptionsPanel.add((Component)this.suffixNameTextField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.insets = singleTabInset;
        gbc.fill = 0;
        this.fileNameOptionsPanel.add((Component)this.useBaseNameWithSuffixRB, gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = this.insets;
        gbc.fill = 2;
        this.fileNameOptionsPanel.add((Component)this.baseNameTextField, gbc);
        this.directoryOptionsPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        this.directoryOptionsPanel.add((Component)this.directoryOptionsLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = this.insets;
        this.directoryOptionsPanel.add((Component)this.originalDirRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        this.directoryOptionsPanel.add((Component)this.newDirectoryRB, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        this.directoryOptionsPanel.add((Component)this.localDirectoryTextField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.directoryOptionsPanel.add((Component)this.togetherInSameDirRB, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        this.sameDirectoryTextField.setMinimumSize(new Dimension(194, this.sameDirectoryTextField.getMinimumSize().height));
        this.directoryOptionsPanel.add((Component)this.sameDirectoryTextField, gbc);
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.directoryOptionsPanel.add((Component)this.browseBtn, gbc);
        this.otherOptionsPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.otherOptionsPanel.add((Component)this.otherOptionLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = this.insets;
        this.otherOptionsPanel.add((Component)this.dontExportFilesWithoutTiersCB, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        this.optionsPanel.add((Component)this.dependentTiersOptionPanel, gbc);
        gbc.gridy = 1;
        gbc.fill = 2;
        this.optionsPanel.add((Component)this.fileNameOptionsPanel, gbc);
        gbc.gridy = 2;
        this.optionsPanel.add((Component)this.directoryOptionsPanel, gbc);
        gbc.gridy = 3;
        gbc.fill = 0;
        this.optionsPanel.add((Component)this.otherOptionsPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.fill = 2;
        gbc.anchor = 25;
        this.getContentPane().add((Component)this.progressBar, gbc);
        this.updateLocale();
    }

    private void updateExportButtonEnabled() {
        if (!this.filesOpened) {
            this.setStartButtonEnabled(false);
            return;
        }
        boolean b = true;
        if (this.togetherInSameDirRB.isSelected() && this.sameDirectoryTextField.getText().equals(this.browseDirText)) {
            b = false;
        }
        if (this.newDirectoryRB.isSelected() && this.localDirectoryTextField.getText().length() <= 0) {
            b = false;
        }
        if (this.addSuffixRB.isSelected()) {
            if (this.originalFileNameWithSuffixRB.isSelected() && this.suffixNameTextField.getText().length() <= 0) {
                b = false;
            } else if (this.useBaseNameWithSuffixRB.isSelected() && this.baseNameTextField.getText().length() <= 0) {
                b = false;
            }
        }
        this.setStartButtonEnabled(b && !this.exportingStarted);
    }

    private void updateButtonsAndFields() {
        this.sameDirectoryTextField.setEnabled(this.togetherInSameDirRB.isSelected());
        this.browseBtn.setEnabled(this.togetherInSameDirRB.isSelected());
        this.localDirectoryTextField.setEnabled(this.newDirectoryRB.isSelected());
        this.baseNameTextField.setEnabled(this.addSuffixRB.isSelected() && this.useBaseNameWithSuffixRB.isSelected());
        this.suffixNameTextField.setEnabled(this.addSuffixRB.isSelected() && this.originalFileNameWithSuffixRB.isSelected());
        this.useBaseNameWithSuffixRB.setEnabled(this.addSuffixRB.isSelected());
        this.originalFileNameWithSuffixRB.setEnabled(this.addSuffixRB.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.browseBtn) {
            String directoryStr = this.showDirectoryChooser();
            if (directoryStr != null) {
                this.sameDirectoryTextField.setText(directoryStr);
            }
        } else {
            super.actionPerformed(ae);
        }
    }

    private String showDirectoryChooser() {
        FileChooser dirChooser = new FileChooser(this);
        dirChooser.createAndShowFileDialog(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"), 0, ElanLocale.getString("Button.OK"), null, null, false, "LastUsedEAFDir", 1, null);
        File selectedDir = dirChooser.getSelectedFile();
        if (selectedDir != null) {
            return selectedDir.getAbsolutePath();
        }
        return null;
    }

    private boolean exists(String string, List<String> stringList) {
        return stringList.indexOf(string) >= 0;
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportTiersDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportTiersDialog.Label.Description"));
        this.neglectDependentTiersRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.NeglectDependentTiers"));
        this.includeParentTiersRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.IncludeParentTiersRB"));
        this.originalFileNameRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.OriginalFileName"));
        this.originalFileNameWithSuffixRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.OriginalFileNameWithSuffix"));
        this.useBaseNameWithSuffixRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.NewBaseNameWithSuffix"));
        this.originalDirRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.OriginalDirectory"));
        this.newDirectoryRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.NewDirectory"));
        this.togetherInSameDirRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.TogetherInSameDirectory"));
        this.browseBtn.setText(ElanLocale.getString("ExportTiersDialog.Button.Browse"));
        this.baseNameTextField.setText(ElanLocale.getString("ExportTiersDialog.TextField.DefaultBaseName"));
        this.suffixNameTextField.setText(ElanLocale.getString("ExportTiersDialog.TextField.DefaultSuffixName"));
        this.localDirectoryTextField.setText(ElanLocale.getString("ExportTiersDialog.TextField.DefaultLocalDirectoryName"));
        this.browseDirText = ElanLocale.getString("ExportTiersDialog.TextField.DirectoryNameField");
        this.sameDirectoryTextField.setText(this.browseDirText);
        this.dependentTiersLabel.setText(ElanLocale.getString("ExportTiersDialog.Label.DependentTierOptions"));
        this.directoryOptionsLabel.setText(ElanLocale.getString("ExportTiersDialog.Label.SaveTiersOptions"));
        this.resultingFilenameLabel.setText(ElanLocale.getString("ExportTiersDialog.Label.FileNameOptions"));
        this.otherOptionLabel.setText(ElanLocale.getString("ExportTiersDialog.Label.OtherOptions"));
        this.dontExportFilesWithoutTiersCB.setText(ElanLocale.getString("ExportTiersDialog.CheckBox.ExportFilesWithoutTiers"));
        this.addSuffixRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.addSuffix"));
    }

    @Override
    protected boolean startExport() throws IOException {
        this.progressValue = 0;
        this.progressBar.setValue(this.progressValue);
        this.savePreferences();
        SaveFileThread t = new SaveFileThread(this.getSelectedTiers());
        t.start();
        this.exportingStarted = true;
        this.updateExportButtonEnabled();
        return false;
    }

    private void savePreferences() {
        Preferences.set("ExportTiersDialog.rootTiersCB", this.isRootTiersOnly(), null);
        Preferences.set("ExportTiersDialog.SelectTiersMode", this.getSelectionMode(), null);
        Preferences.set("ExportTiersDialog.forceParentExport", this.includeParentTiersRB.isSelected(), null);
        Preferences.set("ExportTiersDialog.saveWithOriginalNames", this.originalFileNameRB.isSelected(), null);
        Preferences.set("ExportTiersDialog.saveWithSuffix", this.originalFileNameWithSuffixRB.isSelected(), null);
        String suffixText = this.suffixNameTextField.getText();
        if (!ElanLocale.getString("ExportTiersDialog.TextField.DefaultSuffixName").equals(suffixText)) {
            Preferences.set("ExportTiersDialog.fileNameSuffix", suffixText, null);
        }
        String baseName = this.baseNameTextField.getText();
        if (!ElanLocale.getString("ExportTiersDialog.TextField.DefaultBaseName").equals(baseName)) {
            Preferences.set("ExportTiersDialog.fileBaseName", baseName, null);
        }
        Preferences.set("ExportTiersDialog.saveInOriginalFolder", this.originalDirRB.isSelected(), null);
        Preferences.set("ExportTiersDialog.saveInRelativeFolder", this.newDirectoryRB.isSelected(), null);
        String relFolderName = this.localDirectoryTextField.getText();
        if (!ElanLocale.getString("ExportTiersDialog.TextField.DefaultLocalDirectoryName").equals(relFolderName)) {
            Preferences.set("ExportTiersDialog.saveInRelativeFolderName", relFolderName, null);
        }
        String sameFolder = this.sameDirectoryTextField.getText();
        if (!ElanLocale.getString("ExportTiersDialog.TextField.DirectoryNameField").equals(sameFolder)) {
            Preferences.set("ExportTiersDialog.saveInSameFolderName", sameFolder, null);
        }
        Preferences.set("ExportTiersDialog.dontCreateEmptyFiles", this.dontExportFilesWithoutTiersCB.isSelected(), null);
    }

    private void loadPreferences() {
        boolean origFolder;
        boolean origNames;
        boolean forceParent;
        String stringPref;
        Boolean boolPref = Preferences.getBool("ExportTiersDialog.rootTiersCB", null);
        if (boolPref != null) {
            this.setRootTiersOnly(boolPref);
        }
        if ((stringPref = Preferences.getString("ExportTiersDialog.SelectTiersMode", null)) != null) {
            this.setSelectionMode(stringPref);
        }
        if ((boolPref = Preferences.getBool("ExportTiersDialog.forceParentExport", null)) != null && !(forceParent = boolPref.booleanValue())) {
            this.neglectDependentTiersRB.setSelected(true);
        }
        if ((boolPref = Preferences.getBool("ExportTiersDialog.saveWithOriginalNames", null)) != null && !(origNames = boolPref.booleanValue())) {
            boolean withSuffix;
            this.addSuffixRB.setSelected(true);
            boolPref = Preferences.getBool("ExportTiersDialog.saveWithSuffix", null);
            if (boolPref != null && !(withSuffix = boolPref.booleanValue())) {
                this.useBaseNameWithSuffixRB.setSelected(true);
            }
        }
        if ((stringPref = Preferences.getString("ExportTiersDialog.fileNameSuffix", null)) != null) {
            this.suffixNameTextField.setText(stringPref);
        }
        if ((stringPref = Preferences.getString("ExportTiersDialog.fileBaseName", null)) != null) {
            this.baseNameTextField.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool("ExportTiersDialog.saveInOriginalFolder", null)) != null && !(origFolder = boolPref.booleanValue()) && (boolPref = Preferences.getBool("ExportTiersDialog.saveInRelativeFolder", null)) != null) {
            boolean relFolder = boolPref;
            if (relFolder) {
                this.newDirectoryRB.setSelected(true);
            } else {
                this.togetherInSameDirRB.setSelected(true);
            }
        }
        if ((stringPref = Preferences.getString("ExportTiersDialog.saveInRelativeFolderName", null)) != null) {
            this.localDirectoryTextField.setText(stringPref);
        }
        if ((stringPref = Preferences.getString("ExportTiersDialog.saveInSameFolderName", null)) != null) {
            this.sameDirectoryTextField.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool("ExportTiersDialog.dontCreateEmptyFiles", null)) != null) {
            this.dontExportFilesWithoutTiersCB.setSelected(boolPref);
        }
        this.updateButtonsAndFields();
    }

    private class SaveFileThread
    extends Thread {
        private List<String> tiersToSave;
        private final int YES = 1;
        private final int NO = 2;
        private final int YES_TO_ALL = 0;
        private final int NO_TO_ALL = 3;

        public SaveFileThread(List<String> tiersToSave) {
            this.tiersToSave = tiersToSave;
        }

        private String getDirectoryToSave(File file) {
            String originalDirectory = file.getPath().substring(0, file.getPath().length() - file.getName().length());
            if (ExportTiersDialog.this.originalDirRB.isSelected()) {
                return originalDirectory;
            }
            if (ExportTiersDialog.this.newDirectoryRB.isSelected()) {
                return originalDirectory + ExportTiersDialog.this.localDirectoryTextField.getText().trim();
            }
            if (ExportTiersDialog.this.togetherInSameDirRB.isSelected()) {
                return ExportTiersDialog.this.sameDirectoryTextField.getText();
            }
            return null;
        }

        private String getFileName(TranscriptionImpl transImpl, int nr) {
            if (ExportTiersDialog.this.originalFileNameRB.isSelected()) {
                return transImpl.getName();
            }
            if (ExportTiersDialog.this.originalFileNameWithSuffixRB.isSelected()) {
                String fileName = transImpl.getName();
                int index = fileName.lastIndexOf(46);
                return fileName.substring(0, index) + ExportTiersDialog.this.suffixNameTextField.getText() + fileName.substring(index);
            }
            if (ExportTiersDialog.this.useBaseNameWithSuffixRB.isSelected()) {
                String fileName = transImpl.getName();
                int index = fileName.lastIndexOf(46);
                return ExportTiersDialog.this.baseNameTextField.getText() + (nr + 1) + fileName.substring(index);
            }
            return null;
        }

        private boolean createDirectory(String directoryPath) {
            boolean directoryExists = true;
            File directory = new File(directoryPath);
            if (!directory.exists()) {
                directoryExists = new File(directoryPath).mkdir();
            }
            return directoryExists;
        }

        private void setRelativePaths(String pathName, TranscriptionImpl tr) {
            String relUrl;
            List<LinkedFileDescriptor> linkedFiles = tr.getLinkedFileDescriptors();
            String fullEAFURL = FileUtility.pathToURLString(pathName);
            List<MediaDescriptor> mediaDescriptors = tr.getMediaDescriptors();
            for (int i = 0; i < mediaDescriptors.size(); ++i) {
                MediaDescriptor md = mediaDescriptors.get(i);
                relUrl = FileUtility.getRelativePath(fullEAFURL, md.mediaURL);
                md.relativeMediaURL = "file:/" + relUrl;
            }
            if (linkedFiles.size() > 0) {
                for (int i = 0; i < linkedFiles.size(); ++i) {
                    LinkedFileDescriptor lfd = linkedFiles.get(i);
                    relUrl = FileUtility.getRelativePath(fullEAFURL, lfd.linkURL);
                    lfd.relativeLinkURL = "file:/" + relUrl;
                }
            }
        }

        private void removeTiersFromTranscription(TranscriptionImpl transImpl) {
            ArrayList<TierImpl> tiers = new ArrayList<TierImpl>(transImpl.getTiers());
            for (int i = 0; i < tiers.size(); ++i) {
                TierImpl tier = (TierImpl)tiers.get(i);
                if (ExportTiersDialog.this.exists(tier.getName(), this.tiersToSave)) continue;
                List<TierImpl> dependentTiers = tier.getDependentTiers();
                if (ExportTiersDialog.this.neglectDependentTiersRB.isSelected()) {
                    for (int n = 0; n < dependentTiers.size(); ++n) {
                        transImpl.removeTier(dependentTiers.get(n));
                    }
                    transImpl.removeTier(tier);
                    continue;
                }
                boolean removeParentTier = true;
                for (int n = 0; n < dependentTiers.size(); ++n) {
                    if (!ExportTiersDialog.this.exists(dependentTiers.get(n).getName(), this.tiersToSave)) continue;
                    removeParentTier = false;
                    break;
                }
                if (!removeParentTier) continue;
                transImpl.removeTier(tier);
            }
        }

        @Override
        public void run() {
            int failedExports = 0;
            int refusedExports = 0;
            int emptyFiles = 0;
            boolean saveForever = false;
            boolean skipForever = false;
            for (int f = 0; f < ExportTiersDialog.this.files.size(); ++f) {
                File file = (File)ExportTiersDialog.this.files.get(f);
                if (file == null) continue;
                try {
                    TranscriptionImpl transImpl = new TranscriptionImpl(file.getAbsolutePath());
                    this.removeTiersFromTranscription(transImpl);
                    Object path = this.getDirectoryToSave((File)ExportTiersDialog.this.files.get(f));
                    String fileName = this.getFileName(transImpl, f);
                    if (((String)path).charAt(((String)path).length() - 1) != File.separatorChar) {
                        path = (String)path + File.separatorChar;
                    }
                    String directoryToSave = (String)path + fileName;
                    boolean directoryExists = this.createDirectory((String)path);
                    boolean saveThisFile = true;
                    boolean fileExists = new File(directoryToSave).exists();
                    if (fileExists && skipForever) {
                        saveThisFile = false;
                    }
                    if (!skipForever && !saveForever && fileExists) {
                        Object[] possibleValues = new Object[]{"Yes To All", "Yes", "No", "No To All"};
                        int choice = JOptionPane.showOptionDialog(null, ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description1") + " " + fileName + " " + ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description2") + "\n\n" + ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description3") + "\t " + directoryToSave + "\n\n" + ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description4") + "\n", ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Title"), -1, 2, null, possibleValues, possibleValues[2]);
                        switch (choice) {
                            case 1: {
                                saveThisFile = true;
                                break;
                            }
                            case 0: {
                                saveForever = true;
                                break;
                            }
                            case 3: {
                                skipForever = true;
                                saveThisFile = false;
                                break;
                            }
                            default: {
                                saveThisFile = false;
                            }
                        }
                    }
                    this.setRelativePaths(directoryToSave, transImpl);
                    if (directoryExists) {
                        if (saveForever || saveThisFile) {
                            int saveAsType = SaveAs27Preferences.saveAsTypeWithCheck(transImpl);
                            if (!ExportTiersDialog.this.dontExportFilesWithoutTiersCB.isSelected()) {
                                ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscriptionIn(transImpl, null, new ArrayList<TierImpl>(), directoryToSave, saveAsType);
                            } else if (transImpl.getTiers().size() > 0) {
                                ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscriptionIn(transImpl, null, new ArrayList<TierImpl>(), directoryToSave, saveAsType);
                            } else {
                                ++emptyFiles;
                            }
                        } else {
                            ++refusedExports;
                        }
                    } else {
                        ++failedExports;
                    }
                }
                catch (IOException e) {
                    ClientLogger.LOG.warning("Can not write transcription to file with directory/filename: " + ((File)ExportTiersDialog.this.files.get(f)).getAbsolutePath() + "/" + ((File)ExportTiersDialog.this.files.get(f)).getName());
                    ++failedExports;
                }
                catch (Exception ex) {
                    ClientLogger.LOG.warning("Could not handle file: " + file.getAbsolutePath());
                }
                ExportTiersDialog.this.progressValue++;
                ExportTiersDialog.this.progressBar.setValue(ExportTiersDialog.this.progressValue);
                ExportTiersDialog.this.progressBar.setString(Math.round((float)(100 * (f + 1)) / (float)ExportTiersDialog.this.files.size()) + "%");
            }
            ExportTiersDialog.this.progressBar.setString(ElanLocale.getString("ExportTiersDialog.ProgressBar.ExportingDone"));
            String msg = ExportTiersDialog.this.files.size() - failedExports - refusedExports - emptyFiles + " " + ElanLocale.getString("ExportTiersDialog.Message.OutOf") + " " + ExportTiersDialog.this.files.size() + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg1");
            if (emptyFiles + refusedExports + failedExports > 0) {
                msg = emptyFiles == 1 ? msg + "\n\n" + emptyFiles + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg2single") : msg + "\n\n" + emptyFiles + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg2");
                msg = refusedExports == 1 ? msg + "\n" + refusedExports + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg3single") : msg + "\n" + refusedExports + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg3");
                msg = failedExports == 1 ? msg + "\n" + failedExports + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg4single") : msg + "\n" + failedExports + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg4");
            }
            if (failedExports > 0) {
                JOptionPane.showMessageDialog(ExportTiersDialog.this, msg, ElanLocale.getString("ExportTiersDialog.Message.ExportingDoneTitle"), 2);
            } else {
                JOptionPane.showMessageDialog(ExportTiersDialog.this, msg, ElanLocale.getString("ExportTiersDialog.Message.ExportingDoneTitle"), 1);
            }
            if (ExportTiersDialog.this.files.size() - failedExports - refusedExports - emptyFiles > 0) {
                ExportTiersDialog.this.closeDialog(null);
            } else {
                ExportTiersDialog.this.progressValue = 0;
                ExportTiersDialog.this.progressBar.setValue(ExportTiersDialog.this.progressValue);
                ExportTiersDialog.this.progressBar.setString("0%");
                ExportTiersDialog.this.exportingStarted = false;
                ExportTiersDialog.this.updateExportButtonEnabled();
            }
        }
    }

    private class RadioButtonHandler
    implements ActionListener {
        private RadioButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportTiersDialog.this.updateButtonsAndFields();
            ExportTiersDialog.this.updateExportButtonEnabled();
        }
    }

    private class TextFieldHandler
    implements KeyListener {
        private TextFieldHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            ExportTiersDialog.this.updateExportButtonEnabled();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

