/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.AbstractTierExportDialog;
import mpi.eudico.client.annotator.export.ExportTigerFeatureCheckPane;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.Transcription2Tiger;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class ExportTigerDialog
extends AbstractTierExportDialog
implements ListSelectionListener {
    private JPanel textFieldPanel;
    private JTextField[] featureTextFields = new JTextField[0];

    public ExportTigerDialog(Frame parent, boolean modal, TranscriptionImpl transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.makeLayout();
        this.extractTiers();
        this.updateFeatureTextFields();
        this.postInit();
    }

    public static void main(String[] args) {
        String filename = "resources/testdata/elan/elan-example2.eaf";
        TranscriptionImpl transcription = new TranscriptionImpl(filename);
        JFrame frame = new JFrame();
        ExportTigerDialog dialog = new ExportTigerDialog((Frame)frame, false, transcription, null);
        dialog.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (!lse.getValueIsAdjusting()) {
            this.updateFeatureTextFields();
        }
    }

    protected void extractTiers() {
        if (this.model != null) {
            List<String> useTyp;
            for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.transcription != null) {
                List<TierImpl> v = ExportTigerDialog.getSentenceTiers(this.transcription);
                for (Tier tier : v) {
                    this.model.addRow(Boolean.TRUE, tier.getName());
                }
            }
            if ((useTyp = Preferences.getListOfString("ExportTigerDialog.selectedTiers", this.transcription)) != null) {
                this.loadTierPreferences(useTyp);
            }
        }
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.restrictCheckBox, gridBagConstraints);
        gridBagConstraints.fill = 1;
        this.optionsPanel.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 12;
        this.optionsPanel.add((Component)new JLabel("Features:"), gridBagConstraints);
        this.textFieldPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        this.optionsPanel.add((Component)this.textFieldPanel, gridBagConstraints);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        this.setPreferredSetting();
        this.updateLocale();
    }

    @Override
    protected boolean startExport() throws IOException {
        List<String> selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        long selectionBT = 0L;
        long selectionET = Long.MAX_VALUE;
        if (this.restrictCheckBox.isSelected()) {
            selectionBT = this.selection.getBeginTime();
            selectionET = this.selection.getEndTime();
        }
        String[] features = new String[this.featureTextFields.length];
        for (int i = 0; i < this.featureTextFields.length; ++i) {
            features[i] = this.featureTextFields[i].getText();
        }
        LinkedHashMap<TierImpl, Map<TierImpl, String>> sentenceTierHash = new LinkedHashMap<TierImpl, Map<TierImpl, String>>();
        for (int i = 0; i < selectedTiers.size(); ++i) {
            TierImpl sentenceTier = this.transcription.getTierWithId(selectedTiers.get(i));
            List<TierImpl> featureTiers = ExportTigerDialog.getFeatureTiers(sentenceTier);
            LinkedHashMap<TierImpl, String> featureHash = new LinkedHashMap<TierImpl, String>();
            for (int j = 0; j < featureTiers.size(); ++j) {
                featureHash.put(featureTiers.get(j), features[j]);
            }
            sentenceTierHash.put(sentenceTier, featureHash);
        }
        if (features.length > 1 && ExportTigerFeatureCheckPane.showFeatureCheckPane(this, sentenceTierHash, features) == 2) {
            return false;
        }
        File exportFile = this.promptForFile(ElanLocale.getString("Export.TigerDialog.title"), null, FileExtension.TIGER_EXT, true);
        if (exportFile == null) {
            return false;
        }
        Transcription2Tiger.exportTiers(this.transcription, sentenceTierHash, exportFile, this.encoding, selectionBT, selectionET);
        return true;
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportTigerDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportTigerDialog.TitleLabel"));
    }

    private static List<TierImpl> getFeatureTiers(TierImpl sentenceTier) {
        ArrayList<TierImpl> featureTiers = new ArrayList<TierImpl>();
        List<TierImpl> childTiers = sentenceTier.getChildTiers();
        for (int j = 0; j < childTiers.size(); ++j) {
            TierImpl childTier = childTiers.get(j);
            if (childTier.getLinguisticType().getConstraints().getStereoType() != 0) continue;
            featureTiers.add(childTier);
            ExportTigerDialog.addDescendantFeatureTiers(featureTiers, childTier);
        }
        return featureTiers;
    }

    private static List<TierImpl> getSentenceTiers(TranscriptionImpl transcription) {
        int i;
        ArrayList<TierImpl> noConstraintTiers = new ArrayList<TierImpl>();
        ArrayList<TierImpl> sentenceTiers = new ArrayList<TierImpl>();
        List<LinguisticType> lingTypes = transcription.getLinguisticTypes();
        for (i = 0; i < lingTypes.size(); ++i) {
            LinguisticType lingType = lingTypes.get(i);
            if (lingType.getConstraints() != null) continue;
            noConstraintTiers.addAll(transcription.getTiersWithLinguisticType(lingTypes.get(i).getLinguisticTypeName()));
        }
        for (i = 0; i < noConstraintTiers.size(); ++i) {
            List<TierImpl> childTiers = ((TierImpl)noConstraintTiers.get(i)).getChildTiers();
            boolean containsWordTier = false;
            for (int j = 0; j < childTiers.size(); ++j) {
                TierImpl childTier = childTiers.get(j);
                Constraint constraint = childTier.getLinguisticType().getConstraints();
                if (constraint == null || constraint.getStereoType() != 0) continue;
                containsWordTier = true;
                break;
            }
            if (!containsWordTier) continue;
            sentenceTiers.add((TierImpl)noConstraintTiers.get(i));
        }
        return sentenceTiers;
    }

    private static void addDescendantFeatureTiers(List<TierImpl> featureTiers, TierImpl tier) {
        List<TierImpl> childTiers = tier.getChildTiers();
        for (int k = 0; k < childTiers.size(); ++k) {
            TierImpl childTier = childTiers.get(k);
            if (childTier.getLinguisticType().getConstraints().getStereoType() != 4) continue;
            featureTiers.add(childTier);
            ExportTigerDialog.addDescendantFeatureTiers(featureTiers, childTier);
        }
    }

    private void updateFeatureTextFields() {
        int i;
        int includeCol = this.model.findColumn("export");
        int nameCol = this.model.findColumn("tier");
        int maxFeatures = 0;
        int rowCount = this.model.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            Boolean include = (Boolean)this.model.getValueAt(i, includeCol);
            if (!include.booleanValue()) continue;
            try {
                TierImpl sentenceTier = this.transcription.getTierWithId((String)this.model.getValueAt(i, nameCol));
                maxFeatures = Math.max(maxFeatures, ExportTigerDialog.getFeatureTiers(sentenceTier).size());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (maxFeatures != this.featureTextFields.length) {
            this.textFieldPanel.removeAll();
            this.featureTextFields = new JTextField[maxFeatures];
            for (i = 0; i < maxFeatures; ++i) {
                this.featureTextFields[i] = new JTextField(i < Transcription2Tiger.defaultFeatureNames.length ? Transcription2Tiger.defaultFeatureNames[i] : "", 10);
                this.textFieldPanel.add(this.featureTextFields[i]);
            }
            this.featureTextFields[0].setEnabled(false);
            this.textFieldPanel.revalidate();
        }
    }

    private void setPreferredSetting() {
        List<String> stringsPref;
        Boolean useTyp = Preferences.getBool("ExportTigerDialog.restrictCheckBox", null);
        if (useTyp != null) {
            this.restrictCheckBox.setSelected(useTyp);
        }
        if ((stringsPref = Preferences.getListOfString("ExportTigerDialog.featureTextFields", this.transcription)) != null) {
            this.textFieldPanel.removeAll();
            int size = stringsPref.size();
            this.featureTextFields = new JTextField[size];
            for (int i = 0; i < size; ++i) {
                this.featureTextFields[i] = new JTextField(stringsPref.get(i));
                this.textFieldPanel.add(this.featureTextFields[i]);
            }
        }
    }

    private void savePreferences() {
        Preferences.set("ExportTigerDialog.restrictCheckBox", this.restrictCheckBox.isSelected(), null);
        ArrayList<String> features = new ArrayList<String>();
        for (JTextField featureTextField : this.featureTextFields) {
            features.add(featureTextField.getText());
        }
        Preferences.set("ExportTigerDialog.featureTextFields", features, (Transcription)this.transcription);
        Preferences.set("ExportTigerDialog.selectedTiers", this.getSelectedTiers(), (Transcription)this.transcription);
    }
}

