/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class ExportTigerFeatureCheckPane
extends JDialog {
    public static final int YES_OPTION = 0;
    public static final int CANCEL_OPTION = 2;
    private int option = 2;

    private ExportTigerFeatureCheckPane(JDialog parent, final Map<TierImpl, Map<TierImpl, String>> sentenceTierHash, final String[] features) {
        super((Dialog)parent, true);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new TitledBorder(ElanLocale.getString("ExportTigerDialog.FeaturePane.Title"))));
        Iterator<TierImpl> it1 = sentenceTierHash.keySet().iterator();
        while (it1.hasNext()) {
            Tier sentenceTier = it1.next();
            Map<TierImpl, String> featureHash = sentenceTierHash.get(sentenceTier);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(5, 15, 5, 15);
            JLabel sentenceTierLabel = new JLabel(sentenceTier.getName() + ": ");
            c.gridx = 0;
            c.weightx = 0.25;
            c.gridwidth = 1;
            c.fill = 1;
            mainPanel.add((Component)sentenceTierLabel, c);
            HashMap<Tier, JComboBox> tierComboBoxHash = new HashMap<Tier, JComboBox>();
            int count = 0;
            for (TierImpl tier : featureHash.keySet()) {
                JLabel tierLabel = new JLabel(tier.getName());
                c.gridx = 1;
                c.insets = new Insets(5, 5, 5, 5);
                mainPanel.add((Component)tierLabel, c);
                c.weightx = 0.0;
                c.gridx = 2;
                mainPanel.add((Component)new JLabel("->"), c);
                JComboBox<String> featureComboBox = new JComboBox<String>(features);
                featureComboBox.setSelectedItem(features[count]);
                featureHash.put(tier, features[count]);
                ++count;
                c.fill = 2;
                c.gridx = 3;
                mainPanel.add(featureComboBox, c);
                featureComboBox.addItemListener(new MyItemListener(featureHash, tierComboBoxHash));
                tierComboBoxHash.put(tier, featureComboBox);
            }
            if (!it1.hasNext()) continue;
            c.gridx = 0;
            c.weightx = 1.0;
            c.gridwidth = 4;
            mainPanel.add((Component)new JSeparator(), c);
        }
        this.getContentPane().add((Component)mainPanel, "Center");
        JButton startButton = new JButton(ElanLocale.getString("Button.OK"));
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    for (Map map : sentenceTierHash.values()) {
                        if (map.values().contains(features[0])) continue;
                        JOptionPane.showMessageDialog(ExportTigerFeatureCheckPane.this, ElanLocale.getString("ExportTigerDialog.FeaturePane.ErrorMessagePart1") + " '" + features[0] + "' " + ElanLocale.getString("ExportTigerDialog.FeaturePane.ErrorMessagePart2") + "!", ElanLocale.getString("Message.Error"), 0);
                        return;
                    }
                    ExportTigerFeatureCheckPane.this.option = 0;
                    ExportTigerFeatureCheckPane.this.dispose();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JButton closeButton = new JButton(ElanLocale.getString("Button.Cancel"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportTigerFeatureCheckPane.this.dispose();
            }
        });
        JPanel buttonPanel = new JPanel(new GridLayout(1, 0, 5, 0));
        JPanel bufferPanel = new JPanel();
        bufferPanel.add(buttonPanel);
        buttonPanel.add(startButton);
        buttonPanel.add(closeButton);
        this.getContentPane().add((Component)bufferPanel, "South");
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    public static int showFeatureCheckPane(JDialog parent, Map<TierImpl, Map<TierImpl, String>> sentenceTierHash, String[] features) {
        ExportTigerFeatureCheckPane pane = new ExportTigerFeatureCheckPane(parent, sentenceTierHash, features);
        pane.setVisible(true);
        return pane.option;
    }

    class MyItemListener
    implements ItemListener {
        private final Map<Tier, JComboBox> tierComboBoxHash;
        private final Map<TierImpl, String> tierFeatureHash;
        private String deselectedFeature;

        public MyItemListener(Map<TierImpl, String> tierFeatureHash, Map<Tier, JComboBox> tierComboBoxHash) {
            this.tierFeatureHash = tierFeatureHash;
            this.tierComboBoxHash = tierComboBoxHash;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                this.deselectedFeature = (String)e.getItem();
            } else if (e.getStateChange() == 1 && this.deselectedFeature != null) {
                for (TierImpl tier : this.tierFeatureHash.keySet()) {
                    JComboBox comboBox = this.tierComboBoxHash.get(tier);
                    if (comboBox == e.getSource()) {
                        this.tierFeatureHash.put(tier, (String)e.getItem());
                        continue;
                    }
                    if (!comboBox.getSelectedItem().equals(e.getItem())) continue;
                    ItemListener[] its = comboBox.getItemListeners();
                    comboBox.removeItemListener(its[0]);
                    comboBox.setSelectedItem(this.deselectedFeature);
                    comboBox.addItemListener(its[0]);
                    this.tierFeatureHash.put(tier, this.deselectedFeature);
                }
            }
        }
    }
}

