/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.Transcription2WordList;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ExportWordListDialog
extends AbstractExtTierExportDialog
implements ChangeListener {
    private JRadioButton customDelimRB;
    private JLabel tokenDelimLabel;
    private JRadioButton defaultDelimRB;
    private JTextField customDelimField;
    private ButtonGroup delimButtonGroup;
    private JCheckBox countTokensCB;
    public static int WORDS = 0;
    public static int ANNOTATIONS = 1;
    private int mode = WORDS;

    public ExportWordListDialog(Frame parent, boolean modal, TranscriptionImpl transcription) {
        super(parent, modal, transcription, null);
        this.makeLayout();
        this.extractTiers();
        this.postInit();
    }

    public ExportWordListDialog(Frame parent, boolean modal, List<File> files) {
        this(parent, modal, files, WORDS);
    }

    public ExportWordListDialog(Frame parent, boolean modal, List<File> files, int mode) {
        super(parent, modal, files);
        this.files = files;
        if (mode == ANNOTATIONS || mode == WORDS) {
            this.mode = mode;
        }
        this.makeLayout();
        this.extractTiersFromFiles();
        this.postInit();
    }

    protected void extractTiers() {
        String stringPref;
        List<String> stringsPref = Preferences.getListOfString("ExportWordListDialog.TierOrder", this.transcription);
        if (stringsPref != null) {
            this.setTierOrder(stringsPref);
        } else {
            super.extractTiers(false);
        }
        stringsPref = Preferences.getListOfString("ExportWordListDialog.selectedTiers", this.transcription);
        if (stringsPref != null) {
            this.setSelectedTiers(stringsPref);
        }
        if ((stringPref = Preferences.getString("ExportWordListDialog.SelectTiersMode", this.transcription)) != null) {
            List<String> selItems;
            this.setSelectionMode(stringPref);
            if (!"Tier".equals(stringPref) && (selItems = Preferences.getListOfString("ExportWordListDialog.LastSelectedItems", this.transcription)) != null) {
                this.setSelectedItems(selItems);
            }
        }
        if (stringPref == null) {
            Boolean boolPref = Preferences.getBool("ExportWordListDialog.tierRB", null);
            if (boolPref != null) {
                if (boolPref.booleanValue()) {
                    this.setSelectionMode("Tier");
                } else {
                    this.setSelectionMode("Type");
                }
            } else {
                boolPref = Preferences.getBool("ExportWordListDialog.typeRB", null);
                if (boolPref != null) {
                    if (boolPref.booleanValue()) {
                        this.setSelectionMode("Type");
                    } else {
                        this.setSelectionMode("Tier");
                    }
                }
            }
        }
    }

    @Override
    protected void extractTiersFromFiles() {
        super.extractTiersFromFiles();
        String stringPref = Preferences.getString("ExportWordListDialog.SelectTiersMode", null);
        if (stringPref != null) {
            this.setSelectionMode(stringPref);
        }
        if (stringPref == null) {
            Boolean boolPref = Preferences.getBool("ExportWordListDialog.tierRB", null);
            if (boolPref != null) {
                if (boolPref.booleanValue()) {
                    this.setSelectionMode("Tier");
                } else {
                    this.setSelectionMode("Type");
                }
            } else {
                boolPref = Preferences.getBool("ExportWordListDialog.typeRB", null);
                if (boolPref != null) {
                    if (boolPref.booleanValue()) {
                        this.setSelectionMode("Type");
                    } else {
                        this.setSelectionMode("Tier");
                    }
                }
            }
        }
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        this.countTokensCB = new JCheckBox();
        if (this.mode == WORDS) {
            this.delimButtonGroup = new ButtonGroup();
            this.tokenDelimLabel = new JLabel();
            this.defaultDelimRB = new JRadioButton();
            this.customDelimRB = new JRadioButton();
            this.customDelimField = new JTextField();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.tokenDelimLabel, gridBagConstraints);
            this.defaultDelimRB.setSelected(true);
            this.defaultDelimRB.addChangeListener(this);
            this.delimButtonGroup.add(this.defaultDelimRB);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.defaultDelimRB, gridBagConstraints);
            this.customDelimRB.addChangeListener(this);
            this.delimButtonGroup.add(this.customDelimRB);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.customDelimRB, gridBagConstraints);
            this.customDelimField.setEnabled(false);
            this.customDelimField.setColumns(6);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.customDelimField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(12, 6, 4, 6);
            this.optionsPanel.add((Component)this.countTokensCB, gridBagConstraints);
        } else {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.countTokensCB, gridBagConstraints);
        }
        this.setPreferredSetting();
        this.updateLocale();
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.titleLabel.setText(ElanLocale.getString("ExportDialog.WordList.Title"));
        if (this.mode == WORDS) {
            this.titleLabel.setText(ElanLocale.getString("ExportDialog.WordList.Title"));
            this.tokenDelimLabel.setText(ElanLocale.getString("TokenizeDialog.Label.TokenDelimiter"));
            this.defaultDelimRB.setText(ElanLocale.getString("Button.Default") + "( . , ! ? \" ' )");
            this.customDelimRB.setText(ElanLocale.getString("TokenizeDialog.RadioButton.Custom"));
        } else if (this.mode == ANNOTATIONS) {
            this.titleLabel.setText(ElanLocale.getString("ExportDialog.AnnotationList.Title"));
        }
        this.countTokensCB.setText(ElanLocale.getString("ExportDialog.WordList.CountOccur"));
    }

    @Override
    protected boolean startExport() throws IOException {
        List<String> selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        File exportFile = null;
        if (this.mode == WORDS) {
            exportFile = this.promptForFile(ElanLocale.getString("ExportDialog.WordList.Title"), null, FileExtension.TEXT_EXT, true);
        } else if (this.mode == ANNOTATIONS) {
            exportFile = this.promptForFile(ElanLocale.getString("ExportDialog.AnnotationList.Title"), null, FileExtension.TEXT_EXT, true);
        }
        if (exportFile == null) {
            return false;
        }
        String delimiters = null;
        if (this.mode == WORDS && this.customDelimRB.isSelected()) {
            delimiters = this.customDelimField.getText();
        }
        boolean countOccurrences = this.countTokensCB.isSelected();
        Transcription2WordList twl = new Transcription2WordList();
        try {
            if (this.transcription != null) {
                twl.exportWords(this.transcription, selectedTiers, exportFile, this.encoding, delimiters, countOccurrences);
            } else if (this.mode == ANNOTATIONS) {
                twl.exportWords(this.files, selectedTiers, exportFile, this.encoding, new String(""), countOccurrences);
            } else if (this.mode == WORDS) {
                twl.exportWords(this.files, selectedTiers, exportFile, this.encoding, delimiters, countOccurrences);
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error"), ElanLocale.getString("Message.Error"), 2);
            return false;
        }
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() == this.defaultDelimRB || ce.getSource() == this.customDelimField) {
            if (this.defaultDelimRB.isSelected()) {
                this.customDelimField.setEnabled(false);
            } else {
                this.customDelimField.setEnabled(true);
                this.customDelimField.requestFocus();
            }
        }
    }

    private void setPreferredSetting() {
        if (this.mode == WORDS) {
            Boolean boolPref = Preferences.getBool("ExportWordListDialog.customDelimRB", null);
            if (boolPref != null) {
                this.customDelimRB.setSelected(boolPref);
            }
            if ((boolPref = Preferences.getBool("ExportWordListDialog.defaultDelimRB", null)) != null) {
                this.defaultDelimRB.setSelected(boolPref);
            }
            if ((boolPref = Preferences.getBool("ExportWordListDialog.countTokensCB", null)) != null) {
                this.countTokensCB.setSelected(boolPref);
            }
            if ((boolPref = Preferences.getBool("ExportWordListDialog.customDelimField", null)) != null) {
                this.customDelimField.setText(boolPref.toString());
            }
        } else {
            Boolean boolPref = Preferences.getBool("ExportAnnotationListDialog.countTokensCB", null);
            if (boolPref != null) {
                this.countTokensCB.setSelected(boolPref);
            }
        }
    }

    private void savePreferences() {
        if (this.mode == WORDS) {
            Preferences.set("ExportWordListDialog.customDelimRB", this.customDelimRB.isSelected(), null);
            Preferences.set("ExportWordListDialog.defaultDelimRB", this.defaultDelimRB.isSelected(), null);
            Preferences.set("ExportWordListDialog.countTokensCB", this.countTokensCB.isSelected(), null);
            if (this.customDelimField.getText() != null) {
                Preferences.set("ExportWordListDialog.customDelimField", this.customDelimField.getText(), null);
            }
            if (!this.multipleFileExport) {
                Preferences.set("ExportWordListDialog.selectedTiers", this.getSelectedTiers(), (Transcription)this.transcription);
                Preferences.set("ExportWordListDialog.SelectTiersMode", this.getSelectionMode(), (Transcription)this.transcription);
                Preferences.set("ExportWordListDialog.HiddenTiers", this.getHiddenTiers(), (Transcription)this.transcription);
                if (this.getSelectionMode() != "Tier") {
                    Preferences.set("ExportWordListDialog.LastSelectedItems", this.getSelectedItems(), (Transcription)this.transcription);
                }
                List<String> tierOrder = this.getTierOrder();
                Preferences.set("ExportWordListDialog.TierOrder", tierOrder, (Transcription)this.transcription);
            } else {
                Preferences.set("ExportWordListDialog.SelectTiersMode", this.getSelectionMode(), null);
            }
        } else {
            Preferences.set("ExportAnnotationListDialog.countTokensCB", this.countTokensCB.isSelected(), null);
        }
    }
}

