/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.annotator.util.FileUtility;

public class ImageExporter {
    Frame parentFrame = null;

    public ImageExporter() {
    }

    public ImageExporter(Frame frame) {
        this.parentFrame = frame;
    }

    public void exportImage(Image image) {
        this.exportImage(image, null, null);
    }

    public void exportImage(Image image, String mediaFilePath, Long mediaTime) {
        String imageFormat;
        BufferedImage img = !(image instanceof BufferedImage) ? this.imageToBufferedImage(image) : (BufferedImage)image;
        if (img == null) {
            JOptionPane.showMessageDialog(this.parentFrame, ElanLocale.getString("ImageExporter.Message.NoImage"), ElanLocale.getString("Message.Warning"), 2);
            return;
        }
        String filePath = null;
        Object mediaFileName = null;
        if (mediaFilePath != null) {
            filePath = FileUtility.urlStringToPath(mediaFilePath);
            mediaFileName = FileUtility.fileNameFromPath(filePath);
            if ((mediaFileName = FileUtility.dropExtension((String)mediaFileName)) != null && mediaTime != null) {
                mediaFileName = (String)mediaFileName + "_" + mediaTime.toString();
            }
        }
        if ((imageFormat = Preferences.getString("LastImageFormat", null)) != null && mediaFileName != null) {
            mediaFileName = (String)mediaFileName + "." + imageFormat;
        }
        FileChooser chooser = new FileChooser(this.parentFrame);
        if (mediaFileName != null) {
            chooser.createAndShowFileDialog(null, 1, null, FileExtension.IMAGE_EXT, "LastImageDir", (String)mediaFileName);
        } else {
            chooser.createAndShowFileDialog(null, 1, FileExtension.IMAGE_EXT, "LastImageDir");
        }
        String imageIOType = "jpg";
        File saveFile = chooser.getSelectedFile();
        if (saveFile != null) {
            Object fileName = saveFile.getAbsolutePath();
            String lowerFileName = ((String)fileName).toLowerCase();
            if (lowerFileName.endsWith("png")) {
                imageIOType = "png";
            } else if (lowerFileName.endsWith("bmp")) {
                imageIOType = "bmp";
            } else if (!lowerFileName.endsWith("jpg") && !lowerFileName.endsWith("jpeg")) {
                fileName = (String)fileName + ".jpg";
            }
            Preferences.set("LastImageFormat", imageIOType, null);
            File newSaveFile = new File((String)fileName);
            if (img.getColorModel().hasAlpha() && !imageIOType.equals("png")) {
                BufferedImage flatImg = new BufferedImage(img.getWidth(), img.getHeight(), 1);
                flatImg.getGraphics().drawImage(img, 0, 0, null);
                img = flatImg;
            }
            try {
                ImageIO.write((RenderedImage)img, imageIOType, newSaveFile);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                JOptionPane.showMessageDialog(this.parentFrame, ElanLocale.getString("ExportDialog.Message.Error"), ElanLocale.getString("Message.Error"), 0);
            }
        }
    }

    private BufferedImage imageToBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        BufferedImage bufImg = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufImg;
    }
}

