/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export.multiplefiles;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.MFDomainDialog;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class MultipleFileFlexExportStep1
extends StepPane
implements ActionListener {
    private JRadioButton selectedFilesFromDiskRB;
    private JRadioButton filesFromDomainRB;
    private JPanel fileSelectionPanel;
    private JPanel elementMappingPanel;
    private ButtonGroup buttonGroup;
    private JButton selectFilesBtn;
    private JButton selectDomainBtn;
    private JTable typeTable;
    private DefaultTableModel typeModel;
    private JCheckBox textCB;
    private JCheckBox paraCB;
    private List<TranscriptionImpl> transList;
    private List<String> openedFileList;
    private final String ELEMENT_NAME = "Element Name";
    private final String ELEMENT_TYPE = "Element type";
    private final String SELECT_TYPE = ElanLocale.getString("TranscriptionManager.ComboBoxDefaultString");
    private final String DEFAULT_VALUE = ElanLocale.getString("ExportFlexDialog.DefaultValue");
    private Insets globalInset = new Insets(2, 4, 2, 4);
    private HashMap<String, List<String>> elementTypeMap = new HashMap();
    private List<String> tierContentLanguages;
    private final int IT_INDEX = 0;
    private final int PARA_INDEX = 1;
    private final int PHRASE_INDEX = 2;
    private final int WORD_INDEX = 3;
    private final int MORPH_INDEX = 4;

    public MultipleFileFlexExportStep1(MultiStepPane mp) {
        super(mp);
        this.elementTypeMap.put("interlinear-text", new ArrayList());
        this.elementTypeMap.put("paragraph", new ArrayList());
        this.elementTypeMap.put("phrase", new ArrayList());
        this.elementTypeMap.put("word", new ArrayList());
        this.elementTypeMap.put("morph", new ArrayList());
        this.tierContentLanguages = new ArrayList<String>();
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.initFileSelectionPanel();
        this.initElementMappingPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInset;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.add((Component)this.fileSelectionPanel, gbc);
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 17;
        this.add((Component)this.elementMappingPanel, gbc);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("MultiFileExportFlex.Step1.Title");
    }

    @Override
    public void enterStepForward() {
        this.updateButtonStates();
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    public boolean leaveStepForward() {
        this.storePreferences();
        HashMap<String, String> elementMap = new HashMap<String, String>();
        elementMap.put("interlinear-text", (String)this.typeTable.getValueAt(0, 1));
        elementMap.put("paragraph", (String)this.typeTable.getValueAt(1, 1));
        elementMap.put("phrase", (String)this.typeTable.getValueAt(2, 1));
        String type = (String)this.typeTable.getValueAt(3, 1);
        if (type != null && !type.equals(this.DEFAULT_VALUE) && !type.equals(this.SELECT_TYPE)) {
            elementMap.put("word", type);
        }
        if ((type = (String)this.typeTable.getValueAt(4, 1)) != null && !type.equals(this.DEFAULT_VALUE) && !type.equals(this.SELECT_TYPE)) {
            elementMap.put("morph", type);
        }
        this.multiPane.putStepProperty("ElementTypeMap", elementMap);
        this.multiPane.putStepProperty("TransImplList", this.transList);
        this.multiPane.putStepProperty("OpenedFiles", this.openedFileList);
        if (!this.tierContentLanguages.isEmpty()) {
            this.multiPane.putStepProperty("languages", this.tierContentLanguages);
        }
        return true;
    }

    private void initFileSelectionPanel() {
        this.fileSelectionPanel = new JPanel(new GridBagLayout());
        this.fileSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("MultiFileExport.Panel.Title.FileSelection")));
        this.selectedFilesFromDiskRB = new JRadioButton(ElanLocale.getString("FileAndTierSelectionStepPane.Radio.FilesFromFileBrowser"));
        this.selectedFilesFromDiskRB.addActionListener(this);
        this.selectedFilesFromDiskRB.setSelected(true);
        this.filesFromDomainRB = new JRadioButton(ElanLocale.getString("FileAndTierSelectionStepPane.Radio.FilesFromDomain"));
        this.filesFromDomainRB.addActionListener(this);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.selectedFilesFromDiskRB);
        this.buttonGroup.add(this.filesFromDomainRB);
        this.selectFilesBtn = new JButton(ElanLocale.getString("Button.Browse"));
        this.selectFilesBtn.addActionListener(this);
        this.selectDomainBtn = new JButton(ElanLocale.getString("FileAndTierSelectionStepPane.Button.Domain"));
        this.selectDomainBtn.addActionListener(this);
        this.selectDomainBtn.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = this.globalInset;
        this.fileSelectionPanel.add((Component)this.selectedFilesFromDiskRB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        this.fileSelectionPanel.add((Component)this.selectFilesBtn, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        this.fileSelectionPanel.add((Component)this.filesFromDomainRB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        this.fileSelectionPanel.add((Component)this.selectDomainBtn, gbc);
    }

    private void initElementMappingPanel() {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (MultipleFileFlexExportStep1.this.typeTable.isEditing()) {
                    MultipleFileFlexExportStep1.this.typeTable.editingCanceled(null);
                }
                if (e.getSource() == MultipleFileFlexExportStep1.this.textCB) {
                    if (MultipleFileFlexExportStep1.this.textCB.isSelected()) {
                        MultipleFileFlexExportStep1.this.updateTypesForIT();
                    } else {
                        MultipleFileFlexExportStep1.this.typeTable.setValueAt(null, 0, 1);
                        if (MultipleFileFlexExportStep1.this.paraCB.isSelected()) {
                            MultipleFileFlexExportStep1.this.updateTypesForParagraph();
                        } else {
                            MultipleFileFlexExportStep1.this.updateTypesForPhrase();
                        }
                    }
                } else if (e.getSource() == MultipleFileFlexExportStep1.this.paraCB) {
                    if (MultipleFileFlexExportStep1.this.paraCB.isSelected()) {
                        MultipleFileFlexExportStep1.this.updateTypesForParagraph();
                    } else {
                        MultipleFileFlexExportStep1.this.typeTable.setValueAt(null, 1, 1);
                        MultipleFileFlexExportStep1.this.updateTypesForPhrase();
                    }
                }
                MultipleFileFlexExportStep1.this.updateButtonStates();
            }
        };
        this.textCB = new JCheckBox(ElanLocale.getString("ExportFlexStep1.InterLinearText"));
        this.textCB.setSelected(true);
        this.paraCB = new JCheckBox(ElanLocale.getString("ExportFlexStep1.Paragraph"));
        this.paraCB.setSelected(true);
        this.typeModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (this.getColumnName(column).equals("Element Name")) {
                    return false;
                }
                if (MultipleFileFlexExportStep1.this.typeTable.getValueAt(row, column) == null) {
                    return false;
                }
                if (MultipleFileFlexExportStep1.this.typeTable.getValueAt(row, column).toString().equals(MultipleFileFlexExportStep1.this.DEFAULT_VALUE)) {
                    return false;
                }
                if (MultipleFileFlexExportStep1.this.typeTable.isEditing()) {
                    MultipleFileFlexExportStep1.this.typeTable.editingCanceled(null);
                }
                return true;
            }
        };
        this.typeModel.setColumnIdentifiers(new String[]{"Element Name", "Element type"});
        this.typeModel.addRow(new Object[]{"interlinear-text", null});
        this.typeModel.addRow(new Object[]{"paragraph", null});
        this.typeModel.addRow(new Object[]{"phrase", null});
        this.typeModel.addRow(new Object[]{"word", null});
        this.typeModel.addRow(new Object[]{"morph", null});
        DefaultTableCellRenderer typeTableRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    return cell;
                }
                if (!table.isEnabled()) {
                    table.setGridColor(Color.GRAY);
                    cell.setForeground(Color.GRAY);
                    return cell;
                }
                table.setGridColor(Color.BLACK);
                if (row == 0) {
                    if (MultipleFileFlexExportStep1.this.textCB.isSelected()) {
                        cell.setForeground(Color.BLACK);
                    } else {
                        cell.setForeground(Color.GRAY);
                        return cell;
                    }
                }
                if (row == 1) {
                    if (MultipleFileFlexExportStep1.this.paraCB.isSelected()) {
                        cell.setForeground(Color.BLACK);
                    } else {
                        cell.setForeground(Color.GRAY);
                        return cell;
                    }
                }
                if (value.equals(MultipleFileFlexExportStep1.this.SELECT_TYPE)) {
                    cell.setForeground(Color.GRAY);
                } else {
                    cell.setForeground(Color.BLACK);
                }
                return cell;
            }
        };
        this.typeTable = new JTable(this.typeModel);
        this.typeTable.setCellSelectionEnabled(true);
        this.typeTable.setDefaultEditor(Object.class, new TypeTableCellEditor());
        this.typeTable.setDefaultRenderer(Object.class, typeTableRenderer);
        this.typeTable.setShowGrid(true);
        this.typeTable.setGridColor(Color.BLACK);
        this.typeTable.setSelectionBackground(Color.WHITE);
        this.typeTable.setRowHeight(this.typeTable.getRowHeight() + 5);
        this.elementMappingPanel = new JPanel(new GridBagLayout());
        this.elementMappingPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportFlexStep1.ElementMapping")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInset;
        gbc.fill = 0;
        gbc.anchor = 18;
        this.elementMappingPanel.add((Component)this.textCB, gbc);
        gbc.gridy = 1;
        this.elementMappingPanel.add((Component)this.paraCB, gbc);
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.elementMappingPanel.add((Component)new JScrollPane(this.typeTable), gbc);
        this.loadPreferences();
        this.textCB.addItemListener(listener);
        this.paraCB.addItemListener(listener);
        this.typeTable.setEnabled(false);
        this.textCB.setEnabled(false);
        this.paraCB.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e != null) {
            Object source = e.getSource();
            if (source == this.selectFilesBtn) {
                ArrayList<String> selectedFiles = new ArrayList<String>();
                FileChooser chooser = new FileChooser(this);
                chooser.createAndShowMultiFileDialog(ElanLocale.getString("MultiFileImport.Flex.Select"), 0, null, null, FileExtension.EAF_EXT, false, "LastUsedEAFDir", 0, null);
                Object[] array = chooser.getSelectedFiles();
                if (array != null) {
                    for (Object element : array) {
                        File f = (File)element;
                        if (!f.canRead()) continue;
                        selectedFiles.add(f.getAbsolutePath());
                    }
                    this.loadTranscriptionList(selectedFiles);
                }
            } else if (source == this.selectDomainBtn) {
                File f;
                int i;
                MFDomainDialog domainDialog = new MFDomainDialog(ELANCommandFactory.getRootFrame(null), ElanLocale.getString("ExportDialog.Multi"), true);
                domainDialog.setVisible(true);
                List<String> searchPaths = domainDialog.getSearchPaths();
                List<String> searchDirs = domainDialog.getSearchDirs();
                ArrayList<String> selectedFiles = new ArrayList<String>();
                if (!searchPaths.isEmpty()) {
                    for (i = 0; i < searchPaths.size(); ++i) {
                        f = new File(searchPaths.get(i));
                        if (!f.canRead() || selectedFiles.contains(f.getAbsolutePath())) continue;
                        selectedFiles.add(f.getAbsolutePath());
                    }
                }
                if (!searchDirs.isEmpty()) {
                    for (i = 0; i < searchDirs.size(); ++i) {
                        f = new File(searchDirs.get(i));
                        if (f.isFile() && f.canRead()) {
                            if (selectedFiles.contains(f.getAbsolutePath())) continue;
                            selectedFiles.add(f.getAbsolutePath());
                            continue;
                        }
                        if (!f.isDirectory() || !f.canRead()) continue;
                        this.addFiles(f, selectedFiles);
                    }
                }
                this.loadTranscriptionList(selectedFiles);
            } else if (source == this.selectedFilesFromDiskRB) {
                this.selectFilesBtn.setEnabled(true);
                this.selectDomainBtn.setEnabled(false);
            } else if (source == this.filesFromDomainRB) {
                this.selectFilesBtn.setEnabled(false);
                this.selectDomainBtn.setEnabled(true);
            }
        }
        this.updateButtonStates();
    }

    private void addFiles(File dir, List<String> files) {
        if (dir == null && files == null) {
            return;
        }
        File[] allSubs = dir.listFiles();
        for (int i = 0; i < allSubs.length; ++i) {
            if (allSubs[i].isDirectory() && allSubs[i].canRead()) {
                this.addFiles(allSubs[i], files);
                continue;
            }
            if (!allSubs[i].canRead() || !allSubs[i].getName().toLowerCase().endsWith(FileExtension.EAF_EXT[0]) || files.contains(allSubs[i].getAbsolutePath())) continue;
            files.add(allSubs[i].getAbsolutePath());
        }
    }

    public void updateButtonStates() {
        boolean phraseTier = true;
        String pharseType = (String)this.typeTable.getValueAt(2, 1);
        if (pharseType == null || pharseType.equals(this.SELECT_TYPE) || pharseType.equals(this.DEFAULT_VALUE)) {
            phraseTier = false;
        }
        this.multiPane.setButtonEnabled(1, phraseTier);
        this.multiPane.setButtonEnabled(2, false);
    }

    private void loadTranscriptionList(List<String> files) {
        this.transList = new ArrayList<TranscriptionImpl>();
        this.openedFileList = new ArrayList<String>();
        for (int i = 0; i < files.size(); ++i) {
            TranscriptionImpl transImpl = new TranscriptionImpl(files.get(i));
            if (transImpl == null) continue;
            this.transList.add(transImpl);
            this.openedFileList.add(files.get(i));
        }
        this.loadTypesForIT();
        if (this.textCB.isSelected()) {
            this.updateTypesForIT();
        } else {
            this.typeTable.setValueAt(null, 0, 1);
            if (this.paraCB.isSelected()) {
                this.updateTypesForParagraph();
            } else {
                this.updateTypesForPhrase();
            }
        }
        this.typeTable.setEnabled(true);
        this.textCB.setEnabled(true);
        this.paraCB.setEnabled(true);
        this.extractContentLanguages();
        this.updateButtonStates();
    }

    private void loadTypesForIT() {
        List<String> typeList = this.elementTypeMap.get("interlinear-text");
        typeList.clear();
        for (int tr = 0; tr < this.transList.size(); ++tr) {
            List<TierImpl> tiers = this.transList.get(tr).getTiers();
            for (int i = 0; i < tiers.size(); ++i) {
                TierImpl tier = tiers.get(i);
                if (tier.getLinguisticType().getConstraints() != null || typeList.contains(tier.getLinguisticType().getLinguisticTypeName())) continue;
                typeList.add(tier.getLinguisticType().getLinguisticTypeName());
            }
        }
    }

    private void updateTypesForIT() {
        List<String> typeList = this.elementTypeMap.get("interlinear-text");
        if (typeList.size() == 0) {
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 0, 1);
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 1, 1);
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 3, 1);
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 4, 1);
        } else {
            this.typeModel.setValueAt(typeList.get(0), 0, 1);
            for (int i = 0; i < typeList.size(); ++i) {
                if (!typeList.get(i).startsWith("interlinear-text") && !typeList.get(i).startsWith("txt")) continue;
                this.typeModel.setValueAt(typeList.get(i), 0, 1);
                break;
            }
            if (this.paraCB.isSelected()) {
                this.updateTypesForParagraph();
            } else {
                this.updateTypesForPhrase();
            }
        }
    }

    private void updateTypesForParagraph() {
        List<String> typeList = this.elementTypeMap.get("paragraph");
        typeList.clear();
        String itType = (String)this.typeTable.getValueAt(0, 1);
        for (int t = 0; t < this.transList.size(); ++t) {
            List<TierImpl> tiers = this.transList.get(t).getTiers();
            for (int i = 0; i < tiers.size(); ++i) {
                TierImpl tier = tiers.get(i);
                if (itType != null && tier.getLinguisticType().getLinguisticTypeName().equals(itType)) continue;
                if (tier.getLinguisticType().getConstraints() != null) {
                    int stereotype = tier.getLinguisticType().getConstraints().getStereoType();
                    if (stereotype != 0 && stereotype != 3 && stereotype != 1 || typeList.contains(tier.getLinguisticType().getLinguisticTypeName())) continue;
                    typeList.add(tier.getLinguisticType().getLinguisticTypeName());
                    continue;
                }
                if (typeList.contains(tier.getLinguisticType().getLinguisticTypeName())) continue;
                typeList.add(tier.getLinguisticType().getLinguisticTypeName());
            }
        }
        if (typeList.size() == 0) {
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 1, 1);
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 2, 1);
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 3, 1);
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 4, 1);
        } else {
            this.typeModel.setValueAt(typeList.get(0), 1, 1);
            for (int i = 0; i < typeList.size(); ++i) {
                if (!typeList.get(i).startsWith("paragraph")) continue;
                this.typeModel.setValueAt(typeList.get(i), 1, 1);
                break;
            }
            this.updateTypesForPhrase();
        }
    }

    private void updateTypesForPhrase() {
        List<String> typeList = this.elementTypeMap.get("phrase");
        typeList.clear();
        if (this.paraCB.isSelected()) {
            String paraType = (String)this.typeTable.getValueAt(1, 1);
            for (int tr = 0; tr < this.transList.size(); ++tr) {
                List<TierImpl> tiers = this.transList.get(tr).getTiersWithLinguisticType(paraType);
                for (int t = 0; t < tiers.size(); ++t) {
                    TierImpl tier = tiers.get(t);
                    List<TierImpl> childTiers = tier.getChildTiers();
                    for (int i = 0; i < childTiers.size(); ++i) {
                        tier = childTiers.get(i);
                        int stereotype = tier.getLinguisticType().getConstraints().getStereoType();
                        if (stereotype != 1 && stereotype != 0 && stereotype != 3 || typeList.contains(tier.getLinguisticType().getLinguisticTypeName())) continue;
                        typeList.add(tier.getLinguisticType().getLinguisticTypeName());
                    }
                }
            }
        } else {
            String itType = (String)this.typeTable.getValueAt(0, 1);
            for (int tr = 0; tr < this.transList.size(); ++tr) {
                List<TierImpl> tiers = this.transList.get(tr).getTiers();
                for (int i = 0; i < tiers.size(); ++i) {
                    TierImpl tier = tiers.get(i);
                    if (itType != null && tier.getLinguisticType().getLinguisticTypeName().equals(itType)) continue;
                    if (tier.getLinguisticType().getConstraints() != null) {
                        int sterotype = tier.getLinguisticType().getConstraints().getStereoType();
                        if (sterotype != 1 && sterotype != 0 && sterotype != 3 || typeList.contains(tier.getLinguisticType().getLinguisticTypeName())) continue;
                        typeList.add(tier.getLinguisticType().getLinguisticTypeName());
                        continue;
                    }
                    if (typeList.contains(tier.getLinguisticType().getLinguisticTypeName())) continue;
                    typeList.add(tier.getLinguisticType().getLinguisticTypeName());
                }
            }
        }
        if (typeList.size() == 0) {
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 2, 1);
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 3, 1);
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 4, 1);
        } else {
            this.typeModel.setValueAt(typeList.get(0), 2, 1);
            for (int i = 0; i < typeList.size(); ++i) {
                if (!typeList.get(i).startsWith("phrase")) continue;
                this.typeModel.setValueAt(typeList.get(i), 2, 1);
                break;
            }
            this.updateTypesForWord();
        }
    }

    private void updateTypesForWord() {
        List<String> typeList = this.elementTypeMap.get("word");
        typeList.clear();
        String phraseType = (String)this.typeTable.getValueAt(2, 1);
        for (int tr = 0; tr < this.transList.size(); ++tr) {
            List<TierImpl> tiers = this.transList.get(tr).getTiersWithLinguisticType(phraseType);
            for (int t = 0; t < tiers.size(); ++t) {
                TierImpl tier = tiers.get(t);
                List<TierImpl> childTiers = tier.getChildTiers();
                for (int i = 0; i < childTiers.size(); ++i) {
                    tier = childTiers.get(i);
                    int stereotype = tier.getLinguisticType().getConstraints().getStereoType();
                    if (stereotype != 0 && stereotype != 3 && stereotype != 1 || typeList.contains(tier.getLinguisticType().getLinguisticTypeName())) continue;
                    typeList.add(tier.getLinguisticType().getLinguisticTypeName());
                }
            }
        }
        if (typeList.size() == 0) {
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 3, 1);
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 4, 1);
        } else {
            this.typeModel.setValueAt(typeList.get(0), 3, 1);
            for (int i = 0; i < typeList.size(); ++i) {
                if (!typeList.get(i).startsWith("word")) continue;
                this.typeModel.setValueAt(typeList.get(i), 3, 1);
                break;
            }
        }
        this.updateTypesForMorph();
    }

    private void updateTypesForMorph() {
        List<String> typeList = this.elementTypeMap.get("morph");
        typeList.clear();
        String wordType = (String)this.typeTable.getValueAt(3, 1);
        for (int tr = 0; tr < this.transList.size(); ++tr) {
            List<TierImpl> tiers = this.transList.get(tr).getTiersWithLinguisticType(wordType);
            for (int t = 0; t < tiers.size(); ++t) {
                TierImpl tier = tiers.get(t);
                List<TierImpl> childTiers = tier.getChildTiers();
                for (int i = 0; i < childTiers.size(); ++i) {
                    tier = childTiers.get(i);
                    int stereotype = tier.getLinguisticType().getConstraints().getStereoType();
                    if (stereotype != 3 && stereotype != 0 && stereotype != 1 || typeList.contains(tier.getLinguisticType().getLinguisticTypeName())) continue;
                    typeList.add(tier.getLinguisticType().getLinguisticTypeName());
                }
            }
        }
        if (typeList.size() == 0) {
            this.typeModel.setValueAt(this.DEFAULT_VALUE, 4, 1);
        } else {
            this.typeModel.setValueAt(typeList.get(0), 4, 1);
            for (int i = 0; i < typeList.size(); ++i) {
                if (!typeList.get(i).startsWith("morph")) continue;
                this.typeModel.setValueAt(typeList.get(i), 4, 1);
                break;
            }
        }
    }

    private void deleteRowValuesAfter(int row) {
        for (int i = row + 1; i < this.typeTable.getRowCount(); ++i) {
            this.typeTable.setValueAt(null, i, 1);
        }
    }

    private void updateTypesForRow(int row) {
        switch (row) {
            case 1: {
                this.updateTypesForParagraph();
                break;
            }
            case 2: {
                this.updateTypesForPhrase();
                break;
            }
            case 3: {
                this.updateTypesForWord();
                break;
            }
            case 4: {
                this.updateTypesForMorph();
            }
        }
    }

    private void extractContentLanguages() {
        this.tierContentLanguages.clear();
        for (TranscriptionImpl transcription : this.transList) {
            for (TierImpl tier : transcription.getTiers()) {
                String langRef = tier.getLangRef();
                if (langRef == null || langRef.isEmpty() || this.tierContentLanguages.contains(langRef)) continue;
                this.tierContentLanguages.add(langRef);
            }
        }
        if (this.tierContentLanguages.size() == 0) {
            return;
        }
        int i = this.tierContentLanguages.size() - 1;
        int count = 0;
        while (i >= 0) {
            String s1 = this.tierContentLanguages.get(i);
            for (int j = 0; j <= i && j != i; ++j) {
                String s2 = this.tierContentLanguages.get(j);
                if (s1.length() <= s2.length()) continue;
                this.tierContentLanguages.remove(s1);
                this.tierContentLanguages.add(j, s1);
                ++i;
                break;
            }
            if (count == this.tierContentLanguages.size() - 1) {
                return;
            }
            --i;
            ++count;
        }
    }

    private void loadPreferences() {
        Boolean boolPref = Preferences.getBool("ExportFLExDialog.IncludeInterlinearText", null);
        if (boolPref != null) {
            this.textCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportFLExDialog.IncludeParagraph", null)) != null) {
            this.paraCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("MultipleFileFlexExport.Filesfromdomain", null)) != null) {
            this.filesFromDomainRB.setSelected(boolPref);
            this.selectedFilesFromDiskRB.setSelected(boolPref == false);
        }
    }

    private void storePreferences() {
        Preferences.set("ExportFLExDialog.IncludeInterlinearText", this.textCB.isSelected(), null);
        Preferences.set("ExportFLExDialog.IncludeParagraph", this.paraCB.isSelected(), null);
        Preferences.set("MultipleFileFlexExport.Filesfromdomain", this.filesFromDomainRB.isSelected(), null);
    }

    private class TypeTableCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        private int startEditInOneClick;
        private JComboBox comboBox;
        private int row;
        private String value;

        public TypeTableCellEditor() {
            super(new JComboBox());
            this.startEditInOneClick = 1;
            this.setClickCountToStart(this.startEditInOneClick);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            this.value = value.toString();
            List types = (List)MultipleFileFlexExportStep1.this.elementTypeMap.get(table.getValueAt(row, 0));
            this.comboBox = new JComboBox();
            this.comboBox.addItem(MultipleFileFlexExportStep1.this.SELECT_TYPE);
            for (int i = 0; i < types.size(); ++i) {
                this.comboBox.addItem(types.get(i));
            }
            this.comboBox.addActionListener(this);
            return this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultipleFileFlexExportStep1.this.typeTable.editingStopped(new ChangeEvent(this));
            if (this.value.equals(this.comboBox.getSelectedItem())) {
                return;
            }
            Object val = this.comboBox.getSelectedItem();
            if (!val.equals(MultipleFileFlexExportStep1.this.DEFAULT_VALUE) && !val.equals(MultipleFileFlexExportStep1.this.SELECT_TYPE)) {
                MultipleFileFlexExportStep1.this.deleteRowValuesAfter(this.row);
                if (MultipleFileFlexExportStep1.this.typeTable.getRowCount() - 1 > this.row) {
                    MultipleFileFlexExportStep1.this.updateTypesForRow(this.row + 1);
                }
            } else if (val.equals(MultipleFileFlexExportStep1.this.SELECT_TYPE)) {
                MultipleFileFlexExportStep1.this.deleteRowValuesAfter(this.row);
            }
        }
    }
}

