/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export.multiplefiles;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class MultipleFileFlexExportStep2
extends StepPane {
    private List<TranscriptionImpl> transList;
    private final String SELECT_TYPE = ElanLocale.getString("TranscriptionManager.ComboBoxDefaultString");
    private final String DEFAULT_VALUE = ElanLocale.getString("ExportFlexDialog.DefaultValue");
    private final String MORPH_TYPE = "morph-type";
    private JCheckBox morphTypeCB;
    private JComboBox morphTypeCombo;
    private JPanel itemMappingPanel;
    private JTable itemTable;
    private DefaultTableModel itemModel;
    private HashMap<String, List<String>> itemTypeMap;
    private HashMap<String, String> elementTypeMap;
    private String morphTypeSelected;
    protected Insets globalInset = new Insets(2, 4, 2, 4);
    private String DEL = "_";

    public MultipleFileFlexExportStep2(MultiStepPane mp) {
        super(mp);
        this.itemTypeMap = new HashMap();
        this.itemTypeMap.put("interlinear-text", new ArrayList());
        this.itemTypeMap.put("phrase", new ArrayList());
        this.itemTypeMap.put("word", new ArrayList());
        this.itemTypeMap.put("morph", new ArrayList());
        this.initComponents();
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("ExportFlexStep2.Title");
    }

    @Override
    public void enterStepForward() {
        this.transList = (List)this.multiPane.getStepProperty("TransImplList");
        this.elementTypeMap = (HashMap)this.multiPane.getStepProperty("ElementTypeMap");
        this.updateItemTypesFor("interlinear-text");
        this.updateItemTypesFor("phrase");
        this.updateItemTypesFor("word");
        this.updateItemTypesFor("morph");
        this.updateTypesForMorphType();
        this.updateButtonStates();
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    public boolean leaveStepForward() {
        this.storePreferences();
        ArrayList<String> itList = new ArrayList<String>();
        ArrayList<String> phraseList = new ArrayList<String>();
        ArrayList<String> wordList = new ArrayList<String>();
        ArrayList<String> morphList = new ArrayList<String>();
        for (int i = 0; i < this.itemTable.getRowCount(); ++i) {
            Object obj = this.itemTable.getValueAt(i, 0);
            if (obj != null && !obj.toString().equals(this.DEFAULT_VALUE) && !obj.toString().equals(this.SELECT_TYPE)) {
                itList.add(obj.toString());
            }
            if ((obj = this.itemTable.getValueAt(i, 1)) != null && !obj.toString().equals(this.DEFAULT_VALUE) && !obj.toString().equals(this.SELECT_TYPE)) {
                phraseList.add(obj.toString());
            }
            if ((obj = this.itemTable.getValueAt(i, 2)) != null && !obj.toString().equals(this.DEFAULT_VALUE) && !obj.toString().equals(this.SELECT_TYPE)) {
                wordList.add(obj.toString());
            }
            if ((obj = this.itemTable.getValueAt(i, 3)) == null || obj.toString().equals(this.DEFAULT_VALUE) || obj.toString().equals(this.SELECT_TYPE)) continue;
            morphList.add(obj.toString());
        }
        String morphType = (String)this.morphTypeCombo.getSelectedItem();
        if (morphType != null && !morphType.equals(this.SELECT_TYPE) && !morphType.equals(this.DEFAULT_VALUE)) {
            this.multiPane.putStepProperty("Morph-Type", morphType);
            if (morphList.contains(morphType)) {
                morphList.remove(morphType);
            }
        }
        HashMap<String, ArrayList<String>> elementItemMap = new HashMap<String, ArrayList<String>>();
        elementItemMap.put("interlinear-text", itList);
        elementItemMap.put("phrase", phraseList);
        elementItemMap.put("word", wordList);
        elementItemMap.put("morph", morphList);
        this.multiPane.putStepProperty("ElementItemMap", elementItemMap);
        return true;
    }

    public void updateButtonStates() {
        this.multiPane.setButtonEnabled(1, true);
        this.multiPane.setButtonEnabled(2, true);
    }

    private void loadPreferences() {
        Boolean val = Preferences.getBool("ExportFlex.MorphTypeSelected", null);
        if (val != null) {
            this.morphTypeCB.setSelected(val);
        }
    }

    private void storePreferences() {
        Preferences.set("ExportFlex.MorphTypeSelected", this.morphTypeCB.isSelected(), null);
    }

    @Override
    protected void initComponents() {
        this.morphTypeCB = new JCheckBox(ElanLocale.getString("ExportFlexStep2.SelectMorphType"));
        this.morphTypeCB.setSelected(true);
        this.morphTypeCombo = new JComboBox();
        this.initializeItemMappingPanel();
        JPanel itemPanel = new JPanel();
        itemPanel.setLayout(new GridBagLayout());
        itemPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportFlexStep1.TierMapping")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInset;
        gbc.fill = 0;
        gbc.anchor = 18;
        this.add((Component)this.morphTypeCB, gbc);
        gbc.gridx = 1;
        this.add((Component)this.morphTypeCombo, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.itemMappingPanel, gbc);
        this.loadPreferences();
    }

    private void initializeItemMappingPanel() {
        this.itemModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (MultipleFileFlexExportStep2.this.itemModel.getValueAt(row, column) == null) {
                    return false;
                }
                return !MultipleFileFlexExportStep2.this.itemModel.getValueAt(row, column).toString().equals(MultipleFileFlexExportStep2.this.DEFAULT_VALUE);
            }
        };
        this.itemModel.setColumnIdentifiers(new String[]{"interlinear-text" + this.DEL + "item", "phrase" + this.DEL + "item", "word" + this.DEL + "item", "morph" + this.DEL + "item"});
        this.itemModel.addRow(new Object[]{null, null, null, null});
        DefaultTableCellRenderer itemTableRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    return cell;
                }
                if (value.equals(MultipleFileFlexExportStep2.this.SELECT_TYPE)) {
                    cell.setForeground(Color.GRAY);
                } else {
                    cell.setForeground(Color.BLACK);
                }
                return cell;
            }
        };
        this.itemTable = new JTable(this.itemModel);
        this.itemTable.setCellSelectionEnabled(true);
        this.itemTable.setDefaultEditor(Object.class, new ItemTableCellEditor());
        this.itemTable.setDefaultRenderer(Object.class, itemTableRenderer);
        this.itemTable.setShowGrid(true);
        this.itemTable.setGridColor(Color.BLACK);
        this.itemTable.setSelectionBackground(Color.WHITE);
        this.itemTable.setRowHeight(this.itemTable.getRowHeight() + 5);
        this.itemMappingPanel = new JPanel(new GridBagLayout());
        this.itemMappingPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportFlexStep2.ItemMapping")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInset;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.itemMappingPanel.add((Component)new JScrollPane(this.itemTable), gbc);
    }

    private void updateTypesForMorphType() {
        int i;
        List<String> typeList = this.itemTypeMap.get("morph");
        this.morphTypeCombo.removeAllItems();
        if (typeList.size() <= 0) {
            this.morphTypeCombo.setEnabled(false);
            this.morphTypeCB.setEnabled(false);
            this.morphTypeCombo.addItem(this.DEFAULT_VALUE);
        } else {
            this.morphTypeCombo.setEnabled(true);
            this.morphTypeCB.setEnabled(true);
            this.morphTypeCombo.addItem(this.SELECT_TYPE);
            for (i = 0; i < typeList.size(); ++i) {
                this.morphTypeCombo.addItem(typeList.get(i));
            }
        }
        if (this.morphTypeSelected != null) {
            if (typeList.contains(this.morphTypeSelected)) {
                this.morphTypeCombo.setSelectedItem(this.morphTypeSelected);
            }
        } else {
            for (i = 0; i < typeList.size(); ++i) {
                if (!typeList.get(i).contains("morph-type")) continue;
                this.morphTypeCombo.setSelectedIndex(i + 1);
            }
        }
    }

    private void updateItemTypesFor(String itemType) {
        int i;
        List<String> typeList = this.itemTypeMap.get(itemType);
        typeList.clear();
        int column = 0;
        String type = null;
        if (itemType.equals("interlinear-text")) {
            type = this.elementTypeMap.get("interlinear-text");
            column = 0;
        } else if (itemType.equals("phrase")) {
            type = this.elementTypeMap.get("phrase");
            column = 1;
        } else if (itemType.equals("word")) {
            type = this.elementTypeMap.get("word");
            column = 2;
        } else if (itemType.equals("morph")) {
            type = this.elementTypeMap.get("morph");
            column = 3;
        }
        if (type != null) {
            for (int tr = 0; tr < this.transList.size(); ++tr) {
                List<TierImpl> tiers = this.transList.get(tr).getTiersWithLinguisticType(type);
                for (int t = 0; t < tiers.size(); ++t) {
                    TierImpl tier = tiers.get(t);
                    List<TierImpl> childTiers = tier.getChildTiers();
                    for (i = 0; i < childTiers.size(); ++i) {
                        tier = childTiers.get(i);
                        int sterotype = tier.getLinguisticType().getConstraints().getStereoType();
                        if (sterotype != 4 || typeList.contains(tier.getLinguisticType().getLinguisticTypeName())) continue;
                        typeList.add(tier.getLinguisticType().getLinguisticTypeName());
                    }
                }
            }
        }
        if (typeList.size() > 0) {
            int row = typeList.size();
            for (int i2 = this.itemTable.getRowCount(); i2 <= row; ++i2) {
                this.itemModel.addRow(new Object[]{null, null, null, null});
            }
            boolean addDefaultValue = true;
            for (i = 0; i < typeList.size(); ++i) {
                if (column == 3 && typeList.get(i).contains("morph-type")) {
                    addDefaultValue = false;
                    continue;
                }
                this.itemModel.setValueAt(typeList.get(i), i, column);
            }
            if (addDefaultValue) {
                this.itemModel.setValueAt(this.DEFAULT_VALUE, row, column);
            } else {
                this.itemModel.setValueAt(this.SELECT_TYPE, row, column);
            }
            this.deleteColumnValuesAfter(row, column);
        } else {
            if (this.itemTable.getRowCount() <= 0) {
                this.itemModel.addRow(new Object[]{null, null, null, null});
            }
            this.itemModel.setValueAt(this.DEFAULT_VALUE, 0, column);
            this.deleteColumnValuesAfter(1, column);
        }
        this.checkAndRemoveEmptyRows(this.itemModel);
    }

    private void checkAndRemoveEmptyRows(DefaultTableModel model) {
        int rowIndex = 0;
        while (rowIndex < model.getRowCount()) {
            if (model.getValueAt(rowIndex, 0) == null && model.getValueAt(rowIndex, 1) == null && model.getValueAt(rowIndex, 2) == null && model.getValueAt(rowIndex, 3) == null) {
                model.removeRow(rowIndex);
                continue;
            }
            ++rowIndex;
        }
    }

    private void deleteColumnValuesAfter(int row, int column) {
        for (int i = row + 1; i < this.itemTable.getRowCount(); ++i) {
            this.itemTable.setValueAt(null, i, column);
        }
    }

    private class ItemTableCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        private int startEditInOneClick;
        private JComboBox comboBox;
        private int row;
        private int column;
        private String value;
        private String type;

        public ItemTableCellEditor() {
            super(new JComboBox());
            this.startEditInOneClick = 1;
            this.setClickCountToStart(this.startEditInOneClick);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            int i;
            this.row = row;
            this.column = column;
            this.value = value.toString();
            switch (column) {
                case 0: {
                    this.type = "interlinear-text";
                    break;
                }
                case 1: {
                    this.type = "phrase";
                    break;
                }
                case 2: {
                    this.type = "word";
                    break;
                }
                case 3: {
                    this.type = "morph";
                }
            }
            List types = (List)MultipleFileFlexExportStep2.this.itemTypeMap.get(this.type);
            this.comboBox = new JComboBox();
            ArrayList<String> usedTypes = new ArrayList<String>();
            for (i = 0; i < row; ++i) {
                usedTypes.add((String)table.getValueAt(i, column));
            }
            this.comboBox.addItem(MultipleFileFlexExportStep2.this.SELECT_TYPE);
            for (i = 0; i < types.size(); ++i) {
                if (usedTypes.contains(types.get(i))) continue;
                this.comboBox.addItem(types.get(i));
            }
            this.comboBox.addActionListener(this);
            return this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultipleFileFlexExportStep2.this.itemTable.editingStopped(new ChangeEvent(this));
            if (this.value.equals(this.comboBox.getSelectedItem())) {
                return;
            }
            Object val = this.comboBox.getSelectedItem();
            if (!val.equals(MultipleFileFlexExportStep2.this.DEFAULT_VALUE) && !val.equals(MultipleFileFlexExportStep2.this.SELECT_TYPE)) {
                MultipleFileFlexExportStep2.this.deleteColumnValuesAfter(this.row, this.column);
                if (this.row < ((List)MultipleFileFlexExportStep2.this.itemTypeMap.get(this.type)).size() - 1) {
                    if (MultipleFileFlexExportStep2.this.itemTable.getRowCount() - 1 == this.row) {
                        MultipleFileFlexExportStep2.this.itemModel.addRow(new Object[]{null, null, null, null, null});
                    }
                    MultipleFileFlexExportStep2.this.itemTable.setValueAt(MultipleFileFlexExportStep2.this.SELECT_TYPE, this.row + 1, this.column);
                } else {
                    if (MultipleFileFlexExportStep2.this.itemTable.getRowCount() - 1 == this.row) {
                        MultipleFileFlexExportStep2.this.itemModel.addRow(new Object[]{null, null, null, null, null});
                    }
                    MultipleFileFlexExportStep2.this.itemTable.setValueAt(MultipleFileFlexExportStep2.this.DEFAULT_VALUE, this.row + 1, this.column);
                }
            } else if (val.equals(MultipleFileFlexExportStep2.this.SELECT_TYPE)) {
                MultipleFileFlexExportStep2.this.deleteColumnValuesAfter(this.row, this.column);
            }
            MultipleFileFlexExportStep2.this.checkAndRemoveEmptyRows(MultipleFileFlexExportStep2.this.itemModel);
        }
    }
}

