/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export.multiplefiles;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.util.TableSubHeaderObject;
import mpi.eudico.server.corpora.clomimpl.flex.FlexConstants;

public class MultipleFileFlexExportStep3
extends StepPane {
    private HashMap<String, List<String>> itemTypeMap;
    private HashMap<String, String> elementTypeMap;
    private final String SELECT_TYPE = ElanLocale.getString("TranscriptionManager.ComboBoxDefaultString");
    private final String SELECT_LANG = ElanLocale.getString("ExportFlexStep3.SelectLang");
    private JTable table;
    private DefaultTableModel model;
    private JRadioButton linTypeRB;
    private JCheckBox tierNameCB;
    private JRadioButton typeRB;
    private JRadioButton langRB;
    private JTextField addCustomValueTF;
    private JComboBox removeValueCombo;
    private JButton addButton;
    private JButton removeButton;
    private HashMap<String, List<String>> linTypeMap;
    private List<String> tierContentLanguages;
    protected Insets globalInset = new Insets(2, 4, 2, 4);
    private List<String> typeList;
    private List<String> langList;

    public MultipleFileFlexExportStep3(MultiStepPane mp) {
        super(mp);
        this.linTypeMap = new HashMap();
        this.typeList = new ArrayList<String>();
        for (String element : FlexConstants.DEFINED_TYPES) {
            this.typeList.add(element);
        }
        this.langList = new ArrayList<String>();
        this.initComponents();
    }

    @Override
    public void enterStepForward() {
        this.elementTypeMap = (HashMap)this.multiPane.getStepProperty("ElementTypeMap");
        this.itemTypeMap = (HashMap)this.multiPane.getStepProperty("ElementItemMap");
        this.tierContentLanguages = (List)this.multiPane.getStepProperty("languages");
        this.updateMapsForType("interlinear-text");
        this.updateMapsForType("phrase");
        this.updateMapsForType("word");
        this.updateMapsForType("morph");
        this.updateTable();
        Collections.sort(this.typeList);
        Collections.sort(this.langList);
        this.updateRemoveValuesComboBoxItems();
        this.updateButtonStates();
    }

    protected void updateMapsForType(String flextype) {
        ArrayList<String> typeList = new ArrayList<String>();
        if (this.elementTypeMap.get(flextype) != null) {
            typeList.add(this.elementTypeMap.get(flextype));
        }
        if (this.itemTypeMap.get(flextype) != null) {
            typeList.addAll((Collection)this.itemTypeMap.get(flextype));
        }
        this.linTypeMap.put(flextype, typeList);
    }

    @Override
    public boolean leaveStepForward() {
        HashMap typeLangMap = new HashMap();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (this.table.getValueAt(i, 1) instanceof TableSubHeaderObject) continue;
            ArrayList<String> valueList = new ArrayList<String>();
            valueList.add((String)this.table.getValueAt(i, 1));
            valueList.add((String)this.table.getValueAt(i, 2));
            typeLangMap.put((String)this.table.getValueAt(i, 0), valueList);
        }
        this.multiPane.putStepProperty("TypeLangMap", typeLangMap);
        this.multiPane.putStepProperty("GetFromTierName", this.tierNameCB.isSelected());
        return true;
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    protected void initComponents() {
        ActionHandler actionHandler = new ActionHandler();
        this.model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (column == 0) {
                    return false;
                }
                return this.getValueAt(row, column) instanceof String;
            }
        };
        this.model.setColumnIdentifiers(new String[]{"Linguistic Type Name", "type", "language"});
        DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer(){
            private Color DEF_LABEL_BG;
            {
                this.DEF_LABEL_BG = new Color(MultipleFileFlexExportStep3.this.getBackground().getRed(), MultipleFileFlexExportStep3.this.getBackground().getGreen(), MultipleFileFlexExportStep3.this.getBackground().getBlue());
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    return cell;
                }
                if (value instanceof TableSubHeaderObject) {
                    cell.setFont(new Font(table.getFont().getName(), 1, table.getFont().getSize() + 1));
                    cell.setBackground(this.DEF_LABEL_BG);
                    cell.setForeground(Color.BLACK);
                } else if (value.equals(MultipleFileFlexExportStep3.this.SELECT_TYPE) || value.equals(MultipleFileFlexExportStep3.this.SELECT_LANG)) {
                    cell.setForeground(Color.GRAY);
                    cell.setBackground(Color.WHITE);
                } else {
                    cell.setForeground(Color.BLACK);
                    cell.setBackground(Color.WHITE);
                }
                return cell;
            }
        };
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(Object.class, tableRenderer);
        this.table.setDefaultEditor(Object.class, new TableCellEditor());
        this.table.setShowGrid(true);
        this.table.setGridColor(Color.BLACK);
        this.table.setSelectionBackground(Color.WHITE);
        this.linTypeRB = new JRadioButton(ElanLocale.getString("ExportFlexStep3.LingType"));
        this.linTypeRB.setSelected(true);
        this.tierNameCB = new JCheckBox(ElanLocale.getString("ExportFlexStep3.ExtractfromTierName"));
        this.tierNameCB.setSelected(true);
        this.typeRB = new JRadioButton("type");
        this.typeRB.addActionListener(actionHandler);
        this.langRB = new JRadioButton("language");
        this.langRB.addActionListener(actionHandler);
        this.typeRB.setSelected(true);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.typeRB);
        group1.add(this.langRB);
        this.addCustomValueTF = new JTextField();
        this.removeValueCombo = new JComboBox();
        this.addButton = new JButton(ElanLocale.getString("Button.Add"));
        this.removeButton = new JButton(ElanLocale.getString("FileChooser.Button.Remove"));
        this.addButton.addActionListener(actionHandler);
        this.removeButton.addActionListener(actionHandler);
        JPanel radioPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        radioPanel.add((Component)this.typeRB, gbc);
        gbc.gridx = 1;
        radioPanel.add((Component)this.langRB, gbc);
        JPanel configPanel = new JPanel();
        configPanel.setLayout(new GridBagLayout());
        configPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportFlexStep3.Title.Configuration")));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInset;
        gbc.anchor = 18;
        gbc.fill = 0;
        configPanel.add((Component)new JLabel(ElanLocale.getString("ExportFlexStep3.Label.AddRemove")), gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        configPanel.add((Component)radioPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        configPanel.add((Component)new JLabel(ElanLocale.getString("ExportFlexStep3.Label.AddCustomVal")), gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        configPanel.add((Component)this.addCustomValueTF, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        configPanel.add((Component)this.addButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        configPanel.add((Component)new JLabel(ElanLocale.getString("ExportFlexStep3.Label.RemoveVal")), gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        configPanel.add((Component)this.removeValueCombo, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        configPanel.add((Component)this.removeButton, gbc);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(new TitledBorder(ElanLocale.getString("ExportFlexStep3.Title.Specification")));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 20, 2, 4);
        panel.add((Component)this.linTypeRB, gbc);
        gbc.gridx = 1;
        gbc.anchor = 13;
        panel.add((Component)this.tierNameCB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel.add((Component)new JScrollPane(this.table), gbc);
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInset;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 1;
        this.add((Component)panel, gbc);
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)configPanel, gbc);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("ExportFlexStep3.Title");
    }

    public void updateButtonStates() {
        boolean next_Button = true;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (this.table.getValueAt(i, 1) instanceof TableSubHeaderObject) continue;
            Object val = this.table.getValueAt(i, 1);
            if (val == null || val.equals(this.SELECT_TYPE)) {
                next_Button = false;
                break;
            }
            val = this.table.getValueAt(i, 2);
            if (val != null && !val.equals(this.SELECT_LANG)) continue;
            next_Button = false;
            break;
        }
        this.multiPane.setButtonEnabled(1, next_Button);
        this.multiPane.setButtonEnabled(2, true);
    }

    private void updateTable() {
        while (this.table.getRowCount() > 0) {
            this.model.removeRow(0);
        }
        this.addRowsFor("interlinear-text", this.linTypeMap.get("interlinear-text"));
        this.addRowsFor("phrase", this.linTypeMap.get("phrase"));
        this.addRowsFor("word", this.linTypeMap.get("word"));
        this.addRowsFor("morph", this.linTypeMap.get("morph"));
    }

    private void addRowsFor(String flexType, List<String> valList) {
        if (valList == null || valList.size() == 0) {
            return;
        }
        this.model.addRow(new Object[]{new TableSubHeaderObject(flexType), new TableSubHeaderObject(""), new TableSubHeaderObject("")});
        for (int i = 0; i < valList.size(); ++i) {
            String type = this.getTypeName(valList.get(i));
            String lang = this.getLanguage(valList.get(i));
            if (i == 0 && !flexType.equals("interlinear-text")) {
                if (type.equals(this.SELECT_TYPE)) {
                    type = "txt";
                }
                if (lang == null) {
                    lang = this.SELECT_LANG;
                }
            } else if (type.equals(this.SELECT_TYPE)) {
                lang = null;
            } else if (lang == null) {
                lang = this.SELECT_LANG;
            }
            if (!type.equals(this.SELECT_TYPE) && !this.typeList.contains(type)) {
                this.typeList.add(type);
            }
            if (lang != null && !lang.equals(this.SELECT_LANG) && !this.langList.contains(lang)) {
                this.langList.add(lang);
            }
            this.model.addRow(new String[]{valList.get(i), type, lang});
        }
    }

    private String getTypeName(String typeName) {
        String[] compsArray;
        String type = null;
        if (typeName.startsWith("interlinear-text")) {
            typeName = typeName.substring("interlinear-text".length());
        }
        if (this.tierContentLanguages != null) {
            for (String cl : this.tierContentLanguages) {
                int li;
                if (!typeName.endsWith(cl) || (li = typeName.lastIndexOf(cl)) <= 0 || typeName.charAt(li - 1) != '-') continue;
                int fi = (typeName = typeName.substring(0, li - 1)).indexOf("-");
                if (fi > -1 && fi < typeName.length() - 1) {
                    return typeName.substring(fi + 1);
                }
                return typeName;
            }
        }
        if ((compsArray = typeName.split("-")).length == 3) {
            type = compsArray[1];
        } else if (compsArray.length > 3) {
            type = typeName.substring(typeName.indexOf("-") + 1, typeName.lastIndexOf("-"));
        } else if (compsArray.length == 2) {
            type = compsArray[0];
        }
        if (type == null || type.equals("item")) {
            type = this.SELECT_TYPE;
        }
        return type;
    }

    private String getLanguage(String typeName) {
        int lindex;
        String lang = null;
        if (typeName.startsWith("interlinear-text")) {
            typeName = typeName.substring("interlinear-text".length());
        }
        if (this.tierContentLanguages != null) {
            for (String cl : this.tierContentLanguages) {
                int li;
                if (!typeName.endsWith(cl) || (li = typeName.lastIndexOf(cl)) <= 0 || typeName.charAt(li - 1) != '-') continue;
                return typeName.substring(li);
            }
        }
        if ((lindex = typeName.lastIndexOf("-")) > -1 && lindex < typeName.length() - 2) {
            lang = typeName.substring(lindex + 1);
        }
        return lang;
    }

    private void validateRowValues() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (this.table.getValueAt(i, 1) instanceof TableSubHeaderObject) continue;
            String type = (String)this.table.getValueAt(i, 1);
            String language = (String)this.table.getValueAt(i, 2);
            if (!this.typeList.contains(type)) {
                this.table.setValueAt(this.SELECT_TYPE, i, 1);
                this.table.setValueAt(null, i, 2);
                continue;
            }
            if (this.langList.contains(language)) continue;
            this.table.setValueAt(this.SELECT_LANG, i, 2);
        }
    }

    private void updateRemoveValuesComboBoxItems() {
        this.removeValueCombo.removeAllItems();
        this.removeValueCombo.addItem("<select>");
        if (this.typeRB.isSelected()) {
            for (int i = 0; i < this.typeList.size(); ++i) {
                this.removeValueCombo.addItem(this.typeList.get(i));
            }
        } else {
            for (int i = 0; i < this.langList.size(); ++i) {
                this.removeValueCombo.addItem(this.langList.get(i));
            }
        }
    }

    private class TableCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        private int startEditInOneClick;
        private JComboBox comboBox;
        private int row;
        private int column;
        private Object value;

        public TableCellEditor() {
            super(new JComboBox());
            this.startEditInOneClick = 1;
            this.setClickCountToStart(this.startEditInOneClick);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            this.column = column;
            this.value = value;
            ArrayList<String> usedValues = new ArrayList<String>();
            List values = null;
            if (column == 1) {
                values = MultipleFileFlexExportStep3.this.typeList;
            } else if (column == 2) {
                Object val;
                values = MultipleFileFlexExportStep3.this.langList;
                String typeVal = (String)table.getValueAt(row, 1);
                for (int index = row - 1; index > -1 && !((val = table.getValueAt(index, 2)) instanceof TableSubHeaderObject); --index) {
                    String type = (String)table.getValueAt(index, 1);
                    if (!type.equals(typeVal) || val.toString().equals(MultipleFileFlexExportStep3.this.SELECT_LANG)) continue;
                    usedValues.add(val.toString());
                }
            }
            this.comboBox = new JComboBox();
            String selectItem = null;
            for (int i = 0; i < values.size(); ++i) {
                if (!usedValues.contains(values.get(i)) && value != null && ((String)values.get(i)).equals(value)) {
                    selectItem = value.toString();
                }
                this.comboBox.addItem(values.get(i));
            }
            this.comboBox.setSelectedItem(selectItem);
            this.comboBox.addActionListener(this);
            return this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.comboBox.getSelectedIndex() == -1) {
                return this.value;
            }
            return this.comboBox.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultipleFileFlexExportStep3.this.table.editingStopped(new ChangeEvent(this));
            if (this.value.equals(this.comboBox.getSelectedItem())) {
                return;
            }
            if (this.column == 1) {
                String typeVal = (String)this.comboBox.getSelectedItem();
                Object langVal = MultipleFileFlexExportStep3.this.table.getValueAt(this.row, 2);
                if (langVal == null || langVal.toString().equals(MultipleFileFlexExportStep3.this.SELECT_LANG)) {
                    MultipleFileFlexExportStep3.this.table.setValueAt(MultipleFileFlexExportStep3.this.SELECT_LANG, this.row, 2);
                } else {
                    int index;
                    for (index = this.row - 1; index > -1 && !(MultipleFileFlexExportStep3.this.table.getValueAt(index, 0) instanceof TableSubHeaderObject); --index) {
                    }
                    if (this.row == ++index) {
                        ++index;
                    }
                    Object obj = MultipleFileFlexExportStep3.this.table.getValueAt(index, 2);
                    while (obj != null && !(obj instanceof TableSubHeaderObject)) {
                        String type = (String)MultipleFileFlexExportStep3.this.table.getValueAt(index, 1);
                        if (type.equals(typeVal) && langVal.toString().equals(obj.toString())) {
                            if (this.row > index) {
                                MultipleFileFlexExportStep3.this.table.setValueAt(MultipleFileFlexExportStep3.this.SELECT_LANG, this.row, 2);
                            } else {
                                MultipleFileFlexExportStep3.this.table.setValueAt(MultipleFileFlexExportStep3.this.SELECT_LANG, index, 2);
                            }
                        }
                        if (this.row == ++index) {
                            ++index;
                        }
                        if (index < MultipleFileFlexExportStep3.this.table.getRowCount()) {
                            obj = MultipleFileFlexExportStep3.this.table.getValueAt(index, 2);
                            continue;
                        }
                        obj = null;
                    }
                }
            } else if (this.column == 2) {
                Object langVal = this.comboBox.getSelectedItem();
                String typeVal = (String)MultipleFileFlexExportStep3.this.table.getValueAt(this.row, 1);
                int index = this.row + 1;
                if (index < MultipleFileFlexExportStep3.this.table.getRowCount()) {
                    do {
                        Object obj = MultipleFileFlexExportStep3.this.table.getValueAt(index, 1);
                        Object lang = MultipleFileFlexExportStep3.this.table.getValueAt(index, 2);
                        if (obj instanceof TableSubHeaderObject) break;
                        if (!obj.toString().equals(typeVal) || lang == null || !lang.equals(langVal)) continue;
                        MultipleFileFlexExportStep3.this.table.setValueAt(MultipleFileFlexExportStep3.this.SELECT_LANG, index, 2);
                    } while (++index != MultipleFileFlexExportStep3.this.table.getRowCount());
                }
            }
            MultipleFileFlexExportStep3.this.updateButtonStates();
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String value;
            Object source = e.getSource();
            if (source instanceof JRadioButton) {
                List values = source.equals(MultipleFileFlexExportStep3.this.typeRB) ? MultipleFileFlexExportStep3.this.typeList : MultipleFileFlexExportStep3.this.langList;
                MultipleFileFlexExportStep3.this.removeValueCombo.removeAllItems();
                MultipleFileFlexExportStep3.this.removeValueCombo.addItem("<select>");
                for (int i = 0; i < values.size(); ++i) {
                    MultipleFileFlexExportStep3.this.removeValueCombo.addItem(values.get(i));
                }
            } else if (source.equals(MultipleFileFlexExportStep3.this.addButton)) {
                String value2 = MultipleFileFlexExportStep3.this.addCustomValueTF.getText().trim();
                if (MultipleFileFlexExportStep3.this.typeRB.isSelected()) {
                    if (!MultipleFileFlexExportStep3.this.typeList.contains(value2)) {
                        MultipleFileFlexExportStep3.this.typeList.add(value2);
                        Collections.sort(MultipleFileFlexExportStep3.this.typeList);
                        MultipleFileFlexExportStep3.this.updateRemoveValuesComboBoxItems();
                        if (MultipleFileFlexExportStep3.this.table.getCellEditor() != null && MultipleFileFlexExportStep3.this.table.getEditingColumn() == 1) {
                            MultipleFileFlexExportStep3.this.table.getCellEditor().cancelCellEditing();
                        }
                    }
                } else if (!MultipleFileFlexExportStep3.this.langList.contains(value2)) {
                    MultipleFileFlexExportStep3.this.langList.add(value2);
                    Collections.sort(MultipleFileFlexExportStep3.this.langList);
                    MultipleFileFlexExportStep3.this.updateRemoveValuesComboBoxItems();
                    if (MultipleFileFlexExportStep3.this.table.getCellEditor() != null && MultipleFileFlexExportStep3.this.table.getEditingColumn() == 2) {
                        MultipleFileFlexExportStep3.this.table.getCellEditor().cancelCellEditing();
                    }
                }
                MultipleFileFlexExportStep3.this.addCustomValueTF.setText("");
            } else if (source.equals(MultipleFileFlexExportStep3.this.removeButton) && (value = (String)MultipleFileFlexExportStep3.this.removeValueCombo.getSelectedItem()) != null) {
                if (MultipleFileFlexExportStep3.this.typeRB.isSelected()) {
                    MultipleFileFlexExportStep3.this.typeList.remove(value);
                } else {
                    MultipleFileFlexExportStep3.this.langList.remove(value);
                }
                MultipleFileFlexExportStep3.this.removeValueCombo.removeItem(value);
                MultipleFileFlexExportStep3.this.removeValueCombo.setSelectedIndex(0);
                MultipleFileFlexExportStep3.this.validateRowValues();
            }
        }
    }
}

