/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export.multiplefiles;

import java.io.IOException;
import java.util.List;
import mpi.eudico.client.annotator.export.multiplefiles.AbstractMultiFileExportProgessStepPane;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.theme.ThemeEncoder;
import mpi.eudico.server.corpora.clomimpl.theme.ThemeEncoderInfo;

public class MultipleFileThemeExportStep3
extends AbstractMultiFileExportProgessStepPane {
    private ThemeEncoder themeEncoder;
    private boolean useCVForVVT;
    private boolean useTierNameAsActor;

    public MultipleFileThemeExportStep3(MultiStepPane multiPane) {
        super(multiPane);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doExport(TranscriptionImpl transImpl, String fileName) {
        ThemeEncoderInfo tei = new ThemeEncoderInfo();
        tei.setTierNameAsActor(this.useTierNameAsActor);
        tei.setUseCVforVVT(this.useCVForVVT);
        List<TierImpl> selectedTiersInThisTrans = transImpl.getTiersWithIds(this.selectedTiers);
        try {
            this.themeEncoder.encodeAndSave(transImpl, tei, selectedTiersInThisTrans, fileName);
            return true;
        }
        catch (IOException ioe) {}
        finally {
            return false;
        }
    }

    @Override
    public void enterStepForward() {
        Object stepProp;
        if (this.themeEncoder == null) {
            this.themeEncoder = new ThemeEncoder();
        }
        this.useCVForVVT = (stepProp = this.multiPane.getStepProperty("UseCVForVVT")) instanceof Boolean ? (Boolean)stepProp : false;
        stepProp = this.multiPane.getStepProperty("TierNameAsActor");
        this.useTierNameAsActor = stepProp instanceof Boolean ? (Boolean)stepProp : true;
        super.enterStepForward();
    }
}

