/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export.multiplefiles;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxTypFile;

public class MultipleFileToolBoxExportStep2
extends StepPane
implements ItemListener,
ActionListener {
    private JCheckBox wrapBlocksCB;
    private JCheckBox correctTimesCB;
    private JCheckBox wrapLinesCB;
    private JCheckBox includeEmptyLinesCB;
    private JCheckBox mediaMarkerCB;
    private JCheckBox appendFileNameCB;
    private JTextField numCharTF;
    private JTextField typField;
    private JTextField dbTypField;
    private JTextField markerTF;
    private JTextField mediaMarkerNameTF;
    private JLabel mediaMarkerNameLabel;
    private JLabel mediaTypeLabel;
    private JLabel charPerLineLabel;
    private JLabel databaseErrorLabel;
    private JLabel recordMarkerErrorLabel;
    private JRadioButton ssMSFormatRB;
    private JRadioButton hhMMSSMSFormatRB;
    private JRadioButton wrapNextLineRB;
    private JRadioButton wrapAfterBlockRB;
    private JRadioButton typeRB;
    private JRadioButton specRB;
    private JRadioButton detectedRMRB;
    private JRadioButton defaultRMRB;
    private JRadioButton customRMRB;
    private JRadioButton videoRB;
    private JRadioButton audioRB;
    private JRadioButton absFilePathRB;
    private JRadioButton relFilePathRB;
    private JButton typButton;
    private JComboBox recordMarkerCB;
    private JPanel outputOptionsPanel;
    private JPanel toolboxOptionsPanel;
    private JScrollPane outerScrollPane;
    List<String> recordMarkerList = null;
    private final int NUM_CHARS = 80;
    Insets insets = new Insets(4, 6, 4, 6);
    Insets vertInsets = new Insets(0, 2, 2, 2);
    Insets leftVertIndent = new Insets(0, 16, 2, 2);
    Insets innerInsets = new Insets(4, 2, 4, 2);
    private boolean moveForward = true;

    public MultipleFileToolBoxExportStep2(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        this.initOutputOptionsPanel();
        this.initToolboxOptionsPanel();
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new GridBagLayout());
        this.outerScrollPane = new JScrollPane(outerPanel);
        this.outerScrollPane.setBorder(null);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        Insets globalInset = new Insets(5, 10, 5, 10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = globalInset;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        outerPanel.add((Component)this.outputOptionsPanel, gbc);
        gbc.gridy = 1;
        outerPanel.add((Component)this.toolboxOptionsPanel, gbc);
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        outerPanel.add((Component)new JPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.outerScrollPane, gbc);
        this.setDefaultNumOfChars();
        this.setShoeboxMarkerRB();
        this.loadPreferences();
        TextFieldHandler tfHandler = new TextFieldHandler();
        this.numCharTF.addKeyListener(tfHandler);
        this.typField.addKeyListener(tfHandler);
        this.dbTypField.addKeyListener(tfHandler);
        this.markerTF.addKeyListener(tfHandler);
        this.mediaMarkerNameTF.addKeyListener(tfHandler);
        this.mediaMarkerCB.addItemListener(this);
        this.customRMRB.addItemListener(this);
        this.defaultRMRB.addItemListener(this);
        this.detectedRMRB.addItemListener(this);
        this.specRB.addItemListener(this);
        this.typeRB.addItemListener(this);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("MultiFileExportToolbox.Title.Step2Title");
    }

    @Override
    public void enterStepForward() {
        boolean repaint = false;
        this.detectedRMRB.setEnabled(false);
        this.defaultRMRB.setSelected(true);
        this.detectedRMRB.setText(ElanLocale.getString("ExportShoebox.Label.Detected"));
        if (this.recordMarkerCB != null) {
            this.toolboxOptionsPanel.remove(this.recordMarkerCB);
            this.recordMarkerCB = null;
            repaint = true;
        }
        this.recordMarkerList = (List)this.multiPane.getStepProperty("RecordMarkersList");
        if (this.recordMarkerList != null && this.recordMarkerList.size() > 0) {
            this.updateDetectedRecordMarker();
            repaint = true;
        }
        this.mediaMarkerCB.setSelected(false);
        this.mediaMarkerCB.setEnabled(false);
        boolean mediaDetected = (Boolean)this.multiPane.getStepProperty("EnableMediaMarker");
        if (mediaDetected) {
            this.mediaMarkerCB.setEnabled(mediaDetected);
            this.mediaMarkerCB.setSelected(mediaDetected);
            Boolean bothMediaDetected = (Boolean)this.multiPane.getStepProperty("BothMediaDetected");
            if (!bothMediaDetected.booleanValue()) {
                this.audioRB.setEnabled(false);
                this.videoRB.setEnabled(false);
                this.mediaTypeLabel.setEnabled(false);
            }
            repaint = true;
        }
        if (repaint) {
            this.repaint();
        }
        this.moveForward = true;
        this.updateButtonStates();
    }

    public void updateButtonStates() {
        this.multiPane.setButtonEnabled(2, true);
        this.multiPane.setButtonEnabled(1, this.moveForward);
    }

    private void checkInputFields() {
        this.moveForward = true;
        if (this.wrapBlocksCB.isSelected()) {
            if (this.numCharTF.getText() == null || this.numCharTF.getText().trim().length() <= 0) {
                this.charPerLineLabel.setForeground(Color.RED);
                this.moveForward = false;
            } else {
                this.charPerLineLabel.setForeground(Color.BLACK);
            }
        } else {
            this.charPerLineLabel.setForeground(Color.BLACK);
        }
        this.databaseErrorLabel.setText("");
        if (this.typeRB.isSelected()) {
            if (this.typField.getText() == null || this.typField.getText().trim().length() <= 0) {
                this.databaseErrorLabel.setText("- " + ElanLocale.getString("ImportDialog.Message.SpecifyType"));
                this.moveForward = false;
            }
        } else if (this.specRB.isSelected() && (this.dbTypField.getText() == null || this.dbTypField.getText().trim().length() <= 0)) {
            this.databaseErrorLabel.setText("- " + ElanLocale.getString("ExportShoebox.Message.NoType"));
            this.moveForward = false;
        }
        this.recordMarkerErrorLabel.setText("");
        if (this.customRMRB.isSelected() && (this.markerTF.getText() == null || this.markerTF.getText().trim().length() <= 0)) {
            this.recordMarkerErrorLabel.setText("- " + ElanLocale.getString("ExportShoebox.Message.NoRecordMarker"));
            this.moveForward = false;
        }
        if (this.mediaMarkerCB.isSelected() && (this.mediaMarkerNameTF.getText() == null || this.mediaMarkerNameTF.getText().trim().length() <= 0)) {
            if (this.recordMarkerErrorLabel.getText().trim().length() > 0) {
                this.recordMarkerErrorLabel.setText(this.recordMarkerErrorLabel.getText() + " " + ElanLocale.getString("ExportShoebox.Message.NoMediaMarker"));
            } else {
                this.recordMarkerErrorLabel.setText("- " + ElanLocale.getString("ExportShoebox.Message.NoMediaMarker"));
            }
            this.moveForward = false;
        }
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    public boolean leaveStepForward() {
        this.checkInputFields();
        if (!this.moveForward) {
            this.updateButtonStates();
            return false;
        }
        int charsPerLine = Integer.MAX_VALUE;
        if (this.wrapBlocksCB.isSelected()) {
            String textValue = this.numCharTF.getText().trim();
            try {
                charsPerLine = Integer.parseInt(textValue);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportShoebox.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
                this.numCharTF.selectAll();
                this.numCharTF.requestFocus();
                return false;
            }
        }
        String databaseType = null;
        if (this.typeRB.isSelected()) {
            File tf = new File(this.typField.getText());
            if (!tf.exists()) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ImportDialog.Message.NoType"), ElanLocale.getString("Message.Error"), 0);
                return false;
            }
            try {
                ShoeboxTypFile typFile = new ShoeboxTypFile(tf);
                databaseType = typFile.getDatabaseType();
            }
            catch (Exception typFile) {}
        } else {
            databaseType = this.dbTypField.getText();
        }
        int timeFormat = 1;
        if (this.hhMMSSMSFormatRB.isSelected()) {
            timeFormat = 0;
        }
        String recordMarker = null;
        recordMarker = this.customRMRB.isSelected() ? this.markerTF.getText().trim() : (this.defaultRMRB.isSelected() ? "block" : (this.recordMarkerList.size() == 1 ? this.recordMarkerList.get(0) : this.recordMarkerCB.getSelectedItem().toString()));
        this.multiPane.putStepProperty("CharsPerLine", charsPerLine);
        this.multiPane.putStepProperty("TimeFormat", timeFormat);
        this.multiPane.putStepProperty("CorrectTimes", this.correctTimesCB.isSelected());
        this.multiPane.putStepProperty("TypeFileSelected", this.typeRB.isSelected());
        this.multiPane.putStepProperty("DatabaseType", databaseType);
        this.multiPane.putStepProperty("WrapLines", this.wrapLinesCB.isSelected());
        this.multiPane.putStepProperty("WrapNextLine", this.wrapNextLineRB.isSelected());
        this.multiPane.putStepProperty("IncludeEmptyLines", this.includeEmptyLinesCB.isSelected());
        this.multiPane.putStepProperty("UseDetectedRecordMarker", this.detectedRMRB.isSelected());
        this.multiPane.putStepProperty("AppendFileNameWithRecordMarker", this.appendFileNameCB.isSelected());
        this.multiPane.putStepProperty("RecordMarker", recordMarker);
        this.multiPane.putStepProperty("IncludeMediaMarkerCB", this.mediaMarkerCB.isSelected());
        String mediaMarkerName = this.mediaMarkerNameTF.getText();
        if (mediaMarkerName != null) {
            this.multiPane.putStepProperty("MediaMarkerName", mediaMarkerName.trim());
        }
        this.multiPane.putStepProperty("AudiofileType", this.audioRB.isSelected());
        this.multiPane.putStepProperty("UseRelFilePath", this.relFilePathRB.isSelected());
        this.savePreferences();
        return true;
    }

    private void updateDetectedRecordMarker() {
        this.detectedRMRB.setEnabled(true);
        this.detectedRMRB.setSelected(true);
        if (this.recordMarkerList.size() == 1) {
            this.detectedRMRB.setText(this.detectedRMRB.getText() + " (\\" + this.recordMarkerList.get(0) + ")");
        } else if (this.recordMarkerList.size() > 1) {
            this.recordMarkerCB = new JComboBox();
            for (String marker : this.recordMarkerList) {
                this.recordMarkerCB.addItem(marker);
            }
            this.recordMarkerCB.setSelectedIndex(0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 2, 2, 2);
            this.toolboxOptionsPanel.add((Component)this.recordMarkerCB, gridBagConstraints);
        }
    }

    private void initOutputOptionsPanel() {
        this.outputOptionsPanel = new JPanel(new GridBagLayout());
        this.outputOptionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportDialog.Label.Options")));
        this.wrapBlocksCB = new JCheckBox(ElanLocale.getString("ExportShoebox.Label.WrapBlocks"));
        this.wrapBlocksCB.setSelected(true);
        this.wrapBlocksCB.addItemListener(this);
        this.charPerLineLabel = new JLabel(ElanLocale.getString("ExportShoebox.Label.NumberChars"));
        this.numCharTF = new JTextField(4);
        this.numCharTF.setEnabled(false);
        this.numCharTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        JLabel timeFormatLabel = new JLabel(ElanLocale.getString("ExportShoebox.Label.Format"));
        this.ssMSFormatRB = new JRadioButton(ElanLocale.getString("InterlinearizerOptionsDlg.TimeCodeFormat.Seconds"));
        this.ssMSFormatRB.setSelected(true);
        this.hhMMSSMSFormatRB = new JRadioButton(ElanLocale.getString("InterlinearizerOptionsDlg.TimeCodeFormat.TimeCode"));
        this.correctTimesCB = new JCheckBox(ElanLocale.getString("ExportDialog.CorrectTimes"));
        this.wrapLinesCB = new JCheckBox(ElanLocale.getString("ExportShoebox.Label.WrapLines"));
        this.wrapLinesCB.setSelected(true);
        this.wrapLinesCB.addItemListener(this);
        this.wrapNextLineRB = new JRadioButton(ElanLocale.getString("ExportShoebox.Label.WrapNextLine"));
        this.wrapNextLineRB.setSelected(true);
        this.wrapAfterBlockRB = new JRadioButton(ElanLocale.getString("ExportShoebox.Label.WrapEndOfBlock"));
        this.includeEmptyLinesCB = new JCheckBox(ElanLocale.getString("ExportShoebox.Label.IncludeEmpty"));
        this.includeEmptyLinesCB.setSelected(true);
        ButtonGroup timeGroup = new ButtonGroup();
        timeGroup.add(this.ssMSFormatRB);
        timeGroup.add(this.hhMMSSMSFormatRB);
        ButtonGroup wrapGroup = new ButtonGroup();
        wrapGroup.add(this.wrapNextLineRB);
        wrapGroup.add(this.wrapAfterBlockRB);
        JPanel wrapPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.innerInsets;
        wrapPanel.add((Component)this.wrapBlocksCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.leftVertIndent;
        wrapPanel.add((Component)this.numCharTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.vertInsets;
        wrapPanel.add((Component)this.charPerLineLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.innerInsets;
        wrapPanel.add((Component)this.wrapLinesCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.leftVertIndent;
        wrapPanel.add((Component)this.wrapNextLineRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.leftVertIndent;
        gridBagConstraints.gridwidth = 2;
        wrapPanel.add((Component)this.wrapAfterBlockRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        wrapPanel.add((Component)this.includeEmptyLinesCB, gridBagConstraints);
        JPanel timePanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.innerInsets;
        timePanel.add((Component)timeFormatLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.leftVertIndent;
        timePanel.add((Component)this.hhMMSSMSFormatRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.leftVertIndent;
        timePanel.add((Component)this.ssMSFormatRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.innerInsets;
        timePanel.add((Component)this.correctTimesCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.outputOptionsPanel.add((Component)wrapPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.outputOptionsPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        this.outputOptionsPanel.add((Component)timePanel, gridBagConstraints);
    }

    private void initToolboxOptionsPanel() {
        this.toolboxOptionsPanel = new JPanel(new GridBagLayout());
        this.toolboxOptionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportShoebox.Label.ToolboxOptions")));
        JLabel toolboxDBTypeLabel = new JLabel(ElanLocale.getString("ExportShoebox.Label.ToolboxBDName"));
        toolboxDBTypeLabel.setToolTipText("e.g. \\_sh v3.0  400 Text");
        this.databaseErrorLabel = new JLabel();
        this.databaseErrorLabel.setForeground(Color.RED);
        this.typeRB = new JRadioButton(ElanLocale.getString("ExportShoebox.Label.Type"));
        this.typeRB.setSelected(true);
        this.typField = new JTextField("", 23);
        this.typButton = new JButton("...");
        this.typButton.addActionListener(this);
        this.specRB = new JRadioButton(ElanLocale.getString("ExportShoebox.Label.SpecifyType"));
        this.dbTypField = new JTextField("", 14);
        JLabel recordMarkerLabel = new JLabel(ElanLocale.getString("ExportShoebox.Label.RecordMarker"));
        this.recordMarkerErrorLabel = new JLabel();
        this.recordMarkerErrorLabel.setForeground(Color.RED);
        this.detectedRMRB = new JRadioButton(ElanLocale.getString("ExportShoebox.Label.Detected"));
        this.detectedRMRB.setSelected(true);
        this.defaultRMRB = new JRadioButton(ElanLocale.getString("ExportShoebox.Label.DefaultMarker") + " (\\block)");
        this.customRMRB = new JRadioButton(ElanLocale.getString("ExportShoebox.Label.CustomMarker"));
        this.markerTF = new JTextField("", 6);
        this.markerTF.setEnabled(false);
        this.appendFileNameCB = new JCheckBox(ElanLocale.getString("MultiFileExportToolbox.AppendFileName"));
        this.mediaMarkerCB = new JCheckBox(ElanLocale.getString("ExportShoebox.Label.IncludeMediaMarker"));
        this.audioRB = new JRadioButton(ElanLocale.getString("MultiFileExportToolbox.useAudioFile"));
        this.audioRB.setSelected(true);
        this.audioRB.addItemListener(this);
        this.videoRB = new JRadioButton(ElanLocale.getString("MultiFileExportToolbox.useVideoFile"));
        this.videoRB.addItemListener(this);
        this.absFilePathRB = new JRadioButton(ElanLocale.getString("ExportShoebox.Label.AbsoluteMediaFile"));
        this.absFilePathRB.setSelected(true);
        this.relFilePathRB = new JRadioButton(ElanLocale.getString("ExportShoebox.Label.RelMediaFile"));
        this.mediaMarkerNameLabel = new JLabel(ElanLocale.getString("ExportShoebox.Label.MediaMarkerName"));
        this.mediaTypeLabel = new JLabel(ElanLocale.getString("MultiFileExportToolbox.SelectMediaType"));
        this.mediaMarkerNameTF = new JTextField("", 6);
        this.mediaMarkerNameTF.setEnabled(false);
        ButtonGroup mediaGroup = new ButtonGroup();
        mediaGroup.add(this.videoRB);
        mediaGroup.add(this.audioRB);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.typeRB);
        buttonGroup.add(this.specRB);
        ButtonGroup rmGroup = new ButtonGroup();
        rmGroup.add(this.detectedRMRB);
        rmGroup.add(this.defaultRMRB);
        rmGroup.add(this.customRMRB);
        ButtonGroup fileGroup = new ButtonGroup();
        fileGroup.add(this.absFilePathRB);
        fileGroup.add(this.relFilePathRB);
        int y = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = this.insets;
        this.toolboxOptionsPanel.add((Component)toolboxDBTypeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = this.vertInsets;
        gridBagConstraints.anchor = 18;
        this.toolboxOptionsPanel.add((Component)this.databaseErrorLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.leftVertIndent;
        this.toolboxOptionsPanel.add((Component)this.typeRB, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.vertInsets;
        this.toolboxOptionsPanel.add((Component)this.typField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.toolboxOptionsPanel.add((Component)this.typButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.insets = this.leftVertIndent;
        this.toolboxOptionsPanel.add((Component)this.specRB, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = this.vertInsets;
        this.toolboxOptionsPanel.add((Component)this.dbTypField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = this.insets;
        this.toolboxOptionsPanel.add((Component)recordMarkerLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = this.vertInsets;
        this.toolboxOptionsPanel.add((Component)this.recordMarkerErrorLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.leftVertIndent;
        this.toolboxOptionsPanel.add((Component)this.detectedRMRB, gridBagConstraints);
        gridBagConstraints.gridy = y++;
        this.toolboxOptionsPanel.add((Component)this.defaultRMRB, gridBagConstraints);
        gridBagConstraints.gridy = y++;
        this.toolboxOptionsPanel.add((Component)this.customRMRB, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = this.vertInsets;
        this.toolboxOptionsPanel.add((Component)this.markerTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.insets = this.leftVertIndent;
        this.toolboxOptionsPanel.add((Component)this.appendFileNameCB, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.insets = this.vertInsets;
        this.toolboxOptionsPanel.add((Component)this.mediaMarkerCB, gridBagConstraints);
        gridBagConstraints.gridy = y++;
        gridBagConstraints.insets = this.leftVertIndent;
        this.toolboxOptionsPanel.add((Component)this.mediaMarkerNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = this.vertInsets;
        this.toolboxOptionsPanel.add((Component)this.mediaMarkerNameTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.leftVertIndent;
        this.toolboxOptionsPanel.add((Component)this.mediaTypeLabel, gridBagConstraints);
        JPanel mediaPanel = new JPanel(new GridLayout(1, 2));
        mediaPanel.add(this.audioRB);
        mediaPanel.add(this.videoRB);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.insets = this.innerInsets;
        this.toolboxOptionsPanel.add((Component)mediaPanel, gridBagConstraints);
        JPanel fileNamePanel = new JPanel(new GridLayout(1, 2));
        fileNamePanel.add(this.absFilePathRB);
        fileNamePanel.add(this.relFilePathRB);
        gridBagConstraints.gridy = y;
        this.toolboxOptionsPanel.add((Component)fileNamePanel, gridBagConstraints);
    }

    private void setDefaultNumOfChars() {
        this.numCharTF.setEnabled(true);
        this.numCharTF.setBackground(Constants.SHAREDCOLOR4);
        if (this.numCharTF.getText() != null || this.numCharTF.getText().length() == 0) {
            this.numCharTF.setText("80");
        }
    }

    private void setShoeboxMarkerRB() {
        String stringPref = Preferences.getString("LastUsedShoeboxExport", null);
        if (stringPref == null || stringPref.equalsIgnoreCase("typ")) {
            this.typeRB.setSelected(true);
            String luTypFile = Preferences.getString("LastUsedShoeboxTypFile", null);
            if (luTypFile != null) {
                this.typField.setText(luTypFile);
            }
            this.enableTypComponents(true);
        } else {
            this.specRB.setSelected(true);
            this.enableTypComponents(false);
        }
    }

    private void enableTypComponents(boolean enable) {
        this.typField.setEnabled(enable);
        this.typButton.setEnabled(enable);
        this.dbTypField.setEnabled(!enable);
    }

    private void chooseTyp() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("ImportDialog.Title.Select"), 0, ElanLocale.getString("ImportDialog.Approve"), null, FileExtension.SHOEBOX_TYP_EXT, false, "LastUsedShoeboxTypDir", 0, null);
        File f = chooser.getSelectedFile();
        if (f != null) {
            this.typField.setText(f.getAbsolutePath());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.wrapBlocksCB) {
            if (this.wrapBlocksCB.isSelected()) {
                this.setDefaultNumOfChars();
                this.numCharTF.requestFocus();
                this.wrapLinesCB.setEnabled(true);
                this.wrapNextLineRB.setEnabled(this.wrapLinesCB.isSelected());
                this.wrapAfterBlockRB.setEnabled(this.wrapLinesCB.isSelected());
            } else {
                this.numCharTF.setEnabled(false);
                this.numCharTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
                this.wrapLinesCB.setEnabled(false);
                this.wrapNextLineRB.setEnabled(false);
                this.wrapAfterBlockRB.setEnabled(false);
            }
        } else if (ie.getSource() == this.wrapLinesCB) {
            this.wrapNextLineRB.setEnabled(this.wrapLinesCB.isSelected());
            this.wrapAfterBlockRB.setEnabled(this.wrapLinesCB.isSelected());
        } else if (ie.getSource() == this.typeRB) {
            this.enableTypComponents(true);
            this.checkInputFields();
            this.updateButtonStates();
        } else if (ie.getSource() == this.specRB) {
            this.enableTypComponents(false);
            this.checkInputFields();
            this.updateButtonStates();
            this.dbTypField.requestFocus();
        } else if (ie.getSource() == this.detectedRMRB || ie.getSource() == this.defaultRMRB) {
            this.markerTF.setEnabled(false);
        } else if (ie.getSource() == this.customRMRB) {
            this.markerTF.setEnabled(true);
            this.markerTF.requestFocus();
        } else if (ie.getSource() == this.mediaMarkerCB) {
            this.mediaMarkerNameTF.setEnabled(this.mediaMarkerCB.isSelected());
            this.absFilePathRB.setEnabled(this.mediaMarkerCB.isSelected());
            this.relFilePathRB.setEnabled(this.mediaMarkerCB.isSelected());
            this.audioRB.setEnabled(this.mediaMarkerCB.isSelected());
            this.videoRB.setEnabled(this.mediaMarkerCB.isSelected());
            this.mediaTypeLabel.setEnabled(this.mediaMarkerCB.isSelected());
            this.mediaMarkerNameLabel.setEnabled(this.mediaMarkerCB.isSelected());
        }
        this.updateButtonStates();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.typButton) {
            this.chooseTyp();
            this.typeRB.setSelected(true);
        }
    }

    private void loadPreferences() {
        String stringPref;
        Boolean boolPref = Preferences.getBool("ExportToolbox.WrapBlocks", null);
        if (boolPref != null) {
            this.wrapBlocksCB.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString("ExportShoebox.numCharTF", null)) != null) {
            this.numCharTF.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool("ExportShoebox.wrapLinesCB", null)) != null) {
            this.wrapLinesCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportToolbox.wrapNextLineRB", null)) != null) {
            this.wrapNextLineRB.setSelected(boolPref);
            this.wrapAfterBlockRB.setSelected(boolPref == false);
        }
        if ((boolPref = Preferences.getBool("ExportToolbox.includeEmptyLinesCB", null)) != null) {
            this.includeEmptyLinesCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportToolbox.ssMSFormatRB", null)) != null) {
            this.ssMSFormatRB.setSelected(boolPref);
            this.hhMMSSMSFormatRB.setSelected(boolPref == false);
        }
        if ((boolPref = Preferences.getBool("ExportToolbox.correctTimesCB", null)) != null) {
            this.correctTimesCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportToolbox.detectedRMRB", null)) != null) {
            this.detectedRMRB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportToolbox.defaultRMRB", null)) != null) {
            this.defaultRMRB.setSelected(boolPref);
        }
        if (this.defaultRMRB.isSelected() || this.detectedRMRB.isSelected()) {
            this.customRMRB.setSelected(false);
        } else {
            this.customRMRB.setSelected(true);
        }
        boolPref = Preferences.getBool("ExportToolbox.AppendFileNameToRecordMarker", null);
        if (boolPref != null) {
            this.appendFileNameCB.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString("ExportToolbox.markerTF", null)) != null) {
            this.markerTF.setText(stringPref);
        }
        if ((stringPref = Preferences.getString("ExportToolbox.ManualDBName", null)) != null) {
            this.dbTypField.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool("ExportToolbox.exportMediaMarker", null)) != null) {
            this.mediaMarkerCB.setSelected(boolPref);
            this.mediaMarkerNameTF.setEnabled(this.mediaMarkerCB.isSelected());
            this.absFilePathRB.setEnabled(this.mediaMarkerCB.isSelected());
            this.relFilePathRB.setEnabled(this.mediaMarkerCB.isSelected());
            this.audioRB.setEnabled(this.mediaMarkerCB.isSelected());
            this.videoRB.setEnabled(this.mediaMarkerCB.isSelected());
            this.mediaTypeLabel.setEnabled(this.mediaMarkerCB.isSelected());
            this.mediaMarkerNameLabel.setEnabled(this.mediaMarkerCB.isSelected());
        }
        if ((stringPref = Preferences.getString("ExportToolbox.mediaMarkerName", null)) != null) {
            this.mediaMarkerNameTF.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool("ExportToolbox.absoluteMediaFileName", null)) != null) {
            this.absFilePathRB.setSelected(boolPref);
            this.relFilePathRB.setSelected(boolPref == false);
        }
        if ((boolPref = Preferences.getBool("ExportToolbox.useAudioFile", null)) != null) {
            this.videoRB.setSelected(boolPref);
            this.videoRB.setSelected(boolPref == false);
        }
    }

    private void savePreferences() {
        Preferences.set("ExportToolbox.WrapBlocks", this.wrapBlocksCB.isSelected(), null);
        Preferences.set("ExportToolbox.CharacterPerBlocks", this.numCharTF.getText(), null);
        Preferences.set("ExportToolbox.wrapLinesCB", this.wrapLinesCB.isSelected(), null);
        Preferences.set("ExportToolbox.wrapNextLineRB", this.wrapNextLineRB.isSelected(), null);
        Preferences.set("ExportToolbox.includeEmptyLinesCB", this.includeEmptyLinesCB.isSelected(), null);
        Preferences.set("ExportToolbox.ssMSFormatRB", this.ssMSFormatRB.isSelected(), null);
        Preferences.set("ExportToolbox.correctTimesCB", this.correctTimesCB.isSelected(), null);
        Preferences.set("ExportToolbox.detectedRMRB", this.detectedRMRB.isSelected(), null);
        Preferences.set("ExportToolbox.defaultRMRB", this.defaultRMRB.isSelected(), null);
        Preferences.set("ExportToolbox.markerTF", this.markerTF.getText(), null);
        Preferences.set("ExportToolbox.AppendFileNameToRecordMarker", this.appendFileNameCB.isSelected(), null);
        if (this.specRB.isSelected()) {
            Preferences.set("ExportToolbox.ManualDBName", this.dbTypField.getText(), null);
        }
        Preferences.set("ExportToolbox.exportMediaMarker", this.mediaMarkerCB.isSelected(), null);
        if (this.mediaMarkerCB.isSelected()) {
            Preferences.set("ExportToolbox.mediaMarkerName", this.mediaMarkerNameTF.getText(), null);
            Preferences.set("ExportToolbox.absoluteMediaFileName", this.absFilePathRB.isSelected(), null);
            if (this.audioRB != null) {
                Preferences.set("ExportToolbox.useAudioFile", this.audioRB.isSelected(), null);
            }
        }
        if (this.typeRB.isSelected()) {
            Preferences.set("LastUsedShoeboxExport", "typ", null);
            Preferences.set("LastUsedShoeboxTypFile", this.typField.getText(), null);
        } else {
            Preferences.set("LastUsedShoeboxExport", "", null);
        }
    }

    private class TextFieldHandler
    implements KeyListener {
        private TextFieldHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            MultipleFileToolBoxExportStep2.this.checkInputFields();
            MultipleFileToolBoxExportStep2.this.updateButtonStates();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            MultipleFileToolBoxExportStep2.this.checkInputFields();
            MultipleFileToolBoxExportStep2.this.updateButtonStates();
        }
    }
}

