/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export.multiplefiles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.export.multiplefiles.AbstractMultiFileExportProgessStepPane;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.interlinear.ToolboxEncoder;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxEncoderInfo;

public class MultipleFileToolBoxExportStep4
extends AbstractMultiFileExportProgessStepPane {
    private int charsPerLine;
    private int timeFormat;
    private boolean correctTimes;
    private boolean typeFileSelected;
    private String databaseType;
    private boolean wrapLines;
    private boolean wrapNextLine;
    private boolean includeEmptyLines;
    private boolean appendFileName;
    private String recordMarker;
    private Map<String, String> recordMarkerMap;
    private boolean useDetectedRecordMarker = false;
    private List<String> markersWithBlankLinesList;
    private boolean includeMediaMarker;
    private String mediaMarkerName;
    private boolean useAudioFile = false;
    private boolean useRelFilePath;
    private ToolboxEncoderInfo tbEncoderInfo;
    private Map<String, List<String>> tierMap;
    private final String elanBeginLabel = "ELANBegin";
    private final String elanEndLabel = "ELANEnd";
    private final String elanParticipantLabel = "ELANParticipant";

    public MultipleFileToolBoxExportStep4(MultiStepPane multiPane) {
        super(multiPane);
    }

    @Override
    public void enterStepForward() {
        this.charsPerLine = (Integer)this.multiPane.getStepProperty("CharsPerLine");
        this.timeFormat = (Integer)this.multiPane.getStepProperty("TimeFormat");
        this.correctTimes = (Boolean)this.multiPane.getStepProperty("CorrectTimes");
        this.typeFileSelected = (Boolean)this.multiPane.getStepProperty("TypeFileSelected");
        this.databaseType = (String)this.multiPane.getStepProperty("DatabaseType");
        this.wrapLines = (Boolean)this.multiPane.getStepProperty("WrapLines");
        this.wrapNextLine = (Boolean)this.multiPane.getStepProperty("WrapNextLine");
        this.includeEmptyLines = (Boolean)this.multiPane.getStepProperty("IncludeEmptyLines");
        this.appendFileName = (Boolean)this.multiPane.getStepProperty("AppendFileNameWithRecordMarker");
        this.recordMarker = (String)this.multiPane.getStepProperty("RecordMarker");
        this.recordMarkerMap = (Map)this.multiPane.getStepProperty("RecordMarkersMap");
        this.useDetectedRecordMarker = (Boolean)this.multiPane.getStepProperty("UseDetectedRecordMarker");
        this.tierMap = (Map)this.multiPane.getStepProperty("TierListMap");
        this.markersWithBlankLinesList = (List)this.multiPane.getStepProperty("");
        this.includeMediaMarker = (Boolean)this.multiPane.getStepProperty("IncludeMediaMarkerCB");
        this.mediaMarkerName = (String)this.multiPane.getStepProperty("MediaMarkerName");
        if (this.multiPane.getStepProperty("AudiofileType") != null) {
            this.useAudioFile = (Boolean)this.multiPane.getStepProperty("AudiofileType");
        }
        this.useRelFilePath = (Boolean)this.multiPane.getStepProperty("UseRelFilePath");
        super.enterStepForward();
    }

    @Override
    protected boolean doExport(TranscriptionImpl transcription, String fileName) {
        if (this.tbEncoderInfo == null) {
            this.initilaizeToolboxEncoderInfo();
        }
        if (this.correctTimes) {
            List<MediaDescriptor> mds = transcription.getMediaDescriptors();
            if (mds != null && !mds.isEmpty()) {
                long mediaOffset = mds.get((int)0).timeOrigin;
                this.tbEncoderInfo.setTimeOffset(mediaOffset);
            } else {
                this.tbEncoderInfo.setTimeOffset(0L);
            }
        }
        if (this.includeMediaMarker) {
            String mediaFileName = this.getMediaFileName(transcription);
            if (mediaFileName != null) {
                this.tbEncoderInfo.setIncludeMediaMarker(true);
                this.tbEncoderInfo.setMediaMarker(this.mediaMarkerName);
                this.tbEncoderInfo.setMediaFileName(mediaFileName);
            } else {
                this.tbEncoderInfo.setIncludeMediaMarker(false);
                this.tbEncoderInfo.setMediaMarker(null);
                this.tbEncoderInfo.setMediaFileName(null);
            }
        }
        String oriFilePath = FileUtility.urlToAbsPath(transcription.getFullPath());
        Object recordMarkerForThisFile = this.recordMarker;
        if (this.useDetectedRecordMarker && (recordMarkerForThisFile = this.recordMarkerMap.get(oriFilePath)) == null) {
            recordMarkerForThisFile = this.recordMarker;
        }
        if (this.appendFileName) {
            String file = FileUtility.fileNameFromPath(fileName);
            file = file.substring(0, file.indexOf(46));
            recordMarkerForThisFile = (String)recordMarkerForThisFile + " " + file;
        }
        this.tbEncoderInfo.setRecordMarker((String)recordMarkerForThisFile);
        ArrayList<String> selectedTiersInThisTrans = new ArrayList<String>();
        List<String> tierInThisTrans = this.tierMap.get(oriFilePath);
        if (tierInThisTrans != null) {
            for (String tierName : this.selectedTiers) {
                if (tierInThisTrans.contains(tierName)) {
                    selectedTiersInThisTrans.add(tierName);
                    continue;
                }
                if (!tierName.equals("ELANBegin") && !tierName.equals("ELANEnd") && !tierName.equals("ELANParticipant")) continue;
                selectedTiersInThisTrans.add(tierName);
            }
        }
        if (recordMarkerForThisFile != null && selectedTiersInThisTrans.contains(recordMarkerForThisFile) && !((String)selectedTiersInThisTrans.get(0)).equals(recordMarkerForThisFile)) {
            selectedTiersInThisTrans.remove(recordMarkerForThisFile);
            selectedTiersInThisTrans.add(0, (String)recordMarkerForThisFile);
        }
        this.tbEncoderInfo.setOrderedVisibleTiers(selectedTiersInThisTrans);
        if (fileName != null) {
            try {
                ToolboxEncoder encoder = new ToolboxEncoder();
                encoder.encodeAndSave(transcription, this.tbEncoderInfo, transcription.getTiersWithIds(selectedTiersInThisTrans), fileName);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error") + "\n(" + ioe.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
            }
        }
        return true;
    }

    private void initilaizeToolboxEncoderInfo() {
        int markerSource = 2;
        if (this.typeFileSelected) {
            markerSource = 0;
        }
        this.tbEncoderInfo = new ToolboxEncoderInfo(this.charsPerLine, markerSource, this.timeFormat);
        this.tbEncoderInfo.setCorrectAnnotationTimes(this.correctTimes);
        if (this.databaseType != null) {
            this.tbEncoderInfo.setDatabaseType(this.databaseType);
        }
        if (this.charsPerLine != Integer.MAX_VALUE) {
            this.tbEncoderInfo.setWrapLines(this.wrapLines);
            if (this.wrapLines) {
                if (this.wrapNextLine) {
                    this.tbEncoderInfo.setLineWrapStyle(4);
                } else {
                    this.tbEncoderInfo.setLineWrapStyle(5);
                }
            } else {
                this.tbEncoderInfo.setLineWrapStyle(3);
            }
        } else {
            this.tbEncoderInfo.setWrapLines(false);
            this.tbEncoderInfo.setLineWrapStyle(3);
        }
        this.tbEncoderInfo.setIncludeEmptyMarkers(this.includeEmptyLines);
        this.tbEncoderInfo.setMarkersWithBlankLines(this.markersWithBlankLinesList);
    }

    private String getMediaFileName(TranscriptionImpl trans) {
        String mediaFileName = null;
        List<MediaDescriptor> mds = trans.getMediaDescriptors();
        if (mds != null && mds.size() > 0) {
            if (mds.size() == 1) {
                mediaFileName = mds.get((int)0).mediaURL;
            } else {
                MediaDescriptor md = null;
                for (int i = 0; i < mds.size(); ++i) {
                    md = mds.get(i);
                    String type = md.mimeType;
                    if (type == null) continue;
                    if (this.useAudioFile) {
                        if (!type.equals("audio/x-wav") && !type.equals("audio/*")) continue;
                        mediaFileName = md.mediaURL;
                        break;
                    }
                    if (!MediaDescriptorUtil.isVideoType(md)) continue;
                    mediaFileName = md.mediaURL;
                    break;
                }
            }
        }
        if (mediaFileName != null) {
            if (this.useRelFilePath) {
                mediaFileName = FileUtility.fileNameFromPath(mediaFileName);
            } else {
                String fileURL = FileUtility.urlToAbsPath(mediaFileName);
                int numSlash = 0;
                for (int j = 0; j < fileURL.length() && fileURL.charAt(j) == '/'; ++j) {
                    ++numSlash;
                }
                if (numSlash != 0 && numSlash != 2) {
                    fileURL = fileURL.substring(numSlash);
                }
                mediaFileName = fileURL.replace('/', '\\');
            }
        }
        return mediaFileName;
    }
}

