/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.grid;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.grid.AbstractGridViewer;
import mpi.eudico.client.annotator.grid.AnnotationTable;
import mpi.eudico.client.annotator.grid.GridEditor;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;

public abstract class AbstractEditableGridViewer
extends AbstractGridViewer
implements ACMEditListener {
    protected GridEditor gridEditor;

    public AbstractEditableGridViewer(AnnotationTable table) {
        super(table);
    }

    @Override
    protected void initTable() {
        super.initTable();
        this.gridEditor = new GridEditor(this, this.dataModel);
        this.table.setDefaultEditor(Object.class, this.gridEditor);
    }

    @Override
    public void updateActiveAnnotation() {
        if (this.dataModel.getRowCount() == 0) {
            return;
        }
        this.repaint();
        if (this.getActiveAnnotation() != null) {
            this.doUpdate();
        }
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        if (this.dataModel.getRowCount() == 0) {
            return;
        }
        switch (e.getOperation()) {
            case 7: {
                this.repaint();
                break;
            }
            case 8: {
                this.repaint();
                break;
            }
            default: {
                this.repaint();
            }
        }
    }

    protected void updateDataModel(List<? extends AnnotationCore> annotations) {
        this.gridEditor.cancelCellEditing();
        if (annotations != null) {
            this.dataModel.updateAnnotations(annotations);
        }
    }

    @Override
    public void updateLocale() {
        this.gridEditor.updateLocale();
        super.updateLocale();
    }

    @Override
    public void preferencesChanged() {
        TranscriptionImpl transcription = (TranscriptionImpl)this.getViewerManager().getTranscription();
        Map<String, ?> cvPrefObj = Preferences.getMap("CV.ML.Prefs", transcription);
        if (cvPrefObj != null) {
            HashMap<String, String> CV2TierMap = new HashMap<String, String>();
            HashMap<String, Map<String, Color>> colMap = new HashMap<String, Map<String, Color>>();
            List<TierImpl> tiers = transcription.getTiers();
            for (int i = 0; i < tiers.size(); ++i) {
                HashMap<String, Color> eMap;
                String cvName;
                TierImpl t = tiers.get(i);
                LinguisticType linguisticType = t.getLinguisticType();
                if (linguisticType == null || (cvName = linguisticType.getControlledVocabularyName()) == null) continue;
                if (CV2TierMap.get(cvName) != null) {
                    eMap = (HashMap<String, Color>)colMap.get(CV2TierMap.get(cvName));
                    colMap.put(t.getName(), eMap);
                    continue;
                }
                ControlledVocabulary cv = transcription.getControlledVocabulary(cvName);
                if (cv == null) continue;
                eMap = new HashMap<String, Color>();
                for (CVEntry cve : cv) {
                    if (cve.getPrefColor() == null) continue;
                    eMap.put(cve.getId(), cve.getPrefColor());
                }
                colMap.put(t.getName(), eMap);
                CV2TierMap.put(cvName, t.getName());
            }
            this.table.setColorsForAnnotations(colMap);
        }
    }
}

