/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.util.FavoriteColorPanel;

public class ColorDialog {
    private Component parent;
    private Color oldColor;
    final JColorChooser chooser;
    private AbstractAction aa;
    private Map<String, Color> oldColors = null;
    private FavoriteColorPanel fcp;

    public ColorDialog(Component parent, Color oldColor) {
        this.parent = parent;
        this.oldColor = oldColor;
        this.chooser = new JColorChooser(oldColor);
        AbstractColorChooserPanel[] panels = this.chooser.getChooserPanels();
        AbstractColorChooserPanel[] panels2 = new AbstractColorChooserPanel[panels.length + 1];
        this.fcp = new FavoriteColorPanel();
        panels2[0] = this.fcp;
        for (int i = 0; i < panels.length; ++i) {
            panels2[i + 1] = panels[i];
        }
        this.chooser.setChooserPanels(panels2);
        this.oldColors = Preferences.getMapOfColor("FavoriteColors", null);
        if (this.oldColors != null) {
            Color[] favColors = this.fcp.getColors();
            for (Map.Entry<String, Color> e : this.oldColors.entrySet()) {
                String key = e.getKey();
                Color val = e.getValue();
                try {
                    int index = Integer.valueOf(key);
                    if (index >= favColors.length) continue;
                    favColors[index] = val;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        this.aa = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.putValue("Default", ColorDialog.this.chooser.getColor());
            }
        };
    }

    public Color chooseColor() {
        JDialog cd = JColorChooser.createDialog(this.parent, ElanLocale.getString("ColorChooser.Title"), true, this.chooser, this.aa, null);
        cd.setVisible(true);
        HashMap<String, Color> colMap = new HashMap<String, Color>();
        Color[] colors = this.fcp.getColors();
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i] == null) continue;
            colMap.put(String.valueOf(i), colors[i]);
        }
        if (colMap.size() > 0 || this.oldColors != null) {
            Preferences.set("FavoriteColors", colMap, null);
        }
        Color newColor = (Color)this.aa.getValue("Default");
        return newColor;
    }
}

