/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Dialog;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import mpi.eudico.client.annotator.gui.AbstractEditLanguagesDialog;
import mpi.eudico.client.annotator.prefs.gui.RecentLanguagesBox;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.multilangcv.LangInfo;

public class EditCVLanguagesDialog
extends AbstractEditLanguagesDialog
implements ActionListener {
    private ControlledVocabulary cv;

    public EditCVLanguagesDialog(Dialog parent, ControlledVocabulary cv) {
        super(parent, "EditCVLanguagesDialog");
        this.cv = cv;
        this.updateBoxes();
    }

    @Override
    protected void updateButtons() {
        this.deleteButton.setEnabled(this.getNumberOfLanguages() > 1);
        boolean adding = this.getNumberOfLanguages() > 1 || !this.getLongLanguageId(0).equals("http://cdb.iso.org/lg/CDB-00130975-001");
        this.addButton.setEnabled(adding);
    }

    @Override
    protected JComboBox getNewLanguageComboBox() {
        return new RecentLanguagesBox("");
    }

    @Override
    protected void updateNewLanguageComboBox() {
        this.newLanguageComboBox.setSelectedIndex(this.getIdIndex(this.getLongLanguageId(0)));
        this.newLanguageComboBox.setEditable(false);
    }

    @Override
    int addLanguage(String s, String l, String lab) {
        return this.cv.addLanguage(s, l, lab);
    }

    @Override
    void removeLanguage(int index) {
        this.cv.removeLanguage(index);
    }

    @Override
    boolean setLanguageIds(int index, String s, String l, String lab) {
        return this.cv.setLanguageIds(index, s, l, lab);
    }

    @Override
    int getNumberOfLanguages() {
        return this.cv.getNumberOfLanguages();
    }

    @Override
    LangInfo getLangInfo(int index) {
        return this.cv.getLangInfo(index);
    }
}

