/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;

public class ElanSlider
extends JComponent
implements ElanLocaleListener {
    private JSlider slider;
    private JTextField tfValue;
    private JLabel namelabel;
    private int min;
    private int max;
    private int initvalue;
    private String name;
    private ViewerManager2 vm;
    private List<Character> allowedList;

    public ElanSlider() {
        this.slider = new JSlider();
        this.init();
    }

    public ElanSlider(String name, int min, int max, int initvalue, ViewerManager2 theVM) {
        this.min = min;
        this.max = max;
        this.initvalue = initvalue;
        this.name = name;
        this.vm = theVM;
        this.slider = new JSlider(min, max, initvalue);
        this.init();
    }

    private void init() {
        this.namelabel = new JLabel(this.name + ": ");
        this.tfValue = new JTextField("" + this.initvalue);
        this.tfValue.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.tfValue.getActionMap().put("check", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean bGoodValue = true;
                String str = ElanSlider.this.tfValue.getText();
                List vecAllowed = ElanSlider.this.getAllowed();
                if (!str.equals("")) {
                    int str_length = str.length();
                    for (int i = 0; i < str_length; ++i) {
                        Character objChar = new Character(str.charAt(i));
                        if (vecAllowed.contains(objChar)) continue;
                        bGoodValue = false;
                        break;
                    }
                    if (bGoodValue) {
                        int intValue = Integer.parseInt(str);
                        if (intValue > ElanSlider.this.max) {
                            ElanSlider.this.handleInputError();
                        } else {
                            ElanSlider.this.slider.setSnapToTicks(false);
                            ElanSlider.this.slider.setValue(intValue);
                            ElanSlider.this.slider.setSnapToTicks(true);
                        }
                    } else {
                        ElanSlider.this.handleInputError();
                    }
                }
            }
        });
        this.tfValue.setText("" + this.initvalue);
        String maxString = String.valueOf(this.max);
        Dimension si = new Dimension(10 * (maxString.length() + 1), 20);
        this.tfValue.setMinimumSize(si);
        this.tfValue.setPreferredSize(si);
        this.slider.setMajorTickSpacing(this.max / 2);
        this.slider.setMinorTickSpacing((this.max - this.min) / 20);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setSnapToTicks(true);
        if (this.vm != null) {
            ElanLocale.addElanLocaleListener(this.vm.getTranscription(), this);
        }
        this.updateLocale();
        this.slider.addChangeListener(new ElanSliderChangeListener(this));
        this.initComponents();
    }

    private void handleInputError() {
        Toolkit.getDefaultToolkit().beep();
        this.tfValue.selectAll();
    }

    private List<Character> getAllowed() {
        if (this.allowedList == null) {
            this.allowedList = new ArrayList<Character>(10);
            this.allowedList.add(new Character('1'));
            this.allowedList.add(new Character('2'));
            this.allowedList.add(new Character('3'));
            this.allowedList.add(new Character('4'));
            this.allowedList.add(new Character('5'));
            this.allowedList.add(new Character('6'));
            this.allowedList.add(new Character('7'));
            this.allowedList.add(new Character('8'));
            this.allowedList.add(new Character('9'));
            this.allowedList.add(new Character('0'));
        }
        return this.allowedList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setNameLabel(String strName) {
        this.namelabel.setText(strName + ": ");
    }

    public int getValue() {
        return this.slider.getValue();
    }

    public void setValue(int value) {
        this.slider.setValue(value);
    }

    public int getTextFieldValue() {
        int v = this.slider.getValue();
        try {
            v = Integer.parseInt(this.tfValue.getText());
        }
        catch (NumberFormatException nfe) {
            System.out.println("Play around selection: invalid input");
        }
        return v;
    }

    public void placeComponents() {
        this.validate();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.ipady = 5;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        this.add((Component)this.namelabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets;
        this.add((Component)this.tfValue, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        this.add((Component)this.slider, gbc);
    }

    private void updateSlider(ElanSlider elanslider, int value) {
        String name = elanslider.getName();
        if (name != null) {
            if (name.equals("ELANSLIDERRATE")) {
                this.vm.getMasterMediaPlayer().setRate((float)value / 100.0f);
                Preferences.set("MediaControlRate", new Float((float)value / 100.0f), this.vm.getTranscription(), false, false);
            } else if (name.equals("ELANSLIDERVOLUME")) {
                this.vm.getVolumeManager().setMasterVolume((float)value / 100.0f);
                Preferences.set("MediaControlVolume", new Float((float)value / 100.0f), this.vm.getTranscription(), false, false);
            }
        }
    }

    @Override
    public void updateLocale() {
        if (this.name.equals("ELANSLIDERRATE")) {
            this.setNameLabel(ElanLocale.getString("MediaPlayerControlPanel.ElanSlider.Rate"));
        } else if (this.name.equals("ELANSLIDERVOLUME")) {
            this.setNameLabel(ElanLocale.getString("MediaPlayerControlPanel.ElanSlider.Volume"));
        }
    }

    private class ElanSliderComponentListener
    implements ComponentListener {
        ElanSlider slider;

        ElanSliderComponentListener(ElanSlider slider) {
            this.slider = slider;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.slider.placeComponents();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    private class ElanSliderChangeListener
    implements ChangeListener {
        ElanSlider elanslider;

        ElanSliderChangeListener(ElanSlider elanslider) {
            this.elanslider = elanslider;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int value = ((JSlider)e.getSource()).getValue();
            if (!"ELANSLIDERRATE".equals(this.elanslider.getName())) {
                ElanSlider.this.updateSlider(this.elanslider, value);
            } else if (!ElanSlider.this.slider.getValueIsAdjusting()) {
                ElanSlider.this.updateSlider(this.elanslider, value);
            }
            ElanSlider.this.tfValue.setText("" + value);
        }
    }
}

