/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.tier.TierExportTable;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.annotator.util.FileExtension;

public class ExportExternalCVDialog
extends JDialog
implements ActionListener,
TableModelListener {
    private String exportFilePath;
    private List<String> cvExportList;
    private JButton okButton;
    private JButton cancelButton;
    private JTable exportTable;
    private TierExportTableModel model;
    private final String EXPORT_COLUMN = "export";
    private final String CV_NAME_COLUMN = "cv";

    public ExportExternalCVDialog(Dialog owner, List<String> cvList) {
        super(owner, ElanLocale.getString("ExportExternalCVDialog.Title"), true);
        this.initComponents(cvList);
        this.postInit();
    }

    private void initComponents(List<String> cvList) {
        this.cvExportList = new ArrayList<String>();
        this.model = new TierExportTableModel();
        this.model.setColumnIdentifiers(new String[]{"export", "cv"});
        this.model.addTableModelListener(this);
        this.exportTable = new TierExportTable(this.model);
        for (String cv : cvList) {
            this.model.addRow(Boolean.FALSE, cv);
        }
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        JLabel titleLabel = new JLabel();
        titleLabel.setText(ElanLocale.getString("ExportExternalCVDialog.Title"));
        titleLabel.setFont(titleLabel.getFont().deriveFont(16.0f));
        titleLabel.setHorizontalAlignment(0);
        JPanel linkPanel = new JPanel(new GridBagLayout());
        linkPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportExternalCVDialog.Label.SelectCV")));
        JScrollPane scrollpane = new JScrollPane(this.exportTable);
        scrollpane.setPreferredSize(new Dimension(300, 100));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        linkPanel.add((Component)scrollpane, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)titleLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)linkPanel, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.okButton = new JButton();
        this.okButton.setEnabled(false);
        this.okButton.setText(ElanLocale.getString("Button.OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.anchor = 15;
        gbc.insets = insets;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ExportExternalCVDialog.this.doClose();
            }
        });
    }

    private void postInit() {
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            int includeCol = this.model.findColumn("export");
            boolean enabled = false;
            int rowCount = this.model.getRowCount();
            for (int index = 0; index < rowCount; ++index) {
                if (!((Boolean)this.model.getValueAt(index, includeCol)).booleanValue()) continue;
                enabled = true;
                break;
            }
            this.okButton.setEnabled(enabled);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            File file = this.getExportFile();
            if (file != null) {
                this.exportFilePath = file.getAbsolutePath();
                this.cvExportList = this.model.getSelectedTiers();
            } else {
                this.exportFilePath = null;
                this.cvExportList.clear();
            }
            this.doClose();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.exportFilePath = null;
            this.cvExportList.clear();
            this.doClose();
        }
    }

    public String getExportFilePath() {
        return this.exportFilePath;
    }

    public List<String> getCVList() {
        return this.cvExportList;
    }

    private File getExportFile() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("ExportExternalCVDialog.Title"), 1, FileExtension.ECV_EXT, "ExternalCVDir");
        return chooser.getSelectedFile();
    }
}

