/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FontSizer;
import mpi.eudico.client.annotator.Zoomable;

public class FontSizePanel
extends JPanel
implements ActionListener,
Zoomable {
    private FontSizer fontSizer;
    private JLabel fontLabel;
    private JButton plusButton;
    private JButton minusButton;
    private int defaultFontSize = Constants.DEFAULTFONT.getSize();

    public FontSizePanel(FontSizer fontSizer) {
        this.fontSizer = fontSizer;
        this.initComponents();
    }

    private void initComponents() {
        ImageIcon icon;
        this.setLayout(new GridBagLayout());
        this.fontLabel = new JLabel();
        this.plusButton = new JButton();
        this.minusButton = new JButton();
        try {
            icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Plus16.gif"));
            this.plusButton.setIcon(icon);
        }
        catch (Throwable t) {
            this.plusButton.setText("+");
        }
        try {
            icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Minus16.gif"));
            this.minusButton.setIcon(icon);
        }
        catch (Throwable t) {
            this.minusButton.setText("-");
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.fontLabel, gbc);
        gbc.gridx = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.add((Component)this.minusButton, gbc);
        gbc.gridx = 2;
        this.add((Component)this.plusButton, gbc);
        this.updateLocale();
        this.plusButton.addActionListener(this);
        this.minusButton.addActionListener(this);
    }

    public void updateLocale() {
        this.updateFontLabel(this.defaultFontSize);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.plusButton) {
            this.zoomInStep();
        } else if (e.getSource() == this.minusButton) {
            this.zoomOutStep();
        }
    }

    private int getFontIndex(int fontSize) {
        int i;
        int index = -1;
        for (i = 0; i < Constants.FONT_SIZES.length; ++i) {
            if (fontSize != Constants.FONT_SIZES[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            for (i = 0; i < Constants.FONT_SIZES.length - 1; ++i) {
                if (fontSize <= Constants.FONT_SIZES[i] || fontSize >= Constants.FONT_SIZES[i + 1]) continue;
                int dif1 = fontSize - Constants.FONT_SIZES[i];
                int dif2 = Constants.FONT_SIZES[i + 1] - fontSize;
                if (i <= Constants.FONT_SIZES.length / 2) {
                    index = i + 1;
                    break;
                }
                if (dif1 <= dif2) {
                    index = i;
                    break;
                }
                index = i + 1;
                break;
            }
        }
        return index;
    }

    private void updateFontLabel(int size) {
        this.fontLabel.setText(ElanLocale.getString("Menu.View.FontSize") + ": " + size);
    }

    public void setFontSize(int fontSize) {
        this.fontSizer.setFontSize(fontSize);
        this.updateFontLabel(fontSize);
        if (fontSize == Constants.FONT_SIZES[Constants.FONT_SIZES.length - 1]) {
            this.plusButton.setEnabled(false);
        }
        if (fontSize == Constants.FONT_SIZES[0]) {
            this.minusButton.setEnabled(false);
        }
    }

    @Override
    public void zoomInStep() {
        int index = this.getFontIndex(this.fontSizer.getFontSize());
        if (++index < Constants.FONT_SIZES.length) {
            this.fontSizer.setFontSize(Constants.FONT_SIZES[index]);
            this.updateFontLabel(Constants.FONT_SIZES[index]);
        }
        if (index == Constants.FONT_SIZES.length - 1) {
            this.plusButton.setEnabled(false);
        }
        this.minusButton.setEnabled(true);
    }

    @Override
    public void zoomOutStep() {
        int index = this.getFontIndex(this.fontSizer.getFontSize());
        if (--index >= 0) {
            this.fontSizer.setFontSize(Constants.FONT_SIZES[index]);
            this.updateFontLabel(Constants.FONT_SIZES[index]);
        }
        if (index == 0) {
            this.minusButton.setEnabled(false);
        }
        this.plusButton.setEnabled(true);
    }

    @Override
    public void zoomToDefault() {
        this.fontSizer.setFontSize(this.defaultFontSize);
        this.updateFontLabel(this.defaultFontSize);
        this.plusButton.setEnabled(true);
        this.minusButton.setEnabled(true);
    }
}

