/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.util.TimeFormatter;

public class FormattedMessageDlg {
    private JLabel label;

    public FormattedMessageDlg(String[][] mes) {
        this.showMessage(null, mes);
    }

    public FormattedMessageDlg(ElanMediaPlayer player) {
        String[][] mes = this.createMediaInfo(player);
        this.showMessage(player, mes);
    }

    private String[][] createMediaInfo(ElanMediaPlayer player) {
        if (player == null || player.getMediaDescriptor() == null) {
            return null;
        }
        String[][] info = new String[6][2];
        info[0][0] = ElanLocale.getString("LinkedFilesDialog.Label.MediaURL");
        info[0][1] = player.getMediaDescriptor().mediaURL;
        info[1][0] = ElanLocale.getString("LinkedFilesDialog.Label.MimeType");
        info[1][1] = player.getMediaDescriptor().mimeType;
        info[2][0] = ElanLocale.getString("LinkedFilesDialog.Label.MediaOffset");
        info[2][1] = String.valueOf(player.getMediaDescriptor().timeOrigin);
        info[3][0] = ElanLocale.getString("Player.duration");
        info[3][1] = TimeFormatter.toString(player.getMediaDuration());
        info[4][0] = ElanLocale.getString("Player.FrameRate");
        info[4][1] = String.valueOf(1000.0 / player.getMilliSecondsPerSample());
        info[5][0] = ElanLocale.getString("Player.Framework");
        info[5][1] = player.getFrameworkDescription();
        return info;
    }

    private void showMessage(ElanMediaPlayer player, String[][] mes) {
        if (mes == null) {
            return;
        }
        this.label = new JLabel();
        StringBuilder sb = new StringBuilder();
        sb.append("<html><table>");
        for (int i = 0; i < mes.length; ++i) {
            sb.append("<tr>");
            for (int j = 0; j < mes[i].length; ++j) {
                sb.append("<td>");
                sb.append(mes[i][j]);
                sb.append("</td>");
            }
            sb.append("</tr>");
        }
        sb.append("</table></html>");
        this.label.setText(sb.toString());
        Component cc = null;
        if (player != null) {
            cc = player.getVisualComponent();
        }
        if (cc != null) {
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(cc), this.label, "ELAN", 1);
        } else {
            JOptionPane.showMessageDialog(null, this.label, "ELAN", 1);
        }
    }
}

